/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zzSd
 */

package
{
    import flash.display3D.*;
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.text.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        private var context3D :Context3D;
        private var debugText :TextField = new TextField();
        
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
        }
        
        public function _init() :void
        {
            var stage3DStatus :Boolean = ApplicationDomain.currentDomain.hasDefinition("flash.display.Stage3D");
            
            if (stage3DStatus)
            {
                stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, onContext3D);
                stage.stage3Ds[0].addEventListener(ErrorEvent.ERROR, onError3D);
                stage.stage3Ds[0].requestContext3D();
                
                /*debugText.text = 'Stage3D initialized.';*/
            }else{
                debugText.text =
                    'Flash 11 required.\n' +
                    'This algorithm utilizes Stage3D.\n' +
                    'Please update to Flash version 11+\n' +
                    'to acquire Stage3D capabilities.'
            }
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            debugText.autoSize = TextFieldAutoSize.LEFT;
            /*addChild(debugText);*/
            
            _init();
        }
        
        public function onContext3D($e:Event) :void
        {
            if (hasEventListener(Event.ENTER_FRAME))
               {removeEventListener(Event.ENTER_FRAME, onEnterFrame)}
               
            var stageContext :Stage3D = Stage3D($e.target);
                context3D = stageContext.context3D;
                
            //driver check
            if  ( context3D == null )
                { debugText.text = 'Context3D; Video Driver error' }
                
            //wmode check
            if  ((context3D.driverInfo == Context3DRenderMode.SOFTWARE) || (context3D.driverInfo.indexOf('oftware')>-1))
                { debugText.text = 'wmode != direct (1)' }
                
            /*debugText.text = 'Renderer: ' + context3D.driverInfo;*/
            
            //disable error checking to improve performance & apply BackBuffer
            context3D.enableErrorChecking = false;
            context3D.configureBackBuffer (465, 465, 0, true);

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function onError3D($e:ErrorEvent) :void
        { debugText.text = 'wmode != direct (2)' }
        
        public function onEnterFrame($e:Event) :void
        {
            
        }
    }
}

package
{
    import starling.display.*;
    import starling.utils.*;
    import starling.core.*;
    
    class Starling extends Sprite
    {
        public function Starling()
        {
            var quad:Quad = new Quad(200, 200, Color.RED);
            quad.x = 100;
            quad.y = 50;
            addChild(quad)
        }
    }
}