/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zzQD
 */

//http://code.google.com/edu/parallel/mapreduce-tutorial.html#Basics
package {
    import flash.display.StageScaleMode;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.Sprite;
    
    public class Master extends Sprite 
    {
        private var numWorkers:int = 10,
                    numPoints:int = 10;
        private var tf:TextField = new TextField();
        private var W:int, // width
                    H:int, // height
                    R:Number; // radius
        private var //data:BitmapData,
                    bm:Bitmap;
        private var workers:Worker = new Worker;
        public function Master() 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;            
            
            W = 465
            H = 465
            
            var sp:Sprite = new Sprite();
            var g:Graphics = sp.graphics;
            R = Math.min(W,H) >> 1;
            g.lineStyle(1,0);
            g.beginFill(0xFFFF89, 1);
            g.drawRect(W>>1-R, H>>1-R, 2*R-1, 2*R-1);
            g.endFill();
            g.beginFill(0x0000FF);
            g.drawCircle(W-R,H-R,R-2);
            g.endFill();
            g = null;
            
            data = new BitmapData(sp.width, sp.height, false, 0xAAAAAA);
            data.draw(sp);
            bm = new Bitmap(data);
            bm.x = sp.x;
            bm.y = sp.y;
            this.addChild(bm);
            sp.graphics.clear();
            sp = null;
            
            this.addChild(tf);
            tf.height = 20;
            tf.width = W;
            tf.y = H - 20;
            tf.text = "pi = 0";
            
            var w:Worker = workers;
            var i:int = -1;
            while(++i < numWorkers)
            {
                w.next = new Worker;
                w = w.next;
            }
            
            stage.addEventListener(Event.ENTER_FRAME, ef);
        }
        
        private var countCircle:int,
                    frames:int = 0;
        private function ef(e:Event):void
        {
            ++frames;
            var numPerWorker:int = numPoints / numWorkers;
            var w:Worker = workers;
            while(w = w.next)
                countCircle += w.DO(numPerWorker, R);
            tf.text = "pi = " + String(4 * countCircle / (numPoints * frames));
        }
    }
}

import flash.display.BitmapData;
var data:BitmapData;
class Worker
{
    public var next:Worker;
    public function DO(numPerWorker:int, r:int):int
    {
        var countCircle:int;
        var i:int = -1;
        while(++i < numPerWorker)
        {
            var x:Number = Math.random() * 2 * r;
            var y:Number = Math.random() * 2 * r;
            data.setPixel(x,y,0);
            if(x*x + y*y > r*r)
                ++countCircle;
        }
        return countCircle;
    }
}

