/**
 * Copyright yoneken ( http://wonderfl.net/user/yoneken )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zzEr
 */

// 元ネタはこちら => http://blog.livedoor.jp/k_yon/archives/51719878.html
// (javascript)
//
// 5ivestar様のProxyを利用させて頂きました。
// 詳細 => http://5ivestar.org/blog/2008/12/wonderfl-webproxy/
//
// 用意した画像からgetPixelで色をとってきているだけなので、
// 実は画像はこれじゃなくても、なんだってイケます。

package {
  [SWF(width="128", height="166")]
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.display.Loader;
  import flash.net.URLRequest;
  import flash.system.Security;
  import flash.events.Event;
  import flash.display.Bitmap;
  import flash.display.BitmapData;
  import flash.text.TextField;
  import flash.text.TextFieldType;
  import flash.geom.Rectangle;
  import flash.events.MouseEvent;
  import flash.utils.Timer;
  import flash.events.TimerEvent;

  public class ColorPicker extends Sprite
  {
    public var colorCode:TextField;
    private var bColor:Bitmap;
    private var s:Sprite;
    private var lcolorCircle:Loader;
    private var lgrayBand:Loader;
    private var bcolorCircle:Bitmap;
    private var bgrayBand:Bitmap;
    private var t:Timer;
    private var lcount:int;

    public function ColorPicker()
    {
      Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
      var b:BitmapData = new BitmapData(128, 30, false, 0xffffff);
      bColor = new Bitmap(b);
      addChild(bColor);
      colorCode = new TextField();
      colorCode.type = TextFieldType.INPUT;
      colorCode.border = true;
      colorCode.borderColor = 0x000;
      colorCode.x = 5;
      colorCode.y = 5;
      colorCode.width = 50;
      colorCode.height = 18;
      colorCode.backgroundColor = 0xffffff;
      colorCode.maxChars = 6;
      colorCode.restrict = "0-9,a-f,A-F";
      colorCode.htmlText = "<font color=\"#000000\">FFFFFF</font>";
      addChild(colorCode);
      colorCode.addEventListener(Event.CHANGE, changeColor);
      lcolorCircle = new Loader();
      lcolorCircle.contentLoaderInfo.addEventListener("complete", circleLoaded);
      lgrayBand = new Loader();
      lgrayBand.contentLoaderInfo.addEventListener("complete", bandLoaded);
      s = new Sprite();
      s.x = 0;
      s.y = 30;
      addChild(s);
      s.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
        if(e.localY<128){
          var c:uint = bcolorCircle.bitmapData.getPixel(e.localX, e.localY);
          bColor.bitmapData.fillRect(new Rectangle(0, 0, bColor.width, bColor.height), c);
          colorCode.htmlText = "<font color=\"#"+ (~c).toString(16) +"\">"+c.toString(16).toUpperCase()+"</font>";
          colorCode.borderColor = ~c;
        }else{
          var c2:uint = bgrayBand.bitmapData.getPixel(e.localX, 0);
          bColor.bitmapData.fillRect(new Rectangle(0, 0, bColor.width, bColor.height), c2);
          colorCode.htmlText = "<font color=\"#"+ (~c2).toString(16) +"\">"+c2.toString(16).toUpperCase()+"</font>";
          colorCode.borderColor = ~c2;
        }
      });
      lcount = 0;
      t = new Timer(1000,0);
      t.addEventListener(TimerEvent.TIMER, onTic);
      t.start();
    }

    private function changeColor(e:Event):void
    {
      var c:String = colorCode.text.toUpperCase();
      bColor.bitmapData.fillRect(new Rectangle(0, 0, bColor.width, bColor.height), parseInt(c, 16));
      colorCode.htmlText = "<font color=\"#"+ (~parseInt(c, 16)).toString(16) +"\">"+c+"</font>";
      colorCode.borderColor = ~parseInt(c, 16);
    }

    private function onTic(e:TimerEvent):void
    {
       switch(lcount++){
         case 0:
           lcolorCircle.load(new URLRequest("http://5ivestar.org/proxy/http://image.blog.livedoor.jp/k_yon/imgs/b/2/b2302191.png"));
           t.stop();
           break;
         case 1:
           lgrayBand.load(new URLRequest("http://5ivestar.org/proxy/http://image.blog.livedoor.jp/k_yon/imgs/b/9/b96c7bd8.png"));
           t.stop();
           break;
       }
    }
    private function circleLoaded(e:Event):void
    {
      var b:BitmapData = new BitmapData(lcolorCircle.width, lcolorCircle.height, true, 0x00000000);
      b.draw(lcolorCircle);
      bcolorCircle = new Bitmap(b);
      bcolorCircle.width = 128;
      bcolorCircle.height = 128;
      s.addChild(bcolorCircle);
      Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
      t.start();
    }
    private function bandLoaded(e:Event):void
    {
      var b:BitmapData = new BitmapData(lgrayBand.width, lgrayBand.height, true, 0x00000000);
      b.draw(lgrayBand);
      bgrayBand = new Bitmap(b);
      bgrayBand.width = 128;
      bgrayBand.height = 8;
      bgrayBand.y = 128;
      s.addChild(bgrayBand);

      Wonderfl.capture_delay( 2 );
    }
  }
}

