/**
 * Copyright WeiChih_Lin ( http://wonderfl.net/user/WeiChih_Lin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zyWW
 */

// forked from ProjectNya's LightWater
////////////////////////////////////////////////////////////////////////////////
//  [AS3.0] 燃える火・きらめく星・流れる水
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1047
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    //import net.hires.debug.Stats;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var water:LightWater;
        private var playing:Boolean = true;

        public function Main() {
            Wonderfl.capture_delay(4);
            init();
            //addChild(new Stats());
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            water = new LightWater();
            addChild(water);
            water.x = 232;
            water.y = 100;
            water.init(4, 80);
            water.color = [0x9999FF, 0x66CCFF, 0x99FFFF];
            water.start();
            stage.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        }
        private function click(evt:MouseEvent):void {
            playing = !playing;
            if (playing) {
                water.start();
            } else {
                water.stop();
            }
        }

    }

}


import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.geom.Rectangle;
import flash.geom.ColorTransform;
import flash.display.BlendMode;

class LightWater extends Sprite {
    private static var ids:Array = [0, 0, 0, 0, 0, 1, 1, 2, 3];
    private var colors:Array;
    private var unit:uint = 1;
    private var range:uint = 100;
    private var radian:Number = Math.PI/180;

    public function LightWater() {
        mouseChildren = false;
    }

    public function init(n:uint, r:uint):void {
        unit = n;
        range = r;
    }
    public function set color(list:Array):void {
        colors = list;
        colors.push(0xFFFFFF);
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, createLight, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, createLight);
    }
    private function createLight(evt:Event):void {
        for (var n:uint = 0; n < unit; n++) {
            create();
        }
    }
    private function create():void {
        var water:ParticleFire = new ParticleFire();
        addChild(water);
        var radius:Number = Math.random()*range;
        var angle:Number = Math.random()*360;
        var px:Number = radius*Math.cos(angle*radian);
        var py:Number = radius*Math.sin(angle*radian);
        water.x = px;
        water.y = py;
        var colorTrans:ColorTransform = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
        var id:uint = ids[Math.floor(Math.random()*(ids.length+1))];
        colorTrans.color = colors[id];
        water.transform.colorTransform = colorTrans;
        water.blendMode = BlendMode.ADD;
    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.easing.Quad;
import org.libspark.betweenas3.events.TweenEvent;

class ParticleFire extends Sprite {
    private var base:Shape;
    private static var _width:uint = 40;
    private static var _height:uint = 80;
    private static var yOffset:int = 20;
    private static var targetPos:int = 160;
    private static var bColor:uint = 0xFFFFFF;

    public function ParticleFire() {
        draw();
        init();
    }

    private function init():void {
        var itween:ITween = BetweenAS3.tween(base, {alpha: 1, scaleY: 0.75}, {alpha: 0, scaleY: 0.5}, 0.2, Quad.easeOut);
        itween.addEventListener(TweenEvent.COMPLETE, drop, false, 0, true);
        itween.play();
    }
    private function drop(evt:TweenEvent):void {
        var itween:ITween = BetweenAS3.to(base, {y: targetPos, alpha: 0, scaleY: 1}, 0.5, Quad.easeIn);
        itween.addEventListener(TweenEvent.COMPLETE, complete, false, 0, true);
        itween.play();
    }
    private function complete(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, complete);
        parent.removeChild(this);
    }
    private function draw():void {
        base = new Shape();
        addChild(base);
        var colors:Array = [bColor, bColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(_width, _height, 0, -_width*0.5, -_height*0.5+yOffset);
        base.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        base.graphics.drawEllipse(-_width*0.5, -_height*0.5+yOffset, _width, _height);
        base.graphics.endFill();
    }

}
