/**
 * Copyright lagash ( http://wonderfl.net/user/lagash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zyWP
 */

// forked from dalmacija's 傾斜プラクティス ver.3
// 
// mouse drag	地形スクロール
// click		地形隆起/沈降
// [space]		上記隆起/沈降トグル
// [enter]		地形リセット
// [r]			パーティクルリセット

// Ver.4
//　 同色パーティクル同士のグループ化をおこなうようにした。
//　前よりは束同士がもみ合う感じになってるかと。

//　地形は表示するように変更した。
//　色々地形周りを操作できるようにした。多少は紛争っぽく演出できるかも

//　下の数字は、"各色パーティクル数（パーティクルHPの合計） 
//　グループ数 [パーティクルのグループ所属率] マウスクリックの描画モード" となっております。

//　とりあえず次は地形の回転をいれようか。
//　----------------------------------　
//　コードが試行錯誤の跡そのままでぐちゃぐちゃｗ。機能面が落ち着いたら綺麗にしたい

package {
	import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Bitmap;
	import flash.display.Stage;
	import flash.display.BitmapData;
	import flash.display.DisplayObjectContainer;
	import flash.display.LineScaleMode;
	import flash.display.BlendMode;
	import flash.events.MouseEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.geom.Point;
	import flash.geom.ColorTransform;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.utils.ByteArray;
	import flash.filters.BlurFilter;
	import flash.system.LoaderContext;
	import net.hires.debug.Stats;
	
    public class partest extends Sprite {
		var shape1:Shape;
		//var shape2:Shape;
		//var tmpBmd:BitmapData;
		var bmp:Bitmap;
		var bmp2:Bitmap;
		var bgbmp:Bitmap;
		var bgbmp_source:Bitmap;
		var curves:Object;
		var rotationColor:Number;
		
		var baseMatrix: Matrix = new Matrix();
		var baseRect:Rectangle;
		var basePoint:Point;
		var baseColorTransform:ColorTransform;
		var baseColorTransform2:ColorTransform;
		var ColorMatrixFilter1:ColorMatrixFilter;
		var ColorMatrixFilter2:ColorMatrixFilter;
		var keishaMap:BitmapData;
		
		const maxParticles = 1000;

        static public var forceMap: BitmapData;
        //private var COLOR: uint = 0xFFFFFF;
        private var seed: int;
        private var mw: int;
        private var mh: int;
        private var arr: Array;
        private var point: Point;
        private var point2: Point;
        //private var colorTf: ColorTransform;
        //private var blur: BlurFilter;
		
		static public var stageWidth;
		static public var stageHeight;
		var centerX:uint;
		var centerY:uint;
		var onDrag:Boolean=false;
		var onDragX:int=0;
		var onDragY:int = 0;
		var onDragStartX:int = 0;
		var onDragStartY:int = 0;
		var toggleBW:Boolean = true;
		
		private var particles:Vector.<particle>=new Vector.<particle>();
		private var sidesVec=particles;
		private var groups:Vector.<groupObject> = new Vector.<groupObject>();

		private var textDisp:TextField;
		
		/*　三角関数高速化
		static public const _TABLE_SIZE:int = 0x10000;
		static public const _PI:Number = Math.PI;
		static public const _TWO_PI:Number = 2 * _PI;
		static public const _TWO_PI_SCALE:Number = _TABLE_SIZE / _TWO_PI;
		static public const _HALF_PI:Number = _PI / 2;
		static public const _table:Vector.<Number> = new function ():Vector.<Number>{
			var table:Vector.<Number> = new Vector.<Number>(_TABLE_SIZE, true);
			for (var i:uint = 0; i < _TABLE_SIZE; i++) {
				table[i] = Math.sin(i / _TWO_PI_SCALE);
			}
			return table;
		};
		*/

        public function partest() {
			super();
			addEventListener(Event.ADDED_TO_STAGE, addToStageHandlr);
		}

		private function addToStageHandlr(e:Event) {
			removeEventListener(Event.ADDED_TO_STAGE, addToStageHandlr);

 			stage.frameRate = 60;
			//stage.doubleClickEnabled=true;
			stageWidth = stage.stageWidth;
			stageHeight = stage.stageHeight;
			this.buttonMode=this.useHandCursor = true;
			
            forceMap = new BitmapData(stageWidth / 2+1, stageHeight / 2+1);
			bmp = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xff000000), "auto", true);//bitmap処理用
			bmp.alpha = 1;
			bmp.blendMode=BlendMode.ADD;
			bmp2 = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xff000000), "auto", true);//bitmap処理用
			bgbmp = new Bitmap(new BitmapData(stage.stageWidth * 3, stage.stageHeight * 3), "auto", true);//bitmap処理用
			bgbmp.x = -stage.stageWidth;
			bgbmp.y = -stage.stageHeight;
			bgbmp_source = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight), "auto", true);//bitmap処理用
			shape1 = new Shape();
			shape1.filters = [new BlurFilter(64, 64, 2)];
			textDisp = new TextField();
			textDisp.width=stage.stageWidth;
			textDisp.y = stage.stageHeight-20;
			textDisp.textColor = 0xffffff;
			
			basePoint = new Point(0, 0);
			baseRect = new Rectangle(0, 0, stageWidth, stageHeight);
			baseColorTransform = new ColorTransform;
			baseColorTransform.redMultiplier = .03;
            baseColorTransform.greenMultiplier = .06;
            baseColorTransform.blueMultiplier = .02;
			//baseColorTransform.redOffset = baseColorTransform.greenOffset = baseColorTransform.blueOffset = -10;
			baseColorTransform2 = new ColorTransform;
			baseColorTransform2.redMultiplier = baseColorTransform2.greenMultiplier = baseColorTransform2.blueMultiplier = 5;
			//baseColorTransform2.redOffset = 
            baseColorTransform2.greenOffset = 20;
            //baseColorTransform2.blueOffset = 20;
			
			ColorMatrixFilter1 = new ColorMatrixFilter([
				.03, 0, 0, 0, 0,
				0, .06, 0, 0, 0,
				0, 0, .02, 0, 0,
				0, 0, 0, 1, 0
			]);
			ColorMatrixFilter2 = new ColorMatrixFilter([
				5, 0, 0, 0, 0,
				0, 5, 0, 0, 20,
				0, 0, 5, 0, 0,
				0, 0, 0, 1, 0
			]);
			bgbmp.filters = [ColorMatrixFilter1,ColorMatrixFilter2];
			
			baseMatrix.identity();
            baseMatrix.scale(2,2);
			
			//addChild(bmp2);
			addChild(bgbmp);
			addChild(bmp);
            var st=new Stats();st.blendMode=BlendMode.SCREEN;
			addChild(st);
			addChild(textDisp);

            init();
            setMap();
			
			//イベント登録
			//stage.addEventListener(MouseEvent.DOUBLE_CLICK, mouseClickHandlr);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandlr);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandlr);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandlr);
			stage.addEventListener(Event.ENTER_FRAME, enterframeHandlr);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, function(e:KeyboardEvent) {
				if (e.charCode == 32) toggleBW = (!toggleBW);
				if (e.charCode == 13) setMap();
				if (e.charCode == 114) init();
			} );
			
		}

		private function mouseClickHandlr(e) {
            setMap();
		}
		
		private function mouseDownHandlr(e) {
            onDragX=onDragStartX=e.currentTarget.mouseX;
            onDragY=onDragStartY=e.currentTarget.mouseY;
            onDrag=true;
		}
		
		private function mouseUpHandlr(e) {
			onDrag = false;
		    if (onDragStartX == e.currentTarget.mouseX && onDragStartY == e.currentTarget.mouseY) {
				bgbmp.bitmapData.lock();
				shape1.graphics.clear();
				shape1.graphics.beginFill(0xffffff * uint(toggleBW), .2);
				for (var i = -1; i < 2; i++) for (var j = -1; j < 2; j++) shape1.graphics.drawCircle(e.currentTarget.mouseX+i*stageWidth, e.currentTarget.mouseY+j*stageHeight, 32);
				bgbmp_source.bitmapData.draw(shape1);
				forceMap.draw(bgbmp_source.bitmapData, new Matrix(.5, 0, 0, .5, 0, 0));
				for (i = 0; i < 3; i++) for (j = 0; j < 3; j++) bgbmp.bitmapData.copyPixels( bgbmp_source.bitmapData, baseRect, new Point(i * stageWidth, j * stageHeight));
				bgbmp.bitmapData.unlock();
				
			}
		}
		
		private function mouseMoveHandlr(e) {
			if (!onDrag) return;

			//point.x -=(stageWidth / 2 - centerX) / 20;
			//point.y -=(stageHeight / 2 - centerY) / 20;
			bgbmp.x -=onDragX-e.currentTarget.mouseX;
			bgbmp.y -=onDragY-e.currentTarget.mouseY;
			onDragX = e.currentTarget.mouseX;
			onDragY = e.currentTarget.mouseY;
			
			bgbmp_source.bitmapData.copyPixels(bgbmp.bitmapData, new Rectangle(-bgbmp.x, -bgbmp.y,stageWidth,stageHeight), basePoint);
			forceMap.draw(bgbmp_source.bitmapData, new Matrix(.5, 0, 0, .5, 0, 0));
			for (var i = 0; i < 3; i++) for (var j = 0; j < 3; j++) bgbmp.bitmapData.copyPixels( bgbmp_source.bitmapData, baseRect, new Point(i * stageWidth, j * stageHeight));
			bgbmp.x = -stageWidth;
			bgbmp.y = -stageHeight;

			//forceMap.perlinNoise(mw, mh, 2, seed, true, true, 1, true, arr);
			
			//bgbmp.bitmapData.draw(forceMap,baseMatrix);
			//bgbmp.bitmapData.colorTransform(baseRect, baseColorTransform);
			//bgbmp.bitmapData.colorTransform(baseRect, baseColorTransform2);
		}
		
		//初期化
		private function init() {

			var sidePer=0;
			if(sidesVec){
				var tmpYellow=sidesVec.length;
				var tmpCyan=particles.length-sidesVec.length;
				sidePer=(tmpCyan-tmpYellow)/2;
			}
			
			var currentParticlesLength=particles.length;
			for (var i = 0; i < maxParticles-currentParticlesLength; i++) {
				if (i != 0) { 
					particles.push(new particle(stage.stageWidth * Math.random(), stage.stageHeight * Math.random(), particles.length, particles[particles.length - 1])); 
				}else {
					particles.push(new particle(stage.stageWidth * Math.random(), stage.stageHeight * Math.random(), 0));
				}
				particles[particles.length-1].side = (particles[particles.length-1].yy<stage.stageHeight/2+sidePer)?true:false;
			}
			
		}
		
        function setMap():void{
			forceMap.perlinNoise(mw = forceMap.width >> 2, mh = forceMap.height >> 2, 2, 
			seed = Math.random() * 0xFFFF, true, true, 1,true);
			arr = [point = new Point(), point2 = new Point()];
			
            bgbmp_source.bitmapData.draw(forceMap,baseMatrix);
            //bgbmp_source.bitmapData.colorTransform(baseRect, baseColorTransform);
            //bgbmp_source.bitmapData.colorTransform(baseRect, baseColorTransform2);
			for (var i = 0; i < 3; i++)for (var j = 0; j < 3; j++)bgbmp.bitmapData.copyPixels( bgbmp_source.bitmapData, baseRect,new Point(i*stageWidth,j*stageHeight));
			
			keishaMap = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);//傾斜データ保存用
                  
        }
				
		//メイン
		private function enterframeHandlr(e){
			var flg_2 = 0;
			bmp.bitmapData.lock();
			centerX = centerY = 0;
			
            var col: uint, h: Number;
			
			particles.sort(sortParticles);
				function sortParticles(x, y):Number {
					if (x.xx > y.xx) { return 1; } else { return -1; }
					return 0;
				}
			
			var tmpTx = 0; var tmpTy = 0;
			var yHp:Number=0;
			var cHp:Number=0;
			
			var pl=particles.length;
			for (var i = 0; i < pl; i++) {
				var tmpObj = particles[i];
				
				var sideColor = 0xff * int(tmpObj.side);
				col = 0xff;// * i / maxParticles;
				col = (0x10000 * sideColor*(tmpObj.hp+2)/12) + (0x100 * col*(tmpObj.hp+2)/12) + (col-sideColor)*(tmpObj.hp+2)/12;
				
				//グループ管理
                if(tmpObj.group){
					if (getLineLength(new Rectangle(tmpObj.group.ox, tmpObj.group.oy, tmpObj.xx, tmpObj.yy)) > 150) {
						tmpObj.group.removeMember(tmpObj);
        				tmpObj.group = null;
					}
				}else if (!tmpObj.group) {
					if (groups.length == 0) {
						var newGrp = new groupObject();
						newGrp.side = tmpObj.side;
						newGrp.addMember(tmpObj);
						tmpObj.group = newGrp;
						groups.push(newGrp);
					}else {
						var mostNearGroup;
						var mNGLength=100;
						var gl = groups.length;
						for ( gId = 0; gId < gl; gId++) {
							var tmpGrp = groups[gId];
							var tmpLength = getLineLength(new Rectangle(tmpGrp.ox, tmpGrp.oy, tmpObj.xx, tmpObj.yy));
							if ((!mNGLength || mNGLength > tmpLength) && tmpGrp.side==tmpObj.side) {
								mNGLength = tmpLength;
								mostNearGroup = tmpGrp;
							}
						}
						
						if (mNGLength < 70) {
							mostNearGroup.addMember(tmpObj);
							tmpObj.group = mostNearGroup;
						}else {
							newGrp = new groupObject();
							newGrp.side = tmpObj.side;
							newGrp.addMember(tmpObj);
							tmpObj.group = newGrp;
							groups.push(newGrp);
						}
					}
                }
                
				
				//当たり判定
				if (i != 0) {
					var hitcnt = i;
					while (hitcnt) {
						hitcnt--;
						if ( tmpObj.xx - particles[hitcnt].xx > 3) {
							break;
						}
						if( Math.abs(tmpObj.yy - particles[hitcnt].yy) < 3){// && tmpObj.side!=particles[hitcnt].side) {
							tmpCol=0x666666;
							if(tmpObj.side!=particles[hitcnt].side){
								var dm = (tmpObj.getTl()*tmpObj.hp - particles[hitcnt].getTl()*particles[hitcnt].hp)/(tmpObj.hp+particles[hitcnt].hp);
								if (dm > 0) { particles[hitcnt].hp -= dm; } else { tmpObj.hp += dm; }
								tmpCol=0xff0000;
 
							}
                                for (var exp = 1; exp < 4;exp++){
									bmp.bitmapData.setPixel(tmpObj.xx - exp, tmpObj.yy-exp, tmpCol );
									bmp.bitmapData.setPixel(tmpObj.xx + exp, tmpObj.yy+exp, tmpCol );
									bmp.bitmapData.setPixel(tmpObj.xx-exp, tmpObj.yy + exp, tmpCol );
									bmp.bitmapData.setPixel(tmpObj.xx+exp, tmpObj.yy - exp, tmpCol );
								}
							tmpTx = (tmpObj.tx*tmpObj.hp)-(particles[hitcnt].tx*particles[hitcnt].hp);
							tmpTy = (tmpObj.ty*tmpObj.hp)-(particles[hitcnt].ty*particles[hitcnt].hp);
						        var sAmp = (tmpObj.side!=particles[hitcnt].side)?.6:1.2; 
							tmpObj.tx -= tmpTx/tmpObj.hp*sAmp;
							tmpObj.ty -= tmpTy/tmpObj.hp*sAmp;
							particles[hitcnt].tx += tmpTx/particles[hitcnt].hp*sAmp;
							particles[hitcnt].ty += tmpTy/particles[hitcnt].hp*sAmp;
						}
						break;
					}
				}

				centerX += tmpObj.xx;
				centerY += tmpObj.yy;
				
				var tmpCol = keishaMap.getPixel32(tmpObj.xx, tmpObj.yy);
				if (forceMap.getPixel(tmpObj.xx>>1, tmpObj.yy>>1)!=bmp2.bitmapData.getPixel(tmpObj.xx, tmpObj.yy)) tmpCol=setMapPoint(int(tmpObj.xx), int(tmpObj.yy));
				var bX = tmpCol >>> 16;
				var bY = tmpCol & 0xffff;
				
				tmpObj.dx = int(uint((((bX&0x8000)<<16)>>16)+(bX&0x7fff)))*.00001;
				tmpObj.dy = int(uint((((bY&0x8000)<<16)>>16)+(bY&0x7fff)))*.00001;
				
				var spdLim=5;
				tmpObj.tx = tmpObj.tx * .99 + tmpObj.dx;//(tmpObj.dx * uint(tmpObj.dx > 0 && tmpObj.tx < spdLim) + tmpObj.dx * uint(tmpObj.dx<0 && tmpObj.tx>-spdLim));
				tmpObj.ty = tmpObj.ty * .99 + tmpObj.dy;//(tmpObj.dy * uint(tmpObj.dy > 0 && tmpObj.ty < spdLim) + tmpObj.dy * uint(tmpObj.dy<0 && tmpObj.ty>-spdLim));
				var tl=getLineLength(new Rectangle(0,0,tmpObj.tx,tmpObj.ty));
				if(tl>spdLim){tmpObj.tx=tmpObj.tx/tl*spdLim;tmpObj.ty=tmpObj.ty/tl*spdLim;}

				tmpObj.xx += tmpObj.tx;
				tmpObj.yy += tmpObj.ty;

				if (tmpObj.xx < 0 || tmpObj.xx >= stageWidth) { tmpObj.xx = uint(tmpObj.tx < 0) * (stageWidth-1);}
				if (tmpObj.yy < 0 || tmpObj.yy >= stageHeight) { tmpObj.yy = uint(tmpObj.ty < 0) * (stageHeight-1);}
					
				bmp.bitmapData.setPixel(tmpObj.xx, tmpObj.yy, col );
				//	for (exp = 0; exp < Math.PI;exp+=.3){
				//		bmp.bitmapData.setPixel(tmpObj.xx + Math.sin(exp)*10, tmpObj.yy+ Math.cos(exp)*10, col );
				//		bmp.bitmapData.setPixel(tmpObj.xx + Math.sin(exp+Math.PI)*10, tmpObj.yy+ Math.cos(exp+Math.PI)*10, col );
				//	}
				
				
    			
    			yHp+=(tmpObj.side)?tmpObj.hp:0;
    			cHp+=(!tmpObj.side)?tmpObj.hp:0;

			}
		
			centerX /= particles.length;
			centerY /= particles.length;
			
			//パーティクルの整理
			particles=particles.filter(hpCheck,null);
				function hpCheck(item:particle, index:int, vector:Vector.<particle>):Boolean {
					if (item.hp<=0) {
    					    for ( exp = 1; exp < 20;exp++){
						    bmp.bitmapData.setPixel(item.xx - exp, item.yy, 0x5555 );
				    		    bmp.bitmapData.setPixel(item.xx + exp, item.yy, 0x5555 );
						    bmp.bitmapData.setPixel(item.xx, item.yy + exp, 0x5555 );
						    bmp.bitmapData.setPixel(item.xx, item.yy - exp, 0x5555 );
					    }
					    if (item.group) item.group.removeMember(tmpObj);
					    return false; 
					}
					return true;
				}
				
			sidesVec=particles.filter(sideCheck,null);
				function sideCheck(item:particle, index:int, vector:Vector.<particle>):Boolean {
					if (item.side==false) { return false; }
					return true;
				}

           //パーティクルのリセット判定
			//if(particles.length<maxParticles*.1 || sidesVec.length<10 || particles.length-sidesVec.length<10)init();
  			
			var gStr = "";	
			var gmLength:uint;
			//グループの整理
   			groups=groups.filter(groupsCheck,null);
				function groupsCheck(item:groupObject, index:int, vector:Vector.<groupObject>):Boolean {
				    item.calc();
					if (item.length<=1) { 
					    for(var gId in item.members)item.members[gId].group=null;    
					    return false;
					}
					return true;
				}
				
			//パーティクルのグループ化動作
			for (var gId in groups) {
				tmpGrp = groups[gId];
				gmLength += tmpGrp.length;
				//gStr+="["+tmpGrp.length+"]  ";
				
				
				//sideColor = 0xee * int(tmpGrp.side);
				//col = 0x01000000 + (0x10000 * sideColor) + (0x100 * 0xee) + (0xee-sideColor);
				
				//bmp.bitmapData.setPixel(tmpGrp.ox + 2, tmpGrp.oy + 2, col );
				//bmp.bitmapData.setPixel(tmpGrp.ox - 2, tmpGrp.oy + 2, col );
				//bmp.bitmapData.setPixel(tmpGrp.ox + 2, tmpGrp.oy - 2, col );
				//bmp.bitmapData.setPixel(tmpGrp.ox - 2, tmpGrp.oy - 2, col );
				
				//for (exp = 0; exp < Math.PI;exp+=.3){
				//	bmp.bitmapData.setPixel(tmpGrp.ox + Math.sin(exp)*10, tmpGrp.oy+ Math.cos(exp)*10, col );
				//	bmp.bitmapData.setPixel(tmpGrp.ox + Math.sin(exp+Math.PI)*10, tmpGrp.oy+ Math.cos(exp+Math.PI)*10, col );
				//}
				
				var tmpLx;
				var tmpLy;
				var tmpL;
				for ( i in tmpGrp.members) {
					tmpObj = tmpGrp.members[i];
					tmpLx=tmpGrp.ox - tmpObj.xx;
					tmpLy=tmpGrp.oy - tmpObj.yy;
					tmpL=Math.sqrt(Math.pow(tmpLx, 2) + Math.pow(tmpLy, 2));
					tmpObj.tx += (tmpLx / tmpL) >>2;
					tmpObj.ty += (tmpLy / tmpL) >>2;
					//bmp.bitmapData.setPixel(tmpObj.xx - 1, tmpObj.yy, col );
					//bmp.bitmapData.setPixel(tmpObj.xx + 1, tmpObj.yy, col );
					//bmp.bitmapData.setPixel(tmpObj.xx, tmpObj.yy + 1, col );
					//bmp.bitmapData.setPixel(tmpObj.xx, tmpObj.yy - 1, col );
				}
			}
			gStr += "[" + gmLength + " / "+particles.length+" ("+uint((gmLength/particles.length)*100)+"%)]";
			
			
			//画面表示系処理
			//bmp.bitmapData.colorTransform(baseRect, baseColorTransform);
			//bmp2.bitmapData.applyFilter(bmp2.bitmapData, baseRect, basePoint, new DisplacementMapFilter(bmp.bitmapData));
			//bmp.bitmapData.scroll((stageWidth / 2 - centerX) / 10, (stageHeight / 2 - centerY) / 10);
			//bmp.bitmapData.scroll(_table[((frameCounter + _HALF_PI) * _TWO_PI_SCALE) & (_TABLE_SIZE - 1)] * 10, _table[(frameCounter * _TWO_PI_SCALE) & (_TABLE_SIZE - 1)] * 10);
			//tmpBmd.colorTransform(baseRect, baseColorTransform);
			//tmpBmd.scroll( -(stageWidth / 2 - centerX) / 5, -(stageHeight / 2 - centerY) / 5);
			//if (Math.abs((stageWidth / 2 - centerX) / 10) > 1 || Math.abs((stageHeight / 2 - centerY) / 10) > 1) {
			//bmp.bitmapData.draw(shape1,baseMatrix, null, BlendMode.LIGHTEN);
			//bmp.bitmapData.draw(shape2,baseMatrix, null, BlendMode.ADD);
			//bmp.bitmapData.copyPixels(tmpBmd, baseRect, basePoint, tmpBmd, new Point(0, 0), true);
			bmp.bitmapData.applyFilter(bmp.bitmapData, baseRect, basePoint,new BlurFilter(2,2,2));
			//bmp2.bitmapData.applyFilter(bmp.bitmapData, baseRect, basePoint,new BlurFilter(2,2,1));
			//bmp.bitmapData.draw(shape1,baseMatrix, null, BlendMode.OVERLAY);
			bmp.bitmapData.unlock();
			
			/*
			//パーティクル追加
			if (!flg && flg_2==0 || (mouse_X<0 || mouse_X>stageWidth || mouse_Y<0 || mouse_Y>stageHeight)) return;
			if (particles.length > 0) {
				//if (getLineLength(new Rectangle(particles[particles.length - 1].xx, particles[particles.length - 1].yy, mouse_X, mouse_Y)) < 3) { ; return false; }
				
				do{
					var newX = mouse_X + (Math.random() * 100-50) * flg_2;
					var newY = mouse_Y + (Math.random() * 100-50) * flg_2;
				}while (newX<0 || newX>stageWidth || newY<0 || newY>stageHeight);
				
				particles.push(new particle(newX,newY, particles.length, particles[particles.length-1]));
				particles[0].setObj(particles[particles.length-1]);
			} else {
				
				particles.push(new particle(mouse_X,mouse_Y,0));

			}
			if (particles.length > maxParticles) {
				particles.shift();
			}
			*/
			
			//ステータス表示
			textDisp.text="yellow:"+sidesVec.length+"("+yHp+") / cyan: "+(particles.length-sidesVec.length)+"("+cHp+")  groups: "+groups.length+"  "+gStr+" drawMode:"+((toggleBW)?"rise":"fall");
		}
		
        function setMapPoint(tmpX,tmpY):uint{
			var col = forceMap.getPixel(tmpX >> 1, tmpY >> 1);
			
			var dx = 0;
			var dy = 0;
			
			for (var py = -1; py < 2; py++){
				for (var px = -1; px < 2; px++) {
					
					if (px == 0 && py == 0) continue;
					
					var ppx = tmpX + px;
					var ppy = tmpY + py;
					
					if (ppx < 0 || ppx >= stageWidth) { ppx = int(ppx<0)* (stageWidth-1); }
					if (ppy < 0 || ppy >= stageHeight){ ppy = int(ppy<0)* (stageHeight-1);}
					
					var tmpcol = forceMap.getPixel(ppx >> 1, ppy >> 1);
					//bmp2.bitmapData.setPixel(ppx, ppy, tmpcol);
					
					if (px*px + py*py == 1) {
						dx += (col - tmpcol) * px;
						dy += (col - tmpcol) * py;
					}else {
						dx += (col - tmpcol) * px*.7;
						dy += (col - tmpcol) * py*.7;
					}
				}
			}
			bmp2.bitmapData.setPixel(tmpX, tmpY, col);
			col = uint((uint((uint(dx/5)&0x80000000)>>>16)+(uint(dx/5)&0x7fff)<<16)+uint((uint(dy/5) & 0x80000000) >>> 16) + (uint(dy/5) & 0x7fff));
			keishaMap.setPixel32(tmpX, tmpY, col);
			return col;
		}	
		
		//サブルーチン群
		function getLineLength(p:Rectangle):Number
		{
			var vx=p.x-p.width;
			var vy=p.y-p.height;
			var vl=Math.sqrt(Math.pow(vx,2)+Math.pow(vy,2));
			return vl;
		}
		
		function getLine(p:Rectangle):Point
		{
			var vx=p.x-p.width;
			var vy=p.y-p.height;
			var ts=new Point();
			ts.x=vy/vx;
			ts.y=p.height-ts.x*p.width;
			return ts;
		}
		
		function getCrossLine(p:Rectangle):Point
		{
			var vx=p.x-p.width;
			var vy=p.y-p.height;
			var ts=new Point();
			ts.x=-vx/vy;
			ts.y=p.y-ts.x*p.x;
			return ts;
		}
		
		function clone( arg:* ) :*
		{
			var myBA:ByteArray = new ByteArray();
			myBA.writeObject(arg);
			myBA.position = 0;
			return( myBA.readObject() );
		}

    }
}

	class bugfix {
		function bugfix():void {
		}
	}
	
	
	class particle extends bugfix{
		
		var xx:Number=0;
		var yy:Number=0;
		var tx:Number=0;
		var ty:Number=0;
		var dx:Number=0;
		var dy:Number=0;
		var dl:Number = 0;
		var hp:int;
		var side:Boolean;
		var group:groupObject;
		
		function particle(... args):void {
			xx = args[0];
			yy = args[1];
			var sd;
			tx = Math.cos(sd=Math.random() * Math.PI * 2) * .5;
			ty = Math.cos(sd) * .5;
			hp = 10;
		}
		
		function getTl():Number {
			return Math.sqrt(Math.pow(tx,2)+Math.pow(ty,2));
		}
	}
	
	class groupObject extends bugfix{
		var members:Vector.<particle> = new Vector.<particle>();
		var mLength:uint;
		var px:Number;
		var py:Number;
		var ox:Number;
		var oy:Number;
		var side:Boolean;
		
		function groupObject():void {
			mLength = px = py = ox = oy = 0;
		}
		
		function calc() {
			mLength = members.length;
			//if (mLength < 1) return;
			
			px = py = 0;
			for (var i in members) {
				px += members[i].xx;
				py += members[i].yy;
			}
			ox = px / mLength;
			oy = py / mLength;
		}
		
		function addMember(p:particle) {
			members.push(p);
			mLength = members.length;
			px += p.xx;
			py += p.yy;
			ox = px / mLength;
			oy = py / mLength;
			//calc();
		}

		function removeMember(p:particle) {
			members.splice(members.indexOf(p), 1);
			mLength = members.length;
			px -= p.xx;
			py -= p.yy;
			ox = px / mLength;
			oy = py / mLength;
			//calc();
		}
		
		function get length():uint {
			mLength = members.length;
			return mLength;
		}
	}

