/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zyFz
 */

// forked from saharan's Simple Lighting(Soft3D 3)
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import net.hires.debug.*;
    [SWF(frameRate = "60", width="465", height="465")]
    
    /**
     * Software rendering in ActionScript3.0 #3
     * @author saharan
     */
    public class FlashSoft3D extends Sprite {
        private var r:Renderer;
        private var count:uint;
        private var box:Model;
        private var flag:Boolean;
        public static var debug:TextField;
        
        public function FlashSoft3D() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            r = new Renderer(465, 465);
            
            // dirx, diry, dirz, red, green, blue
                r.light(0).directional(2, 0, 1, 0.67, 0.80, 0.93);
                r.light(1).directional(-2, 0, 1, 0.9, 0.6, 0.7);
                r.light(2).directional(0, -2, 1, 0.5, 0.5, 0.5);
            flag = true;
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent = null):void {
                if (flag) {
                    r.light(0).directional(0, 0, 1, 1, 1, 1);
                    r.light(1).disable();
                    r.light(2).disable();
                } else {
                    r.light(0).directional(2, 0, 1, 0.67, 0.80, 0.93);
                    r.light(1).directional(-2, 0, 1, 0.9, 0.6, 0.7);
                    r.light(2).directional(0, -2, 1, 0.5, 0.5, 0.5);
                }
                flag = !flag;
            } );
            addChild(r.image);
            // debug = new TextField();
            // debug.x = 200;
            // debug.textColor = 0xffffff;
            // addChild(debug);
            // addChild(new Stats());
            box = new Model();
            box.toDevil();
            addEventListener(Event.ENTER_FRAME, frame);
        }
        
        private function frame(e:Event = null):void {
            ++count;
            r.beginScene(0x000000);
            r.rotateX( Math.PI );
            r.rotateY( count / 40 );
            r.scale( 5, 5, 5 );
            r.translate( 0, -3, 0 );
            box.render( r );
            r.endScene();
        }
    }
}
import flash.display.*;

class Renderer {
    private var img:BitmapData;
    private var fBuffer:Vector.<uint>;
    private var zBuffer:Vector.<Number>;
    private var bitmap:Bitmap;
    
    private var width:uint;
    private var height:uint;
    private var aspect:Number;
    private var width2:uint;
    private var height2:uint;
    private var size:uint;
    private var near:uint;
    private var far:uint;
    
    private var cameraPosition:Vec3D;
    private var cameraTarget:Vec3D;
    private var cameraUp:Vec3D;
    
    private var worldMatrix:Mat4x4;
    private var viewMatrix:Mat4x4;
    private var projectionMatrix:Mat4x4;
    
    private var numStacks:int;
    private var stack:Vector.<Mat4x4>;
    private var color:uint;
    
    private var amb:Number;
    private var dif:Number;
    private var spc:Number;
    private var shn:Number;
    private var emi:Number;
    private var r:Number;
    private var g:Number;
    private var b:Number;
    
    private var lights:Vector.<Light>;
    private var ambr:Number;
    private var ambg:Number;
    private var ambb:Number;
    
    public function Renderer(width:uint, height:uint) {
        img = new BitmapData(width, height, false, 0);
        bitmap = new Bitmap(img);
        this.width = width;
        this.height = height;
        aspect = height / width;
        size = width * height;
        width2 = width >> 1;
        height2 = height >> 1;
        numStacks = 0;
        zBuffer = new Vector.<Number>(size, true);
        fBuffer = new Vector.<uint>(size, true);
        lights = new Vector.<Light>(8, true);
        for (var i:int = 0; i < 8; i++) lights[i] = new Light();
        stack = new Vector.<Mat4x4>(64, true);
        worldMatrix = new Mat4x4();
        viewMatrix = new Mat4x4();
        projectionMatrix = new Mat4x4();
        
        // system initialization
        lookAt(new Vec3D(0, 0, 50),  new Vec3D(0, 0, 0), new Vec3D(0, 1, 0));
        perspective(60 * Math.PI / 180, 5, 5000);
        ambient(0.2, 0.2, 0.2);
        light(0).directional(0, 0, 1, 1, 1, 1);
        material(0.8, 0.8, 0, 0, 0, 1, 1, 1);
    }
    
    public function get image():Bitmap {
        return bitmap;
    }
    
    public function push():void {
        if(numStacks < 32) {
            stack[numStacks] = new Mat4x4(
                worldMatrix.e00, worldMatrix.e01, worldMatrix.e02, worldMatrix.e03,
                worldMatrix.e10, worldMatrix.e11, worldMatrix.e12, worldMatrix.e13,
                worldMatrix.e20, worldMatrix.e21, worldMatrix.e22, worldMatrix.e23,
                worldMatrix.e30, worldMatrix.e31, worldMatrix.e32, worldMatrix.e33);
            numStacks++;
        }
    }
    
    public function pop():void {
        if (numStacks > 0) {
            numStacks--;
            worldMatrix = stack[numStacks];
        }
    }
    
    public function rotateX(theta:Number):void {
        var temp:Mat4x4 = new Mat4x4();
        temp.rotateX(theta);
        temp.mulEqualMatrix(worldMatrix);
        worldMatrix = temp;
    }
    
    public function rotateY(theta:Number):void {
        var temp:Mat4x4 = new Mat4x4();
        temp.rotateY(theta);
        temp.mulEqualMatrix(worldMatrix);
        worldMatrix = temp;
    }
    
    public function rotateZ(theta:Number):void {
        var temp:Mat4x4 = new Mat4x4();
        temp.rotateZ(theta);
        temp.mulEqualMatrix(worldMatrix);
        worldMatrix = temp;
    }
    
    public function scale(sx:Number, sy:Number, sz:Number):void {
        var temp:Mat4x4 = new Mat4x4();
        temp.scale(sx, sy, sz);
        temp.mulEqualMatrix(worldMatrix);
        worldMatrix = temp;
    }
    
    public function translate(tx:Number, ty:Number, tz:Number):void {
        var temp:Mat4x4 = new Mat4x4();
        temp.translate(tx, ty, tz);
        temp.mulEqualMatrix(worldMatrix);
        worldMatrix = temp;
    }
    
    public function beginScene(background:uint):void {
        for (var i:int = 0; i < size; i++) {
            fBuffer[i] = background;
            zBuffer[i] = 0;
        }
        worldMatrix.identity();
    }
    
    public function renderPolygon(v1:Vertex, v2:Vertex, v3:Vertex):void {
        v1.worldPos.setVector(v1.pos.x, v1.pos.y, v1.pos.z);
        worldMatrix.mulEqualVector(v1.worldPos);
        v2.worldPos.setVector(v2.pos.x, v2.pos.y, v2.pos.z);
        worldMatrix.mulEqualVector(v2.worldPos);
        v3.worldPos.setVector(v3.pos.x, v3.pos.y, v3.pos.z);
        worldMatrix.mulEqualVector(v3.worldPos);
        
        lighting(v1, v2, v3);
        
        v1.viewPos.setVector(v1.worldPos.x, v1.worldPos.y, v1.worldPos.z);
        viewMatrix.mulEqualVector(v1.viewPos);
        v2.viewPos.setVector(v2.worldPos.x, v2.worldPos.y, v2.worldPos.z);
        viewMatrix.mulEqualVector(v2.viewPos);
        v3.viewPos.setVector(v3.worldPos.x, v3.worldPos.y, v3.worldPos.z);
        viewMatrix.mulEqualVector(v3.viewPos);
        
        clipPolygonDepth(v1, v2, v3, 0);
    }
    
    public function light(id:uint):Light {
        return lights[id];
    }
    
    public function ambient(r:Number, g:Number, b:Number):void {
        ambr = r;
        ambg = g;
        ambb = b;
    }
    
    public function material(ambient:Number, diffuse:Number, specular:Number,
        shininess:Number, emission:Number, r:Number, g:Number, b:Number):void {
        amb = ambient;
        dif = diffuse;
        spc = specular;
        shn = shininess;
        emi = emission;
        this.r = r;
        this.g = g;
        this.b = b;
    }
    
    private function lighting(v1:Vertex, v2:Vertex, v3:Vertex):void {
        // simple lighting
        var cr:Number = (amb * ambr + emi) * r;
        var cg:Number = (amb * ambg + emi) * g;
        var cb:Number = (amb * ambb + emi) * b;
        const nor:Vec3D = v2.worldPos.sub(v1.worldPos).cross(v3.worldPos.sub(v2.worldPos));
        nor.normalize();
        const view:Vec3D = cameraTarget.sub(cameraPosition);
        view.normalize();
        const ref:Vec3D = new Vec3D();
        for (var i:int = 0; i < 8; i++) {
            const light:Light = lights[i];
            if (light.type == Light.DISABLED) continue;
            const lr:Number = light.r;
            const lg:Number = light.g;
            const lb:Number = light.b;
            switch(light.type) {
                case Light.DIRECTIONAL: // directional light
                const dot:Number = light.dir.dot(nor) * dif;
                if (dot > 0) {
                    cr += r * lr * dot;
                    cg += g * lg * dot;
                    cb += b * lb * dot;
                }
                if (spc > 0) {
                    // calc reflection vector and specular
                    // ref = vec - 2 * (nor * vec) * nor
                    var dots:Number = 2 * nor.dot(view);
                    ref.setVector(view.x - nor.x * dots, view.y - nor.y * dots, view.z - nor.z * dots);
                    dots = light.dir.dot(ref);
                    if (dots > 0) {
                        dots = Math.pow(dots, shn) * spc;
                        cr += lr * dots;
                        cg += lg * dots;
                        cb += lb * dots;
                    }
                }
                break;
            }
        }
        if (cr > 1) cr = 1;
        if (cg > 1) cg = 1;
        if (cb > 1) cb = 1;
        color = (cr * 0xff) << 16 | (cg * 0xff) << 8 | (cb * 0xff);
    }
    
    private function clipPolygonDepth(v1:Vertex, v2:Vertex, v3:Vertex, step:int):void {
        var flag:int;
        var c1:Vertex;
        var c2:Vertex;
        switch(step) {
        case 0:// near
            flag = 0;
            if (v1.viewPos.z < near) flag |= 1;
            if (v2.viewPos.z < near) flag |= 2;
            if (v3.viewPos.z < near) flag |= 4;
            if (flag != 0) {
                switch (flag) {
                case 1:// 1
                    c1 = interpolate(v1, v2, (near - v1.viewPos.z) / (v2.viewPos.z - v1.viewPos.z), false);
                    c2 = interpolate(v1, v3, (near - v1.viewPos.z) / (v3.viewPos.z - v1.viewPos.z), false);
                    c1.viewPos.z = near;
                    c2.viewPos.z = near;
                    clipPolygonDepth(c1, v2, v3, 1);
                    clipPolygonDepth(c1, v3, c2, 1);
                    return;
                case 2:// 2
                    c1 = interpolate(v2, v3, (near - v2.viewPos.z) / (v3.viewPos.z - v2.viewPos.z), false);
                    c2 = interpolate(v2, v1, (near - v2.viewPos.z) / (v1.viewPos.z - v2.viewPos.z), false);
                    c1.viewPos.z = near;
                    c2.viewPos.z = near;
                    clipPolygonDepth(c1, v3, v1, 1);
                    clipPolygonDepth(c1, v1, c2, 1);
                    return;
                case 3:// 1 2
                    c1 = interpolate(v1, v3, (near - v1.viewPos.z) / (v3.viewPos.z - v1.viewPos.z), false);
                    c2 = interpolate(v2, v3, (near - v2.viewPos.z) / (v3.viewPos.z - v2.viewPos.z), false);
                    c1.viewPos.z = near;
                    c2.viewPos.z = near;
                    clipPolygonDepth(c1, c2, v3, 1);
                    return;
                case 4:// 3
                    c1 = interpolate(v3, v1, (near - v3.viewPos.z) / (v1.viewPos.z - v3.viewPos.z), false);
                    c2 = interpolate(v3, v2, (near - v3.viewPos.z) / (v2.viewPos.z - v3.viewPos.z), false);
                    c1.viewPos.z = near;
                    c2.viewPos.z = near;
                    clipPolygonDepth(c1, v1, v2, 1);
                    clipPolygonDepth(c1, v2, c2, 1);
                    return;
                case 5:// 3 1
                    c1 = interpolate(v3, v2, (near - v3.viewPos.z) / (v2.viewPos.z - v3.viewPos.z), false);
                    c2 = interpolate(v1, v2, (near - v1.viewPos.z) / (v2.viewPos.z - v1.viewPos.z), false);
                    c1.viewPos.z = near;
                    c2.viewPos.z = near;
                    clipPolygonDepth(c1, c2, v2, 1);
                    return;
                case 6:// 2 3
                    c1 = interpolate(v2, v1, (near - v2.viewPos.z) / (v1.viewPos.z - v2.viewPos.z), false);
                    c2 = interpolate(v3, v1, (near - v3.viewPos.z) / (v1.viewPos.z - v3.viewPos.z), false);
                    c1.viewPos.z = near;
                    c2.viewPos.z = near;
                    clipPolygonDepth(c1, c2, v1, 1);
                    return;
                case 7:// 1 2 3
                    return;
                }
            }
        case 1:// far
            flag = 0;
            if (v1.viewPos.z > far) flag |= 1;
            if (v2.viewPos.z > far) flag |= 2;
            if (v3.viewPos.z > far) flag |= 4;
            if (flag != 0) {
                switch (flag) {
                case 1:// 1
                    c1 = interpolate(v1, v2, (far - v1.viewPos.z) / (v2.viewPos.z - v1.viewPos.z), false);
                    c2 = interpolate(v1, v3, (far - v1.viewPos.z) / (v3.viewPos.z - v1.viewPos.z), false);
                    c1.viewPos.z = far;
                    c2.viewPos.z = far;
                    clipPolygonScreen(c1, v2, v3, 0);
                    clipPolygonScreen(c1, v3, c2, 0);
                    return;
                case 2:// 2
                    c1 = interpolate(v2, v3, (far - v2.viewPos.z) / (v3.viewPos.z - v2.viewPos.z), false);
                    c2 = interpolate(v2, v1, (far - v2.viewPos.z) / (v1.viewPos.z - v2.viewPos.z), false);
                    c1.viewPos.z = far;
                    c2.viewPos.z = far;
                    clipPolygonScreen(c1, v3, v1, 0);
                    clipPolygonScreen(c1, v1, c2, 0);
                    return;
                case 3:// 1 2
                    c1 = interpolate(v1, v3, (far - v1.viewPos.z) / (v3.viewPos.z - v1.viewPos.z), false);
                    c2 = interpolate(v2, v3, (far - v2.viewPos.z) / (v3.viewPos.z - v2.viewPos.z), false);
                    c1.viewPos.z = far;
                    c2.viewPos.z = far;
                    clipPolygonScreen(c1, c2, v3, 0);
                    return;
                case 4:// 3
                    c1 = interpolate(v3, v1, (far - v3.viewPos.z) / (v1.viewPos.z - v3.viewPos.z), false);
                    c2 = interpolate(v3, v2, (far - v3.viewPos.z) / (v2.viewPos.z - v3.viewPos.z), false);
                    c1.viewPos.z = far;
                    c2.viewPos.z = far;
                    clipPolygonScreen(c1, v1, v2, 0);
                    clipPolygonScreen(c1, v2, c2, 0);
                    return;
                case 5:// 3 1
                    c1 = interpolate(v3, v2, (far - v3.viewPos.z) / (v2.viewPos.z - v3.viewPos.z), false);
                    c2 = interpolate(v1, v2, (far - v1.viewPos.z) / (v2.viewPos.z - v1.viewPos.z), false);
                    c1.viewPos.z = far;
                    c2.viewPos.z = far;
                    clipPolygonScreen(c1, c2, v2, 0);
                    return;
                case 6:// 2 3
                    c1 = interpolate(v2, v1, (far - v2.viewPos.z) / (v1.viewPos.z - v2.viewPos.z), false);
                    c2 = interpolate(v3, v1, (far - v3.viewPos.z) / (v1.viewPos.z - v3.viewPos.z), false);
                    c1.viewPos.z = far;
                    c2.viewPos.z = far;
                    clipPolygonScreen(c1, c2, v1, 0);
                    return;
                case 7:// 1 2 3
                    return;
                }
            }
        }
        clipPolygonScreen(v1, v2, v3, 0);
    }
    
    private function clipPolygonScreen(v1:Vertex, v2:Vertex, v3:Vertex, step:int):void {
        var flag:int;
        var c1:Vertex;
        var c2:Vertex;
        switch(step) {
        case 0:// left
            { // transform
                var invW:Number;
                v1.projPos.setVector(v1.viewPos.x, v1.viewPos.y, v1.viewPos.z, 1);
                projectionMatrix.mulEqualVector(v1.projPos);
                invW = 1 / v1.projPos.w;
                v1.projPos.x *= invW;
                v1.projPos.y *= invW;
                v1.projPos.z = invW;
                v1.projPos.x = width2 + v1.projPos.x * width2 >> 0;
                v1.projPos.y = height2 + v1.projPos.y * height2 >> 0;
                
                v2.projPos.setVector(v2.viewPos.x, v2.viewPos.y, v2.viewPos.z);
                projectionMatrix.mulEqualVector(v2.projPos);
                invW = 1 / v2.projPos.w;
                v2.projPos.x *= invW;
                v2.projPos.y *= invW;
                v2.projPos.z = invW;
                v2.projPos.x = width2 + v2.projPos.x * width2 >> 0;
                v2.projPos.y = height2 + v2.projPos.y * height2 >> 0;
                
                v3.projPos.setVector(v3.viewPos.x, v3.viewPos.y, v3.viewPos.z);
                projectionMatrix.mulEqualVector(v3.projPos);
                invW = 1 / v3.projPos.w;
                v3.projPos.x *= invW;
                v3.projPos.y *= invW;
                v3.projPos.z = invW;
                v3.projPos.x = width2 + v3.projPos.x * width2 >> 0;
                v3.projPos.y = height2 + v3.projPos.y * height2 >> 0;
                
                // culling
                if ((v3.projPos.x - v1.projPos.x) * (v2.projPos.y - v1.projPos.y) -
                (v3.projPos.y - v1.projPos.y) * (v2.projPos.x - v1.projPos.x) < 0) return;
                
                // TODO:Lighting
            }
            flag = 0;
            if (v1.projPos.x < 0) flag |= 1;
            if (v2.projPos.x < 0) flag |= 2;
            if (v3.projPos.x < 0) flag |= 4;
            if (flag != 0) {
                switch (flag) {
                case 1:// 1
                    c1 = interpolate(v1, v2, -v1.projPos.x / (v2.projPos.x - v1.projPos.x), true);
                    c2 = interpolate(v1, v3, -v1.projPos.x / (v3.projPos.x - v1.projPos.x), true);
                    c1.projPos.x = 0;
                    c2.projPos.x = 0;
                    clipPolygonScreen(c1, v2, v3, 1);
                    clipPolygonScreen(c1, v3, c2, 1);
                    return;
                case 2:// 2
                    c1 = interpolate(v2, v3, -v2.projPos.x / (v3.projPos.x - v2.projPos.x), true);
                    c2 = interpolate(v2, v1, -v2.projPos.x / (v1.projPos.x - v2.projPos.x), true);
                    c1.projPos.x = 0;
                    c2.projPos.x = 0;
                    clipPolygonScreen(c1, v3, v1, 1);
                    clipPolygonScreen(c1, v1, c2, 1);
                    return;
                case 3:// 1 2
                    c1 = interpolate(v1, v3, -v1.projPos.x / (v3.projPos.x - v1.projPos.x), true);
                    c2 = interpolate(v2, v3, -v2.projPos.x / (v3.projPos.x - v2.projPos.x), true);
                    c1.projPos.x = 0;
                    c2.projPos.x = 0;
                    clipPolygonScreen(c1, c2, v3, 1);
                    return;
                case 4:// 3
                    c1 = interpolate(v3, v1, -v3.projPos.x / (v1.projPos.x - v3.projPos.x), true);
                    c2 = interpolate(v3, v2, -v3.projPos.x / (v2.projPos.x - v3.projPos.x), true);
                    c1.projPos.x = 0;
                    c2.projPos.x = 0;
                    clipPolygonScreen(c1, v1, v2, 1);
                    clipPolygonScreen(c1, v2, c2, 1);
                    return;
                case 5:// 3 1
                    c1 = interpolate(v3, v2, -v3.projPos.x / (v2.projPos.x - v3.projPos.x), true);
                    c2 = interpolate(v1, v2, -v1.projPos.x / (v2.projPos.x - v1.projPos.x), true);
                    c1.projPos.x = 0;
                    c2.projPos.x = 0;
                    clipPolygonScreen(c1, c2, v2, 1);
                    return;
                case 6:// 2 3
                    c1 = interpolate(v2, v1, -v2.projPos.x / (v1.projPos.x - v2.projPos.x), true);
                    c2 = interpolate(v3, v1, -v3.projPos.x / (v1.projPos.x - v3.projPos.x), true);
                    c1.projPos.x = 0;
                    c2.projPos.x = 0;
                    clipPolygonScreen(c1, c2, v1, 1);
                    return;
                case 7:// 1 2 3
                    return;
                }
            }
        case 1:// right
            flag = 0;
            if (v1.projPos.x > width) flag |= 1;
            if (v2.projPos.x > width) flag |= 2;
            if (v3.projPos.x > width) flag |= 4;
            if (flag != 0) {
                switch (flag) {
                case 1:// 1
                    c1 = interpolate(v1, v2, (width - v1.projPos.x) / (v2.projPos.x - v1.projPos.x), true);
                    c2 = interpolate(v1, v3, (width - v1.projPos.x) / (v3.projPos.x - v1.projPos.x), true);
                    c1.projPos.x = width;
                    c2.projPos.x = width;
                    clipPolygonScreen(c1, v2, v3, 2);
                    clipPolygonScreen(c1, v3, c2, 2);
                    return;
                case 2:// 2
                    c1 = interpolate(v2, v3, (width - v2.projPos.x) / (v3.projPos.x - v2.projPos.x), true);
                    c2 = interpolate(v2, v1, (width - v2.projPos.x) / (v1.projPos.x - v2.projPos.x), true);
                    c1.projPos.x = width;
                    c2.projPos.x = width;
                    clipPolygonScreen(c1, v3, v1, 2);
                    clipPolygonScreen(c1, v1, c2, 2);
                    return;
                case 3:// 1 2
                    c1 = interpolate(v1, v3, (width - v1.projPos.x) / (v3.projPos.x - v1.projPos.x), true);
                    c2 = interpolate(v2, v3, (width - v2.projPos.x) / (v3.projPos.x - v2.projPos.x), true);
                    c1.projPos.x = width;
                    c2.projPos.x = width;
                    clipPolygonScreen(c1, c2, v3, 2);
                    return;
                case 4:// 3
                    c1 = interpolate(v3, v1, (width - v3.projPos.x) / (v1.projPos.x - v3.projPos.x), true);
                    c2 = interpolate(v3, v2, (width - v3.projPos.x) / (v2.projPos.x - v3.projPos.x), true);
                    c1.projPos.x = width;
                    c2.projPos.x = width;
                    clipPolygonScreen(c1, v1, v2, 2);
                    clipPolygonScreen(c1, v2, c2, 2);
                    return;
                case 5:// 3 1
                    c1 = interpolate(v3, v2, (width - v3.projPos.x) / (v2.projPos.x - v3.projPos.x), true);
                    c2 = interpolate(v1, v2, (width - v1.projPos.x) / (v2.projPos.x - v1.projPos.x), true);
                    c1.projPos.x = width;
                    c2.projPos.x = width;
                    clipPolygonScreen(c1, c2, v2, 2);
                    return;
                case 6:// 2 3
                    c1 = interpolate(v2, v1, (width - v2.projPos.x) / (v1.projPos.x - v2.projPos.x), true);
                    c2 = interpolate(v3, v1, (width - v3.projPos.x) / (v1.projPos.x - v3.projPos.x), true);
                    c1.projPos.x = width;
                    c2.projPos.x = width;
                    clipPolygonScreen(c1, c2, v1, 2);
                    return;
                case 7:// 1 2 3
                    return;
                }
            }
        case 2:// top
            flag = 0;
            if (v1.projPos.y < 0) flag |= 1;
            if (v2.projPos.y < 0) flag |= 2;
            if (v3.projPos.y < 0) flag |= 4;
            if (flag != 0) {
                switch (flag) {
                case 1:// 1
                    c1 = interpolate(v1, v2, -v1.projPos.y / (v2.projPos.y - v1.projPos.y), true);
                    c2 = interpolate(v1, v3, -v1.projPos.y / (v3.projPos.y - v1.projPos.y), true);
                    c1.projPos.y = 0;
                    c2.projPos.y = 0;
                    clipPolygonScreen(c1, v2, v3, 3);
                    clipPolygonScreen(c1, v3, c2, 3);
                    return;
                case 2:// 2
                    c1 = interpolate(v2, v3, -v2.projPos.y / (v3.projPos.y - v2.projPos.y), true);
                    c2 = interpolate(v2, v1, -v2.projPos.y / (v1.projPos.y - v2.projPos.y), true);
                    c1.projPos.y = 0;
                    c2.projPos.y = 0;
                    clipPolygonScreen(c1, v3, v1, 3);
                    clipPolygonScreen(c1, v1, c2, 3);
                    return;
                case 3:// 1 2
                    c1 = interpolate(v1, v3, -v1.projPos.y / (v3.projPos.y - v1.projPos.y), true);
                    c2 = interpolate(v2, v3, -v2.projPos.y / (v3.projPos.y - v2.projPos.y), true);
                    c1.projPos.y = 0;
                    c2.projPos.y = 0;
                    clipPolygonScreen(c1, c2, v3, 3);
                    return;
                case 4:// 3
                    c1 = interpolate(v3, v1, -v3.projPos.y / (v1.projPos.y - v3.projPos.y), true);
                    c2 = interpolate(v3, v2, -v3.projPos.y / (v2.projPos.y - v3.projPos.y), true);
                    c1.projPos.y = 0;
                    c2.projPos.y = 0;
                    clipPolygonScreen(c1, v1, v2, 3);
                    clipPolygonScreen(c1, v2, c2, 3);
                    return;
                case 5:// 3 1
                    c1 = interpolate(v3, v2, -v3.projPos.y / (v2.projPos.y - v3.projPos.y), true);
                    c2 = interpolate(v1, v2, -v1.projPos.y / (v2.projPos.y - v1.projPos.y), true);
                    c1.projPos.y = 0;
                    c2.projPos.y = 0;
                    clipPolygonScreen(c1, c2, v2, 3);
                    return;
                case 6:// 2 3
                    c1 = interpolate(v2, v1, -v2.projPos.y / (v1.projPos.y - v2.projPos.y), true);
                    c2 = interpolate(v3, v1, -v3.projPos.y / (v1.projPos.y - v3.projPos.y), true);
                    c1.projPos.y = 0;
                    c2.projPos.y = 0;
                    clipPolygonScreen(c1, c2, v1, 3);
                    return;
                case 7:// 1 2 3
                    return;
                }
            }
        case 3:// bottom
            flag = 0;
            if (v1.projPos.y > height) flag |= 1;
            if (v2.projPos.y > height) flag |= 2;
            if (v3.projPos.y > height) flag |= 4;
            if (flag != 0) {
                switch (flag) {
                case 1:// 1
                    c1 = interpolate(v1, v2, (height - v1.projPos.y) / (v2.projPos.y - v1.projPos.y), true);
                    c2 = interpolate(v1, v3, (height - v1.projPos.y) / (v3.projPos.y - v1.projPos.y), true);
                    c1.projPos.y = height;
                    c2.projPos.y = height;
                    renderTriangle(c1, v2, v3);
                    renderTriangle(c1, v3, c2);
                    return;
                case 2:// 2
                    c1 = interpolate(v2, v3, (height - v2.projPos.y) / (v3.projPos.y - v2.projPos.y), true);
                    c2 = interpolate(v2, v1, (height - v2.projPos.y) / (v1.projPos.y - v2.projPos.y), true);
                    c1.projPos.y = height;
                    c2.projPos.y = height;
                    renderTriangle(c1, v3, v1);
                    renderTriangle(c1, v1, c2);
                    return;
                case 3:// 1 2
                    c1 = interpolate(v1, v3, (height - v1.projPos.y) / (v3.projPos.y - v1.projPos.y), true);
                    c2 = interpolate(v2, v3, (height - v2.projPos.y) / (v3.projPos.y - v2.projPos.y), true);
                    c1.projPos.y = height;
                    c2.projPos.y = height;
                    renderTriangle(c1, c2, v3);
                    return;
                case 4:// 3
                    c1 = interpolate(v3, v1, (height - v3.projPos.y) / (v1.projPos.y - v3.projPos.y), true);
                    c2 = interpolate(v3, v2, (height - v3.projPos.y) / (v2.projPos.y - v3.projPos.y), true);
                    c1.projPos.y = height;
                    c2.projPos.y = height;
                    renderTriangle(c1, v1, v2);
                    renderTriangle(c1, v2, c2);
                    return;
                case 5:// 3 1
                    c1 = interpolate(v3, v2, (height - v3.projPos.y) / (v2.projPos.y - v3.projPos.y), true);
                    c2 = interpolate(v1, v2, (height - v1.projPos.y) / (v2.projPos.y - v1.projPos.y), true);
                    c1.projPos.y = height;
                    c2.projPos.y = height;
                    renderTriangle(c1, c2, v2);
                    return;
                case 6:// 2 3
                    c1 = interpolate(v2, v1, (height - v2.projPos.y) / (v1.projPos.y - v2.projPos.y), true);
                    c2 = interpolate(v3, v1, (height - v3.projPos.y) / (v1.projPos.y - v3.projPos.y), true);
                    c1.projPos.y = height;
                    c2.projPos.y = height;
                    renderTriangle(c1, c2, v1);
                    return;
                case 7:// 1 2 3
                    return;
                }
            }
        }
        renderTriangle(v1, v2, v3);
    }
    
    private function interpolate(v1:Vertex, v2:Vertex, t:Number, screen:Boolean):Vertex {
        var v3:Vertex = new Vertex();
        // v3.worldPos.x = v1.worldPos.x + (v2.worldPos.x - v1.worldPos.x) * t;
        // v3.worldPos.y = v1.worldPos.y + (v2.worldPos.y - v1.worldPos.y) * t;
        // v3.worldPos.z = v1.worldPos.z + (v2.worldPos.z - v1.worldPos.z) * t;
        if(screen) {
            v3.projPos.x = (v1.projPos.x + (v2.projPos.x - v1.projPos.x) * t) >> 0;
            v3.projPos.y = (v1.projPos.y + (v2.projPos.y - v1.projPos.y) * t) >> 0;
            v3.projPos.z = v1.projPos.z + (v2.projPos.z - v1.projPos.z) * t;
        } else {
            v3.viewPos.x = v1.viewPos.x + (v2.viewPos.x - v1.viewPos.x) * t;
            v3.viewPos.y = v1.viewPos.y + (v2.viewPos.y - v1.viewPos.y) * t;
            v3.viewPos.z = v1.viewPos.z + (v2.viewPos.z - v1.viewPos.z) * t;
        }
        return v3;
    }
    
    private function renderTriangle(v1:Vertex, v2:Vertex, v3:Vertex):void {
        var top:Vec3D;
        var left:Vec3D;
        var right:Vec3D;
        if (v1.projPos.y < v2.projPos.y) {
            if (v2.projPos.y < v3.projPos.y) {
                top = v1.projPos;
                left = v2.projPos;
                right = v3.projPos;
            } else if (v1.projPos.y < v3.projPos.y) {
                top = v1.projPos;
                left = v3.projPos;
                right = v2.projPos;
            } else {
                top = v3.projPos;
                left = v1.projPos;
                right = v2.projPos;
            }
        } else {
            if (v2.projPos.y > v3.projPos.y) {
                top = v3.projPos;
                left = v2.projPos;
                right = v1.projPos;
            } else if (v1.projPos.y > v3.projPos.y) {
                top = v2.projPos;
                left = v3.projPos;
                right = v1.projPos;
            } else {
                top = v2.projPos;
                left = v1.projPos;
                right = v3.projPos;
            }
        }
        var min:int = top.y + 0.5;
        var mid:int = left.y + 0.5;
        var max:int = right.y + 0.5;
        if ((left.x - top.x) / (left.y - top.y) > (right.x - top.x) / (right.y - top.y)) {
            var temp:Vec3D = left;
            left = right;
            right = temp;
        }
        if (min == max) return;
        renderFlat(top, left, right, min, mid, max);
    }
    
    private function renderFlat(top:Vec3D, left:Vec3D, right:Vec3D, min:int, mid:int, max:int):void {
        var invLength:Number;
        const zBuffer:Vector.<Number> = this.zBuffer;
        const fBuffer:Vector.<uint> = this.fBuffer;
        
        // thickness
        var t:Number = (right.x - top.x) * (left.y - top.y) - (left.x - top.x) * (right.y - top.y);
        if (t == 0) return;
        t = 1 / t;
        
        // in scanline
        var lLength:int = left.y - top.y;
        var rLength:int = right.y - top.y;
        var lineZ:Number;
        const addLineZ:Number = ((right.z - top.z) * lLength - (left.z - top.z) * rLength) * t * 0xffffff;
        
        // left data
        var lY:int = left.y;
        invLength = 1 / lLength;
        var lX:Number = top.x;
        var lAddX:Number = (left.x - top.x) * invLength;
        var lZ:Number = top.z;
        var lAddZ:Number = (left.z - top.z) * invLength;
        
        // right data
        var rY:int = right.y;
        invLength = 1 / rLength;
        var rX:Number = top.x;
        var rAddX:Number = (right.x - top.x) * invLength;
        var rZ:Number = top.z;
        var rAddZ:Number = (right.z - top.z) * invLength;
        
        var y:int = min;
        var offset:int = min * width;
        
        while (y < max) {
            if (y == mid) {
                // flip left and right
                if (lY == rY)
                    return;
                if (y == lY) {
                    lLength = right.y - left.y;
                    invLength = 1 / lLength;
                    lX = left.x;
                    lAddX = (right.x - left.x) * invLength;
                    lZ = left.z;
                    lAddZ = (right.z - left.z) * invLength;
                }
                if (y == rY) {
                    rLength = left.y - right.y;
                    invLength = 1 / rLength;
                    rX = right.x;
                    rAddX = (left.x - right.x) * invLength;
                    rZ = right.z;
                    rAddZ = (left.z - right.z) * invLength;
                }
            }
            const ilx:int = lX;
            const irx:int = rX;
            if (irx - ilx > 0) {
                lineZ = lZ * 0xffffff;
                var pix:int = offset + ilx;
                const end:int = offset + irx;
                while (pix < end) {
                    if (zBuffer[pix] < lineZ) {
                        fBuffer[pix] = color;
                        zBuffer[pix] = lineZ;
                    }
                    pix++;
                    lineZ += addLineZ;
                }
            }
            lX += lAddX;
            rX += rAddX;
            lZ += lAddZ;
            rZ += rAddZ;
            offset += width;
            y++;
        }
    }
    
    public function renderPoint(vertex:Vec3D):void {
        worldMatrix.mulEqualVector(vertex);
        viewMatrix.mulEqualVector(vertex);
        projectionMatrix.mulEqualVector(vertex);
        var invW:Number = 1 / vertex.w;
        vertex.x *= invW;
        vertex.y *= invW;
        vertex.z *= invW;
        vertex.x = (width2 + vertex.x * width2) >> 0;
        vertex.y = (height2 + vertex.y * height2) >> 0;
        if (vertex.x >= 0 && vertex.x < width && vertex.y >= 0 && vertex.y < height) {
            var index:uint = vertex.y * width + vertex.x;
            fBuffer[index] = 0xffffff;
        }
    }
    
    public function endScene():void {
        img.setVector(img.rect, fBuffer);
    }
    
    public function lookAt(position:Vec3D, target:Vec3D, up:Vec3D):void {
        cameraPosition = position;
        cameraTarget = target;
        cameraUp = up;
        var axisZ:Vec3D = cameraTarget.sub(cameraPosition);
        axisZ.normalize();
        var axisX:Vec3D = cameraUp.cross(axisZ);
        axisX.normalize();
        var axisY:Vec3D = axisZ.cross(axisX);
        viewMatrix.e00 = axisX.x;
        viewMatrix.e01 = axisY.x;
        viewMatrix.e02 = axisZ.x;
        viewMatrix.e03 = 0;
        viewMatrix.e10 = axisX.y;
        viewMatrix.e11 = axisY.y;
        viewMatrix.e12 = axisZ.y;
        viewMatrix.e13 = 0;
        viewMatrix.e20 = axisX.z;
        viewMatrix.e21 = axisY.z;
        viewMatrix.e22 = axisZ.z;
        viewMatrix.e23 = 0;
        viewMatrix.e30 = -axisX.dot(cameraPosition);
        viewMatrix.e31 = -axisY.dot(cameraPosition);
        viewMatrix.e32 = -axisZ.dot(cameraPosition);
        viewMatrix.e33 = 1;
    }
    
    public function perspective(fovY:Number, near:Number, far:Number):void {
        this.near = near;
        this.far = far;
        var h:Number = Math.cos(fovY * 0.5) / Math.sin(fovY * 0.5);
        var w:Number = h * aspect;
        var ffn:Number = far / (far - near);
        projectionMatrix.e00 = w;
        projectionMatrix.e01 = 0;
        projectionMatrix.e02 = 0;
        projectionMatrix.e03 = 0;
        projectionMatrix.e10 = 0;
        projectionMatrix.e11 = h;
        projectionMatrix.e12 = 0;
        projectionMatrix.e13 = 0;
        projectionMatrix.e20 = 0;
        projectionMatrix.e21 = 0;
        projectionMatrix.e22 = ffn;
        projectionMatrix.e23 = 1;
        projectionMatrix.e30 = 0;
        projectionMatrix.e31 = 0;
        projectionMatrix.e32 = -near * ffn;
        projectionMatrix.e33 = 0;
    }
}

class Light {
    public static const DISABLED:uint = 0;
    public static const DIRECTIONAL:uint = 1;
    public var dir:Vec3D;
    public var pos:Vec3D;
    public var r:Number;
    public var g:Number;
    public var b:Number;
    public var type:uint;
    public function Light() {
        type = DISABLED;
        dir = new Vec3D();
        pos = new Vec3D();
    }
    
    public function directional(dx:Number, dy:Number, dz:Number, r:Number, g:Number, b:Number):void {
        type = DIRECTIONAL;
        dir.setVector(dx, dy, dz);
        dir.normalize();
        this.r = r;
        this.g = g;
        this.b = b;
    }
    
    public function disable():void {
        type = DISABLED;
    }
}

class Model {
    public var vertices:Vector.<Vertex>;
    public var faces:Vector.<Vector.<uint>>;
    public function Model() {
        vertices = new Vector.<Vertex>();
        faces = new Vector.<Vector.<uint>>();
    }
    
    public function toDevil():void {
        vertices[ 0 ] = new Vertex( 0.25, 3.786098, -0.336729 );
        vertices[ 1 ] = new Vertex( 0.095491, 3.786098, -0.448986 );
        vertices[ 2 ] = new Vertex( -0.095492, 3.786098, -0.448985 );
        vertices[ 3 ] = new Vertex( -0.25, 3.786098, -0.336728 );
        vertices[ 4 ] = new Vertex( -0.309017, 3.786098, -0.155093 );
        vertices[ 5 ] = new Vertex( -0.25, 3.786098, 0.026543 );
        vertices[ 6 ] = new Vertex( -0.111373, 3.768411, 0.137338 );
        vertices[ 7 ] = new Vertex( 0.111373, 3.768411, 0.137338 );
        vertices[ 8 ] = new Vertex( 0.25, 3.786098, 0.026543 );
        vertices[ 9 ] = new Vertex( 0.309017, 3.786098, -0.155093 );
        vertices[ 10 ] = new Vertex( 0.475528, 3.928138, -0.500584 );
        vertices[ 11 ] = new Vertex( 0.181636, 3.928138, -0.71411 );
        vertices[ 12 ] = new Vertex( -0.181636, 3.928138, -0.71411 );
        vertices[ 13 ] = new Vertex( -0.475528, 3.928138, -0.500584 );
        vertices[ 14 ] = new Vertex( -0.587785, 3.928138, -0.155093 );
        vertices[ 15 ] = new Vertex( -0.422427, 3.915709, 0.223133 );
        vertices[ 16 ] = new Vertex( -0.117944, 3.839431, 0.401857 );
        vertices[ 17 ] = new Vertex( 0.117944, 3.839431, 0.401857 );
        vertices[ 18 ] = new Vertex( 0.422427, 3.915709, 0.223133 );
        vertices[ 19 ] = new Vertex( 0.587785, 3.928138, -0.155093 );
        vertices[ 20 ] = new Vertex( 0.654509, 4.14937, -0.630621 );
        vertices[ 21 ] = new Vertex( 0.25, 4.14937, -0.924514 );
        vertices[ 22 ] = new Vertex( -0.25, 4.14937, -0.924514 );
        vertices[ 23 ] = new Vertex( -0.654509, 4.14937, -0.630621 );
        vertices[ 24 ] = new Vertex( -0.809017, 4.14937, -0.155093 );
        vertices[ 25 ] = new Vertex( -0.608856, 4.110299, 0.320436 );
        vertices[ 26 ] = new Vertex( -0.220355, 4.067378, 0.598615 );
        vertices[ 27 ] = new Vertex( 0.220355, 4.067378, 0.598615 );
        vertices[ 28 ] = new Vertex( 0.608856, 4.110299, 0.320435 );
        vertices[ 29 ] = new Vertex( 0.809017, 4.14937, -0.155093 );
        vertices[ 30 ] = new Vertex( 0.769421, 4.428138, -0.71411 );
        vertices[ 31 ] = new Vertex( 0.293893, 4.428138, -1.059602 );
        vertices[ 32 ] = new Vertex( -0.293893, 4.428138, -1.059601 );
        vertices[ 33 ] = new Vertex( -0.769421, 4.428138, -0.71411 );
        vertices[ 34 ] = new Vertex( -0.951057, 4.428138, -0.155093 );
        vertices[ 35 ] = new Vertex( -0.769421, 4.428138, 0.403924 );
        vertices[ 36 ] = new Vertex( -0.293893, 4.428138, 0.749416 );
        vertices[ 37 ] = new Vertex( 0.293893, 4.428138, 0.749416 );
        vertices[ 38 ] = new Vertex( 0.769421, 4.428138, 0.403924 );
        vertices[ 39 ] = new Vertex( 0.951057, 4.428138, -0.155093 );
        vertices[ 40 ] = new Vertex( 0.809017, 4.737155, -0.742878 );
        vertices[ 41 ] = new Vertex( 0.309017, 4.737155, -1.106149 );
        vertices[ 42 ] = new Vertex( -0.309017, 4.737155, -1.106149 );
        vertices[ 43 ] = new Vertex( -0.809017, 4.737155, -0.742878 );
        vertices[ 44 ] = new Vertex( -1, 4.737155, -0.155093 );
        vertices[ 45 ] = new Vertex( -0.809017, 4.737155, 0.432693 );
        vertices[ 46 ] = new Vertex( -0.309017, 4.737155, 0.795964 );
        vertices[ 47 ] = new Vertex( 0.309017, 4.737155, 0.795964 );
        vertices[ 48 ] = new Vertex( 0.809017, 4.737155, 0.432692 );
        vertices[ 49 ] = new Vertex( 1, 4.737155, -0.155093 );
        vertices[ 50 ] = new Vertex( 0.769421, 5.046173, -0.71411 );
        vertices[ 51 ] = new Vertex( 0.293893, 5.046173, -1.059602 );
        vertices[ 52 ] = new Vertex( -0.293893, 5.046173, -1.059601 );
        vertices[ 53 ] = new Vertex( -0.769421, 5.046173, -0.71411 );
        vertices[ 54 ] = new Vertex( -0.951057, 5.046173, -0.155093 );
        vertices[ 55 ] = new Vertex( -0.769421, 5.046173, 0.403924 );
        vertices[ 56 ] = new Vertex( -0.293893, 5.046173, 0.749416 );
        vertices[ 57 ] = new Vertex( 0.293893, 5.046173, 0.749416 );
        vertices[ 58 ] = new Vertex( 0.769421, 5.046173, 0.403924 );
        vertices[ 59 ] = new Vertex( 0.951057, 5.046173, -0.155093 );
        vertices[ 60 ] = new Vertex( 0.654509, 5.32494, -0.630621 );
        vertices[ 61 ] = new Vertex( 0.25, 5.32494, -0.924514 );
        vertices[ 62 ] = new Vertex( -0.25, 5.32494, -0.924514 );
        vertices[ 63 ] = new Vertex( -0.654509, 5.32494, -0.630621 );
        vertices[ 64 ] = new Vertex( -0.809017, 5.32494, -0.155093 );
        vertices[ 65 ] = new Vertex( -0.654509, 5.32494, 0.320436 );
        vertices[ 66 ] = new Vertex( -0.25, 5.32494, 0.614328 );
        vertices[ 67 ] = new Vertex( 0.25, 5.32494, 0.614328 );
        vertices[ 68 ] = new Vertex( 0.654509, 5.32494, 0.320435 );
        vertices[ 69 ] = new Vertex( 0.809017, 5.32494, -0.155093 );
        vertices[ 70 ] = new Vertex( 0.606805, 5.546173, -0.474751 );
        vertices[ 71 ] = new Vertex( 0.181636, 5.546173, -0.71411 );
        vertices[ 72 ] = new Vertex( -0.181636, 5.546173, -0.71411 );
        vertices[ 73 ] = new Vertex( -0.606805, 5.546173, -0.474751 );
        vertices[ 74 ] = new Vertex( -0.695686, 5.546173, -0.155093 );
        vertices[ 75 ] = new Vertex( -0.475528, 5.546173, 0.190399 );
        vertices[ 76 ] = new Vertex( -0.181636, 5.546173, 0.403924 );
        vertices[ 77 ] = new Vertex( 0.181636, 5.546173, 0.403924 );
        vertices[ 78 ] = new Vertex( 0.475528, 5.546173, 0.190399 );
        vertices[ 79 ] = new Vertex( 0.695686, 5.546173, -0.155093 );
        vertices[ 80 ] = new Vertex( 0.378391, 5.688212, -0.391052 );
        vertices[ 81 ] = new Vertex( 0.095491, 5.688212, -0.448986 );
        vertices[ 82 ] = new Vertex( -0.095492, 5.688212, -0.448985 );
        vertices[ 83 ] = new Vertex( -0.378391, 5.688212, -0.391052 );
        vertices[ 84 ] = new Vertex( -0.467717, 5.688212, -0.10077 );
        vertices[ 85 ] = new Vertex( -0.25, 5.688212, 0.026543 );
        vertices[ 86 ] = new Vertex( -0.095491, 5.688212, 0.1388 );
        vertices[ 87 ] = new Vertex( 0.095492, 5.688212, 0.1388 );
        vertices[ 88 ] = new Vertex( 0.25, 5.688212, 0.026543 );
        vertices[ 89 ] = new Vertex( 0.467717, 5.688212, -0.10077 );
        vertices[ 90 ] = new Vertex( 0, 3.737155, -0.155093 );
        vertices[ 91 ] = new Vertex( 0, 5.737155, -0.155093 );
        vertices[ 92 ] = new Vertex( -0.53191, 1.7819, 0.536913 );
        vertices[ 93 ] = new Vertex( -0.171565, 1.817217, 0.796843 );
        vertices[ 94 ] = new Vertex( 0.192573, 1.817217, 0.796843 );
        vertices[ 95 ] = new Vertex( 0.53191, 1.7819, 0.536913 );
        vertices[ 96 ] = new Vertex( -0.6159, 2.149882, 0.510469 );
        vertices[ 97 ] = new Vertex( -0.210252, 2.15998, 0.802215 );
        vertices[ 98 ] = new Vertex( 0.210252, 2.15998, 0.802215 );
        vertices[ 99 ] = new Vertex( 0.6159, 2.149882, 0.510469 );
        vertices[ 100 ] = new Vertex( -0.575221, 2.617895, 0.456948 );
        vertices[ 101 ] = new Vertex( -0.19174, 2.617895, 0.764118 );
        vertices[ 102 ] = new Vertex( 0.19174, 2.617895, 0.749676 );
        vertices[ 103 ] = new Vertex( 0.575221, 2.617895, 0.456948 );
        vertices[ 104 ] = new Vertex( -0.433055, 3.049706, 0.410744 );
        vertices[ 105 ] = new Vertex( -0.159968, 3.049706, 0.647897 );
        vertices[ 106 ] = new Vertex( 0.159968, 3.049706, 0.647897 );
        vertices[ 107 ] = new Vertex( 0.433055, 3.049706, 0.410744 );
        vertices[ 108 ] = new Vertex( -0.305742, 3.445872, 0.378327 );
        vertices[ 109 ] = new Vertex( -0.153604, 3.40346, 0.54068 );
        vertices[ 110 ] = new Vertex( 0.153604, 3.40346, 0.54068 );
        vertices[ 111 ] = new Vertex( 0.305742, 3.445872, 0.378327 );
        vertices[ 112 ] = new Vertex( -0.265119, 3.597068, 0.370343 );
        vertices[ 113 ] = new Vertex( -0.157858, 3.70635, 0.435882 );
        vertices[ 114 ] = new Vertex( 0.157858, 3.70635, 0.435882 );
        vertices[ 115 ] = new Vertex( 0.265119, 3.597068, 0.370343 );
        vertices[ 116 ] = new Vertex( -0.265119, 3.597068, 0.235533 );
        vertices[ 117 ] = new Vertex( -0.136217, 3.70635, 0.152262 );
        vertices[ 118 ] = new Vertex( 0.136217, 3.70635, 0.152262 );
        vertices[ 119 ] = new Vertex( 0.265119, 3.597068, 0.235533 );
        vertices[ 120 ] = new Vertex( -0.305742, 3.445872, 0.196811 );
        vertices[ 121 ] = new Vertex( -0.139454, 3.442234, 0.071393 );
        vertices[ 122 ] = new Vertex( 0.139454, 3.442234, 0.071393 );
        vertices[ 123 ] = new Vertex( 0.305742, 3.445872, 0.196811 );
        vertices[ 124 ] = new Vertex( -0.445053, 3.049706, 0.104664 );
        vertices[ 125 ] = new Vertex( -0.148732, 3.049706, -0.107922 );
        vertices[ 126 ] = new Vertex( 0.148732, 3.049706, -0.107922 );
        vertices[ 127 ] = new Vertex( 0.445053, 3.049706, 0.104664 );
        vertices[ 128 ] = new Vertex( -0.575221, 2.617895, 0.043159 );
        vertices[ 129 ] = new Vertex( -0.19174, 2.617895, -0.23414 );
        vertices[ 130 ] = new Vertex( 0.19174, 2.617895, -0.23414 );
        vertices[ 131 ] = new Vertex( 0.575221, 2.617895, 0.043159 );
        vertices[ 132 ] = new Vertex( -0.6159, 2.149882, 0.044771 );
        vertices[ 133 ] = new Vertex( -0.2053, 2.149882, -0.260431 );
        vertices[ 134 ] = new Vertex( 0.2053, 2.149882, -0.260431 );
        vertices[ 135 ] = new Vertex( 0.6159, 2.149882, 0.044771 );
        vertices[ 136 ] = new Vertex( -0.548436, 1.7819, 0.112683 );
        vertices[ 137 ] = new Vertex( -0.192573, 1.802284, -0.143604 );
        vertices[ 138 ] = new Vertex( 0.192573, 1.802284, -0.143604 );
        vertices[ 139 ] = new Vertex( 0.548436, 1.7819, 0.112682 );
        vertices[ 140 ] = new Vertex( 0.580005, 3.393497, 0.199693 );
        vertices[ 141 ] = new Vertex( 0.580005, 3.393497, 0.419204 );
        vertices[ 142 ] = new Vertex( 0.610045, 3.598429, 0.193259 );
        vertices[ 143 ] = new Vertex( 0.610045, 3.598429, 0.432388 );
        vertices[ 144 ] = new Vertex( -0.580005, 3.393497, 0.199693 );
        vertices[ 145 ] = new Vertex( -0.580005, 3.393497, 0.419204 );
        vertices[ 146 ] = new Vertex( -0.610045, 3.598429, 0.432388 );
        vertices[ 147 ] = new Vertex( -0.610045, 3.598429, 0.193259 );
        vertices[ 148 ] = new Vertex( 0.912338, 3.324297, 0.188779 );
        vertices[ 149 ] = new Vertex( 0.912338, 3.324297, 0.4268 );
        vertices[ 150 ] = new Vertex( 0.947241, 3.604049, 0.183042 );
        vertices[ 151 ] = new Vertex( 0.947241, 3.604049, 0.442334 );
        vertices[ 152 ] = new Vertex( -0.912338, 3.324297, 0.188779 );
        vertices[ 153 ] = new Vertex( -0.912338, 3.324297, 0.4268 );
        vertices[ 154 ] = new Vertex( -0.947241, 3.604049, 0.442334 );
        vertices[ 155 ] = new Vertex( -0.947241, 3.604049, 0.183042 );
        vertices[ 156 ] = new Vertex( 1.225867, 3.245269, 0.15972 );
        vertices[ 157 ] = new Vertex( 1.225867, 3.245269, 0.451957 );
        vertices[ 158 ] = new Vertex( 1.283388, 3.609186, 0.157384 );
        vertices[ 159 ] = new Vertex( 1.283388, 3.609186, 0.475737 );
        vertices[ 160 ] = new Vertex( -1.225867, 3.245269, 0.15972 );
        vertices[ 161 ] = new Vertex( -1.175735, 3.245269, 0.451957 );
        vertices[ 162 ] = new Vertex( -1.283388, 3.609186, 0.475737 );
        vertices[ 163 ] = new Vertex( -1.283388, 3.609186, 0.157384 );
        vertices[ 164 ] = new Vertex( 1.552759, 3.169208, 0.137581 );
        vertices[ 165 ] = new Vertex( 1.552759, 3.169208, 0.47107 );
        vertices[ 166 ] = new Vertex( 1.63858, 3.607229, 0.134915 );
        vertices[ 167 ] = new Vertex( 1.63858, 3.607229, 0.498206 );
        vertices[ 168 ] = new Vertex( -1.552759, 3.169208, 0.137581 );
        vertices[ 169 ] = new Vertex( -1.552759, 3.169208, 0.47107 );
        vertices[ 170 ] = new Vertex( -1.63858, 3.607229, 0.498206 );
        vertices[ 171 ] = new Vertex( -1.63858, 3.607229, 0.134915 );
        vertices[ 172 ] = new Vertex( 1.770551, 3.342976, 0.173459 );
        vertices[ 173 ] = new Vertex( 1.770551, 3.342976, 0.395785 );
        vertices[ 174 ] = new Vertex( 1.819058, 3.598383, 0.171682 );
        vertices[ 175 ] = new Vertex( 1.819058, 3.598383, 0.413876 );
        vertices[ 176 ] = new Vertex( -1.770551, 3.342976, 0.173459 );
        vertices[ 177 ] = new Vertex( -1.770551, 3.342976, 0.395785 );
        vertices[ 178 ] = new Vertex( -1.819058, 3.598383, 0.413876 );
        vertices[ 179 ] = new Vertex( -1.819058, 3.598383, 0.171682 );
        vertices[ 180 ] = new Vertex( -0.487882, 1.576912, 0.152374 );
        vertices[ 181 ] = new Vertex( -0.166198, 1.655506, 0.080379 );
        vertices[ 182 ] = new Vertex( -0.166198, 1.655506, 0.590056 );
        vertices[ 183 ] = new Vertex( -0.487882, 1.576912, 0.475834 );
        vertices[ 184 ] = new Vertex( 0.165529, 1.655506, 0.080379 );
        vertices[ 185 ] = new Vertex( 0.487882, 1.576912, 0.152374 );
        vertices[ 186 ] = new Vertex( 0.487882, 1.576912, 0.475834 );
        vertices[ 187 ] = new Vertex( 0.165529, 1.655506, 0.590056 );
        vertices[ 188 ] = new Vertex( -0.477529, 1.32991, 0.14587 );
        vertices[ 189 ] = new Vertex( -0.206713, 1.32813, 0.149637 );
        vertices[ 190 ] = new Vertex( -0.206713, 1.32813, 0.4439 );
        vertices[ 191 ] = new Vertex( -0.477529, 1.32991, 0.452245 );
        vertices[ 192 ] = new Vertex( 0.206713, 1.32813, 0.149637 );
        vertices[ 193 ] = new Vertex( 0.477529, 1.32991, 0.14587 );
        vertices[ 194 ] = new Vertex( 0.477529, 1.32991, 0.452245 );
        vertices[ 195 ] = new Vertex( 0.206713, 1.32813, 0.4439 );
        vertices[ 196 ] = new Vertex( -0.492932, 1.032668, 0.150986 );
        vertices[ 197 ] = new Vertex( -0.20993, 1.030829, 0.139273 );
        vertices[ 198 ] = new Vertex( -0.20993, 1.030829, 0.448787 );
        vertices[ 199 ] = new Vertex( -0.492932, 1.032668, 0.442565 );
        vertices[ 200 ] = new Vertex( 0.20993, 1.030829, 0.139273 );
        vertices[ 201 ] = new Vertex( 0.492932, 1.032668, 0.150986 );
        vertices[ 202 ] = new Vertex( 0.492932, 1.032668, 0.442565 );
        vertices[ 203 ] = new Vertex( 0.209929, 1.030829, 0.448787 );
        vertices[ 204 ] = new Vertex( -0.520434, 0.76545, 0.165672 );
        vertices[ 205 ] = new Vertex( -0.207023, 0.763274, 0.147208 );
        vertices[ 206 ] = new Vertex( -0.207023, 0.763274, 0.45828 );
        vertices[ 207 ] = new Vertex( -0.520434, 0.76545, 0.457477 );
        vertices[ 208 ] = new Vertex( 0.207023, 0.763274, 0.147208 );
        vertices[ 209 ] = new Vertex( 0.520434, 0.76545, 0.165673 );
        vertices[ 210 ] = new Vertex( 0.520434, 0.76545, 0.457477 );
        vertices[ 211 ] = new Vertex( 0.207023, 0.763274, 0.45828 );
        vertices[ 212 ] = new Vertex( -0.552651, 0.45709, 0.174518 );
        vertices[ 213 ] = new Vertex( -0.187566, 0.454515, 0.159627 );
        vertices[ 214 ] = new Vertex( -0.187566, 0.454515, 0.514442 );
        vertices[ 215 ] = new Vertex( -0.552651, 0.45709, 0.506532 );
        vertices[ 216 ] = new Vertex( 0.187566, 0.454515, 0.159627 );
        vertices[ 217 ] = new Vertex( 0.552651, 0.45709, 0.174518 );
        vertices[ 218 ] = new Vertex( 0.552651, 0.45709, 0.506532 );
        vertices[ 219 ] = new Vertex( 0.187566, 0.454515, 0.514442 );
        vertices[ 220 ] = new Vertex( -0.576621, 0.126275, 0.181601 );
        vertices[ 221 ] = new Vertex( -0.161041, 0.123699, 0.166711 );
        vertices[ 222 ] = new Vertex( -0.161041, 0.123699, 0.555285 );
        vertices[ 223 ] = new Vertex( -0.576621, 0.126275, 0.547375 );
        vertices[ 224 ] = new Vertex( 0.161041, 0.123699, 0.166711 );
        vertices[ 225 ] = new Vertex( 0.576621, 0.126274, 0.181602 );
        vertices[ 226 ] = new Vertex( 0.576621, 0.126274, 0.547375 );
        vertices[ 227 ] = new Vertex( 0.161041, 0.123699, 0.555285 );
        vertices[ 228 ] = new Vertex( -0.591214, 0, 0.129318 );
        vertices[ 229 ] = new Vertex( -0.149426, 0, 0.114427 );
        vertices[ 230 ] = new Vertex( -0.14318, 0, 0.555285 );
        vertices[ 231 ] = new Vertex( -0.577264, 0, 0.547375 );
        vertices[ 232 ] = new Vertex( 0.149426, 0, 0.114427 );
        vertices[ 233 ] = new Vertex( 0.591214, 0, 0.129318 );
        vertices[ 234 ] = new Vertex( 0.577264, 0, 0.547375 );
        vertices[ 235 ] = new Vertex( 0.14318, 0, 0.555285 );
        vertices[ 236 ] = new Vertex( -0.698675, 5.84287, -0.454833 );
        vertices[ 237 ] = new Vertex( -0.757201, 5.84287, -0.244346 );
        vertices[ 238 ] = new Vertex( -0.607089, 5.936401, -0.208575 );
        vertices[ 239 ] = new Vertex( -0.54827, 5.936401, -0.399719 );
        vertices[ 240 ] = new Vertex( 0.757201, 5.84287, -0.244346 );
        vertices[ 241 ] = new Vertex( 0.698675, 5.84287, -0.454833 );
        vertices[ 242 ] = new Vertex( 0.54827, 5.936401, -0.399719 );
        vertices[ 243 ] = new Vertex( 0.607089, 5.936401, -0.208575 );
        vertices[ 244 ] = new Vertex( -0.792427, 6.206368, -0.380862 );
        vertices[ 245 ] = new Vertex( 0.792427, 6.206368, -0.380862 );
        vertices[ 246 ] = new Vertex( -0.040033, 1.84864, 0.864447 );
        vertices[ 247 ] = new Vertex( 0.049882, 1.84864, 0.864447 );
        vertices[ 248 ] = new Vertex( 0.054248, 1.94582, 0.86597 );
        vertices[ 249 ] = new Vertex( -0.049586, 1.94582, 0.86597 );
        vertices[ 250 ] = new Vertex( -0.029867, 1.856531, 1.110447 );
        vertices[ 251 ] = new Vertex( 0.039068, 1.856531, 1.110447 );
        vertices[ 252 ] = new Vertex( 0.042415, 1.931036, 1.111615 );
        vertices[ 253 ] = new Vertex( -0.037191, 1.931036, 1.111615 );
        vertices[ 254 ] = new Vertex( -0.029144, 1.853868, 1.333744 );
        vertices[ 255 ] = new Vertex( -0.02842, 1.851205, 1.557042 );
        vertices[ 256 ] = new Vertex( -0.027696, 1.848542, 1.780339 );
        vertices[ 257 ] = new Vertex( -0.026973, 1.845879, 2.003637 );
        vertices[ 258 ] = new Vertex( -0.026249, 1.843216, 2.226934 );
        vertices[ 259 ] = new Vertex( -0.025525, 1.840553, 2.450232 );
        vertices[ 260 ] = new Vertex( -0.024801, 1.83789, 2.673529 );
        vertices[ 261 ] = new Vertex( -0.024078, 1.835227, 2.896827 );
        vertices[ 262 ] = new Vertex( -0.023354, 1.832564, 3.120124 );
        vertices[ 263 ] = new Vertex( -0.02263, 1.829901, 3.343421 );
        vertices[ 264 ] = new Vertex( 0.038298, 1.853868, 1.333744 );
        vertices[ 265 ] = new Vertex( 0.037528, 1.851205, 1.557042 );
        vertices[ 266 ] = new Vertex( 0.036758, 1.848542, 1.780339 );
        vertices[ 267 ] = new Vertex( 0.035988, 1.845879, 2.003637 );
        vertices[ 268 ] = new Vertex( 0.035219, 1.843216, 2.226934 );
        vertices[ 269 ] = new Vertex( 0.034449, 1.840553, 2.450232 );
        vertices[ 270 ] = new Vertex( 0.033679, 1.83789, 2.673529 );
        vertices[ 271 ] = new Vertex( 0.032909, 1.835227, 2.896827 );
        vertices[ 272 ] = new Vertex( 0.032139, 1.832564, 3.120124 );
        vertices[ 273 ] = new Vertex( 0.031369, 1.829901, 3.343421 );
        vertices[ 274 ] = new Vertex( 0.041572, 1.926759, 1.334887 );
        vertices[ 275 ] = new Vertex( 0.04073, 1.922482, 1.558159 );
        vertices[ 276 ] = new Vertex( 0.039887, 1.918204, 1.781431 );
        vertices[ 277 ] = new Vertex( 0.039045, 1.913927, 2.004703 );
        vertices[ 278 ] = new Vertex( 0.038203, 1.90965, 2.227975 );
        vertices[ 279 ] = new Vertex( 0.03736, 1.905373, 2.451247 );
        vertices[ 280 ] = new Vertex( 0.036518, 1.901095, 2.67452 );
        vertices[ 281 ] = new Vertex( 0.035676, 1.896818, 2.897791 );
        vertices[ 282 ] = new Vertex( 0.034833, 1.892541, 3.121064 );
        vertices[ 283 ] = new Vertex( 0.033991, 1.888264, 3.344336 );
        vertices[ 284 ] = new Vertex( -0.036309, 1.926759, 1.334887 );
        vertices[ 285 ] = new Vertex( -0.035427, 1.922482, 1.558159 );
        vertices[ 286 ] = new Vertex( -0.034544, 1.918204, 1.781431 );
        vertices[ 287 ] = new Vertex( -0.033662, 1.913927, 2.004703 );
        vertices[ 288 ] = new Vertex( -0.032779, 1.90965, 2.227975 );
        vertices[ 289 ] = new Vertex( -0.031897, 1.905373, 2.451247 );
        vertices[ 290 ] = new Vertex( -0.031015, 1.901095, 2.67452 );
        vertices[ 291 ] = new Vertex( -0.030132, 1.896818, 2.897791 );
        vertices[ 292 ] = new Vertex( -0.02925, 1.892541, 3.121064 );
        vertices[ 293 ] = new Vertex( -0.028367, 1.888264, 3.344336 );
        vertices[ 294 ] = new Vertex( -0.10154, 1.737756, 3.405142 );
        vertices[ 295 ] = new Vertex( 0.115313, 1.737756, 3.405142 );
        vertices[ 296 ] = new Vertex( 0.12584, 1.972129, 3.408815 );
        vertices[ 297 ] = new Vertex( -0.124579, 1.972129, 3.408815 );
        vertices[ 298 ] = new Vertex( 0.003758, 1.849526, 3.752653 );
        for (var i:int = 0; i < 594; i++)
            faces[i] = new Vector.<uint>( 3, true );
        faces[ 0 ][ 0 ] = 0;
        faces[ 0 ][ 1 ] = 1;
        faces[ 0 ][ 2 ] = 10;
        faces[ 1 ][ 0 ] = 10;
        faces[ 1 ][ 1 ] = 1;
        faces[ 1 ][ 2 ] = 11;
        faces[ 2 ][ 0 ] = 1;
        faces[ 2 ][ 1 ] = 2;
        faces[ 2 ][ 2 ] = 11;
        faces[ 3 ][ 0 ] = 11;
        faces[ 3 ][ 1 ] = 2;
        faces[ 3 ][ 2 ] = 12;
        faces[ 4 ][ 0 ] = 2;
        faces[ 4 ][ 1 ] = 3;
        faces[ 4 ][ 2 ] = 12;
        faces[ 5 ][ 0 ] = 12;
        faces[ 5 ][ 1 ] = 3;
        faces[ 5 ][ 2 ] = 13;
        faces[ 6 ][ 0 ] = 3;
        faces[ 6 ][ 1 ] = 4;
        faces[ 6 ][ 2 ] = 13;
        faces[ 7 ][ 0 ] = 13;
        faces[ 7 ][ 1 ] = 4;
        faces[ 7 ][ 2 ] = 14;
        faces[ 8 ][ 0 ] = 4;
        faces[ 8 ][ 1 ] = 5;
        faces[ 8 ][ 2 ] = 14;
        faces[ 9 ][ 0 ] = 14;
        faces[ 9 ][ 1 ] = 5;
        faces[ 9 ][ 2 ] = 15;
        faces[ 10 ][ 0 ] = 5;
        faces[ 10 ][ 1 ] = 6;
        faces[ 10 ][ 2 ] = 15;
        faces[ 11 ][ 0 ] = 15;
        faces[ 11 ][ 1 ] = 6;
        faces[ 11 ][ 2 ] = 16;
        faces[ 12 ][ 0 ] = 8;
        faces[ 12 ][ 1 ] = 18;
        faces[ 12 ][ 2 ] = 7;
        faces[ 13 ][ 0 ] = 7;
        faces[ 13 ][ 1 ] = 18;
        faces[ 13 ][ 2 ] = 17;
        faces[ 14 ][ 0 ] = 9;
        faces[ 14 ][ 1 ] = 19;
        faces[ 14 ][ 2 ] = 8;
        faces[ 15 ][ 0 ] = 8;
        faces[ 15 ][ 1 ] = 19;
        faces[ 15 ][ 2 ] = 18;
        faces[ 16 ][ 0 ] = 9;
        faces[ 16 ][ 1 ] = 0;
        faces[ 16 ][ 2 ] = 19;
        faces[ 17 ][ 0 ] = 19;
        faces[ 17 ][ 1 ] = 0;
        faces[ 17 ][ 2 ] = 10;
        faces[ 18 ][ 0 ] = 10;
        faces[ 18 ][ 1 ] = 11;
        faces[ 18 ][ 2 ] = 20;
        faces[ 19 ][ 0 ] = 20;
        faces[ 19 ][ 1 ] = 11;
        faces[ 19 ][ 2 ] = 21;
        faces[ 20 ][ 0 ] = 11;
        faces[ 20 ][ 1 ] = 12;
        faces[ 20 ][ 2 ] = 21;
        faces[ 21 ][ 0 ] = 21;
        faces[ 21 ][ 1 ] = 12;
        faces[ 21 ][ 2 ] = 22;
        faces[ 22 ][ 0 ] = 12;
        faces[ 22 ][ 1 ] = 13;
        faces[ 22 ][ 2 ] = 22;
        faces[ 23 ][ 0 ] = 22;
        faces[ 23 ][ 1 ] = 13;
        faces[ 23 ][ 2 ] = 23;
        faces[ 24 ][ 0 ] = 13;
        faces[ 24 ][ 1 ] = 14;
        faces[ 24 ][ 2 ] = 23;
        faces[ 25 ][ 0 ] = 23;
        faces[ 25 ][ 1 ] = 14;
        faces[ 25 ][ 2 ] = 24;
        faces[ 26 ][ 0 ] = 15;
        faces[ 26 ][ 1 ] = 25;
        faces[ 26 ][ 2 ] = 14;
        faces[ 27 ][ 0 ] = 14;
        faces[ 27 ][ 1 ] = 25;
        faces[ 27 ][ 2 ] = 24;
        faces[ 28 ][ 0 ] = 16;
        faces[ 28 ][ 1 ] = 26;
        faces[ 28 ][ 2 ] = 15;
        faces[ 29 ][ 0 ] = 15;
        faces[ 29 ][ 1 ] = 26;
        faces[ 29 ][ 2 ] = 25;
        faces[ 30 ][ 0 ] = 16;
        faces[ 30 ][ 1 ] = 17;
        faces[ 30 ][ 2 ] = 26;
        faces[ 31 ][ 0 ] = 26;
        faces[ 31 ][ 1 ] = 17;
        faces[ 31 ][ 2 ] = 27;
        faces[ 32 ][ 0 ] = 17;
        faces[ 32 ][ 1 ] = 18;
        faces[ 32 ][ 2 ] = 27;
        faces[ 33 ][ 0 ] = 27;
        faces[ 33 ][ 1 ] = 18;
        faces[ 33 ][ 2 ] = 28;
        faces[ 34 ][ 0 ] = 18;
        faces[ 34 ][ 1 ] = 19;
        faces[ 34 ][ 2 ] = 28;
        faces[ 35 ][ 0 ] = 28;
        faces[ 35 ][ 1 ] = 19;
        faces[ 35 ][ 2 ] = 29;
        faces[ 36 ][ 0 ] = 19;
        faces[ 36 ][ 1 ] = 10;
        faces[ 36 ][ 2 ] = 29;
        faces[ 37 ][ 0 ] = 29;
        faces[ 37 ][ 1 ] = 10;
        faces[ 37 ][ 2 ] = 20;
        faces[ 38 ][ 0 ] = 20;
        faces[ 38 ][ 1 ] = 21;
        faces[ 38 ][ 2 ] = 30;
        faces[ 39 ][ 0 ] = 30;
        faces[ 39 ][ 1 ] = 21;
        faces[ 39 ][ 2 ] = 31;
        faces[ 40 ][ 0 ] = 21;
        faces[ 40 ][ 1 ] = 22;
        faces[ 40 ][ 2 ] = 31;
        faces[ 41 ][ 0 ] = 31;
        faces[ 41 ][ 1 ] = 22;
        faces[ 41 ][ 2 ] = 32;
        faces[ 42 ][ 0 ] = 22;
        faces[ 42 ][ 1 ] = 23;
        faces[ 42 ][ 2 ] = 32;
        faces[ 43 ][ 0 ] = 32;
        faces[ 43 ][ 1 ] = 23;
        faces[ 43 ][ 2 ] = 33;
        faces[ 44 ][ 0 ] = 23;
        faces[ 44 ][ 1 ] = 24;
        faces[ 44 ][ 2 ] = 33;
        faces[ 45 ][ 0 ] = 33;
        faces[ 45 ][ 1 ] = 24;
        faces[ 45 ][ 2 ] = 34;
        faces[ 46 ][ 0 ] = 25;
        faces[ 46 ][ 1 ] = 35;
        faces[ 46 ][ 2 ] = 24;
        faces[ 47 ][ 0 ] = 24;
        faces[ 47 ][ 1 ] = 35;
        faces[ 47 ][ 2 ] = 34;
        faces[ 48 ][ 0 ] = 26;
        faces[ 48 ][ 1 ] = 36;
        faces[ 48 ][ 2 ] = 25;
        faces[ 49 ][ 0 ] = 25;
        faces[ 49 ][ 1 ] = 36;
        faces[ 49 ][ 2 ] = 35;
        faces[ 50 ][ 0 ] = 26;
        faces[ 50 ][ 1 ] = 27;
        faces[ 50 ][ 2 ] = 36;
        faces[ 51 ][ 0 ] = 36;
        faces[ 51 ][ 1 ] = 27;
        faces[ 51 ][ 2 ] = 37;
        faces[ 52 ][ 0 ] = 27;
        faces[ 52 ][ 1 ] = 28;
        faces[ 52 ][ 2 ] = 37;
        faces[ 53 ][ 0 ] = 37;
        faces[ 53 ][ 1 ] = 28;
        faces[ 53 ][ 2 ] = 38;
        faces[ 54 ][ 0 ] = 28;
        faces[ 54 ][ 1 ] = 29;
        faces[ 54 ][ 2 ] = 38;
        faces[ 55 ][ 0 ] = 38;
        faces[ 55 ][ 1 ] = 29;
        faces[ 55 ][ 2 ] = 39;
        faces[ 56 ][ 0 ] = 29;
        faces[ 56 ][ 1 ] = 20;
        faces[ 56 ][ 2 ] = 39;
        faces[ 57 ][ 0 ] = 39;
        faces[ 57 ][ 1 ] = 20;
        faces[ 57 ][ 2 ] = 30;
        faces[ 58 ][ 0 ] = 30;
        faces[ 58 ][ 1 ] = 31;
        faces[ 58 ][ 2 ] = 40;
        faces[ 59 ][ 0 ] = 40;
        faces[ 59 ][ 1 ] = 31;
        faces[ 59 ][ 2 ] = 41;
        faces[ 60 ][ 0 ] = 31;
        faces[ 60 ][ 1 ] = 32;
        faces[ 60 ][ 2 ] = 41;
        faces[ 61 ][ 0 ] = 41;
        faces[ 61 ][ 1 ] = 32;
        faces[ 61 ][ 2 ] = 42;
        faces[ 62 ][ 0 ] = 32;
        faces[ 62 ][ 1 ] = 33;
        faces[ 62 ][ 2 ] = 42;
        faces[ 63 ][ 0 ] = 42;
        faces[ 63 ][ 1 ] = 33;
        faces[ 63 ][ 2 ] = 43;
        faces[ 64 ][ 0 ] = 33;
        faces[ 64 ][ 1 ] = 34;
        faces[ 64 ][ 2 ] = 43;
        faces[ 65 ][ 0 ] = 43;
        faces[ 65 ][ 1 ] = 34;
        faces[ 65 ][ 2 ] = 44;
        faces[ 66 ][ 0 ] = 34;
        faces[ 66 ][ 1 ] = 35;
        faces[ 66 ][ 2 ] = 44;
        faces[ 67 ][ 0 ] = 44;
        faces[ 67 ][ 1 ] = 35;
        faces[ 67 ][ 2 ] = 45;
        faces[ 68 ][ 0 ] = 35;
        faces[ 68 ][ 1 ] = 36;
        faces[ 68 ][ 2 ] = 45;
        faces[ 69 ][ 0 ] = 45;
        faces[ 69 ][ 1 ] = 36;
        faces[ 69 ][ 2 ] = 46;
        faces[ 70 ][ 0 ] = 36;
        faces[ 70 ][ 1 ] = 37;
        faces[ 70 ][ 2 ] = 46;
        faces[ 71 ][ 0 ] = 46;
        faces[ 71 ][ 1 ] = 37;
        faces[ 71 ][ 2 ] = 47;
        faces[ 72 ][ 0 ] = 37;
        faces[ 72 ][ 1 ] = 38;
        faces[ 72 ][ 2 ] = 47;
        faces[ 73 ][ 0 ] = 47;
        faces[ 73 ][ 1 ] = 38;
        faces[ 73 ][ 2 ] = 48;
        faces[ 74 ][ 0 ] = 38;
        faces[ 74 ][ 1 ] = 39;
        faces[ 74 ][ 2 ] = 48;
        faces[ 75 ][ 0 ] = 48;
        faces[ 75 ][ 1 ] = 39;
        faces[ 75 ][ 2 ] = 49;
        faces[ 76 ][ 0 ] = 39;
        faces[ 76 ][ 1 ] = 30;
        faces[ 76 ][ 2 ] = 49;
        faces[ 77 ][ 0 ] = 49;
        faces[ 77 ][ 1 ] = 30;
        faces[ 77 ][ 2 ] = 40;
        faces[ 78 ][ 0 ] = 40;
        faces[ 78 ][ 1 ] = 41;
        faces[ 78 ][ 2 ] = 50;
        faces[ 79 ][ 0 ] = 50;
        faces[ 79 ][ 1 ] = 41;
        faces[ 79 ][ 2 ] = 51;
        faces[ 80 ][ 0 ] = 41;
        faces[ 80 ][ 1 ] = 42;
        faces[ 80 ][ 2 ] = 51;
        faces[ 81 ][ 0 ] = 51;
        faces[ 81 ][ 1 ] = 42;
        faces[ 81 ][ 2 ] = 52;
        faces[ 82 ][ 0 ] = 42;
        faces[ 82 ][ 1 ] = 43;
        faces[ 82 ][ 2 ] = 52;
        faces[ 83 ][ 0 ] = 52;
        faces[ 83 ][ 1 ] = 43;
        faces[ 83 ][ 2 ] = 53;
        faces[ 84 ][ 0 ] = 43;
        faces[ 84 ][ 1 ] = 44;
        faces[ 84 ][ 2 ] = 53;
        faces[ 85 ][ 0 ] = 53;
        faces[ 85 ][ 1 ] = 44;
        faces[ 85 ][ 2 ] = 54;
        faces[ 86 ][ 0 ] = 44;
        faces[ 86 ][ 1 ] = 45;
        faces[ 86 ][ 2 ] = 54;
        faces[ 87 ][ 0 ] = 54;
        faces[ 87 ][ 1 ] = 45;
        faces[ 87 ][ 2 ] = 55;
        faces[ 88 ][ 0 ] = 45;
        faces[ 88 ][ 1 ] = 46;
        faces[ 88 ][ 2 ] = 55;
        faces[ 89 ][ 0 ] = 55;
        faces[ 89 ][ 1 ] = 46;
        faces[ 89 ][ 2 ] = 56;
        faces[ 90 ][ 0 ] = 46;
        faces[ 90 ][ 1 ] = 47;
        faces[ 90 ][ 2 ] = 56;
        faces[ 91 ][ 0 ] = 56;
        faces[ 91 ][ 1 ] = 47;
        faces[ 91 ][ 2 ] = 57;
        faces[ 92 ][ 0 ] = 47;
        faces[ 92 ][ 1 ] = 48;
        faces[ 92 ][ 2 ] = 57;
        faces[ 93 ][ 0 ] = 57;
        faces[ 93 ][ 1 ] = 48;
        faces[ 93 ][ 2 ] = 58;
        faces[ 94 ][ 0 ] = 48;
        faces[ 94 ][ 1 ] = 49;
        faces[ 94 ][ 2 ] = 58;
        faces[ 95 ][ 0 ] = 58;
        faces[ 95 ][ 1 ] = 49;
        faces[ 95 ][ 2 ] = 59;
        faces[ 96 ][ 0 ] = 49;
        faces[ 96 ][ 1 ] = 40;
        faces[ 96 ][ 2 ] = 59;
        faces[ 97 ][ 0 ] = 59;
        faces[ 97 ][ 1 ] = 40;
        faces[ 97 ][ 2 ] = 50;
        faces[ 98 ][ 0 ] = 50;
        faces[ 98 ][ 1 ] = 51;
        faces[ 98 ][ 2 ] = 60;
        faces[ 99 ][ 0 ] = 60;
        faces[ 99 ][ 1 ] = 51;
        faces[ 99 ][ 2 ] = 61;
        faces[ 100 ][ 0 ] = 51;
        faces[ 100 ][ 1 ] = 52;
        faces[ 100 ][ 2 ] = 61;
        faces[ 101 ][ 0 ] = 61;
        faces[ 101 ][ 1 ] = 52;
        faces[ 101 ][ 2 ] = 62;
        faces[ 102 ][ 0 ] = 52;
        faces[ 102 ][ 1 ] = 53;
        faces[ 102 ][ 2 ] = 62;
        faces[ 103 ][ 0 ] = 62;
        faces[ 103 ][ 1 ] = 53;
        faces[ 103 ][ 2 ] = 63;
        faces[ 104 ][ 0 ] = 53;
        faces[ 104 ][ 1 ] = 54;
        faces[ 104 ][ 2 ] = 63;
        faces[ 105 ][ 0 ] = 63;
        faces[ 105 ][ 1 ] = 54;
        faces[ 105 ][ 2 ] = 64;
        faces[ 106 ][ 0 ] = 54;
        faces[ 106 ][ 1 ] = 55;
        faces[ 106 ][ 2 ] = 64;
        faces[ 107 ][ 0 ] = 64;
        faces[ 107 ][ 1 ] = 55;
        faces[ 107 ][ 2 ] = 65;
        faces[ 108 ][ 0 ] = 55;
        faces[ 108 ][ 1 ] = 56;
        faces[ 108 ][ 2 ] = 65;
        faces[ 109 ][ 0 ] = 65;
        faces[ 109 ][ 1 ] = 56;
        faces[ 109 ][ 2 ] = 66;
        faces[ 110 ][ 0 ] = 56;
        faces[ 110 ][ 1 ] = 57;
        faces[ 110 ][ 2 ] = 66;
        faces[ 111 ][ 0 ] = 66;
        faces[ 111 ][ 1 ] = 57;
        faces[ 111 ][ 2 ] = 67;
        faces[ 112 ][ 0 ] = 57;
        faces[ 112 ][ 1 ] = 58;
        faces[ 112 ][ 2 ] = 67;
        faces[ 113 ][ 0 ] = 67;
        faces[ 113 ][ 1 ] = 58;
        faces[ 113 ][ 2 ] = 68;
        faces[ 114 ][ 0 ] = 58;
        faces[ 114 ][ 1 ] = 59;
        faces[ 114 ][ 2 ] = 68;
        faces[ 115 ][ 0 ] = 68;
        faces[ 115 ][ 1 ] = 59;
        faces[ 115 ][ 2 ] = 69;
        faces[ 116 ][ 0 ] = 59;
        faces[ 116 ][ 1 ] = 50;
        faces[ 116 ][ 2 ] = 69;
        faces[ 117 ][ 0 ] = 69;
        faces[ 117 ][ 1 ] = 50;
        faces[ 117 ][ 2 ] = 60;
        faces[ 118 ][ 0 ] = 61;
        faces[ 118 ][ 1 ] = 71;
        faces[ 118 ][ 2 ] = 60;
        faces[ 119 ][ 0 ] = 60;
        faces[ 119 ][ 1 ] = 71;
        faces[ 119 ][ 2 ] = 70;
        faces[ 120 ][ 0 ] = 61;
        faces[ 120 ][ 1 ] = 62;
        faces[ 120 ][ 2 ] = 71;
        faces[ 121 ][ 0 ] = 71;
        faces[ 121 ][ 1 ] = 62;
        faces[ 121 ][ 2 ] = 72;
        faces[ 122 ][ 0 ] = 62;
        faces[ 122 ][ 1 ] = 63;
        faces[ 122 ][ 2 ] = 72;
        faces[ 123 ][ 0 ] = 72;
        faces[ 123 ][ 1 ] = 63;
        faces[ 123 ][ 2 ] = 73;
        faces[ 124 ][ 0 ] = 63;
        faces[ 124 ][ 1 ] = 64;
        faces[ 124 ][ 2 ] = 73;
        faces[ 125 ][ 0 ] = 73;
        faces[ 125 ][ 1 ] = 64;
        faces[ 125 ][ 2 ] = 74;
        faces[ 126 ][ 0 ] = 64;
        faces[ 126 ][ 1 ] = 65;
        faces[ 126 ][ 2 ] = 74;
        faces[ 127 ][ 0 ] = 74;
        faces[ 127 ][ 1 ] = 65;
        faces[ 127 ][ 2 ] = 75;
        faces[ 128 ][ 0 ] = 65;
        faces[ 128 ][ 1 ] = 66;
        faces[ 128 ][ 2 ] = 75;
        faces[ 129 ][ 0 ] = 75;
        faces[ 129 ][ 1 ] = 66;
        faces[ 129 ][ 2 ] = 76;
        faces[ 130 ][ 0 ] = 66;
        faces[ 130 ][ 1 ] = 67;
        faces[ 130 ][ 2 ] = 76;
        faces[ 131 ][ 0 ] = 76;
        faces[ 131 ][ 1 ] = 67;
        faces[ 131 ][ 2 ] = 77;
        faces[ 132 ][ 0 ] = 67;
        faces[ 132 ][ 1 ] = 68;
        faces[ 132 ][ 2 ] = 77;
        faces[ 133 ][ 0 ] = 77;
        faces[ 133 ][ 1 ] = 68;
        faces[ 133 ][ 2 ] = 78;
        faces[ 134 ][ 0 ] = 69;
        faces[ 134 ][ 1 ] = 79;
        faces[ 134 ][ 2 ] = 68;
        faces[ 135 ][ 0 ] = 68;
        faces[ 135 ][ 1 ] = 79;
        faces[ 135 ][ 2 ] = 78;
        faces[ 136 ][ 0 ] = 60;
        faces[ 136 ][ 1 ] = 70;
        faces[ 136 ][ 2 ] = 69;
        faces[ 137 ][ 0 ] = 69;
        faces[ 137 ][ 1 ] = 70;
        faces[ 137 ][ 2 ] = 79;
        faces[ 138 ][ 0 ] = 70;
        faces[ 138 ][ 1 ] = 71;
        faces[ 138 ][ 2 ] = 80;
        faces[ 139 ][ 0 ] = 80;
        faces[ 139 ][ 1 ] = 71;
        faces[ 139 ][ 2 ] = 81;
        faces[ 140 ][ 0 ] = 71;
        faces[ 140 ][ 1 ] = 72;
        faces[ 140 ][ 2 ] = 81;
        faces[ 141 ][ 0 ] = 81;
        faces[ 141 ][ 1 ] = 72;
        faces[ 141 ][ 2 ] = 82;
        faces[ 142 ][ 0 ] = 73;
        faces[ 142 ][ 1 ] = 83;
        faces[ 142 ][ 2 ] = 72;
        faces[ 143 ][ 0 ] = 72;
        faces[ 143 ][ 1 ] = 83;
        faces[ 143 ][ 2 ] = 82;
        faces[ 144 ][ 0 ] = 74;
        faces[ 144 ][ 1 ] = 75;
        faces[ 144 ][ 2 ] = 84;
        faces[ 145 ][ 0 ] = 84;
        faces[ 145 ][ 1 ] = 75;
        faces[ 145 ][ 2 ] = 85;
        faces[ 146 ][ 0 ] = 75;
        faces[ 146 ][ 1 ] = 76;
        faces[ 146 ][ 2 ] = 85;
        faces[ 147 ][ 0 ] = 85;
        faces[ 147 ][ 1 ] = 76;
        faces[ 147 ][ 2 ] = 86;
        faces[ 148 ][ 0 ] = 76;
        faces[ 148 ][ 1 ] = 77;
        faces[ 148 ][ 2 ] = 86;
        faces[ 149 ][ 0 ] = 86;
        faces[ 149 ][ 1 ] = 77;
        faces[ 149 ][ 2 ] = 87;
        faces[ 150 ][ 0 ] = 77;
        faces[ 150 ][ 1 ] = 78;
        faces[ 150 ][ 2 ] = 87;
        faces[ 151 ][ 0 ] = 87;
        faces[ 151 ][ 1 ] = 78;
        faces[ 151 ][ 2 ] = 88;
        faces[ 152 ][ 0 ] = 79;
        faces[ 152 ][ 1 ] = 89;
        faces[ 152 ][ 2 ] = 78;
        faces[ 153 ][ 0 ] = 78;
        faces[ 153 ][ 1 ] = 89;
        faces[ 153 ][ 2 ] = 88;
        faces[ 154 ][ 0 ] = 1;
        faces[ 154 ][ 1 ] = 0;
        faces[ 154 ][ 2 ] = 90;
        faces[ 155 ][ 0 ] = 2;
        faces[ 155 ][ 1 ] = 1;
        faces[ 155 ][ 2 ] = 90;
        faces[ 156 ][ 0 ] = 3;
        faces[ 156 ][ 1 ] = 2;
        faces[ 156 ][ 2 ] = 90;
        faces[ 157 ][ 0 ] = 4;
        faces[ 157 ][ 1 ] = 3;
        faces[ 157 ][ 2 ] = 90;
        faces[ 158 ][ 0 ] = 5;
        faces[ 158 ][ 1 ] = 4;
        faces[ 158 ][ 2 ] = 90;
        faces[ 159 ][ 0 ] = 6;
        faces[ 159 ][ 1 ] = 5;
        faces[ 159 ][ 2 ] = 90;
        faces[ 160 ][ 0 ] = 7;
        faces[ 160 ][ 1 ] = 6;
        faces[ 160 ][ 2 ] = 90;
        faces[ 161 ][ 0 ] = 8;
        faces[ 161 ][ 1 ] = 7;
        faces[ 161 ][ 2 ] = 90;
        faces[ 162 ][ 0 ] = 9;
        faces[ 162 ][ 1 ] = 8;
        faces[ 162 ][ 2 ] = 90;
        faces[ 163 ][ 0 ] = 0;
        faces[ 163 ][ 1 ] = 9;
        faces[ 163 ][ 2 ] = 90;
        faces[ 164 ][ 0 ] = 80;
        faces[ 164 ][ 1 ] = 81;
        faces[ 164 ][ 2 ] = 91;
        faces[ 165 ][ 0 ] = 81;
        faces[ 165 ][ 1 ] = 82;
        faces[ 165 ][ 2 ] = 91;
        faces[ 166 ][ 0 ] = 82;
        faces[ 166 ][ 1 ] = 83;
        faces[ 166 ][ 2 ] = 91;
        faces[ 167 ][ 0 ] = 83;
        faces[ 167 ][ 1 ] = 84;
        faces[ 167 ][ 2 ] = 91;
        faces[ 168 ][ 0 ] = 84;
        faces[ 168 ][ 1 ] = 85;
        faces[ 168 ][ 2 ] = 91;
        faces[ 169 ][ 0 ] = 85;
        faces[ 169 ][ 1 ] = 86;
        faces[ 169 ][ 2 ] = 91;
        faces[ 170 ][ 0 ] = 86;
        faces[ 170 ][ 1 ] = 87;
        faces[ 170 ][ 2 ] = 91;
        faces[ 171 ][ 0 ] = 87;
        faces[ 171 ][ 1 ] = 88;
        faces[ 171 ][ 2 ] = 91;
        faces[ 172 ][ 0 ] = 88;
        faces[ 172 ][ 1 ] = 89;
        faces[ 172 ][ 2 ] = 91;
        faces[ 173 ][ 0 ] = 89;
        faces[ 173 ][ 1 ] = 80;
        faces[ 173 ][ 2 ] = 91;
        faces[ 174 ][ 0 ] = 93;
        faces[ 174 ][ 1 ] = 97;
        faces[ 174 ][ 2 ] = 92;
        faces[ 175 ][ 0 ] = 92;
        faces[ 175 ][ 1 ] = 97;
        faces[ 175 ][ 2 ] = 96;
        faces[ 176 ][ 0 ] = 94;
        faces[ 176 ][ 1 ] = 95;
        faces[ 176 ][ 2 ] = 98;
        faces[ 177 ][ 0 ] = 98;
        faces[ 177 ][ 1 ] = 95;
        faces[ 177 ][ 2 ] = 99;
        faces[ 178 ][ 0 ] = 96;
        faces[ 178 ][ 1 ] = 97;
        faces[ 178 ][ 2 ] = 100;
        faces[ 179 ][ 0 ] = 100;
        faces[ 179 ][ 1 ] = 97;
        faces[ 179 ][ 2 ] = 101;
        faces[ 180 ][ 0 ] = 97;
        faces[ 180 ][ 1 ] = 98;
        faces[ 180 ][ 2 ] = 101;
        faces[ 181 ][ 0 ] = 101;
        faces[ 181 ][ 1 ] = 98;
        faces[ 181 ][ 2 ] = 102;
        faces[ 182 ][ 0 ] = 98;
        faces[ 182 ][ 1 ] = 99;
        faces[ 182 ][ 2 ] = 102;
        faces[ 183 ][ 0 ] = 102;
        faces[ 183 ][ 1 ] = 99;
        faces[ 183 ][ 2 ] = 103;
        faces[ 184 ][ 0 ] = 100;
        faces[ 184 ][ 1 ] = 101;
        faces[ 184 ][ 2 ] = 104;
        faces[ 185 ][ 0 ] = 104;
        faces[ 185 ][ 1 ] = 101;
        faces[ 185 ][ 2 ] = 105;
        faces[ 186 ][ 0 ] = 101;
        faces[ 186 ][ 1 ] = 102;
        faces[ 186 ][ 2 ] = 105;
        faces[ 187 ][ 0 ] = 105;
        faces[ 187 ][ 1 ] = 102;
        faces[ 187 ][ 2 ] = 106;
        faces[ 188 ][ 0 ] = 103;
        faces[ 188 ][ 1 ] = 107;
        faces[ 188 ][ 2 ] = 102;
        faces[ 189 ][ 0 ] = 102;
        faces[ 189 ][ 1 ] = 107;
        faces[ 189 ][ 2 ] = 106;
        faces[ 190 ][ 0 ] = 105;
        faces[ 190 ][ 1 ] = 109;
        faces[ 190 ][ 2 ] = 104;
        faces[ 191 ][ 0 ] = 104;
        faces[ 191 ][ 1 ] = 109;
        faces[ 191 ][ 2 ] = 108;
        faces[ 192 ][ 0 ] = 105;
        faces[ 192 ][ 1 ] = 106;
        faces[ 192 ][ 2 ] = 109;
        faces[ 193 ][ 0 ] = 109;
        faces[ 193 ][ 1 ] = 106;
        faces[ 193 ][ 2 ] = 110;
        faces[ 194 ][ 0 ] = 106;
        faces[ 194 ][ 1 ] = 107;
        faces[ 194 ][ 2 ] = 110;
        faces[ 195 ][ 0 ] = 110;
        faces[ 195 ][ 1 ] = 107;
        faces[ 195 ][ 2 ] = 111;
        faces[ 196 ][ 0 ] = 108;
        faces[ 196 ][ 1 ] = 109;
        faces[ 196 ][ 2 ] = 112;
        faces[ 197 ][ 0 ] = 112;
        faces[ 197 ][ 1 ] = 109;
        faces[ 197 ][ 2 ] = 113;
        faces[ 198 ][ 0 ] = 109;
        faces[ 198 ][ 1 ] = 110;
        faces[ 198 ][ 2 ] = 113;
        faces[ 199 ][ 0 ] = 113;
        faces[ 199 ][ 1 ] = 110;
        faces[ 199 ][ 2 ] = 114;
        faces[ 200 ][ 0 ] = 111;
        faces[ 200 ][ 1 ] = 115;
        faces[ 200 ][ 2 ] = 110;
        faces[ 201 ][ 0 ] = 110;
        faces[ 201 ][ 1 ] = 115;
        faces[ 201 ][ 2 ] = 114;
        faces[ 202 ][ 0 ] = 112;
        faces[ 202 ][ 1 ] = 113;
        faces[ 202 ][ 2 ] = 116;
        faces[ 203 ][ 0 ] = 116;
        faces[ 203 ][ 1 ] = 113;
        faces[ 203 ][ 2 ] = 117;
        faces[ 204 ][ 0 ] = 115;
        faces[ 204 ][ 1 ] = 119;
        faces[ 204 ][ 2 ] = 114;
        faces[ 205 ][ 0 ] = 114;
        faces[ 205 ][ 1 ] = 119;
        faces[ 205 ][ 2 ] = 118;
        faces[ 206 ][ 0 ] = 117;
        faces[ 206 ][ 1 ] = 121;
        faces[ 206 ][ 2 ] = 116;
        faces[ 207 ][ 0 ] = 116;
        faces[ 207 ][ 1 ] = 121;
        faces[ 207 ][ 2 ] = 120;
        faces[ 208 ][ 0 ] = 117;
        faces[ 208 ][ 1 ] = 118;
        faces[ 208 ][ 2 ] = 121;
        faces[ 209 ][ 0 ] = 121;
        faces[ 209 ][ 1 ] = 118;
        faces[ 209 ][ 2 ] = 122;
        faces[ 210 ][ 0 ] = 118;
        faces[ 210 ][ 1 ] = 119;
        faces[ 210 ][ 2 ] = 122;
        faces[ 211 ][ 0 ] = 122;
        faces[ 211 ][ 1 ] = 119;
        faces[ 211 ][ 2 ] = 123;
        faces[ 212 ][ 0 ] = 120;
        faces[ 212 ][ 1 ] = 121;
        faces[ 212 ][ 2 ] = 124;
        faces[ 213 ][ 0 ] = 124;
        faces[ 213 ][ 1 ] = 121;
        faces[ 213 ][ 2 ] = 125;
        faces[ 214 ][ 0 ] = 121;
        faces[ 214 ][ 1 ] = 122;
        faces[ 214 ][ 2 ] = 125;
        faces[ 215 ][ 0 ] = 125;
        faces[ 215 ][ 1 ] = 122;
        faces[ 215 ][ 2 ] = 126;
        faces[ 216 ][ 0 ] = 123;
        faces[ 216 ][ 1 ] = 127;
        faces[ 216 ][ 2 ] = 122;
        faces[ 217 ][ 0 ] = 122;
        faces[ 217 ][ 1 ] = 127;
        faces[ 217 ][ 2 ] = 126;
        faces[ 218 ][ 0 ] = 125;
        faces[ 218 ][ 1 ] = 129;
        faces[ 218 ][ 2 ] = 124;
        faces[ 219 ][ 0 ] = 124;
        faces[ 219 ][ 1 ] = 129;
        faces[ 219 ][ 2 ] = 128;
        faces[ 220 ][ 0 ] = 125;
        faces[ 220 ][ 1 ] = 126;
        faces[ 220 ][ 2 ] = 129;
        faces[ 221 ][ 0 ] = 129;
        faces[ 221 ][ 1 ] = 126;
        faces[ 221 ][ 2 ] = 130;
        faces[ 222 ][ 0 ] = 126;
        faces[ 222 ][ 1 ] = 127;
        faces[ 222 ][ 2 ] = 130;
        faces[ 223 ][ 0 ] = 130;
        faces[ 223 ][ 1 ] = 127;
        faces[ 223 ][ 2 ] = 131;
        faces[ 224 ][ 0 ] = 129;
        faces[ 224 ][ 1 ] = 133;
        faces[ 224 ][ 2 ] = 128;
        faces[ 225 ][ 0 ] = 128;
        faces[ 225 ][ 1 ] = 133;
        faces[ 225 ][ 2 ] = 132;
        faces[ 226 ][ 0 ] = 129;
        faces[ 226 ][ 1 ] = 130;
        faces[ 226 ][ 2 ] = 133;
        faces[ 227 ][ 0 ] = 133;
        faces[ 227 ][ 1 ] = 130;
        faces[ 227 ][ 2 ] = 134;
        faces[ 228 ][ 0 ] = 130;
        faces[ 228 ][ 1 ] = 131;
        faces[ 228 ][ 2 ] = 134;
        faces[ 229 ][ 0 ] = 134;
        faces[ 229 ][ 1 ] = 131;
        faces[ 229 ][ 2 ] = 135;
        faces[ 230 ][ 0 ] = 133;
        faces[ 230 ][ 1 ] = 137;
        faces[ 230 ][ 2 ] = 132;
        faces[ 231 ][ 0 ] = 132;
        faces[ 231 ][ 1 ] = 137;
        faces[ 231 ][ 2 ] = 136;
        faces[ 232 ][ 0 ] = 133;
        faces[ 232 ][ 1 ] = 134;
        faces[ 232 ][ 2 ] = 137;
        faces[ 233 ][ 0 ] = 137;
        faces[ 233 ][ 1 ] = 134;
        faces[ 233 ][ 2 ] = 138;
        faces[ 234 ][ 0 ] = 134;
        faces[ 234 ][ 1 ] = 135;
        faces[ 234 ][ 2 ] = 138;
        faces[ 235 ][ 0 ] = 138;
        faces[ 235 ][ 1 ] = 135;
        faces[ 235 ][ 2 ] = 139;
        faces[ 236 ][ 0 ] = 228;
        faces[ 236 ][ 1 ] = 229;
        faces[ 236 ][ 2 ] = 231;
        faces[ 237 ][ 0 ] = 231;
        faces[ 237 ][ 1 ] = 229;
        faces[ 237 ][ 2 ] = 230;
        faces[ 238 ][ 0 ] = 233;
        faces[ 238 ][ 1 ] = 234;
        faces[ 238 ][ 2 ] = 232;
        faces[ 239 ][ 0 ] = 232;
        faces[ 239 ][ 1 ] = 234;
        faces[ 239 ][ 2 ] = 235;
        faces[ 240 ][ 0 ] = 95;
        faces[ 240 ][ 1 ] = 139;
        faces[ 240 ][ 2 ] = 99;
        faces[ 241 ][ 0 ] = 99;
        faces[ 241 ][ 1 ] = 139;
        faces[ 241 ][ 2 ] = 135;
        faces[ 242 ][ 0 ] = 99;
        faces[ 242 ][ 1 ] = 135;
        faces[ 242 ][ 2 ] = 103;
        faces[ 243 ][ 0 ] = 103;
        faces[ 243 ][ 1 ] = 135;
        faces[ 243 ][ 2 ] = 131;
        faces[ 244 ][ 0 ] = 131;
        faces[ 244 ][ 1 ] = 127;
        faces[ 244 ][ 2 ] = 103;
        faces[ 245 ][ 0 ] = 103;
        faces[ 245 ][ 1 ] = 127;
        faces[ 245 ][ 2 ] = 107;
        faces[ 246 ][ 0 ] = 127;
        faces[ 246 ][ 1 ] = 123;
        faces[ 246 ][ 2 ] = 107;
        faces[ 247 ][ 0 ] = 107;
        faces[ 247 ][ 1 ] = 123;
        faces[ 247 ][ 2 ] = 111;
        faces[ 248 ][ 0 ] = 172;
        faces[ 248 ][ 1 ] = 174;
        faces[ 248 ][ 2 ] = 173;
        faces[ 249 ][ 0 ] = 173;
        faces[ 249 ][ 1 ] = 174;
        faces[ 249 ][ 2 ] = 175;
        faces[ 250 ][ 0 ] = 92;
        faces[ 250 ][ 1 ] = 96;
        faces[ 250 ][ 2 ] = 136;
        faces[ 251 ][ 0 ] = 136;
        faces[ 251 ][ 1 ] = 96;
        faces[ 251 ][ 2 ] = 132;
        faces[ 252 ][ 0 ] = 96;
        faces[ 252 ][ 1 ] = 100;
        faces[ 252 ][ 2 ] = 132;
        faces[ 253 ][ 0 ] = 132;
        faces[ 253 ][ 1 ] = 100;
        faces[ 253 ][ 2 ] = 128;
        faces[ 254 ][ 0 ] = 128;
        faces[ 254 ][ 1 ] = 100;
        faces[ 254 ][ 2 ] = 124;
        faces[ 255 ][ 0 ] = 124;
        faces[ 255 ][ 1 ] = 100;
        faces[ 255 ][ 2 ] = 104;
        faces[ 256 ][ 0 ] = 124;
        faces[ 256 ][ 1 ] = 104;
        faces[ 256 ][ 2 ] = 120;
        faces[ 257 ][ 0 ] = 120;
        faces[ 257 ][ 1 ] = 104;
        faces[ 257 ][ 2 ] = 108;
        faces[ 258 ][ 0 ] = 176;
        faces[ 258 ][ 1 ] = 177;
        faces[ 258 ][ 2 ] = 179;
        faces[ 259 ][ 0 ] = 179;
        faces[ 259 ][ 1 ] = 177;
        faces[ 259 ][ 2 ] = 178;
        faces[ 260 ][ 0 ] = 113;
        faces[ 260 ][ 1 ] = 114;
        faces[ 260 ][ 2 ] = 16;
        faces[ 261 ][ 0 ] = 16;
        faces[ 261 ][ 1 ] = 114;
        faces[ 261 ][ 2 ] = 17;
        faces[ 262 ][ 0 ] = 114;
        faces[ 262 ][ 1 ] = 118;
        faces[ 262 ][ 2 ] = 17;
        faces[ 263 ][ 0 ] = 17;
        faces[ 263 ][ 1 ] = 118;
        faces[ 263 ][ 2 ] = 7;
        faces[ 264 ][ 0 ] = 118;
        faces[ 264 ][ 1 ] = 117;
        faces[ 264 ][ 2 ] = 7;
        faces[ 265 ][ 0 ] = 7;
        faces[ 265 ][ 1 ] = 117;
        faces[ 265 ][ 2 ] = 6;
        faces[ 266 ][ 0 ] = 113;
        faces[ 266 ][ 1 ] = 16;
        faces[ 266 ][ 2 ] = 117;
        faces[ 267 ][ 0 ] = 117;
        faces[ 267 ][ 1 ] = 16;
        faces[ 267 ][ 2 ] = 6;
        faces[ 268 ][ 0 ] = 123;
        faces[ 268 ][ 1 ] = 140;
        faces[ 268 ][ 2 ] = 111;
        faces[ 269 ][ 0 ] = 111;
        faces[ 269 ][ 1 ] = 140;
        faces[ 269 ][ 2 ] = 141;
        faces[ 270 ][ 0 ] = 119;
        faces[ 270 ][ 1 ] = 142;
        faces[ 270 ][ 2 ] = 123;
        faces[ 271 ][ 0 ] = 123;
        faces[ 271 ][ 1 ] = 142;
        faces[ 271 ][ 2 ] = 140;
        faces[ 272 ][ 0 ] = 119;
        faces[ 272 ][ 1 ] = 115;
        faces[ 272 ][ 2 ] = 142;
        faces[ 273 ][ 0 ] = 142;
        faces[ 273 ][ 1 ] = 115;
        faces[ 273 ][ 2 ] = 143;
        faces[ 274 ][ 0 ] = 115;
        faces[ 274 ][ 1 ] = 111;
        faces[ 274 ][ 2 ] = 143;
        faces[ 275 ][ 0 ] = 143;
        faces[ 275 ][ 1 ] = 111;
        faces[ 275 ][ 2 ] = 141;
        faces[ 276 ][ 0 ] = 120;
        faces[ 276 ][ 1 ] = 108;
        faces[ 276 ][ 2 ] = 144;
        faces[ 277 ][ 0 ] = 144;
        faces[ 277 ][ 1 ] = 108;
        faces[ 277 ][ 2 ] = 145;
        faces[ 278 ][ 0 ] = 112;
        faces[ 278 ][ 1 ] = 146;
        faces[ 278 ][ 2 ] = 108;
        faces[ 279 ][ 0 ] = 108;
        faces[ 279 ][ 1 ] = 146;
        faces[ 279 ][ 2 ] = 145;
        faces[ 280 ][ 0 ] = 116;
        faces[ 280 ][ 1 ] = 147;
        faces[ 280 ][ 2 ] = 112;
        faces[ 281 ][ 0 ] = 112;
        faces[ 281 ][ 1 ] = 147;
        faces[ 281 ][ 2 ] = 146;
        faces[ 282 ][ 0 ] = 116;
        faces[ 282 ][ 1 ] = 120;
        faces[ 282 ][ 2 ] = 147;
        faces[ 283 ][ 0 ] = 147;
        faces[ 283 ][ 1 ] = 120;
        faces[ 283 ][ 2 ] = 144;
        faces[ 284 ][ 0 ] = 141;
        faces[ 284 ][ 1 ] = 140;
        faces[ 284 ][ 2 ] = 149;
        faces[ 285 ][ 0 ] = 149;
        faces[ 285 ][ 1 ] = 140;
        faces[ 285 ][ 2 ] = 148;
        faces[ 286 ][ 0 ] = 140;
        faces[ 286 ][ 1 ] = 142;
        faces[ 286 ][ 2 ] = 148;
        faces[ 287 ][ 0 ] = 148;
        faces[ 287 ][ 1 ] = 142;
        faces[ 287 ][ 2 ] = 150;
        faces[ 288 ][ 0 ] = 142;
        faces[ 288 ][ 1 ] = 143;
        faces[ 288 ][ 2 ] = 150;
        faces[ 289 ][ 0 ] = 150;
        faces[ 289 ][ 1 ] = 143;
        faces[ 289 ][ 2 ] = 151;
        faces[ 290 ][ 0 ] = 141;
        faces[ 290 ][ 1 ] = 149;
        faces[ 290 ][ 2 ] = 143;
        faces[ 291 ][ 0 ] = 143;
        faces[ 291 ][ 1 ] = 149;
        faces[ 291 ][ 2 ] = 151;
        faces[ 292 ][ 0 ] = 145;
        faces[ 292 ][ 1 ] = 153;
        faces[ 292 ][ 2 ] = 144;
        faces[ 293 ][ 0 ] = 144;
        faces[ 293 ][ 1 ] = 153;
        faces[ 293 ][ 2 ] = 152;
        faces[ 294 ][ 0 ] = 145;
        faces[ 294 ][ 1 ] = 146;
        faces[ 294 ][ 2 ] = 153;
        faces[ 295 ][ 0 ] = 153;
        faces[ 295 ][ 1 ] = 146;
        faces[ 295 ][ 2 ] = 154;
        faces[ 296 ][ 0 ] = 146;
        faces[ 296 ][ 1 ] = 147;
        faces[ 296 ][ 2 ] = 154;
        faces[ 297 ][ 0 ] = 154;
        faces[ 297 ][ 1 ] = 147;
        faces[ 297 ][ 2 ] = 155;
        faces[ 298 ][ 0 ] = 144;
        faces[ 298 ][ 1 ] = 152;
        faces[ 298 ][ 2 ] = 147;
        faces[ 299 ][ 0 ] = 147;
        faces[ 299 ][ 1 ] = 152;
        faces[ 299 ][ 2 ] = 155;
        faces[ 300 ][ 0 ] = 149;
        faces[ 300 ][ 1 ] = 148;
        faces[ 300 ][ 2 ] = 157;
        faces[ 301 ][ 0 ] = 157;
        faces[ 301 ][ 1 ] = 148;
        faces[ 301 ][ 2 ] = 156;
        faces[ 302 ][ 0 ] = 148;
        faces[ 302 ][ 1 ] = 150;
        faces[ 302 ][ 2 ] = 156;
        faces[ 303 ][ 0 ] = 156;
        faces[ 303 ][ 1 ] = 150;
        faces[ 303 ][ 2 ] = 158;
        faces[ 304 ][ 0 ] = 150;
        faces[ 304 ][ 1 ] = 151;
        faces[ 304 ][ 2 ] = 158;
        faces[ 305 ][ 0 ] = 158;
        faces[ 305 ][ 1 ] = 151;
        faces[ 305 ][ 2 ] = 159;
        faces[ 306 ][ 0 ] = 149;
        faces[ 306 ][ 1 ] = 157;
        faces[ 306 ][ 2 ] = 151;
        faces[ 307 ][ 0 ] = 151;
        faces[ 307 ][ 1 ] = 157;
        faces[ 307 ][ 2 ] = 159;
        faces[ 308 ][ 0 ] = 153;
        faces[ 308 ][ 1 ] = 161;
        faces[ 308 ][ 2 ] = 152;
        faces[ 309 ][ 0 ] = 152;
        faces[ 309 ][ 1 ] = 161;
        faces[ 309 ][ 2 ] = 160;
        faces[ 310 ][ 0 ] = 153;
        faces[ 310 ][ 1 ] = 154;
        faces[ 310 ][ 2 ] = 161;
        faces[ 311 ][ 0 ] = 161;
        faces[ 311 ][ 1 ] = 154;
        faces[ 311 ][ 2 ] = 162;
        faces[ 312 ][ 0 ] = 155;
        faces[ 312 ][ 1 ] = 163;
        faces[ 312 ][ 2 ] = 154;
        faces[ 313 ][ 0 ] = 154;
        faces[ 313 ][ 1 ] = 163;
        faces[ 313 ][ 2 ] = 162;
        faces[ 314 ][ 0 ] = 152;
        faces[ 314 ][ 1 ] = 160;
        faces[ 314 ][ 2 ] = 155;
        faces[ 315 ][ 0 ] = 155;
        faces[ 315 ][ 1 ] = 160;
        faces[ 315 ][ 2 ] = 163;
        faces[ 316 ][ 0 ] = 157;
        faces[ 316 ][ 1 ] = 156;
        faces[ 316 ][ 2 ] = 165;
        faces[ 317 ][ 0 ] = 165;
        faces[ 317 ][ 1 ] = 156;
        faces[ 317 ][ 2 ] = 164;
        faces[ 318 ][ 0 ] = 156;
        faces[ 318 ][ 1 ] = 158;
        faces[ 318 ][ 2 ] = 164;
        faces[ 319 ][ 0 ] = 164;
        faces[ 319 ][ 1 ] = 158;
        faces[ 319 ][ 2 ] = 166;
        faces[ 320 ][ 0 ] = 158;
        faces[ 320 ][ 1 ] = 159;
        faces[ 320 ][ 2 ] = 166;
        faces[ 321 ][ 0 ] = 166;
        faces[ 321 ][ 1 ] = 159;
        faces[ 321 ][ 2 ] = 167;
        faces[ 322 ][ 0 ] = 157;
        faces[ 322 ][ 1 ] = 165;
        faces[ 322 ][ 2 ] = 159;
        faces[ 323 ][ 0 ] = 159;
        faces[ 323 ][ 1 ] = 165;
        faces[ 323 ][ 2 ] = 167;
        faces[ 324 ][ 0 ] = 161;
        faces[ 324 ][ 1 ] = 169;
        faces[ 324 ][ 2 ] = 160;
        faces[ 325 ][ 0 ] = 160;
        faces[ 325 ][ 1 ] = 169;
        faces[ 325 ][ 2 ] = 168;
        faces[ 326 ][ 0 ] = 161;
        faces[ 326 ][ 1 ] = 162;
        faces[ 326 ][ 2 ] = 169;
        faces[ 327 ][ 0 ] = 169;
        faces[ 327 ][ 1 ] = 162;
        faces[ 327 ][ 2 ] = 170;
        faces[ 328 ][ 0 ] = 162;
        faces[ 328 ][ 1 ] = 163;
        faces[ 328 ][ 2 ] = 170;
        faces[ 329 ][ 0 ] = 170;
        faces[ 329 ][ 1 ] = 163;
        faces[ 329 ][ 2 ] = 171;
        faces[ 330 ][ 0 ] = 160;
        faces[ 330 ][ 1 ] = 168;
        faces[ 330 ][ 2 ] = 163;
        faces[ 331 ][ 0 ] = 163;
        faces[ 331 ][ 1 ] = 168;
        faces[ 331 ][ 2 ] = 171;
        faces[ 332 ][ 0 ] = 165;
        faces[ 332 ][ 1 ] = 164;
        faces[ 332 ][ 2 ] = 173;
        faces[ 333 ][ 0 ] = 173;
        faces[ 333 ][ 1 ] = 164;
        faces[ 333 ][ 2 ] = 172;
        faces[ 334 ][ 0 ] = 164;
        faces[ 334 ][ 1 ] = 166;
        faces[ 334 ][ 2 ] = 172;
        faces[ 335 ][ 0 ] = 172;
        faces[ 335 ][ 1 ] = 166;
        faces[ 335 ][ 2 ] = 174;
        faces[ 336 ][ 0 ] = 167;
        faces[ 336 ][ 1 ] = 175;
        faces[ 336 ][ 2 ] = 166;
        faces[ 337 ][ 0 ] = 166;
        faces[ 337 ][ 1 ] = 175;
        faces[ 337 ][ 2 ] = 174;
        faces[ 338 ][ 0 ] = 165;
        faces[ 338 ][ 1 ] = 173;
        faces[ 338 ][ 2 ] = 167;
        faces[ 339 ][ 0 ] = 167;
        faces[ 339 ][ 1 ] = 173;
        faces[ 339 ][ 2 ] = 175;
        faces[ 340 ][ 0 ] = 169;
        faces[ 340 ][ 1 ] = 177;
        faces[ 340 ][ 2 ] = 168;
        faces[ 341 ][ 0 ] = 168;
        faces[ 341 ][ 1 ] = 177;
        faces[ 341 ][ 2 ] = 176;
        faces[ 342 ][ 0 ] = 169;
        faces[ 342 ][ 1 ] = 170;
        faces[ 342 ][ 2 ] = 177;
        faces[ 343 ][ 0 ] = 177;
        faces[ 343 ][ 1 ] = 170;
        faces[ 343 ][ 2 ] = 178;
        faces[ 344 ][ 0 ] = 170;
        faces[ 344 ][ 1 ] = 171;
        faces[ 344 ][ 2 ] = 178;
        faces[ 345 ][ 0 ] = 178;
        faces[ 345 ][ 1 ] = 171;
        faces[ 345 ][ 2 ] = 179;
        faces[ 346 ][ 0 ] = 168;
        faces[ 346 ][ 1 ] = 176;
        faces[ 346 ][ 2 ] = 171;
        faces[ 347 ][ 0 ] = 171;
        faces[ 347 ][ 1 ] = 176;
        faces[ 347 ][ 2 ] = 179;
        faces[ 348 ][ 0 ] = 137;
        faces[ 348 ][ 1 ] = 181;
        faces[ 348 ][ 2 ] = 136;
        faces[ 349 ][ 0 ] = 136;
        faces[ 349 ][ 1 ] = 181;
        faces[ 349 ][ 2 ] = 180;
        faces[ 350 ][ 0 ] = 93;
        faces[ 350 ][ 1 ] = 92;
        faces[ 350 ][ 2 ] = 182;
        faces[ 351 ][ 0 ] = 182;
        faces[ 351 ][ 1 ] = 92;
        faces[ 351 ][ 2 ] = 183;
        faces[ 352 ][ 0 ] = 92;
        faces[ 352 ][ 1 ] = 136;
        faces[ 352 ][ 2 ] = 183;
        faces[ 353 ][ 0 ] = 183;
        faces[ 353 ][ 1 ] = 136;
        faces[ 353 ][ 2 ] = 180;
        faces[ 354 ][ 0 ] = 138;
        faces[ 354 ][ 1 ] = 139;
        faces[ 354 ][ 2 ] = 184;
        faces[ 355 ][ 0 ] = 184;
        faces[ 355 ][ 1 ] = 139;
        faces[ 355 ][ 2 ] = 185;
        faces[ 356 ][ 0 ] = 95;
        faces[ 356 ][ 1 ] = 186;
        faces[ 356 ][ 2 ] = 139;
        faces[ 357 ][ 0 ] = 139;
        faces[ 357 ][ 1 ] = 186;
        faces[ 357 ][ 2 ] = 185;
        faces[ 358 ][ 0 ] = 94;
        faces[ 358 ][ 1 ] = 187;
        faces[ 358 ][ 2 ] = 95;
        faces[ 359 ][ 0 ] = 95;
        faces[ 359 ][ 1 ] = 187;
        faces[ 359 ][ 2 ] = 186;
        faces[ 360 ][ 0 ] = 181;
        faces[ 360 ][ 1 ] = 189;
        faces[ 360 ][ 2 ] = 180;
        faces[ 361 ][ 0 ] = 180;
        faces[ 361 ][ 1 ] = 189;
        faces[ 361 ][ 2 ] = 188;
        faces[ 362 ][ 0 ] = 182;
        faces[ 362 ][ 1 ] = 190;
        faces[ 362 ][ 2 ] = 181;
        faces[ 363 ][ 0 ] = 181;
        faces[ 363 ][ 1 ] = 190;
        faces[ 363 ][ 2 ] = 189;
        faces[ 364 ][ 0 ] = 182;
        faces[ 364 ][ 1 ] = 183;
        faces[ 364 ][ 2 ] = 190;
        faces[ 365 ][ 0 ] = 190;
        faces[ 365 ][ 1 ] = 183;
        faces[ 365 ][ 2 ] = 191;
        faces[ 366 ][ 0 ] = 183;
        faces[ 366 ][ 1 ] = 180;
        faces[ 366 ][ 2 ] = 191;
        faces[ 367 ][ 0 ] = 191;
        faces[ 367 ][ 1 ] = 180;
        faces[ 367 ][ 2 ] = 188;
        faces[ 368 ][ 0 ] = 184;
        faces[ 368 ][ 1 ] = 185;
        faces[ 368 ][ 2 ] = 192;
        faces[ 369 ][ 0 ] = 192;
        faces[ 369 ][ 1 ] = 185;
        faces[ 369 ][ 2 ] = 193;
        faces[ 370 ][ 0 ] = 186;
        faces[ 370 ][ 1 ] = 194;
        faces[ 370 ][ 2 ] = 185;
        faces[ 371 ][ 0 ] = 185;
        faces[ 371 ][ 1 ] = 194;
        faces[ 371 ][ 2 ] = 193;
        faces[ 372 ][ 0 ] = 187;
        faces[ 372 ][ 1 ] = 195;
        faces[ 372 ][ 2 ] = 186;
        faces[ 373 ][ 0 ] = 186;
        faces[ 373 ][ 1 ] = 195;
        faces[ 373 ][ 2 ] = 194;
        faces[ 374 ][ 0 ] = 187;
        faces[ 374 ][ 1 ] = 184;
        faces[ 374 ][ 2 ] = 195;
        faces[ 375 ][ 0 ] = 195;
        faces[ 375 ][ 1 ] = 184;
        faces[ 375 ][ 2 ] = 192;
        faces[ 376 ][ 0 ] = 182;
        faces[ 376 ][ 1 ] = 187;
        faces[ 376 ][ 2 ] = 93;
        faces[ 377 ][ 0 ] = 93;
        faces[ 377 ][ 1 ] = 187;
        faces[ 377 ][ 2 ] = 94;
        faces[ 378 ][ 0 ] = 181;
        faces[ 378 ][ 1 ] = 137;
        faces[ 378 ][ 2 ] = 184;
        faces[ 379 ][ 0 ] = 184;
        faces[ 379 ][ 1 ] = 137;
        faces[ 379 ][ 2 ] = 138;
        faces[ 380 ][ 0 ] = 182;
        faces[ 380 ][ 1 ] = 181;
        faces[ 380 ][ 2 ] = 187;
        faces[ 381 ][ 0 ] = 187;
        faces[ 381 ][ 1 ] = 181;
        faces[ 381 ][ 2 ] = 184;
        faces[ 382 ][ 0 ] = 189;
        faces[ 382 ][ 1 ] = 197;
        faces[ 382 ][ 2 ] = 188;
        faces[ 383 ][ 0 ] = 188;
        faces[ 383 ][ 1 ] = 197;
        faces[ 383 ][ 2 ] = 196;
        faces[ 384 ][ 0 ] = 190;
        faces[ 384 ][ 1 ] = 198;
        faces[ 384 ][ 2 ] = 189;
        faces[ 385 ][ 0 ] = 189;
        faces[ 385 ][ 1 ] = 198;
        faces[ 385 ][ 2 ] = 197;
        faces[ 386 ][ 0 ] = 190;
        faces[ 386 ][ 1 ] = 191;
        faces[ 386 ][ 2 ] = 198;
        faces[ 387 ][ 0 ] = 198;
        faces[ 387 ][ 1 ] = 191;
        faces[ 387 ][ 2 ] = 199;
        faces[ 388 ][ 0 ] = 191;
        faces[ 388 ][ 1 ] = 188;
        faces[ 388 ][ 2 ] = 199;
        faces[ 389 ][ 0 ] = 199;
        faces[ 389 ][ 1 ] = 188;
        faces[ 389 ][ 2 ] = 196;
        faces[ 390 ][ 0 ] = 192;
        faces[ 390 ][ 1 ] = 193;
        faces[ 390 ][ 2 ] = 200;
        faces[ 391 ][ 0 ] = 200;
        faces[ 391 ][ 1 ] = 193;
        faces[ 391 ][ 2 ] = 201;
        faces[ 392 ][ 0 ] = 194;
        faces[ 392 ][ 1 ] = 202;
        faces[ 392 ][ 2 ] = 193;
        faces[ 393 ][ 0 ] = 193;
        faces[ 393 ][ 1 ] = 202;
        faces[ 393 ][ 2 ] = 201;
        faces[ 394 ][ 0 ] = 195;
        faces[ 394 ][ 1 ] = 203;
        faces[ 394 ][ 2 ] = 194;
        faces[ 395 ][ 0 ] = 194;
        faces[ 395 ][ 1 ] = 203;
        faces[ 395 ][ 2 ] = 202;
        faces[ 396 ][ 0 ] = 195;
        faces[ 396 ][ 1 ] = 192;
        faces[ 396 ][ 2 ] = 203;
        faces[ 397 ][ 0 ] = 203;
        faces[ 397 ][ 1 ] = 192;
        faces[ 397 ][ 2 ] = 200;
        faces[ 398 ][ 0 ] = 197;
        faces[ 398 ][ 1 ] = 205;
        faces[ 398 ][ 2 ] = 196;
        faces[ 399 ][ 0 ] = 196;
        faces[ 399 ][ 1 ] = 205;
        faces[ 399 ][ 2 ] = 204;
        faces[ 400 ][ 0 ] = 197;
        faces[ 400 ][ 1 ] = 198;
        faces[ 400 ][ 2 ] = 205;
        faces[ 401 ][ 0 ] = 205;
        faces[ 401 ][ 1 ] = 198;
        faces[ 401 ][ 2 ] = 206;
        faces[ 402 ][ 0 ] = 198;
        faces[ 402 ][ 1 ] = 199;
        faces[ 402 ][ 2 ] = 206;
        faces[ 403 ][ 0 ] = 206;
        faces[ 403 ][ 1 ] = 199;
        faces[ 403 ][ 2 ] = 207;
        faces[ 404 ][ 0 ] = 196;
        faces[ 404 ][ 1 ] = 204;
        faces[ 404 ][ 2 ] = 199;
        faces[ 405 ][ 0 ] = 199;
        faces[ 405 ][ 1 ] = 204;
        faces[ 405 ][ 2 ] = 207;
        faces[ 406 ][ 0 ] = 200;
        faces[ 406 ][ 1 ] = 201;
        faces[ 406 ][ 2 ] = 208;
        faces[ 407 ][ 0 ] = 208;
        faces[ 407 ][ 1 ] = 201;
        faces[ 407 ][ 2 ] = 209;
        faces[ 408 ][ 0 ] = 201;
        faces[ 408 ][ 1 ] = 202;
        faces[ 408 ][ 2 ] = 209;
        faces[ 409 ][ 0 ] = 209;
        faces[ 409 ][ 1 ] = 202;
        faces[ 409 ][ 2 ] = 210;
        faces[ 410 ][ 0 ] = 203;
        faces[ 410 ][ 1 ] = 211;
        faces[ 410 ][ 2 ] = 202;
        faces[ 411 ][ 0 ] = 202;
        faces[ 411 ][ 1 ] = 211;
        faces[ 411 ][ 2 ] = 210;
        faces[ 412 ][ 0 ] = 200;
        faces[ 412 ][ 1 ] = 208;
        faces[ 412 ][ 2 ] = 203;
        faces[ 413 ][ 0 ] = 203;
        faces[ 413 ][ 1 ] = 208;
        faces[ 413 ][ 2 ] = 211;
        faces[ 414 ][ 0 ] = 205;
        faces[ 414 ][ 1 ] = 213;
        faces[ 414 ][ 2 ] = 204;
        faces[ 415 ][ 0 ] = 204;
        faces[ 415 ][ 1 ] = 213;
        faces[ 415 ][ 2 ] = 212;
        faces[ 416 ][ 0 ] = 205;
        faces[ 416 ][ 1 ] = 206;
        faces[ 416 ][ 2 ] = 213;
        faces[ 417 ][ 0 ] = 213;
        faces[ 417 ][ 1 ] = 206;
        faces[ 417 ][ 2 ] = 214;
        faces[ 418 ][ 0 ] = 206;
        faces[ 418 ][ 1 ] = 207;
        faces[ 418 ][ 2 ] = 214;
        faces[ 419 ][ 0 ] = 214;
        faces[ 419 ][ 1 ] = 207;
        faces[ 419 ][ 2 ] = 215;
        faces[ 420 ][ 0 ] = 204;
        faces[ 420 ][ 1 ] = 212;
        faces[ 420 ][ 2 ] = 207;
        faces[ 421 ][ 0 ] = 207;
        faces[ 421 ][ 1 ] = 212;
        faces[ 421 ][ 2 ] = 215;
        faces[ 422 ][ 0 ] = 208;
        faces[ 422 ][ 1 ] = 209;
        faces[ 422 ][ 2 ] = 216;
        faces[ 423 ][ 0 ] = 216;
        faces[ 423 ][ 1 ] = 209;
        faces[ 423 ][ 2 ] = 217;
        faces[ 424 ][ 0 ] = 209;
        faces[ 424 ][ 1 ] = 210;
        faces[ 424 ][ 2 ] = 217;
        faces[ 425 ][ 0 ] = 217;
        faces[ 425 ][ 1 ] = 210;
        faces[ 425 ][ 2 ] = 218;
        faces[ 426 ][ 0 ] = 211;
        faces[ 426 ][ 1 ] = 219;
        faces[ 426 ][ 2 ] = 210;
        faces[ 427 ][ 0 ] = 210;
        faces[ 427 ][ 1 ] = 219;
        faces[ 427 ][ 2 ] = 218;
        faces[ 428 ][ 0 ] = 208;
        faces[ 428 ][ 1 ] = 216;
        faces[ 428 ][ 2 ] = 211;
        faces[ 429 ][ 0 ] = 211;
        faces[ 429 ][ 1 ] = 216;
        faces[ 429 ][ 2 ] = 219;
        faces[ 430 ][ 0 ] = 212;
        faces[ 430 ][ 1 ] = 213;
        faces[ 430 ][ 2 ] = 220;
        faces[ 431 ][ 0 ] = 220;
        faces[ 431 ][ 1 ] = 213;
        faces[ 431 ][ 2 ] = 221;
        faces[ 432 ][ 0 ] = 213;
        faces[ 432 ][ 1 ] = 214;
        faces[ 432 ][ 2 ] = 221;
        faces[ 433 ][ 0 ] = 221;
        faces[ 433 ][ 1 ] = 214;
        faces[ 433 ][ 2 ] = 222;
        faces[ 434 ][ 0 ] = 215;
        faces[ 434 ][ 1 ] = 223;
        faces[ 434 ][ 2 ] = 214;
        faces[ 435 ][ 0 ] = 214;
        faces[ 435 ][ 1 ] = 223;
        faces[ 435 ][ 2 ] = 222;
        faces[ 436 ][ 0 ] = 212;
        faces[ 436 ][ 1 ] = 220;
        faces[ 436 ][ 2 ] = 215;
        faces[ 437 ][ 0 ] = 215;
        faces[ 437 ][ 1 ] = 220;
        faces[ 437 ][ 2 ] = 223;
        faces[ 438 ][ 0 ] = 217;
        faces[ 438 ][ 1 ] = 225;
        faces[ 438 ][ 2 ] = 216;
        faces[ 439 ][ 0 ] = 216;
        faces[ 439 ][ 1 ] = 225;
        faces[ 439 ][ 2 ] = 224;
        faces[ 440 ][ 0 ] = 217;
        faces[ 440 ][ 1 ] = 218;
        faces[ 440 ][ 2 ] = 225;
        faces[ 441 ][ 0 ] = 225;
        faces[ 441 ][ 1 ] = 218;
        faces[ 441 ][ 2 ] = 226;
        faces[ 442 ][ 0 ] = 218;
        faces[ 442 ][ 1 ] = 219;
        faces[ 442 ][ 2 ] = 226;
        faces[ 443 ][ 0 ] = 226;
        faces[ 443 ][ 1 ] = 219;
        faces[ 443 ][ 2 ] = 227;
        faces[ 444 ][ 0 ] = 216;
        faces[ 444 ][ 1 ] = 224;
        faces[ 444 ][ 2 ] = 219;
        faces[ 445 ][ 0 ] = 219;
        faces[ 445 ][ 1 ] = 224;
        faces[ 445 ][ 2 ] = 227;
        faces[ 446 ][ 0 ] = 220;
        faces[ 446 ][ 1 ] = 221;
        faces[ 446 ][ 2 ] = 228;
        faces[ 447 ][ 0 ] = 228;
        faces[ 447 ][ 1 ] = 221;
        faces[ 447 ][ 2 ] = 229;
        faces[ 448 ][ 0 ] = 222;
        faces[ 448 ][ 1 ] = 230;
        faces[ 448 ][ 2 ] = 221;
        faces[ 449 ][ 0 ] = 221;
        faces[ 449 ][ 1 ] = 230;
        faces[ 449 ][ 2 ] = 229;
        faces[ 450 ][ 0 ] = 223;
        faces[ 450 ][ 1 ] = 231;
        faces[ 450 ][ 2 ] = 222;
        faces[ 451 ][ 0 ] = 222;
        faces[ 451 ][ 1 ] = 231;
        faces[ 451 ][ 2 ] = 230;
        faces[ 452 ][ 0 ] = 223;
        faces[ 452 ][ 1 ] = 220;
        faces[ 452 ][ 2 ] = 231;
        faces[ 453 ][ 0 ] = 231;
        faces[ 453 ][ 1 ] = 220;
        faces[ 453 ][ 2 ] = 228;
        faces[ 454 ][ 0 ] = 225;
        faces[ 454 ][ 1 ] = 233;
        faces[ 454 ][ 2 ] = 224;
        faces[ 455 ][ 0 ] = 224;
        faces[ 455 ][ 1 ] = 233;
        faces[ 455 ][ 2 ] = 232;
        faces[ 456 ][ 0 ] = 226;
        faces[ 456 ][ 1 ] = 234;
        faces[ 456 ][ 2 ] = 225;
        faces[ 457 ][ 0 ] = 225;
        faces[ 457 ][ 1 ] = 234;
        faces[ 457 ][ 2 ] = 233;
        faces[ 458 ][ 0 ] = 226;
        faces[ 458 ][ 1 ] = 227;
        faces[ 458 ][ 2 ] = 234;
        faces[ 459 ][ 0 ] = 234;
        faces[ 459 ][ 1 ] = 227;
        faces[ 459 ][ 2 ] = 235;
        faces[ 460 ][ 0 ] = 227;
        faces[ 460 ][ 1 ] = 224;
        faces[ 460 ][ 2 ] = 235;
        faces[ 461 ][ 0 ] = 235;
        faces[ 461 ][ 1 ] = 224;
        faces[ 461 ][ 2 ] = 232;
        faces[ 462 ][ 0 ] = 74;
        faces[ 462 ][ 1 ] = 237;
        faces[ 462 ][ 2 ] = 73;
        faces[ 463 ][ 0 ] = 73;
        faces[ 463 ][ 1 ] = 237;
        faces[ 463 ][ 2 ] = 236;
        faces[ 464 ][ 0 ] = 74;
        faces[ 464 ][ 1 ] = 84;
        faces[ 464 ][ 2 ] = 237;
        faces[ 465 ][ 0 ] = 237;
        faces[ 465 ][ 1 ] = 84;
        faces[ 465 ][ 2 ] = 238;
        faces[ 466 ][ 0 ] = 84;
        faces[ 466 ][ 1 ] = 83;
        faces[ 466 ][ 2 ] = 238;
        faces[ 467 ][ 0 ] = 238;
        faces[ 467 ][ 1 ] = 83;
        faces[ 467 ][ 2 ] = 239;
        faces[ 468 ][ 0 ] = 73;
        faces[ 468 ][ 1 ] = 236;
        faces[ 468 ][ 2 ] = 83;
        faces[ 469 ][ 0 ] = 83;
        faces[ 469 ][ 1 ] = 236;
        faces[ 469 ][ 2 ] = 239;
        faces[ 470 ][ 0 ] = 79;
        faces[ 470 ][ 1 ] = 70;
        faces[ 470 ][ 2 ] = 240;
        faces[ 471 ][ 0 ] = 240;
        faces[ 471 ][ 1 ] = 70;
        faces[ 471 ][ 2 ] = 241;
        faces[ 472 ][ 0 ] = 70;
        faces[ 472 ][ 1 ] = 80;
        faces[ 472 ][ 2 ] = 241;
        faces[ 473 ][ 0 ] = 241;
        faces[ 473 ][ 1 ] = 80;
        faces[ 473 ][ 2 ] = 242;
        faces[ 474 ][ 0 ] = 89;
        faces[ 474 ][ 1 ] = 243;
        faces[ 474 ][ 2 ] = 80;
        faces[ 475 ][ 0 ] = 80;
        faces[ 475 ][ 1 ] = 243;
        faces[ 475 ][ 2 ] = 242;
        faces[ 476 ][ 0 ] = 79;
        faces[ 476 ][ 1 ] = 240;
        faces[ 476 ][ 2 ] = 89;
        faces[ 477 ][ 0 ] = 89;
        faces[ 477 ][ 1 ] = 240;
        faces[ 477 ][ 2 ] = 243;
        faces[ 478 ][ 0 ] = 236;
        faces[ 478 ][ 1 ] = 237;
        faces[ 478 ][ 2 ] = 244;
        faces[ 479 ][ 0 ] = 237;
        faces[ 479 ][ 1 ] = 238;
        faces[ 479 ][ 2 ] = 244;
        faces[ 480 ][ 0 ] = 238;
        faces[ 480 ][ 1 ] = 239;
        faces[ 480 ][ 2 ] = 244;
        faces[ 481 ][ 0 ] = 239;
        faces[ 481 ][ 1 ] = 236;
        faces[ 481 ][ 2 ] = 244;
        faces[ 482 ][ 0 ] = 240;
        faces[ 482 ][ 1 ] = 241;
        faces[ 482 ][ 2 ] = 245;
        faces[ 483 ][ 0 ] = 241;
        faces[ 483 ][ 1 ] = 242;
        faces[ 483 ][ 2 ] = 245;
        faces[ 484 ][ 0 ] = 242;
        faces[ 484 ][ 1 ] = 243;
        faces[ 484 ][ 2 ] = 245;
        faces[ 485 ][ 0 ] = 243;
        faces[ 485 ][ 1 ] = 240;
        faces[ 485 ][ 2 ] = 245;
        faces[ 486 ][ 0 ] = 94;
        faces[ 486 ][ 1 ] = 247;
        faces[ 486 ][ 2 ] = 93;
        faces[ 487 ][ 0 ] = 93;
        faces[ 487 ][ 1 ] = 247;
        faces[ 487 ][ 2 ] = 246;
        faces[ 488 ][ 0 ] = 98;
        faces[ 488 ][ 1 ] = 248;
        faces[ 488 ][ 2 ] = 94;
        faces[ 489 ][ 0 ] = 94;
        faces[ 489 ][ 1 ] = 248;
        faces[ 489 ][ 2 ] = 247;
        faces[ 490 ][ 0 ] = 97;
        faces[ 490 ][ 1 ] = 249;
        faces[ 490 ][ 2 ] = 98;
        faces[ 491 ][ 0 ] = 98;
        faces[ 491 ][ 1 ] = 249;
        faces[ 491 ][ 2 ] = 248;
        faces[ 492 ][ 0 ] = 97;
        faces[ 492 ][ 1 ] = 93;
        faces[ 492 ][ 2 ] = 249;
        faces[ 493 ][ 0 ] = 249;
        faces[ 493 ][ 1 ] = 93;
        faces[ 493 ][ 2 ] = 246;
        faces[ 494 ][ 0 ] = 247;
        faces[ 494 ][ 1 ] = 251;
        faces[ 494 ][ 2 ] = 246;
        faces[ 495 ][ 0 ] = 246;
        faces[ 495 ][ 1 ] = 251;
        faces[ 495 ][ 2 ] = 250;
        faces[ 496 ][ 0 ] = 247;
        faces[ 496 ][ 1 ] = 248;
        faces[ 496 ][ 2 ] = 251;
        faces[ 497 ][ 0 ] = 251;
        faces[ 497 ][ 1 ] = 248;
        faces[ 497 ][ 2 ] = 252;
        faces[ 498 ][ 0 ] = 249;
        faces[ 498 ][ 1 ] = 253;
        faces[ 498 ][ 2 ] = 248;
        faces[ 499 ][ 0 ] = 248;
        faces[ 499 ][ 1 ] = 253;
        faces[ 499 ][ 2 ] = 252;
        faces[ 500 ][ 0 ] = 249;
        faces[ 500 ][ 1 ] = 246;
        faces[ 500 ][ 2 ] = 253;
        faces[ 501 ][ 0 ] = 253;
        faces[ 501 ][ 1 ] = 246;
        faces[ 501 ][ 2 ] = 250;
        faces[ 502 ][ 0 ] = 250;
        faces[ 502 ][ 1 ] = 251;
        faces[ 502 ][ 2 ] = 254;
        faces[ 503 ][ 0 ] = 254;
        faces[ 503 ][ 1 ] = 251;
        faces[ 503 ][ 2 ] = 264;
        faces[ 504 ][ 0 ] = 254;
        faces[ 504 ][ 1 ] = 264;
        faces[ 504 ][ 2 ] = 255;
        faces[ 505 ][ 0 ] = 255;
        faces[ 505 ][ 1 ] = 264;
        faces[ 505 ][ 2 ] = 265;
        faces[ 506 ][ 0 ] = 255;
        faces[ 506 ][ 1 ] = 265;
        faces[ 506 ][ 2 ] = 256;
        faces[ 507 ][ 0 ] = 256;
        faces[ 507 ][ 1 ] = 265;
        faces[ 507 ][ 2 ] = 266;
        faces[ 508 ][ 0 ] = 256;
        faces[ 508 ][ 1 ] = 266;
        faces[ 508 ][ 2 ] = 257;
        faces[ 509 ][ 0 ] = 257;
        faces[ 509 ][ 1 ] = 266;
        faces[ 509 ][ 2 ] = 267;
        faces[ 510 ][ 0 ] = 257;
        faces[ 510 ][ 1 ] = 267;
        faces[ 510 ][ 2 ] = 258;
        faces[ 511 ][ 0 ] = 258;
        faces[ 511 ][ 1 ] = 267;
        faces[ 511 ][ 2 ] = 268;
        faces[ 512 ][ 0 ] = 258;
        faces[ 512 ][ 1 ] = 268;
        faces[ 512 ][ 2 ] = 259;
        faces[ 513 ][ 0 ] = 259;
        faces[ 513 ][ 1 ] = 268;
        faces[ 513 ][ 2 ] = 269;
        faces[ 514 ][ 0 ] = 259;
        faces[ 514 ][ 1 ] = 269;
        faces[ 514 ][ 2 ] = 260;
        faces[ 515 ][ 0 ] = 260;
        faces[ 515 ][ 1 ] = 269;
        faces[ 515 ][ 2 ] = 270;
        faces[ 516 ][ 0 ] = 260;
        faces[ 516 ][ 1 ] = 270;
        faces[ 516 ][ 2 ] = 261;
        faces[ 517 ][ 0 ] = 261;
        faces[ 517 ][ 1 ] = 270;
        faces[ 517 ][ 2 ] = 271;
        faces[ 518 ][ 0 ] = 261;
        faces[ 518 ][ 1 ] = 271;
        faces[ 518 ][ 2 ] = 262;
        faces[ 519 ][ 0 ] = 262;
        faces[ 519 ][ 1 ] = 271;
        faces[ 519 ][ 2 ] = 272;
        faces[ 520 ][ 0 ] = 262;
        faces[ 520 ][ 1 ] = 272;
        faces[ 520 ][ 2 ] = 263;
        faces[ 521 ][ 0 ] = 263;
        faces[ 521 ][ 1 ] = 272;
        faces[ 521 ][ 2 ] = 273;
        faces[ 522 ][ 0 ] = 251;
        faces[ 522 ][ 1 ] = 252;
        faces[ 522 ][ 2 ] = 264;
        faces[ 523 ][ 0 ] = 264;
        faces[ 523 ][ 1 ] = 252;
        faces[ 523 ][ 2 ] = 274;
        faces[ 524 ][ 0 ] = 264;
        faces[ 524 ][ 1 ] = 274;
        faces[ 524 ][ 2 ] = 265;
        faces[ 525 ][ 0 ] = 265;
        faces[ 525 ][ 1 ] = 274;
        faces[ 525 ][ 2 ] = 275;
        faces[ 526 ][ 0 ] = 265;
        faces[ 526 ][ 1 ] = 275;
        faces[ 526 ][ 2 ] = 266;
        faces[ 527 ][ 0 ] = 266;
        faces[ 527 ][ 1 ] = 275;
        faces[ 527 ][ 2 ] = 276;
        faces[ 528 ][ 0 ] = 266;
        faces[ 528 ][ 1 ] = 276;
        faces[ 528 ][ 2 ] = 267;
        faces[ 529 ][ 0 ] = 267;
        faces[ 529 ][ 1 ] = 276;
        faces[ 529 ][ 2 ] = 277;
        faces[ 530 ][ 0 ] = 267;
        faces[ 530 ][ 1 ] = 277;
        faces[ 530 ][ 2 ] = 268;
        faces[ 531 ][ 0 ] = 268;
        faces[ 531 ][ 1 ] = 277;
        faces[ 531 ][ 2 ] = 278;
        faces[ 532 ][ 0 ] = 268;
        faces[ 532 ][ 1 ] = 278;
        faces[ 532 ][ 2 ] = 269;
        faces[ 533 ][ 0 ] = 269;
        faces[ 533 ][ 1 ] = 278;
        faces[ 533 ][ 2 ] = 279;
        faces[ 534 ][ 0 ] = 269;
        faces[ 534 ][ 1 ] = 279;
        faces[ 534 ][ 2 ] = 270;
        faces[ 535 ][ 0 ] = 270;
        faces[ 535 ][ 1 ] = 279;
        faces[ 535 ][ 2 ] = 280;
        faces[ 536 ][ 0 ] = 270;
        faces[ 536 ][ 1 ] = 280;
        faces[ 536 ][ 2 ] = 271;
        faces[ 537 ][ 0 ] = 271;
        faces[ 537 ][ 1 ] = 280;
        faces[ 537 ][ 2 ] = 281;
        faces[ 538 ][ 0 ] = 271;
        faces[ 538 ][ 1 ] = 281;
        faces[ 538 ][ 2 ] = 272;
        faces[ 539 ][ 0 ] = 272;
        faces[ 539 ][ 1 ] = 281;
        faces[ 539 ][ 2 ] = 282;
        faces[ 540 ][ 0 ] = 272;
        faces[ 540 ][ 1 ] = 282;
        faces[ 540 ][ 2 ] = 273;
        faces[ 541 ][ 0 ] = 273;
        faces[ 541 ][ 1 ] = 282;
        faces[ 541 ][ 2 ] = 283;
        faces[ 542 ][ 0 ] = 252;
        faces[ 542 ][ 1 ] = 253;
        faces[ 542 ][ 2 ] = 274;
        faces[ 543 ][ 0 ] = 274;
        faces[ 543 ][ 1 ] = 253;
        faces[ 543 ][ 2 ] = 284;
        faces[ 544 ][ 0 ] = 274;
        faces[ 544 ][ 1 ] = 284;
        faces[ 544 ][ 2 ] = 275;
        faces[ 545 ][ 0 ] = 275;
        faces[ 545 ][ 1 ] = 284;
        faces[ 545 ][ 2 ] = 285;
        faces[ 546 ][ 0 ] = 275;
        faces[ 546 ][ 1 ] = 285;
        faces[ 546 ][ 2 ] = 276;
        faces[ 547 ][ 0 ] = 276;
        faces[ 547 ][ 1 ] = 285;
        faces[ 547 ][ 2 ] = 286;
        faces[ 548 ][ 0 ] = 276;
        faces[ 548 ][ 1 ] = 286;
        faces[ 548 ][ 2 ] = 277;
        faces[ 549 ][ 0 ] = 277;
        faces[ 549 ][ 1 ] = 286;
        faces[ 549 ][ 2 ] = 287;
        faces[ 550 ][ 0 ] = 277;
        faces[ 550 ][ 1 ] = 287;
        faces[ 550 ][ 2 ] = 278;
        faces[ 551 ][ 0 ] = 278;
        faces[ 551 ][ 1 ] = 287;
        faces[ 551 ][ 2 ] = 288;
        faces[ 552 ][ 0 ] = 278;
        faces[ 552 ][ 1 ] = 288;
        faces[ 552 ][ 2 ] = 279;
        faces[ 553 ][ 0 ] = 279;
        faces[ 553 ][ 1 ] = 288;
        faces[ 553 ][ 2 ] = 289;
        faces[ 554 ][ 0 ] = 279;
        faces[ 554 ][ 1 ] = 289;
        faces[ 554 ][ 2 ] = 280;
        faces[ 555 ][ 0 ] = 280;
        faces[ 555 ][ 1 ] = 289;
        faces[ 555 ][ 2 ] = 290;
        faces[ 556 ][ 0 ] = 280;
        faces[ 556 ][ 1 ] = 290;
        faces[ 556 ][ 2 ] = 281;
        faces[ 557 ][ 0 ] = 281;
        faces[ 557 ][ 1 ] = 290;
        faces[ 557 ][ 2 ] = 291;
        faces[ 558 ][ 0 ] = 281;
        faces[ 558 ][ 1 ] = 291;
        faces[ 558 ][ 2 ] = 282;
        faces[ 559 ][ 0 ] = 282;
        faces[ 559 ][ 1 ] = 291;
        faces[ 559 ][ 2 ] = 292;
        faces[ 560 ][ 0 ] = 282;
        faces[ 560 ][ 1 ] = 292;
        faces[ 560 ][ 2 ] = 283;
        faces[ 561 ][ 0 ] = 283;
        faces[ 561 ][ 1 ] = 292;
        faces[ 561 ][ 2 ] = 293;
        faces[ 562 ][ 0 ] = 253;
        faces[ 562 ][ 1 ] = 250;
        faces[ 562 ][ 2 ] = 284;
        faces[ 563 ][ 0 ] = 284;
        faces[ 563 ][ 1 ] = 250;
        faces[ 563 ][ 2 ] = 254;
        faces[ 564 ][ 0 ] = 284;
        faces[ 564 ][ 1 ] = 254;
        faces[ 564 ][ 2 ] = 285;
        faces[ 565 ][ 0 ] = 285;
        faces[ 565 ][ 1 ] = 254;
        faces[ 565 ][ 2 ] = 255;
        faces[ 566 ][ 0 ] = 285;
        faces[ 566 ][ 1 ] = 255;
        faces[ 566 ][ 2 ] = 286;
        faces[ 567 ][ 0 ] = 286;
        faces[ 567 ][ 1 ] = 255;
        faces[ 567 ][ 2 ] = 256;
        faces[ 568 ][ 0 ] = 286;
        faces[ 568 ][ 1 ] = 256;
        faces[ 568 ][ 2 ] = 287;
        faces[ 569 ][ 0 ] = 287;
        faces[ 569 ][ 1 ] = 256;
        faces[ 569 ][ 2 ] = 257;
        faces[ 570 ][ 0 ] = 287;
        faces[ 570 ][ 1 ] = 257;
        faces[ 570 ][ 2 ] = 288;
        faces[ 571 ][ 0 ] = 288;
        faces[ 571 ][ 1 ] = 257;
        faces[ 571 ][ 2 ] = 258;
        faces[ 572 ][ 0 ] = 288;
        faces[ 572 ][ 1 ] = 258;
        faces[ 572 ][ 2 ] = 289;
        faces[ 573 ][ 0 ] = 289;
        faces[ 573 ][ 1 ] = 258;
        faces[ 573 ][ 2 ] = 259;
        faces[ 574 ][ 0 ] = 289;
        faces[ 574 ][ 1 ] = 259;
        faces[ 574 ][ 2 ] = 290;
        faces[ 575 ][ 0 ] = 290;
        faces[ 575 ][ 1 ] = 259;
        faces[ 575 ][ 2 ] = 260;
        faces[ 576 ][ 0 ] = 290;
        faces[ 576 ][ 1 ] = 260;
        faces[ 576 ][ 2 ] = 291;
        faces[ 577 ][ 0 ] = 291;
        faces[ 577 ][ 1 ] = 260;
        faces[ 577 ][ 2 ] = 261;
        faces[ 578 ][ 0 ] = 291;
        faces[ 578 ][ 1 ] = 261;
        faces[ 578 ][ 2 ] = 292;
        faces[ 579 ][ 0 ] = 292;
        faces[ 579 ][ 1 ] = 261;
        faces[ 579 ][ 2 ] = 262;
        faces[ 580 ][ 0 ] = 292;
        faces[ 580 ][ 1 ] = 262;
        faces[ 580 ][ 2 ] = 293;
        faces[ 581 ][ 0 ] = 293;
        faces[ 581 ][ 1 ] = 262;
        faces[ 581 ][ 2 ] = 263;
        faces[ 582 ][ 0 ] = 263;
        faces[ 582 ][ 1 ] = 273;
        faces[ 582 ][ 2 ] = 294;
        faces[ 583 ][ 0 ] = 294;
        faces[ 583 ][ 1 ] = 273;
        faces[ 583 ][ 2 ] = 295;
        faces[ 584 ][ 0 ] = 273;
        faces[ 584 ][ 1 ] = 283;
        faces[ 584 ][ 2 ] = 295;
        faces[ 585 ][ 0 ] = 295;
        faces[ 585 ][ 1 ] = 283;
        faces[ 585 ][ 2 ] = 296;
        faces[ 586 ][ 0 ] = 283;
        faces[ 586 ][ 1 ] = 293;
        faces[ 586 ][ 2 ] = 296;
        faces[ 587 ][ 0 ] = 296;
        faces[ 587 ][ 1 ] = 293;
        faces[ 587 ][ 2 ] = 297;
        faces[ 588 ][ 0 ] = 263;
        faces[ 588 ][ 1 ] = 294;
        faces[ 588 ][ 2 ] = 293;
        faces[ 589 ][ 0 ] = 293;
        faces[ 589 ][ 1 ] = 294;
        faces[ 589 ][ 2 ] = 297;
        faces[ 590 ][ 0 ] = 294;
        faces[ 590 ][ 1 ] = 295;
        faces[ 590 ][ 2 ] = 298;
        faces[ 591 ][ 0 ] = 295;
        faces[ 591 ][ 1 ] = 296;
        faces[ 591 ][ 2 ] = 298;
        faces[ 592 ][ 0 ] = 296;
        faces[ 592 ][ 1 ] = 297;
        faces[ 592 ][ 2 ] = 298;
        faces[ 593 ][ 0 ] = 297;
        faces[ 593 ][ 1 ] = 294;
        faces[ 593 ][ 2 ] = 298;
    }
    
    public function render(renderer:Renderer):void {
        for (var i:int = 0; i < faces.length; i++)
            renderer.renderPolygon(vertices[faces[i][0]], vertices[faces[i][1]], vertices[faces[i][2]]);
    }
}

class Vertex {
    public var pos:Vec3D;
    public var worldPos:Vec3D;
    public var viewPos:Vec3D;
    public var projPos:Vec3D;
    
    public function Vertex(x:Number = 0, y:Number = 0, z:Number = 0):void {
        pos = new Vec3D(x, y, z);
        worldPos = new Vec3D();
        viewPos = new Vec3D();
        projPos = new Vec3D();
    }
}

class Vec3D {
    /*
     * [x y z w]
     */
    public var x:Number;
    public var y:Number;
    public var z:Number;
    public var w:Number;
    
    public function Vec3D(x:Number = 0, y:Number = 0, z:Number = 0, w:Number = 0) {
        setVector(x, y, z, w);
    }
    
    public function setVector(x:Number = 0, y:Number = 0, z:Number = 0, w:Number = 0):void {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }
    
    public function add(v:Vec3D):Vec3D {
        return new Vec3D(x + v.x, y + v.y, z + v.z);
    }
    
    public function addEqual(v:Vec3D):void {
        x += v.x;
        y += v.y;
        z += v.z;
    }
    
    public function sub(v:Vec3D):Vec3D {
        return new Vec3D(x - v.x, y - v.y, z - v.z);
    }
    
    public function subEqual(v:Vec3D):void {
        x -= v.x;
        y -= v.y;
        z -= v.z;
    }
    
    public function mul(s:Number):Vec3D {
        return new Vec3D(x * s, y * s, z * s);
    }
    
    public function mulEqual(s:Number):void {
        x *= s;
        y *= s;
        z *= s;
    }
    
    public function dot(v:Vec3D):Number {
        return x * v.x + y * v.y + z * v.z;
    }
    
    public function cross(v:Vec3D):Vec3D {
        return new Vec3D(y * v.z - z * v.y, z * v.x - x * v.z, x * v.y - y * v.x);
    }
    
    public function length():Number {
        return Math.sqrt(x * x + y * y + z * z);
    }
    
    public function normalize():void {
        var length:Number = length();
        if (length != 0 && length != 1) {
            length = 1 / length;
            x *= length;
            y *= length;
            z *= length;
        }
    }
}

class Mat4x4 {
    /*
     * [e00 e01 e02 e03]
     * [e10 e11 e12 e13]
     * [e20 e21 e22 e23]
     * [e30 e31 e32 e33]
     */
    public var e00:Number;
    public var e01:Number;
    public var e02:Number;
    public var e03:Number;
    public var e10:Number;
    public var e11:Number;
    public var e12:Number;
    public var e13:Number;
    public var e20:Number;
    public var e21:Number;
    public var e22:Number;
    public var e23:Number;
    public var e30:Number;
    public var e31:Number;
    public var e32:Number;
    public var e33:Number;
    
    public function Mat4x4(e00:Number = 1, e01:Number = 0, e02:Number = 0, e03:Number = 0,
        e10:Number = 0, e11:Number = 1, e12:Number = 0, e13:Number = 0,
        e20:Number = 0, e21:Number = 0, e22:Number = 1, e23:Number = 0,
        e30:Number = 0, e31:Number = 0, e32:Number = 0, e33:Number = 1) {
        setMatrix(e00, e01, e02, e03, e10, e11, e12, e13,
            e20, e21, e22, e23, e30, e31, e32, e33);
    }
    
    public function identity():void {
        setMatrix();
    }
    
    
    public function setMatrix(e00:Number = 1, e01:Number = 0, e02:Number = 0, e03:Number = 0,
        e10:Number = 0, e11:Number = 1, e12:Number = 0, e13:Number = 0,
        e20:Number = 0, e21:Number = 0, e22:Number = 1, e23:Number = 0,
        e30:Number = 0, e31:Number = 0, e32:Number = 0, e33:Number = 1):void {
        this.e00 = e00;
        this.e01 = e01;
        this.e02 = e02;
        this.e03 = e03;
        this.e10 = e10;
        this.e11 = e11;
        this.e12 = e12;
        this.e13 = e13;
        this.e20 = e20;
        this.e21 = e21;
        this.e22 = e22;
        this.e23 = e23;
        this.e30 = e30;
        this.e31 = e31;
        this.e32 = e32;
        this.e33 = e33;
    }
    
    public function rotateX(theta:Number):void {
        var sin:Number = Math.sin(theta);
        var cos:Number = Math.cos(theta);
        var m:Mat4x4 = new Mat4x4();
        m.e11 = cos;
        m.e12 = sin;
        m.e21 = -sin;
        m.e22 = cos;
        mulEqualMatrix(m);
    }
    
    public function rotateY(theta:Number):void {
        var sin:Number = Math.sin(theta);
        var cos:Number = Math.cos(theta);
        var m:Mat4x4 = new Mat4x4();
        m.e00 = cos;
        m.e02 = sin;
        m.e20 = -sin;
        m.e22 = cos;
        mulEqualMatrix(m);
    }
    
    public function rotateZ(theta:Number):void {
        var sin:Number = Math.sin(theta);
        var cos:Number = Math.cos(theta);
        var m:Mat4x4 = new Mat4x4();
        m.e00 = cos;
        m.e01 = -sin;
        m.e10 = sin;
        m.e11 = cos;
        mulEqualMatrix(m);
    }
    
    public function translate(tx:Number, ty:Number, tz:Number):void {
        var m:Mat4x4 = new Mat4x4();
        m.e30 = tx;
        m.e31 = ty;
        m.e32 = tz;
        mulEqualMatrix(m);
    }
    
    public function scale(sx:Number, sy:Number, sz:Number):void {
        var m:Mat4x4 = new Mat4x4();
        m.e00 = sx;
        m.e11 = sy;
        m.e22 = sz;
        mulEqualMatrix(m);
    }
    
    public function mulMatrix(m:Mat4x4):Mat4x4 {
        var t11:Number = e00 * m.e00 + e01 * m.e10 + e02 * m.e20 + e03 * m.e30;
        var t12:Number = e00 * m.e01 + e01 * m.e11 + e02 * m.e21 + e03 * m.e31;
        var t13:Number = e00 * m.e02 + e01 * m.e12 + e02 * m.e22 + e03 * m.e32;
        var t14:Number = e00 * m.e03 + e01 * m.e13 + e02 * m.e23 + e03 * m.e33;
        var t21:Number = e10 * m.e00 + e11 * m.e10 + e12 * m.e20 + e13 * m.e30;
        var t22:Number = e10 * m.e01 + e11 * m.e11 + e12 * m.e21 + e13 * m.e31;
        var t23:Number = e10 * m.e02 + e11 * m.e12 + e12 * m.e22 + e13 * m.e32;
        var t24:Number = e10 * m.e03 + e11 * m.e13 + e12 * m.e23 + e13 * m.e33;
        var t31:Number = e20 * m.e00 + e21 * m.e10 + e22 * m.e20 + e23 * m.e30;
        var t32:Number = e20 * m.e01 + e21 * m.e11 + e22 * m.e21 + e23 * m.e31;
        var t33:Number = e20 * m.e02 + e21 * m.e12 + e22 * m.e22 + e23 * m.e32;
        var t34:Number = e20 * m.e03 + e21 * m.e13 + e22 * m.e23 + e23 * m.e33;
        var t41:Number = e30 * m.e00 + e31 * m.e10 + e32 * m.e20 + e33 * m.e30;
        var t42:Number = e30 * m.e01 + e31 * m.e11 + e32 * m.e21 + e33 * m.e31;
        var t43:Number = e30 * m.e02 + e31 * m.e12 + e32 * m.e22 + e33 * m.e32;
        var t44:Number = e30 * m.e03 + e31 * m.e13 + e32 * m.e23 + e33 * m.e33;
        return new Mat4x4(t11, t12, t13, t14, t21, t22, t23, t24, t31, t32, t33, t34, t41,
                t42, t43, t44);
    }
    
    public function mulEqualMatrix(m:Mat4x4):void {
        var t11:Number = e00 * m.e00 + e01 * m.e10 + e02 * m.e20 + e03 * m.e30;
        var t12:Number = e00 * m.e01 + e01 * m.e11 + e02 * m.e21 + e03 * m.e31;
        var t13:Number = e00 * m.e02 + e01 * m.e12 + e02 * m.e22 + e03 * m.e32;
        var t14:Number = e00 * m.e03 + e01 * m.e13 + e02 * m.e23 + e03 * m.e33;
        var t21:Number = e10 * m.e00 + e11 * m.e10 + e12 * m.e20 + e13 * m.e30;
        var t22:Number = e10 * m.e01 + e11 * m.e11 + e12 * m.e21 + e13 * m.e31;
        var t23:Number = e10 * m.e02 + e11 * m.e12 + e12 * m.e22 + e13 * m.e32;
        var t24:Number = e10 * m.e03 + e11 * m.e13 + e12 * m.e23 + e13 * m.e33;
        var t31:Number = e20 * m.e00 + e21 * m.e10 + e22 * m.e20 + e23 * m.e30;
        var t32:Number = e20 * m.e01 + e21 * m.e11 + e22 * m.e21 + e23 * m.e31;
        var t33:Number = e20 * m.e02 + e21 * m.e12 + e22 * m.e22 + e23 * m.e32;
        var t34:Number = e20 * m.e03 + e21 * m.e13 + e22 * m.e23 + e23 * m.e33;
        var t41:Number = e30 * m.e00 + e31 * m.e10 + e32 * m.e20 + e33 * m.e30;
        var t42:Number = e30 * m.e01 + e31 * m.e11 + e32 * m.e21 + e33 * m.e31;
        var t43:Number = e30 * m.e02 + e31 * m.e12 + e32 * m.e22 + e33 * m.e32;
        var t44:Number = e30 * m.e03 + e31 * m.e13 + e32 * m.e23 + e33 * m.e33;
        setMatrix(t11, t12, t13, t14, t21, t22, t23, t24, t31, t32, t33, t34, t41,
                t42, t43, t44);
    }
    
    public function mulVector(v:Vec3D):Vec3D {
        return new Vec3D(e00 * v.x + e10 * v.y + e20 * v.z + e30,
                    e01 * v.x + e11 * v.y + e21 * v.z + e31,
                    e02 * v.x + e12 * v.y + e22 * v.z + e32,
                    e03 * v.x + e13 * v.y + e23 * v.z + e33);
    }
    
    public function mulEqualVector(v:Vec3D):void {
        v.setVector(e00 * v.x + e10 * v.y + e20 * v.z + e30,
                    e01 * v.x + e11 * v.y + e21 * v.z + e31,
                    e02 * v.x + e12 * v.y + e22 * v.z + e32,
                    e03 * v.x + e13 * v.y + e23 * v.z + e33);
    }
}