/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zxdt
 */

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.filters.ConvolutionFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.utils.getTimer;
    
    public class ConvolutionFastMode extends Sprite {
        
        private var tf:TextField;
        
       // This sketch shows the speed difference between using integer weights and non-integer weights
       // when using the convolution filter 
        
        public function ConvolutionFastMode() {
            init()
        }
        
         private function init():void
        {
            tf = new TextField();
            tf.autoSize = "left";
            addChild(tf);
            
            test1();
            test2();
        }
        
         private function test1():void
        {
            var bm:BitmapData = new BitmapData(512,512,true,0);
            bm.noise(1234,0,255,15,false);
            
            var cnv:ConvolutionFilter = new ConvolutionFilter(3,3,[1,2,1,2,4,2,1,2,1],16);
            var r:Rectangle = bm.rect;
            var p:Point = new Point();
            var t:int = getTimer();
            for ( var i:int = 0; i < 50; i++ )
            {
                bm.applyFilter( bm, r, p, cnv );
            }
            tf.appendText( "int: "+(getTimer() - t) );
        }
        
        private function test2():void
        {
            var bm:BitmapData = new BitmapData(512,512,true,0);
            bm.noise(1234,0,255,15,false);
            
            var cnv:ConvolutionFilter = new ConvolutionFilter(3,3,[1/16,2/16,1/16,2/16,4/16,2/16,1/16,2/16,1/16],1);
            var r:Rectangle = bm.rect;
            var p:Point = new Point();
            var t:int = getTimer();
            for ( var i:int = 0; i < 50; i++ )
            {
                bm.applyFilter( bm, r, p, cnv );
            }
            tf.appendText( "\nnon-int: "+(getTimer() - t) );
        }
        
       
    }
}