/**
 * Copyright hipoca ( http://wonderfl.net/user/hipoca )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zxbm
 */

// forked from shinta's forked from: PV3D CubeInteractive
// forked from milkmidi's PV3D CubeInteractive
/*
 * http://milkmidi.com
 * http://milkmidi.blogspot.com
 * */
package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import flash.net.URLVariables;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.materials.utils.MaterialsList;    
    import org.papervision3d.objects.primitives.Cube;    
    import org.papervision3d.view.BasicView;    
    import org.papervision3d.events.*;
    import caurina.transitions.Tweener;
    public class CubeInteractive extends BasicView    {        
        private var _cube        :Cube;
        private var _cube2        :Cube;
        private var _isRotation    :Boolean = true;//是否旋轉
        public function CubeInteractive(){
            super(0, 0, true, true);            
            camera.y = 300;
            camera.focus = 15;
            init3DObject();
            startRendering();
        }
        private function init3DObject():void {      
            var sides:int = Cube.ALL;
            
            var mm:ColorMaterial = new ColorMaterial(0x60aa, 1, true);
            mm.smooth = true;
            mm.interactive = true;
            mm.name = "front";
            
            var mm1:ColorMaterial = new ColorMaterial(0xfde200, 1, true);
            mm1.smooth = true;
            mm1.interactive = true;
            mm1.name = "back";
            
            var mm2:ColorMaterial = new ColorMaterial(0xd00024, 1, true);
            mm2.smooth = true;
            mm2.interactive = true;
            mm2.name = "left";
            
            var mm3:ColorMaterial = new ColorMaterial(0xefb200, 1, true);
            mm3.smooth = true;
            mm3.interactive = true;
            mm3.name = "right";
            
            var mm4:ColorMaterial = new ColorMaterial(0x00ffff, 1, true);
            mm4.smooth = true;
            mm4.interactive = true;
            mm4.name = "top";
            
            var mm5:ColorMaterial = new ColorMaterial(0x00ffff, 1, true);
            mm5.smooth = true;
            mm5.interactive = true;
            mm5.name = "bottom";
                        
            var _ml:MaterialsList = new MaterialsList(
            {
                front:mm, 
                back:mm1, 
                left:mm2, 
                right:mm3
                
            });
            _cube = new Cube(_ml, 300, 300, 300, 10, 10, 10);
            _cube2 = new Cube(_ml, 300, 300, 300 ,10, 10, 10, sides);            
            _cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK , _cubeClickHandler);
            scene.addChild(_cube);
            scene.addChild(_cube2);
        }

        private function _cubeClickHandler(e:InteractiveScene3DEvent):void {            
            if (_isRotation == false) {
                //如果不是在旋轉，就回到旋轉模式
                _isRotation = true;
                return;
            }
            _isRotation = false;
            var _obj:Object;
            //透過e.face3d, 可以得到點擊時, 面的物件
            //再透過其當下的 material.name來做判斷, 就可以知道那一面被按下
            switch (e.face3d.material.name) {
                case "front" :
                    var fronturl:URLRequest = new URLRequest("http://www.google.be");
                    navigateToURL(fronturl);            
                case "back" :
                    navigateToURL(new URLRequest("http://www.yahoo.be/"));
                case "left" :
                    navigateToURL(new URLRequest("http://www.yahoo.be/")); 
                case "right" :
                    navigateToURL(new URLRequest("http://www.yahoo.be/"));
            }
            _obj.time = 1;            
            Tweener.addTween(_cube, _obj );
        }
        override protected function onRenderTick(event:Event = null):void {
            super.onRenderTick(event);        
            if (_isRotation) {
                var _targetX:Number = (stage.stageWidth * .5 - mouseX) / 300
                _cube.rotationY += _targetX;
                _cube2.rotationY += _targetX;
            }            
        }
    }
}