/**
 * Copyright spanvega ( http://wonderfl.net/user/spanvega )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zxQe
 */

package
{
    // CLICK TO REBUILD

    import flash.geom.*;
    import flash.events.*;
    import flash.display.*;

    /**  @author SPANVEGA // CHRISTIAN  **/

    [ SWF (width = '465', height = '465', backgroundColor = '0xFFFFFF', frameRate = '60')]

    public class GRAYSCALE extends Sprite
    {
        private var data : Vector.<Number>, draw : Vector.<IGraphicsData>;

        private var b : BitmapData, map : BitmapData, fog : BitmapData;
        private var s : Shape = new Shape ();

        private var o : Array = [new Point (), new Point ()];
        private var w : uint, h : uint, i : int, k : int;
        private var v : Vector.<uint>;
        private var c : uint, n : int;
        private var r : Rectangle;
        private var m : Matrix;


        public function GRAYSCALE ()
        {
            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init ($ : Event = null) : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {removeEventListener (Event.ADDED_TO_STAGE, init); }

            stage.scaleMode = 'noScale';
            stage.align = 'TL';

            h = stage.stageHeight;
            w = stage.stageWidth;

            //

            var command : Vector.<int> = new Vector.<int> (w + 3, true);

            for (i = 0; i < command.length; i++)

            command [i] = (i < 1 ? 1 : 2);

            // 

            data = new Vector.<Number>((w + 3) * 2, true);

            // odd values | x

            for (i = 0; i < w; i++)

            data [i * 2] = i;

            // path data closure

            data [w * 2]     = w;
            data [w * 2 + 1] = h;
            data [w * 2 + 2] = 0;
            data [w * 2 + 3] = h;
            data [w * 2 + 4] = data [0];

            //

            m = new Matrix ();
            m.createGradientBox (1, 465, -90 * Math.PI / 180, 0, h - 465);

            draw = new <IGraphicsData>
            [
                new GraphicsStroke
                (
                    1, false, 'normal', 'none', 'miter', 3, new GraphicsSolidFill (0x808080, 0.5)
                ),
                new GraphicsGradientFill
                (
                    'linear',
                    [
                        0x808080, 0xFFFFFF, 0, 0, 0xFFFFFF, 0xFFFFFF, 0, 0,
                        0xFFFFFF, 0xFFFFFF, 0, 0, 0xFFFFFF, 0xFFFFFF
                    ],
                    [   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1   ],
                    [
                        0, 12, 12, 21, 21, 47, 47, 56, 56, 82, 82, 91, 91, 255
                    ],
                    m
                ),
                new GraphicsPath (command, data)
            ];

            //

            map = new BitmapData (w, 1);

            r = new Rectangle (0, 0, w, 1);
            
            m = new Matrix (-1, 0, 0, 1, w, 0);

            fog = new BitmapData (w, h, true, 0);

            addChild (new Bitmap (b = new BitmapData (w, h)));

            with (addChild (new Bitmap (fog))) { alpha = 0.5; blendMode = BlendMode.HARDLIGHT; };

            //

            pre ();
            stage.addEventListener (MouseEvent.CLICK, pre);
            stage.addEventListener (Event.ENTER_FRAME, render);
        }

        private function render ($ : Event = null) : void
        {
            o[0].x =- (o[1].x += 2);
            o[0].y =- (o[1].y += 2);

            map.perlinNoise (300, 300, 2, n, false, true, 1, true, o);

            v = map.getVector (r);

            // even values | y

            for (i = 0; i < w; i++)

            data [i * 2 + 1] = (h - 0xE8) + (v [i] & 0xE8) * 2;

            // path data closure

            data [w * 2 + 5] = data [1];

            //

            s.graphics.clear ();
            s.graphics.drawGraphicsData (draw);

            //

            fog.scroll (0, 1);
            fog.draw (map, m);

            b.scroll (0, -1);
            b.draw (s);

            // shade

            for (i = 0; i < w; i++)
            {
                if ((v [i] & 0xE8) > 0x68)
                {
                    c = v [i] & 0xFF;

                    c = (0xFF - c) % 0xFF;

                    b.setPixel32 (i, h - 1, 0xFF << 24 | c << 16 | c << 8 | c);
                }
            }
        }

        private function pre ($ : Event = null) : void
        {
            n = seed ();

            for (k = 0; k < h; k++)

            render ();
        }

        //

        private function seed () : int
        {
            var n : int = Math.random () * 10000 + 1;

            if (ERROR_SEEDS.indexOf (n) >= 0) n++;

            return n;
        }

        private const ERROR_SEEDS : Array = [346, 514, 1155, 1519, 1690, 1977, 2327,
             2337, 2399, 2860, 2999, 3099, 4777, 4952, 5673, 6265, 7185, 7259, 7371,
             7383, 7717, 7847, 8032, 8350, 8676, 8963, 8997, 9080, 9403, 9615, 9685];
    }
}