/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zxBc
 */

package
{
    import flash.display.LoaderInfo;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.system.*;
    
    public class main extends Sprite
    {
        private var imgContainer:Sprite;
        private var canvas:BitmapData;
        private var orgBitmapData:BitmapData;
        private const DIV:uint = 30; //分割数

        
        public function main()
        {
            imgContainer = new Sprite();
            addChild(imgContainer);
            imgContainer.y = 0;
            
            
            
            loadImage(); 
        }
        
        private function loadImage():void
        {
            Security.loadPolicyFile("http://t2421.jp/crossdomain.xml");
            
            var loader:Loader= new Loader();
            var urlReq:URLRequest = new URLRequest("http://t2421.jp/wonderfl/test.jpg");
            loader.load(urlReq);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
        }
        

        
        private function completeHandler(e:Event):void
        {
 
            trace("complete");
            var loader:Loader = Loader(e.target.loader);
            var img:Bitmap = Bitmap(loader.content);
            addChild(img);
            createBitmap(img);
        }
        
        //bitmapを作成する。
        private function createBitmap(img:Bitmap):void
        {
            var hDiv:uint = DIV;
            var vDiv:uint = DIV;
            var numDiv:uint = hDiv * vDiv;
            orgBitmapData = new BitmapData(img.width, img.height);
            var matrix:Matrix = new Matrix();
            orgBitmapData.draw(img, matrix);
            var orgBmp:Bitmap = new Bitmap(orgBitmapData);
            imgContainer.addChild(orgBmp);
            canvas = new BitmapData(orgBitmapData.width, orgBitmapData.height);
            
            var grid:Array = getGridArray(imgContainer, hDiv, vDiv);
            for (var i:uint = 0; i < grid.length; i++)
            {
                var color:uint = getColorAvarage(orgBitmapData, grid[i]);
                var bmdB:BitmapData = new BitmapData(grid[i].width, grid[i].height, false);
                bmdB.fillRect(bmdB.rect, color);
                var bmpB:Bitmap = new Bitmap(bmdB, "auto", true);
                bmpB.x = grid[i].x;
                bmpB.y = grid[i].y;
                addChild(bmpB);
            }
            orgBmp.alpha = 0;

        }
        
        /*
         * パラメーターを元に、グリッド状になるようなにRectangleインスタンスのセットを取得
         * @param baseObject ベースとなるdisplayObject
         * @param hDiv 水平方向分割数
         * @param vDiv 垂直方向分割数
         */
        private function getGridArray(baseObject:DisplayObject, hDiv:uint, vDiv:uint):Array
        {
            var rectArr:Array = [];
            var rectNum:uint = hDiv * vDiv;
            var rect:Rectangle = new Rectangle();
            var _width:Number = uint(baseObject.width / hDiv);
            var _height:Number = uint(baseObject.height / vDiv);
            for (var i:uint = 0; i < rectNum; i++)
            {
                rectArr.push(new Rectangle((i % hDiv) * _width, Math.floor(i / vDiv) * _height, _width, _height));
            }
            
            return rectArr;
        }
        
        
        /*
         * 指定された    ビットマップデータの範囲から平均の色を計算する。
         * @param baseBmd ベースとなるビットマップデータ
         * @param targetrect ターゲットとなる範囲
         */
        private function getColorAvarage(baseBmd:BitmapData, targetRect:Rectangle):uint
        {
            
            var byteArr:ByteArray = baseBmd.getPixels(targetRect);
            byteArr.position = 0;
            var c:uint, rgb:uint, r:uint, g:uint, b:uint;
            
            while (byteArr.bytesAvailable)
            {
                rgb = byteArr.readUnsignedInt() & 0xffffff;
                r += (rgb >> 0x10) & 0xFF;
                g += (rgb >> 0x08) & 0xFF;
                b += (rgb >> 0x00) & 0xFF;
            }
            
            var cnt:uint = targetRect.width * targetRect.height;
            r = r / cnt;
            g = g / cnt;
            b = b / cnt;
            c = (r << 0x10) | (g << 0x08) | (b << 0x00);
            
            return c;
        
        }
    }
}