/**
 * Copyright arithma ( http://wonderfl.net/user/arithma )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zx5N
 */

package 
{
	import caurina.transitions.Tweener;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	
	/**
	 * ...
	 * @author arithma
	 */
	public class CircleMenu extends Sprite 
	{
		private var buttons:Array;
		public function CircleMenu() {
			buttons = new Array();
			for (var i:int = 0; i < 12; i++) {
				var button:Sprite = new Sprite();
				button.graphics.beginFill(0);
				button.graphics.drawRoundRect( -30, -8 - 150, 60, 16, 5, 5);
				button.graphics.endFill();
				
				buttons.push(button);
				button.x = stage.stageWidth * .5;
				button.y = stage.stageHeight * .5;
				addChild(button);
				button.buttonMode = true;
				
				button.rotation = 360 / 12 * i;
				
				button.addEventListener(MouseEvent.MOUSE_OVER, buttonClick);
			}
		}
		
		private function buttonClick(e:MouseEvent):void {
			var index:int = buttons.indexOf(e.currentTarget);
			var center:Number = 360 / 12 * index;
			while (center - buttons[index].rotation > 180)
				center -= 360;
			while (center - buttons[index].rotation < -180)
				center += 360;
			Tweener.addTween(buttons[index], { rotation:center, time:1, scaleY:1.1 } );
			buttons[index].transform.colorTransform = new ColorTransform(0, 0, 0, 1, 0xFF, 0x66);
			for (var i:int = index + 1; i < index + 12; i++) {
				var r:int = i % 12;
				r = (r - index) % 12;
				var rot:Number = (360 / 13 * (r + ((r > 0)?.5: -.5)) + center);
				while (rot - buttons[i % 12].rotation > 180)
					rot -= 360;
				while (rot - buttons[i % 12].rotation < -180)
					rot += 360;
				Tweener.addTween(buttons[i%12], { rotation:rot, scaleY:1, time:1 } );
				buttons[i%12].transform.colorTransform = new ColorTransform();
			}
		}
	}
	
}