/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zwOo
 */

// forked from narutohyper's Alternativa3D Tips さまざまなプリミティブを作る
// forked from clockmaker's [Alternativa3D] Basic Template 
package {
	import alternativ5.engine3d.materials.FillMaterial;
	import alternativ5.engine3d.materials.TextureMaterial;
	import alternativ5.engine3d.materials.TextureMaterialPrecision
	import alternativ5.engine3d.primitives.Cone;
	import alternativ5.engine3d.primitives.Box;
	import alternativ5.engine3d.core.Object3D;
	import alternativ5.engine3d.core.Mesh;
	import alternativ5.engine3d.core.Vertex;

	import alternativ5.engine3d.controllers.CameraController;
	import alternativ5.engine3d.core.Camera3D;
	import alternativ5.engine3d.core.Scene3D;
	import alternativ5.engine3d.display.View;

	import alternativ5.types.Point3D;
	import alternativ5.types.Texture;
	import alternativ5.utils.*

	import flash.display.Sprite;
	import flash.display.BlendMode;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.GradientType;
	import flash.display.LineScaleMode;

	import flash.events.Event;

	import flash.geom.Matrix;
		

	[SWF(width = 465, height = 465, frameRate = 60,backgroundColor=0xFFFFFF)]
	/**
	 * Alternativa3D Tips 複数のカメラとViewを使う
	 * 
	 * 3DsceneのキャプチャーをするCamera3Dとその表示を行うViewですが
	 * 一つしか使えないわけではありません。
	 * 
	 * このサンプルでは、一つのsceneを、４つのカメラで違う角度から捉え
	 * ４つの別々のViewに表示しています。
	 * 
	 * もちろん、４つのcameraはそれぞれ、Controlできますので（複数のWalkController、CameraControllerを作成設置する事も可）、
	 * メインで、操作、サブcameraで、全体をキャプチャーなんてこともできます。
	 * 
	 * [さまざまなプリミティブを作る ]をfolkした為、ソースが若干長くなりました
	 * 単純な事を繰り返しているだけですｗ
	 * 
	 * @narutohyper
	*/

	/**
	 * Alternativa3D を簡単に扱うためのベーシックテンプレート
	 * @author Yasu (clockmaker)
	 */
	public class SimpleDemo extends Sprite {

		public function SimpleDemo():void {
									
			// テンプレートを作成します
			var template:BasicTemplate = new BasicTemplate();
			addChild(template);
			template.camera.z = -500;

			var base:Object3D=new Object3D;
			template.scene.root.addChild(base);

  	  	    // FPS display launch  
   		    FPS.init(stage);  
		
			//--------------------------------------------------------------------------------
			//複数のカメラとViewを作成する
			//--------------------------------------------------------------------------------

			//メインView（template内）をmain用Spriteに張替え
			//（template内のonResizeによる、viewの大きさの制御は切る）
			//（インスタンスからは操作できないので、テンプレ内で直接コメントアウトしてます）

				// 表示用Sprite
				var mainSp:Sprite=new Sprite();
				mainSp.addChild(template.view);
				this.addChild(mainSp);


			//２台目のカメラとVIEWを作成
				// 上部に配置し、下を向かせる
				var camera2:Camera3D = new Camera3D();
				camera2.y = -500;
				camera2.rotationX = MathUtils.toRadian(-90);
				template.scene.root.addChild(camera2);
				
				// set view
				var view2:View = new View();
				view2.camera = camera2;

				// 表示用Sprite
				var topSp:Sprite=new Sprite();

				topSp.addChild(view2);
				this.addChild(topSp);




			//３台目のカメラとVIEWを作成

				// 前部に配置し、後ろを向かせる
				var camera3:Camera3D = new Camera3D();
				camera3.z = 500;
				camera3.rotationY = MathUtils.toRadian(-180);
				template.scene.root.addChild(camera3);
			
				// set view
				var view3:View = new View();
				view3.camera = camera3;

				// 表示用Sprite
				var frontSp:Sprite=new Sprite();

				frontSp.addChild(view3);
				this.addChild(frontSp);

			//４台目のカメラとVIEWを作成

				// 右に配置し、左を向かせる
				var camera4:Camera3D = new Camera3D();
				camera4.x = 500;
				camera4.rotationY = MathUtils.toRadian(-90);
				template.scene.root.addChild(camera4);
				
				// set view
				var view4:View = new View();
				view4.camera = camera4;

				// 表示用Sprite
				var sideSp:Sprite=new Sprite();

				sideSp.addChild(view4);
				this.addChild(sideSp);

			//stageの大きさ変更時の対応
				stage.addEventListener(Event.RESIZE, onResize);

			//各Viewの大きさを整える為、一度onResizeを呼ぶ
			onResize();


			function onResize(event:Event = null):void {
				//各Viewと表示Spriteの枠の大きさを変更
				template.view.width = stage.stageWidth/2;
				template.view.height = stage.stageHeight/2;
				mainSp.graphics.clear()
				mainSp.graphics.lineStyle(2,0x666666,0.5,true,LineScaleMode.NONE)
				mainSp.graphics.drawRect(0,0,stage.stageWidth/2,stage.stageHeight/2)
				mainSp.x=stage.stageWidth/2;
				mainSp.y=stage.stageHeight/2;

				view2.width = stage.stageWidth/2;
				view2.height = stage.stageHeight/2;
				topSp.graphics.clear()
				topSp.graphics.lineStyle(2,0x666666,0.5,true,LineScaleMode.NONE)
				topSp.graphics.drawRect(0,0,stage.stageWidth/2,stage.stageHeight/2)


				view3.width = stage.stageWidth/2;
				view3.height = stage.stageHeight/2;
				frontSp.graphics.clear()
				frontSp.graphics.lineStyle(2,0x666666,0.5,true,LineScaleMode.NONE)
				frontSp.graphics.drawRect(0,0,stage.stageWidth/2,stage.stageHeight/2)
				frontSp.y=stage.stageHeight/2


				view4.width = stage.stageWidth/2;
				view4.height = stage.stageHeight/2;
				sideSp.graphics.clear()
				sideSp.graphics.lineStyle(2,0x666666,0.5,true,LineScaleMode.NONE)
				sideSp.graphics.drawRect(0,0,stage.stageWidth/2,stage.stageHeight/2)
				sideSp.x=stage.stageWidth/2;

			}

			/*--------------------------------------------------------------------------------
			カメラ操作ここまで
			以下はフォーク元
			Alternativa3D Tips さまざまなプリミティブを作る 
			http://wonderfl.net/code/a52a69df7e37a84a691da8c23acb990803735936
			と同じ
			（ただし、template内のonResize内のみコメントアウトしてます）
			--------------------------------------------------------------------------------*/


			// プリミティブを作成します
			//三角形
			var column3:Cone = new Cone(50,50,50,1,3)
					column3.setMaterialToSurface(new FillMaterial(0x9999CC),'side');
					column3.setMaterialToSurface(new FillMaterial(0xCCCCFF),'top');
					column3.setMaterialToSurface(new FillMaterial(0x666699),'bottom');
					column3.coords=new Point3D(0,0,0)
					base.addChild(column3);

			//四角形
			var column4:Cone = new Cone(50,50,50,1,4)
					column4.setMaterialToSurface(new FillMaterial(0x99CC99),'side');
					column4.setMaterialToSurface(new FillMaterial(0xCCFFCC),'top');
					column4.setMaterialToSurface(new FillMaterial(0x669966),'bottom');
					column4.coords=new Point3D(-100,100,100)
					base.addChild(column4);

			//五角形
			var column5:Cone = new Cone(50,50,50,1,5)
					column5.setMaterialToSurface(new FillMaterial(0xCC9999),'side');
					column5.setMaterialToSurface(new FillMaterial(0xFFCCCC),'top');
					column5.setMaterialToSurface(new FillMaterial(0x996666),'bottom');
					column5.coords=new Point3D(-100,-100,100)
					base.addChild(column5);

			//六角形
			var column6:Cone = new Cone(50,50,50,1,6)
					column6.setMaterialToSurface(new FillMaterial(0xCC99CC),'side');
					column6.setMaterialToSurface(new FillMaterial(0xFFEEFF),'top');
					column6.setMaterialToSurface(new FillMaterial(0x994499),'bottom');
					column6.coords=new Point3D(-100,100,-100)
					base.addChild(column6);

			//三十六角形
			var column36:Cone = new Cone(50,50,50,1,36)
					column36.setMaterialToSurface(new FillMaterial(0x99CCCC),'side');
					column36.setMaterialToSurface(new FillMaterial(0xEEFFFF),'top');
					column36.setMaterialToSurface(new FillMaterial(0x449999),'bottom');
					column36.coords=new Point3D(100,-100,-100)
					base.addChild(column36);


			//おまけ1・・・三角錐
			var column2:Cone = new Cone(60,50,0,1,3)

					//sideの塗りわけができないので、sideのfaceを、それぞれ、別のサーフェースにする
					column2.removeSurface(column2.getSurfaceById('side'))
					column2.createSurface(['0_0'],'side_0')
					column2.createSurface(['1_0'],'side_1')
					column2.createSurface(['2_0'],'side_2')
					column2.setMaterialToSurface(new FillMaterial(0xCC8833),'side_0');
					column2.setMaterialToSurface(new FillMaterial(0xFFA14F),'side_1');
					column2.setMaterialToSurface(new FillMaterial(0xFFD897),'side_2');
					column2.setMaterialToSurface(new FillMaterial(0xCC6600),'bottom');

					column2.coords=new Point3D(-100,-100,-100)
					base.addChild(column2);


			//おまけ2・・・10角形を改造して星にする・・・が、裏（bottom）の面がひっくり返ってしまって見えなくなってしまうｗ
			var column10:Cone = new Cone(50,50,50,1,10)
					column10.setMaterialToSurface(new FillMaterial(0xCCCC00),'side');
					column10.setMaterialToSurface(new FillMaterial(0xFFFF66),'top');

					column10.coords=new Point3D(100,-100,100)
					base.addChild(column10);

					var v1:Vertex;
					var v2:Vertex;
					var tx:Number;
					var ty:Number;
					var r:Number;
					for (var i:uint=0;i<10;i++) {
						v1=column10.getVertexById(i+'_'+0)
						v2=column10.getVertexById(i+'_'+1)
						if (i%2==0) {
							r=30
						} else {
							r=50
						}
						tx=Math.cos(MathUtils.toRadian(360/10*i))*r
						ty=Math.sin(MathUtils.toRadian(360/10*i))*r
						v1.x=tx
						v1.y=ty
						v2.x=tx
						v2.y=ty

					}
					column10.removeSurface('bottom')
					column10.removeFace('bottom')
					/*
					//なので、一度bottomのSurface,Faceを作り直す。
					//が！！時計回り、半時計周りどちらも試したけど、ひっくり返ったまま。
					//column10.createFace(['0_0', '1_0', '2_0', '3_0', '4_0', '5_0', '6_0', '7_0', '8_0', '9_0'],'bottom')
					//column10.createFace(['9_0', '8_0', '7_0', '6_0', '5_0', '4_0', '3_0', '2_0', '1_0', '0_0'],'bottom')
					//しょうがないので、中心点を作って、５枚のfaceを新たに作り、Surfaceに割り付けるｗ
					*/
					column10.createVertex(0,0,-25,'b_0')
					column10.createFace(['0_0','9_0','b_0','1_0'],'bottom0')
					column10.createFace(['8_0','7_0','b_0','9_0'],'bottom1')
					column10.createFace(['6_0','5_0','b_0','7_0'],'bottom2')
					column10.createFace(['4_0','3_0','b_0','5_0'],'bottom3')
					column10.createFace(['2_0','1_0','b_0','3_0'],'bottom4')

					column10.createSurface(['bottom0','bottom1','bottom2','bottom3','bottom4'],'bottom')
					column10.setMaterialToSurface(new FillMaterial(0x9999944),'bottom');

					//で、星の完成


			//おまけ3・・・バグの検証？Coneには、TextureMaterialが貼り付けられないｗ
			var columnError:Cone = new Cone(50,50,50,1,4)
					columnError.coords=new Point3D(100,100,-100)
					base.addChild(columnError);
			var box:Box = new Box(50,70,70)
					box.coords=new Point3D(100,100,100)
					base.addChild(box);

				//テスト用グラデーションのマテリアルを作成する
				var bmd1:BitmapData=new BitmapData(100,100,false,0xFF000000)
				var bmd2:BitmapData=new BitmapData(100,100,false,0xFF000000)
				var tempSprite:Sprite=new Sprite();
				var colors:Array=new Array(0xCCCCCC,0x333333)
				var alphas:Array=new Array(1,1)
				var ratios:Array=new Array(0,255)
				var matrix:Matrix=new Matrix()
				matrix.createGradientBox(100,100,Math.PI/3,0,0)
				tempSprite.graphics.beginGradientFill(GradientType.LINEAR,colors, alphas, ratios, matrix)
				tempSprite.graphics.drawRect(0,0,100,100)
				bmd1.draw(tempSprite)
				bmd2.draw(tempSprite)

			//ConeとBox両方に同じ様に、TextureMaterialを貼り付ける
				columnError.cloneMaterialToAllSurfaces(new TextureMaterial(new Texture(bmd1),1,true,true,BlendMode.NORMAL,-1,0x000000,TextureMaterialPrecision.BEST));
				box.cloneMaterialToAllSurfaces(new TextureMaterial(new Texture(bmd2),1,true,true,BlendMode.NORMAL,-1,0x000000,TextureMaterialPrecision.BEST));
				//明るい面が上に行くように回転
				//column.rotationX = MathUtils.toRadian(90)



			// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
			// レンダリング前に実行したい処理を記述します。
			template.onPreRender = function():void {

				// 立方体を回転させます (角度はラジアン)
				base.rotationY += 1 * Math.PI / 180;
				box.rotationY += 1 * Math.PI / 180;
				column2.rotationY += 5 * Math.PI / 180;
				column3.rotationY += 5 * Math.PI / 180;
				column4.rotationY += 5 * Math.PI / 180;
				column5.rotationY += 5 * Math.PI / 180;
				column6.rotationY += 5 * Math.PI / 180;
				column10.rotationY += 5 * Math.PI / 180;
				column36.rotationY += 5 * Math.PI / 180;

				// マウスがステージの高さ何%の位置にあるか算出
				var rateY:Number = mouseY / stage.stageHeight;
				
				// カメラの高さの座標を調整
				// イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
				template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
				
				// カメラの座標を中央に向かせる
				template.cameraContoller.lookAt(new Point3D());
			}
		}


	}
}













import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;


/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
class BasicTemplate extends Sprite{
	/**
	 * シーンインスタンスです。
	 */
	public var scene:Scene3D;
	/**
	 * ビューインスタンスです。
	 */
	public var view:View;
	/**
	 * カメラインスタンスです。
	 */
	public var camera:Camera3D;
	/**
	 * カメラコントローラーです。
	 */
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	/**
	 * 新しい BasicTemplate インスタンスを作成します。
	 * @param	viewWidth
	 * @param	viewHeight
	 * @param	scaleToStage
	 */
	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理をオーバーライドして記述します。
	 */
	protected function atInit():void {}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理を記述します。
	 */
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPreRender():void {}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理を記述します。
	 */
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPostRender():void {
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理を記述します。
	 */
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	/**
	 * レンダリングを開始します。
	 */
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	/**
	 * レンダリングを停止します。
	 */
	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	/**
	 * シングルレンダリング(レンダリングを一回だけ)を実行します。
	 */
	public function singleRender():void {
		onRenderTick();
	}
	
	/**
	 * @private
	 */
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		// resize
		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		// render
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	/**
	 * @private
	 */
	private function onRenderTick(e:Event = null):void {
		atPostRender();
		_onPostRender();
		scene.calculate();
		atPreRender();
		_onPreRender();
	}
	
	/**
	 * @private
	 */
	private function onResize(event:Event = null):void {
		//if (_scaleToStage) {
		//	view.width = stage.stageWidth;
		//	view.height = stage.stageHeight;
		//}else {
		//	view.width = _viewWidth;
		//	view.height = _viewHeight;
		//}
	}
}








