/**
 * Copyright insocium ( http://wonderfl.net/user/insocium )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zv06
 */

/**
 * Copyright Bienvenu ( http://wonderfl.net/user/Bienvenu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9NPf
 */

// forked from cjcat2266's [Stardust] Fireworks
/**
 * Stardust Particle Engine
 * 
 * Homepage
 *     http://code.google.com/p/stardust-particle-engine/
 * 
 * Documentation
 *     http://stardust-particle-engine.googlecode.com/svn/trunk/docs/index.html
 * 
 * PDF Manual
 *     http://stardust-particle-engine.googlecode.com/svn/trunk/manual/Stardust%20Particle%20Engine%20Manual.pdf
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import idv.cjcat.stardust.common.clocks.ImpulseClock;
    import idv.cjcat.stardust.common.events.EmitterEvent;
    import idv.cjcat.stardust.twoD.renderers.PixelRenderer;
    
    [SWF(backgroundColor="#000000", frameRate=60)]
    
    public class Main extends Sprite {
        
        private const PARTICLE_COUNT:int = 50;
        
        private var emitter:FireworksEmitter;
        private var canvasBMP:Bitmap;
        private var fadeBMP:Bitmap;
        
        public function Main():void {
            canvasBMP = new Bitmap(new BitmapData(465, 465, true, 0));
            fadeBMP = new Bitmap(new BitmapData(465, 465, false, 0));
            addChild(fadeBMP);
            addChild(canvasBMP);
            
            var clock:ImpulseClock = new ImpulseClock(PARTICLE_COUNT);
            emitter = new FireworksEmitter(clock);
            var renderer:PixelRenderer = new PixelRenderer(canvasBMP.bitmapData);
            renderer.addEmitter(emitter);
            
       //     emitter.addEventListener(EmitterEvent.EMITTER_EMPTY, clock.impulse);
            addEventListener(Event.ENTER_FRAME, mainLoop);
        }
        
        private var fade:ColorTransform = new ColorTransform(1, 0, 0, 1, 0, -200, -200, -10);
        private function mainLoop(e:Event):void {
            fadeBMP.bitmapData.draw(canvasBMP.bitmapData);
            fadeBMP.bitmapData.colorTransform(fadeBMP.bitmapData.rect, fade);
            
            canvasBMP.bitmapData.fillRect(canvasBMP.bitmapData.rect, 0);
            emitter.step();
        }
    }
}

//------------------------------------------------------------------------------------------------

import flash.display.Shape;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.AlphaCurve;
import idv.cjcat.stardust.common.actions.CompositeAction;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.triggers.DeathTrigger;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Color;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Mask;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.Spawn;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

//------------------------------------------------------------------------------------------------

//I have no idea why this line must be added in order to compile successfully on Wonderfl.
//Just ignore this class :p
class BugFixer extends Shape { public function BugFixer() { } }

//------------------------------------------------------------------------------------------------

class FireworksEmitter extends Emitter2D {
    
    public function FireworksEmitter(clock:Clock) {
        super(clock);
        
        //initializers
        addInitializer(new Mask(1));
        addInitializer(new Color(0xFFFFFF));
        addInitializer(new Life(new UniformRandom(70, 20)));
        addInitializer(new Velocity(new LazySectorZone(1.5, 1)));
        addInitializer(new Position(new SinglePoint(232.5, 150)));
        
        //spawned particle initializers
        var spawn:Spawn = new Spawn(new UniformRandom(20, 0));
        spawn.addInitializer(new Mask(2));
        spawn.addInitializer(new Color(0xFFFFFF));
        spawn.addInitializer(new Life(new UniformRandom(20, 15)));
        spawn.addInitializer(new Velocity(new LazySectorZone(1, 0.5)));
        
        //actions
        var gravity:Gravity = new Gravity();
        gravity.addField(new UniformField(0, 0.02));
        
        var commonActions:CompositeAction = new CompositeAction();
        commonActions.mask = 1 | 2;
        commonActions.addAction(gravity);
        commonActions.addAction(new Age());
        commonActions.addAction(new DeathLife());
        commonActions.addAction(new Move());
        
        var trigger:DeathTrigger = new DeathTrigger();
        trigger.mask = 1;
        trigger.addAction(spawn);
        
        addAction(commonActions);
        addAction(trigger);
    }
}