/**
 * Copyright sihakata9999 ( http://wonderfl.net/user/sihakata9999 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zuuw
 */

// forked from kotobuki's Prototyping Lab: Recipe 10.3
package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.utils.getTimer;
  import funnel.*;
  import funnel.ui.LED;

  [SWF(backgroundColor="0xCCCCCC")]

  public class DetectMovement extends Sprite {
    // 動きがあったと判断する閾値
    private const THRESHOLD:Number = 0.5;

    // Arduino
    private var arduino:Arduino;

    // センサからの入力を表示するスコープ
    private var scopeForInputSignal_0:SignalScope;
    private var scopeForInputSignal_1:SignalScope;
    private var scopeForInputSignal_2:SignalScope;

    // センサからの入力とスムージングした結果の差を表示するスコープ
    private var scopeForDiff_0:SignalScope; 
    private var scopeForDiff_1:SignalScope;
    private var scopeForDiff_2:SignalScope;

    // 加速度センサのx軸に接続したピン
    private var sensorPin_0:Pin;
    private var sensorPin_1:Pin;
    private var sensorPin_2:Pin;

    // LED
    private var led:LED;

    // 前回LEDをトリガした時刻
    private var lastTrigger:int = 0;

    public function DetectMovement() {
      // LEDに接続したピンのモードをPWMにセット
      var config:Configuration = Arduino.FIRMATA;
      config.setDigitalPinMode(9, PWM);
      arduino = new Arduino(config);

      // LEDを初期化
      led = new LED(arduino.digitalPin(9));

      // センサに接続したピンに移動平均フィルタとイベントリスナをセット
      sensorPin_0 = arduino.analogPin(0);
      sensorPin_0.addFilter(new Convolution(
                          Convolution.MOVING_AVERAGE));
      sensorPin_0.addEventListener(PinEvent.CHANGE, onChange);
      
      sensorPin_1 = arduino.analogPin(1);
      sensorPin_1.addFilter(new Convolution(
                          Convolution.MOVING_AVERAGE));
      sensorPin_1.addEventListener(PinEvent.CHANGE, onChange);

      sensorPin_2 = arduino.analogPin(2);
      sensorPin_2.addFilter(new Convolution(
                          Convolution.MOVING_AVERAGE));
      sensorPin_2.addEventListener(PinEvent.CHANGE, onChange);

      //-----------------------------------------------------//
      // センサからの入力を表示するスコープを生成
      scopeForInputSignal_0 = new SignalScope(10, 0, 400, "X axis");
      addChild(scopeForInputSignal_0);
      
      scopeForDiff_0 = new SignalScope(10, 25, 400,  "X Diff (raw-sm)", -1, 1);
      addChild(scopeForDiff_0);

      scopeForInputSignal_1 = new SignalScope(10, 80, 400, "Y axis");
      addChild(scopeForInputSignal_1);
      
      scopeForDiff_1 = new SignalScope(10, 105, 400,  "Y Diff (raw-sm)", -1, 1);
      addChild(scopeForDiff_1);

      scopeForInputSignal_2 = new SignalScope(10, 160, 400, "Z axis");
      addChild(scopeForInputSignal_2);
      
      scopeForDiff_2 = new SignalScope(10, 185, 400,  "Z Diff (raw-sm)", -1, 1);
      addChild(scopeForDiff_2);

     //-----------------------------------------------------//
      // sukopu toyarawo secchi 
      //scopeForInputSignal_2 = new SignalScope(10, 180, 200, 
      //                                      "X axis");
      //addChild(scopeForInputSignal_2);


     // 毎フレームごとに発生するイベントにイベントリスナをセット
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    // 毎フレームごとに以下を実行
    private function onEnterFrame(e:Event):void {
      // センサからの入力を表示
      scopeForInputSignal_0.update(sensorPin_0.value);
      scopeForInputSignal_1.update(sensorPin_1.value);
      scopeForInputSignal_2.update(sensorPin_2.value);
      
     
      // センサからの入力とスムージングした値の差を表示
      var diff_0:Number = sensorPin_0.preFilterValue - sensorPin_0.value;
      scopeForDiff_0.update(diff_0);
      var diff_1:Number = sensorPin_1.preFilterValue - sensorPin_1.value;
      scopeForDiff_1.update(diff_1);
      var diff_2:Number = sensorPin_2.preFilterValue - sensorPin_2.value;
      scopeForDiff_2.update(diff_2);

    }

    // センサに接続したピンに変化があれば呼ばれる
    private function onChange(e:PinEvent):void {
      // センサからの入力とスムージングした値の差を求める
      var diff:Number = sensorPin_0.preFilterValue 
                        - sensorPin_0.value;

      // 現在の時刻を読み取る
      var now:int = getTimer();

      // 差の絶対値が閾値より大きく、前回トリガしてから一定時間が経過していたら
      if ((Math.abs(diff) > THRESHOLD) 
          && ((now - lastTrigger) > 10)) {
        // LEDをノコギリ波でブリンクさせる
        led.blink(300, 1, Osc.SAW);

        // 前回トリガした時刻として現在の時刻を記録
        lastTrigger = now;
      }
    }
  }
}
