/**
 * Copyright mek099 ( http://wonderfl.net/user/mek099 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zuuN
 */

// forked from shmdmoto's 画像ファイルの表示
package 
{
    import flash.events.KeyboardEvent;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import frocessing.display.F5MovieClip2D;
    /**
     * 画像ファイルの表示
     * @author shmdmoto
     */
    public class miniGame1 extends F5MovieClip2D
    {
        public var imgLoader1:Loader;
        public var imgLoader2:Loader;
        public var imgLoader3:Loader;
        public var imgLoader4:Loader;
        public var imgLoader5:Loader;
        public var imgLoader6:Loader;
        public var imgLoader7:Loader;
        public var imgLoader8:Loader;
        public function miniGame1() {
             Wonderfl.disable_capture();
             super(false);
        }
        public function setup() : void
        {
            imgLoader1 = new Loader();
            imgLoader2 = new Loader();
            imgLoader3 = new Loader();
            imgLoader4 = new Loader();
            imgLoader5 = new Loader();
            imgLoader6 = new Loader();
            imgLoader7 = new Loader();
            imgLoader8 = new Loader();
            
            imgLoader1.load( new URLRequest("http://www.motoike.net/wonderfl/mek099_apple01.jpg") );
            addChild(imgLoader1);
            imgLoader2.load( new URLRequest("http://www.motoike.net/wonderfl/mek099_apple02.jpg") );
            addChild(imgLoader2);
            imgLoader3.load( new URLRequest("http://www.motoike.net/wonderfl/mek099_apple03.jpg") );
            addChild(imgLoader3);
            imgLoader4.load( new URLRequest("http://www.motoike.net/wonderfl/mek099_apple04.jpg") );
            addChild(imgLoader4);
            imgLoader5.load( new URLRequest("http://www.motoike.net/wonderfl/mek099_apple05.jpg") );
            addChild(imgLoader5);
            imgLoader6.load( new URLRequest("http://www.motoike.net/wonderfl/mek099_apple06.jpg") );
            addChild(imgLoader6);
            imgLoader7.load( new URLRequest("http://www.motoike.net/wonderfl/mek099_apple07.jpg") );
            addChild(imgLoader7);
            imgLoader8.load( new URLRequest("http://www.motoike.net/wonderfl/mek099_hand.png") );
            addChild(imgLoader8);
        }
        
      public function draw() : void
      {
      }
    }    
}
// 以下は，動きを記述するためのクラスですので，編集しないでください．
import flash.utils.getTimer;
import frocessing.math.PerlinNoise;
/**
 * Interpolate:指定した時間で，開始値から終値までの過渡的を
 *             記述するクラス
 */
class Interpolate
{
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var duration  :Number;
    private var begin     :Number;
    private var end       :Number;
    private var pow       :Number;
    private var tOffset   :Number;
    private var tElapsed  :Number;
    private var prevVal   :Number;
    private var tRestart  :Number;
    public  var status    :int = NOINIT;
    public function Interpolate( t:Number, s:Number, f:Number,
                                 p:Number = 1) {
        begin = prevVal = s;
        end = f;
        duration = t;
        pow = p;
        tOffset = 0;
        tElapsed = 0;
    }
    public function val() :Number {
        var t :Number;
        if( status == NOINIT){
            tOffset = getTimer()/1000;
            prevVal = begin;
            status = RUNNING;
        } else if( status == RUNNING ) {
            t = getTimer()/1000;
            tElapsed = t -tOffset;
            if( tElapsed < duration ) {
                prevVal = begin + ( end - begin )*Math.pow(tElapsed/duration,pow);
            } else {
                prevVal = end;
                status = STOPPED;
            }
        } else if( status == WAITING){
            t = getTimer()/1000;
            if( t >= tRestart) {
                status = RUNNING;
                tOffset = t - tElapsed;        
            }
        }
        return prevVal;
    }
    public function pause() :void
    {
        status = STOPPED;
    }
    public function cont() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000-tElapsed;        
    }
    public function start() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000;                
    }
    public function wait( waitTime :Number ) :void
    {
        status = WAITING;
        tRestart = getTimer() + waitTime;
    }
    
    public function isRunning() :Boolean
    {
        if( status == RUNNING ) {
            return true;
        } else {
            return false;
        }
    }
    public function isStopped() :Boolean
    {
        if( status == STOPPED ) {
            return true;
        } else {
            return false;
        }
    }
    public function isEnd() :Boolean
    {
        if( prevVal >= end) {
            return true;
        } else {
            return false;
        }
    }
}
/**
 * LFO:指定した時間での周期的変動を記述するクラス
 */
class LFO {
    public static const SIN    :int = 1;
    public static const COS    :int = 2;
    public static const SAW    :int = 3;
    public static const TRI    :int = 4;
    public static const SQR    :int = 5;
    public static const ABSSIN :int = 6;
    public static const NOISE  :int = 7;
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var period    :Number;
    private var amplitude :Number;
    private var phase     :Number;
    private var offset    :Number;
    private var type      :int = SIN;
    private var isStart   :Boolean;
    private var t_offset  :Number;
    private var status    :int = NOINIT;
    
    public function LFO( prd :Number, amp :Number,
                         of :Number = 0, ph :Number = 0)
    {
        period    = prd;
        amplitude = amp;
        offset    = of;
        phase     = ph;
    }
    public function setPeak( min :Number, max :Number) :void
    {
        offset = (min + max) / 2;
        if( min < max ) {
            amplitude    = (max - min) / 2;
        } else {
            amplitude    = (min - max) / 2;
        }        
    }
    public function setType( t :int ) :void
    {
        type = t;
    }
    public function val( mul :Number=1.0 ) :Number {
        if(status == NOINIT) {
            status = RUNNING;
            t_offset = getTimer() / 1000.0;
            return val();
        } else if(status == RUNNING　) {
            var t :Number = getTimer() / 1000.0 - t_offset;
            var temp :Number;
            switch(type) {
                case SIN :
                    return  offset + mul * amplitude * 
                    Math.sin(2.0 * Math.PI *( t/period + phase) );
                case COS :
                    return  offset + mul * amplitude *
                    Math.cos(2.0 * Math.PI *( t/period + phase) );
                case SAW :
                    temp = t / period + 0.5 + phase - 
                    Math.floor( t / period + 0.5 + phase ) - 0.5;
                    return  offset + 2.0 * mul * amplitude * temp;
                case TRI :
                    temp = t / period + phase - 
                    Math.floor (t / period + phase );
                    if( 0.0 <= temp && temp < 0.25 ) {
                        return offset + mul * amplitude * 4.0 * temp;
                    } else if( temp < 0.75 ) {
                        return offset + mul * amplitude * (  2.0 - 4.0 * temp);
                    } else {
                        return offset + mul * amplitude * ( -4.0 + 4.0 * temp);
                    }
                case SQR :
                    temp = t/period + phase - 
                    Math.floor( t / period + phase);
                    if( temp < 0.5 ){
                        return offset + mul * amplitude;
                    } else {
                        return offset - mul * amplitude;
                    }
                case ABSSIN :
                    return  offset + 
                    Math.abs(mul * amplitude * Math.sin(2.0*Math.PI *( t/period + phase)));
                case NOISE :
                    var p :PerlinNoise = new PerlinNoise(); 
                    return offset -mul * amplitude + 2.0 * mul * amplitude * p.noise(t/period+phase,1);
                default :
                    return 0.0;
            }
        } else {
            return 0.0;
        }        
    }
}