/**
 * Copyright hacker_7jtkctfs ( http://wonderfl.net/user/hacker_7jtkctfs )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zu5Y
 */

/* Based on http://papervision2.com/loading-complex-models/ */

package {
	import flash.events.Event;
	import flash.events.MouseEvent;
	import org.papervision3d.events.FileLoadEvent;
	import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.parsers.Collada;
    import org.papervision3d.objects.parsers.SketchupCollada;
	import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import flash.geom.Point;
	import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.system.LoaderContext;
    import org.papervision3d.core.math.Matrix3D;
	
    public class Main extends BasicView{
        public var cow:DisplayObject3D;
		protected var materialList:MaterialsList;
        protected var bitmapFileMaterial:BitmapFileMaterial;
        
        /* handle user rotation */         
        public var mdp:Point = new Point(); // mouse down point
		public var bgClicked:Boolean = false;
		public var autoRotate:Boolean = true;		
			
        public function Main():void {
            super();
            /* get filename from arg */
            var varName:String;
            var paramObj:Object = LoaderInfo(this.root.loaderInfo).parameters;
            for (varName in paramObj) {
				myFlashVar = String(paramObj[varName]);
			}
            var myFlashVar:String;
			/* load textures */
			//materialList       = new MaterialsList();
            //bitmapFileMaterial  = new BitmapFileMaterial("daeModel/Cow.png");
            //materialList.addMaterial(bitmapFileMaterial,"all");
            
            /* load model */
            cow = new Collada(myFlashVar);
            cow = new Collada("http://papervision2.com/wp-content/downloads/dae/cow.dae");
            //cow = new SketchupCollada("http://www.ahlvik.se/colladaTest/Chief.dae");
            cow.moveDown(viewport.viewportHeight*0.5);
            cow.scale = 1;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, startRotation);
            stage.addEventListener(MouseEvent.DOUBLE_CLICK, startAutoRotation);
            stage.addEventListener(MouseEvent.MOUSE_WHEEL, mouseScroll);
            scene.addChild(cow);
            startRendering();
        }
		private function mouseScroll(event:MouseEvent):Boolean{
			//camera.zoom += event.delta;
			var newScale:Number = cow.scale + event.delta*0.1;
			if(newScale > 0.0){
				cow.scale = newScale;	
			}
			return false;
		}
		private function startAutoRotation(event:MouseEvent):void{
			autoRotate = !autoRotate;
		}
       private function startRotation(event:MouseEvent):void{
       		stage.addEventListener(MouseEvent.MOUSE_UP, endDrag);
			stage.addEventListener(Event.MOUSE_LEAVE, endDrag);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
			
			mdp.x = mouseX;
			mdp.y = mouseY;
			bgClicked = true;
			onMove();
       	}
       	public function endDrag(event:Event = null):void{
			stage.removeEventListener(MouseEvent.MOUSE_UP, endDrag);
			stage.removeEventListener(Event.MOUSE_LEAVE, endDrag);
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);
			bgClicked = false;
		}
		public function onMove(event:Event=null):void{
			var m:Matrix3D;
			m = Matrix3D.rotationY((mouseX - mdp.x)/150);
			m = Matrix3D.multiply(m, Matrix3D.rotationX(-(mouseY - mdp.y)/150));
			cow.transform = Matrix3D.multiply(m, cow.transform);
			
			mdp.x = mouseX;
			mdp.y = mouseY;
		}
        override protected function onRenderTick(event:Event = null):void{
	        	super.onRenderTick(event);
	        	if(autoRotate == true && bgClicked != true){
	        		cow.yaw(1);
	        	}	
        }
       
    }
   
}