/**
 * Copyright ShutheSL ( http://wonderfl.net/user/ShutheSL )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ztTK
 */

// forked from nutsu's BitmapDataSample10
// forked from nutsu's BitmapDataSample8
// forked from nutsu's BitmapDataSample7
// forked from nutsu's BitmapDataSample5
// forked from nutsu's BitmapDataSample4
// forked from nutsu's BitmapDataSample3
// forked from nutsu's BitmapDataSample1
package {
    
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.display.BlendMode;
    import flash.geom.Point;
    import flash.display.BitmapDataChannel;
    import flash.filters.DisplacementMapFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width=465,height=465,backgroundColor=0x33FF66,frameRate=30)]
    public class BitmapDataSample10 extends Sprite {
        
        private var bmpdata:BitmapData;
        private var sprite:Sprite;
        private var matrix:Matrix;
        private var colortrans:ColorTransform;
        private var filter:DisplacementMapFilter;
        
        public function BitmapDataSample10() {
            //BitmapDataを作成して表示リストに追加
            bmpdata = new BitmapData( 465, 465, false, 0 );
            addChild( new Bitmap(bmpdata) );
            //グラフィックの生成
            sprite = newFig( 0, 10, 40, 0x33FF66 );
            //Matrix,ColorTransformの初期化
            matrix = new Matrix();
            colortrans = new ColorTransform();
            //エフェクトの初期化
            var mapBitmap:BitmapData = new BitmapData( 465, 465, false, 0 );
            var mapPoint:Point       = mapBitmap.rect.topLeft;
            var componentX:uint      = BitmapDataChannel.RED;
            var componentY:uint      = BitmapDataChannel.GREEN;
            var scaleX:Number        = 8;
            var scaleY:Number        = 8;
            mapBitmap.perlinNoise( 240, 240, 2, 0, false, false );
            filter = new DisplacementMapFilter( mapBitmap, mapPoint, componentX, componentY, scaleX, scaleY );
            //イベント
            addEventListener( Event.ENTER_FRAME, enterframe );
            stage.addEventListener( MouseEvent.CLICK, reset );
        }
        
        private function enterframe(e:Event):void {
            //エフェクトの適用
            bmpdata.applyFilter( bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter );
            //変形
            matrix.identity();
            var s:Number = Math.random()*2;
            matrix.scale( s, s );
            matrix.rotate( Math.PI * Math.random() );
            matrix.translate( mouseX, mouseY );
            //色変換
            colortrans.greenMultiplier = mouseX / 465;
            colortrans.blueMultiplier  = mouseY / 465;
            colortrans.alphaMultiplier = Math.random();
            //BitmapDataへ描画
            bmpdata.draw( sprite, matrix, colortrans, BlendMode.ADD );
        }
        
        private function reset(e:MouseEvent):void {
            bmpdata.fillRect( bmpdata.rect, 0xFFFFFF );
        }
        
        private function newFig( cx:Number, cy:Number, size:Number, col:uint ):Sprite {
            //中心(cx,cy), 幅高さsize, 色col　のグラフィックを生成
            var shape:Sprite = new Sprite();
            shape.graphics.lineStyle( 0, 0xFFFFFF, 0.3 );
            shape.graphics.beginFill( col );
            shape.graphics.drawCircle( cx, cy, size*0.2 );
            shape.graphics.drawCircle( cx, cy, size*0.2 );
            var w:Number = size * 0.6;
            var h:Number = size * 0.15;
            shape.graphics.drawRect( cx - w/2, cy - h/2, w, h );
            shape.graphics.endFill();
            return shape;
        }
    }
}