/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zskS
 */

// forked from chrisperone's ParticlePower
package {
    import flash.geom.Vector3D;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.utils.getTimer;
    import flash.geom.Rectangle;
    
    public class FlashTest extends Sprite {
        static public const k_PARTICLE_SIZE:uint = 2;
        static public const k_PARTICLE_RECT:Rectangle = new Rectangle(0, 0, k_PARTICLE_SIZE, k_PARTICLE_SIZE);
        static public var m_canvas:BitmapData;
        static public var m_particles:Vector.<Particle>;
        private var m_prevTime:int;
        private var m_time:int;
        
        public function FlashTest() {
            // write as3 code here..
            m_canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
            addChild(new Bitmap(m_canvas));
            m_particles = new Vector.<Particle>;
            for (var i:uint; i < 600; ++i)
                m_particles[i] = new Particle(new Vector3D(Math.random() * m_canvas.width, Math.random() * m_canvas.height), 0, Math.random() * 360);
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function update(e:Event):void {
            var particle:Particle,
            particleB:Particle;
            
            m_prevTime = m_time;
            m_time = getTimer();
            
            m_canvas.lock();
            m_canvas.fillRect(m_canvas.rect, 0);
            //while (particle = particle.m_next) {
            for each (particle in m_particles) {
                particle.update((m_time - m_prevTime) * 0.001, mouseX, mouseY);
                for each (particleB in m_particles) {
                    if (particle !== particleB && particle.m_loc.subtract(particleB.m_loc).lengthSquared < k_PARTICLE_SIZE * k_PARTICLE_SIZE) {
                        particle.explode(particleB);
                    }
                }
                m_canvas.copyPixels(particle.m_graphic, k_PARTICLE_RECT, Particle.get2DLoc(particle.m_loc, 0));
            }
            m_canvas.unlock();
        }
    }
}
import flash.display.BitmapData;
import flash.geom.Vector3D;
import flash.geom.Point;

final class Particle {
    public var m_loc:Vector3D;
    public var m_mag:Number;
    public var m_angle:int;
    public var m_graphic:BitmapData;
    public var m_next:Particle;
    
    public function Particle(loc:Vector3D, mag:Number, angle:int) {
        m_loc = loc,
        m_mag = mag,
        m_angle = angle;
        m_graphic = new BitmapData(FlashTest.k_PARTICLE_SIZE, FlashTest.k_PARTICLE_SIZE, false, Math.random() * 0xFFFFFF | 0xFF000000);
    }
    public function update(deltaTime:Number, mouseX:Number, mouseY:Number):void {
        const dx:Number = m_loc.x - mouseX;
        const dy:Number = m_loc.y - mouseY;
        const distSqrd:Number = dx * dx + dy * dy;
        if (distSqrd < 1250) {
            m_angle = Math.atan2(dy, dx) * (180/Math.PI),
            m_mag = (1 - Math.sqrt(distSqrd) / 1250) * 250;
        }
        m_loc.x += Math.cos(m_angle * (Math.PI/180)) * m_mag * deltaTime,
        m_loc.y += Math.sin(m_angle * (Math.PI/180)) * m_mag * deltaTime;
        m_mag *= 0.95;
        if (m_loc.x < 0 || m_loc.x > FlashTest.m_canvas.width) m_angle += Math.random() < 0.5 ? -180 : 180;
        if (m_loc.y < 0 || m_loc.y > FlashTest.m_canvas.height) m_angle += Math.random() < 0.5 ? -180 : 180;
    }
    public function explode(instigator:Particle):void {
        //const i:int = FlashTest.m_particles.indexOf(this);

        //FlashTest.m_particles.splice(i, 1);
        //for each (var particle:Particle in FlashTest.m_particles) {
            const distSqrd:Number = m_loc.subtract(instigator.m_loc).lengthSquared;
            //if (distSqrd < 250) {
                instigator.m_angle = instigator.m_angle + 180; //Math.atan2(particle.m_loc.y - m_loc.y, particle.m_loc.x - m_loc.x) * (180/Math.PI),
                instigator.m_mag = m_mag * (1 - Math.sqrt(distSqrd) / 1250) * 2;
            //}
        //}
    }
    static public function get2DLoc(loc:Vector3D, rot:Number):Point {
        return new Point(loc.x, loc.y);
    }
}