/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zrQL
 */

// forked from siouxcitizen's Away3D練習1　Plane表示
// forked from siouxcitizen's forked from: Away3Dの練習
// forked from ser1zw's Away3Dの練習

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.events.MouseEvent;
  
  import away3d.containers.View3D;
  import away3d.primitives.Plane;
  import away3d.materials.WireColorMaterial;
  import away3d.materials.ColorMaterial;
  import away3d.materials.WireframeMaterial;

  [SWF(backgroundColor="#337777")]
  public class Away3DPlaneTest extends Sprite {
    private var view:View3D;

    private var planeWithWireColorMaterial : Plane;
    private var planeWithColorMaterial : Plane;
    private var planeWithWireframeMaterial : Plane;

    private var wireColorMaterial:WireColorMaterial;
    private var colorMaterial:ColorMaterial;
    private var wireframeMaterial:WireframeMaterial;


    public function Away3DPlaneTest() {
      view = new View3D();
      view.x = stage.stageWidth >> 1;
      view.y = stage.stageHeight >> 1;
      addChild(view);

      wireColorMaterial = new WireColorMaterial();
      wireColorMaterial.color = 0xff0000;
      wireColorMaterial.wireColor = 0xffff00;
      planeWithWireColorMaterial = new Plane({width: 50, height: 50});
      planeWithWireColorMaterial.material = wireColorMaterial;
      planeWithWireColorMaterial.bothsides = true;
      planeWithWireColorMaterial.y = 100;
      planeWithWireColorMaterial.rotationX = -90;
      view.scene.addChild(planeWithWireColorMaterial);

      colorMaterial = new ColorMaterial(0x0000ff);
      //colorMaterial.color = 0x0000ff;
      planeWithColorMaterial = new Plane({width: 50, height: 50});
      planeWithColorMaterial.material = colorMaterial;
      planeWithColorMaterial.bothsides = true;
      planeWithColorMaterial.y = -100;
      planeWithColorMaterial.rotationX = -90;
      view.scene.addChild(planeWithColorMaterial);

      wireframeMaterial = new WireframeMaterial(0x00ff00);
      planeWithWireframeMaterial = new Plane({width: 50, height: 50});
      planeWithWireframeMaterial.material = wireframeMaterial;
      planeWithWireframeMaterial.bothsides = true;
      planeWithWireframeMaterial.x = 100;
      planeWithWireframeMaterial.rotationX = -90;
      view.scene.addChild(planeWithWireframeMaterial);

      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function onEnterFrame(e:Event):void {
      view.scene.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
      view.scene.rotationY = stage.mouseX - (stage.stageWidth >> 1);

      planeWithWireColorMaterial.rotationX += 3;
      planeWithWireColorMaterial.rotationY += 3;

      planeWithColorMaterial.rotationX += 3;
      planeWithColorMaterial.rotationY += 3;

      planeWithWireframeMaterial.rotationX += 3;
      planeWithWireframeMaterial.rotationY += 3;

      view.render();
    }
  }
}
