/**
 * Copyright kazuhiroyamada ( http://wonderfl.net/user/kazuhiroyamada )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zr1l
 */

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.primitives.Plane;
    
    import caurina.transitions.Tweener;
    
    public class WaveImage extends BasicView {
        private var loaderObj:Loader;
        private var plane:Plane
        
        public function WaveImage() {
            loadImage("http://assets.wonderfl.net/images/related_images/9/9f/9fe3/9fe38020b23a7d1934b9f955aa01618707b11933");
            
            camera.z = -1400;
            camera.focus = 1000;
            camera.zoom = 1;
        }
        
        private function loadImage(imageName:String):void{
            loaderObj = new Loader();
            var _url:URLRequest = new URLRequest(imageName);
            var loaderContext:LoaderContext = new LoaderContext();
            loaderContext.checkPolicyFile = true;
            loaderObj.load(_url, loaderContext);
            loaderObj.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadedImage);
        }
        
        private function onLoadedImage(e:Event):void{
            loaderObj.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoadedImage);
            preparePlane();
        }
        
        private function preparePlane():void{
            var bmpData:BitmapData = new BitmapData(loaderObj.width, loaderObj.height);
            bmpData.draw(loaderObj);
            makePlane(bmpData);
            
            startWave();
        }
        
        private function startWave():void{
            startRendering();
            wavePlane(plane);
        }
        
        private function wavePlane(plane:Plane):void{
            for ( var i:String in plane.geometry.vertices ) {
                Tweener.addTween(plane.geometry.vertices[i], { z:-100, time:0.3, delay:0.005*Number(i), transition: "easeInOutSine",
                    onComplete:function():void{
                        Tweener.addTween(this, { z:0, time:0.3, transition: "easeInOutSine" } );
                    }
                } );
            }
        }
        
        private function makePlane(asset:BitmapData):void{
            var planeMaterial:BitmapMaterial = new BitmapMaterial(asset);
            plane = new Plane(planeMaterial, loaderObj.width, loaderObj.height, 5, 10);
            scene.addChild(plane);
        }
    }
}