/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zq6y
 */

// forked from tkinjo's forked from: 色相環
// forked from tkinjo's 色相環
// forked from tkinjo's 色相
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * 色相環クラス
     * 　とそのサンプル
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private var stageWidth:Number  = stage.stageWidth;
        private var stageHeight:Number = stage.stageHeight;
        private var stageCenter:Point  = new Point( stageWidth / 2, stageHeight / 2 );
        
        private var hueCircle1:HueCircle;
        private var hueCircle2:HueCircle;
        
        private var counter1:Number = 0;
        private var direction1:Number = 1;
        
        private var counter2:Number = 0;
        private var direction2:Number = 1;
        
        public function Main() 
        {
            hueCircle1 = new HueCircle( stageWidth / 4, stageWidth / 6 );
            hueCircle1.x = stageWidth / 4;
            hueCircle1.y = stageWidth / 4;
            addChild( hueCircle1 );
            
            hueCircle2 = new HueCircle( stageWidth / 4, stageWidth / 6 );
            hueCircle2.x = stageWidth / 4 * 3;
            hueCircle2.y = stageWidth / 4 * 3;
            addChild( hueCircle2 );
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            if ( counter1 > 100 ) {
                
                direction1 = -direction1;
                counter1 = 0;
            }
            if ( counter2 > 130 ) {
                
                direction2 = -direction2;
                counter2 = 0;
            }
            
            
            hueCircle1.radius      += -direction1;
            hueCircle1.innerRadius +=  direction1;
            
            hueCircle2.radius      +=  direction2;
            hueCircle2.innerRadius += -direction2;
            
            counter1++;
            counter2++;
        }
    }
}



import flash.display.*;
import flash.geom.*;
import flash.events.*;


class HueCircle extends Sprite {
    
    public function get radius():Number { return _radius; }
    public function set radius(value:Number):void 
    {
        _radius = value;
        draw();
    }
    private var _radius:Number;
    
    
    
    public function get innerRadius():Number { return _innerRadius; }
    public function set innerRadius(value:Number):void 
    {
        _innerRadius = value;
        draw();
    }
    private var _innerRadius:Number;
    
    
    
    private var bitmap:Bitmap;
    private var circleMask:Sprite;
    
    
    
    public function HueCircle( radius:Number, innerRadius:Number = 0 ) {
        
        _radius = radius;
        _innerRadius = innerRadius;
        
        var diameter:Number = radius * 2;
        
        
        
        if ( hueCircleBitmapData == null )
            resizeHueCircleBitmapData( diameter );
        
        
        
        bitmap = new Bitmap( hueCircleBitmapData );
        bitmap.cacheAsBitmap = true;
        addChild( bitmap );
        
        
        
        circleMask = new Sprite();
        circleMask.cacheAsBitmap = true;
        addChild( circleMask );
        
        
        
        bitmap.mask = circleMask;
        
        draw();
    }
    
    private function draw():void {
        
        circleMask.graphics.clear();
        circleMask.graphics.beginFill( 0xffffff );
        circleMask.graphics.drawCircle( radius, radius, radius);
        if( innerRadius != 0 ) circleMask.graphics.drawCircle( radius, radius, innerRadius );
        circleMask.graphics.endFill();
        
        
        var largeRadius:Number = ( ( radius > innerRadius ) ? radius : innerRadius );
        bitmap.x = -largeRadius;
        bitmap.y = -largeRadius;
        bitmap.scaleX = largeRadius / ( hueCircleBitmapData.width / 2 );
        bitmap.scaleY = largeRadius / ( hueCircleBitmapData.width / 2 );
        
        circleMask.x = -radius;
        circleMask.y = -radius;
    }
    
    
    
    
    
    
    private static var hueCircleBitmapData:BitmapData;
    
    public static function resizeHueCircleBitmapData( width:Number ):void {
        
        var centerPoint:Point = new Point( width / 2, width / 2 );
        var tempPoint:Point = new Point();
        
        hueCircleBitmapData = new BitmapData( width, width, false );
        
        hueCircleBitmapData.lock();
        
        for ( var i:int = 0; i < width; i++ ) {
            
            for ( var j:int = 0; j < width; j++ ) {
                
                tempPoint.x = i;
                tempPoint.y = j;
                hueCircleBitmapData.setPixel( i, j, getHueCircleColor( centerPoint, tempPoint ) );
            }
        }
        
        hueCircleBitmapData.unlock();
    }
}


function getHueCircleColor( centerPoint:Point, point:Point ):uint {
    
    return HSVtoRGB( getHueCircleAngle( centerPoint, point ), 1, 1 );
}


function getHueCircleAngle( centerPoint:Point, point:Point ):uint {
    
    var pointFromCenterPoint:Point = point.subtract( centerPoint );
    var pointBearingFromCenterPoint:Number = Math.atan2( pointFromCenterPoint.y, pointFromCenterPoint.x ) * 180 / Math.PI;
    
    if ( pointBearingFromCenterPoint < 0 )
    pointBearingFromCenterPoint = pointBearingFromCenterPoint + 360;
    
    return pointBearingFromCenterPoint;
}

function HSVtoRGB( h:Number, s:Number, v:Number ):uint {
    
    var Hi:uint = ( h / 60 ) % 6;
    
    var f:Number = h / 60 - Hi;
    
    var p:Number = v * ( 1 - s );
    
    var q:Number = v * ( 1 - f * s );
    
    var t:Number = v * ( 1 - ( 1 - f ) * s );
    
    switch( Hi ) {
        
        case 0:
            return toRGB255( v, t, p );
        
        case 1:
            return toRGB255( q, v, p );
        
        case 2:
            return toRGB255( p, v, t );
        
        case 3:
            return toRGB255( p, q, v );
        
        case 4:
            return toRGB255( t, p, v );
        
        case 5:
            return toRGB255( v, p, q );
    }
    
    return 0;
}


function toRGB255( r:Number, g:Number, b:Number ):uint {
    
    return ( r * 255 << 16 ) + ( g * 255 << 8 ) + b * 255;
}