/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zpnV
 */

// forked from kotobuki's Simple Sound Player: Photo Reflector
// forked from kotobuki's Simple Sound Player: Physical Button
// forked from kotobuki's Simple Sound Player
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import flash.utils.getTimer;

    import funnel.*;
    import funnel.ui.*;

    [SWF(backgroundColor="0x808080")]

    public class SimpleSoundPlayer extends Sprite {
        // これはMac OS Xの場合にはパーソナルウェブ共有、Windowsの場合には
        // AN HTTPDなどを使用してローカルでサーバを用意することを想定した
        // URLです。
        private const URL_OF_SOUND_FILE:String = "http://localhost/sounds/snare.mp3";

        private var _sound:Sound;

        private var _gainer:Gainer;

        private var _signalScope:SignalScope;

        private var _lastPlayed:int = 0;

        private var _sensorPin:Pin;

        [SWF(backgroundColor="0x808080")]

        public function SimpleSoundPlayer() {
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, onLoadComplete);
            _sound.load(new URLRequest(URL_OF_SOUND_FILE));

            _gainer = new Gainer();
            _sensorPin = _gainer.analogInput(0);

            // センサからの入力を確認するためのSignalScopeを用意します
            _signalScope = new SignalScope(10, 10, 200, "Photo Reflector");
            addChild(_signalScope);

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onLoadComplete(e:Event):void {
            // サウンドの準備ができたらセンサ入力に対してにSetPointフィルタをセットし、
            // 0→1への変化が起きた時に呼ぶイベントリスナをセットします
            _sensorPin.addFilter(new SetPoint([0.8, 0.05]));
            _sensorPin.addEventListener(PinEvent.RISING_EDGE, onRisingEdge);
        }

        private function onEnterFrame(e:Event):void {
            // 毎フレームごとにSignalScopeを更新します
            _signalScope.update(_sensorPin);
        }

        private function onRisingEdge(e:PinEvent):void {
            // 前回の再生から一定時間（この場合は200ms）が経過していたら再生を始めます
            var now:int = getTimer();
            if ((now - _lastPlayed) > 200) {
                _sound.play(30);
                _lastPlayed = now;
            }
        }
    }
}
