/**
 * Copyright divillysausages ( http://wonderfl.net/user/divillysausages )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zphz
 */

package {
    import flash.events.EventDispatcher;
    import flash.events.Event;    
    import flash.events.MouseEvent;
    import flash.display.Shape;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        private static var m_format:TextFormat        = null;
        private static const EVENT_TURN_GREEN:String  = "green";
        private static const EVENT_TURN_RED:String    = "red";
        
        private var m_dispatcher:EventDispatcher = null; // the event dispatcher that will send our event
        private var m_turnGreenBut:TextField     = null; // our button to turn our sprite green
        private var m_turnRedBut:TextField       = null; // the button to turn our sprite red
        private var m_shape:Shape                = null; // our shape
        
        public function FlashTest() {
            // write as3 code here..
            trace( "Hello world" );
            
            // create our event listener and add the events to it
            this.m_dispatcher = new EventDispatcher;
            this.m_dispatcher.addEventListener( FlashTest.EVENT_TURN_GREEN, this._onTurnGreen );
            this.m_dispatcher.addEventListener( FlashTest.EVENT_TURN_RED, this._onTurnRed );
            
            // create our buttons
            this.m_turnGreenBut    = this._createButton( "Turn green", 10.0, 10.0 );
            this.m_turnRedBut      = this._createButton( "Turn red", this.m_turnGreenBut.x + this.m_turnGreenBut.width + 10.0, 10.0 );
            
            // create our shape
            this.m_shape   = new Shape;
            this.m_shape.x = this.m_shape.y = 100.0;
            this.addChild( this.m_shape );
            
            // draw our shape
            this._drawShape( 0xffffff );
        }
        
        private function _drawShape( colour:uint ):void
        {
            this.m_shape.graphics.clear();
            this.m_shape.graphics.lineStyle( 2.0 );
            this.m_shape.graphics.beginFill( colour );
            this.m_shape.graphics.drawCircle( 0.0, 0.0, 20.0 );
            this.m_shape.graphics.endFill();
        }

        
        private function _createButton( label:String, x:Number, y:Number ):TextField
        {
            if( FlashTest.m_format == null )
                FlashTest.m_format = new TextFormat( "Trebuchet Ms", 12 );
                
            // create the textfield
            var t:TextField         = new TextField;
            t.defaultTextFormat     = FlashTest.m_format;
            t.selectable            = false;
            t.border                = true;
            t.background            = true;
            t.text                  = label;
            t.x                     = x;
            t.y                     = y;
            t.width                 = t.textWidth + 4.0;
            t.height                = t.textHeight + 4.0;
            
            // add the click listener
            t.addEventListener( MouseEvent.CLICK, this._onClickButton );
            
            this.addChild( t );
            return t;
        }
        
        // called when we click on one of the buttons to turn our shape red or green
        private function _onClickButton( e:MouseEvent ):void
        {
            var isGreen:Boolean = ( ( e.target as TextField ) == this.m_turnGreenBut );
            this.m_dispatcher.dispatchEvent( new Event( isGreen ? FlashTest.EVENT_TURN_GREEN : FlashTest.EVENT_TURN_RED ) );
        }
        
        // called when our event dispatcher tells us to turn green
        private function _onTurnGreen( e:Event ):void
        {
            this._drawShape( 0x00ff00 );
        }
        
        // called when our event dispatcher tells us to turn red
        private function _onTurnRed( e:Event ):void
        {
            this._drawShape( 0xff0000 );
        }




    }
}