/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zoww
 */

// forked from mousepancyo's Photoshop風カラーピッカー with お絵かき
/*
Photoshopのカラーピッカー風のカラーピッカーを
作ってみました。
（僕の環境（MacOS 10.6.4）では、なぜかSafariで見るとスライダーの挙動がやたらと重い & まだちょっと変な動きをしますが…）

このカラーピッカーで色を選んで下の黒い部分に
お絵かきできます。

お絵かきの部分は以前wonderflにポストした「もじゃもじゃお絵かき」
http://wonderfl.net/c/A5Jf をほぼそのまま使い回しですが…


*/

package {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.net.URLRequest;
    import flash.system.System;
    import flash.system.Security;
    import flash.system.ApplicationDomain;
    import flash.system.LoaderContext;
    import flash.desktop.Clipboard;
    import flash.ui.MouseCursor;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="30")]

    public class Main extends Sprite {
        private static const DOMAIN:String = "www.digifie.jp"
        private static const POLICY_FILE:String = "http://www.digifie.jp/crossdomain.xml"
        private static const UI_DATA:String = "http://www.digifie.jp/files/UI.swf"

        private var _loader:Loader = new Loader();
        private var _UISet:Class;
        private var UISet:MovieClip;
        private var circle:Sprite;
        private var bt0:*;
        private var bt1:*;
        private var bt2:*;
        private var slider:*;
        private var color0:Sprite;
        private var color1:Sprite;
        private var color2:Sprite;
        private var color3:Sprite;
        private var color4:Sprite;
        private var color5:Sprite;
        private var prevColorObj:Sprite;
        private var setColorObj:Sprite;
        private var rgb:*;
        private var h:*;
        private var s:*;
        private var b:*;
        
        private var _svbmpd:BitmapData;
        private var _hbmpd:BitmapData;
        private var _svBmp:Bitmap;
        private var _hBmp:Bitmap;
        private var _rot:uint = 0;
        private var _colorArray:Array = new Array();
        
        private var _canvas:Canvas

        public function Main() {
            Security.loadPolicyFile(POLICY_FILE);
            Security.allowDomain(DOMAIN);
            //
            graphics.beginFill(0xF6F6F6, 1)
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight)
            graphics.endFill()
            //
            swfLoad();
        }
        
        private function swfLoad():void{
            var context:LoaderContext = new LoaderContext(); 
            context.checkPolicyFile = true;
            context.applicationDomain = ApplicationDomain.currentDomain;   
            var req:URLRequest = new URLRequest(UI_DATA);
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, swfLoadComplete);
            _loader.load(req, context);
        }
        
        private function swfLoadComplete(e:Event):void {
            _UISet = _loader.contentLoaderInfo.applicationDomain.getDefinition("UISet") as Class;
            UISet = new _UISet();
            addChild(UISet);
            bt0 = UISet.bt0;
            bt1 = UISet.bt1;
            bt2 = UISet.bt2;
            circle = UISet.circle;
            slider = UISet.slider;
            prevColorObj = UISet.prevColorObj;
            setColorObj = UISet.setColorObj;
            color0 = UISet.color0;
            color1 = UISet.color1;
            color2 = UISet.color2;
            color3 = UISet.color3;
            color4 = UISet.color4;
            color5 = UISet.color5;
            rgb = UISet.rgb;
            h = UISet.h;
            s = UISet.s;
            b = UISet.b;
            //
            init();
        }
        
        private function init():void{
            //sv
            _svbmpd = CreatePickColor.svBmpd(_rot);
            _svBmp = new Bitmap(_svbmpd);
            addChild(_svBmp);
            _svBmp.x = 20;
            _svBmp.y = 20;
            //h
            _hbmpd = CreatePickColor.hBmpd();
            _hBmp = new Bitmap(_hbmpd);
            addChild(_hBmp);
            _hBmp.x = 285;
            _hBmp.y = 20;
            //
            setChildIndex(UISet,numChildren - 1);
            //スライダーのようなUIは、MOUSE_OUTでUP状態にすると、処理が重い場合などはすぐにターゲットから外れてしまい
            //止まってしまいます。なので、MOUSE_UPをstageで検出するようにして、OUTの判定は無しにすればスムーズに動きます。
            //また、dragStart&dragStopでは、挙動がもっさりするので、stage.mouseX、stage.mouseYでカーソルを移動させた方が良いですね。
            
            slider.addEventListener(MouseEvent.MOUSE_DOWN,sliderDownFunc);
            //slider.addEventListener(MouseEvent.MOUSE_UP,mouseUpFunc); 
            //slider.addEventListener(MouseEvent.MOUSE_OUT,mouseUpFunc);
            circle.addEventListener(MouseEvent.MOUSE_DOWN,circleDownFunc);
            //circle.addEventListener(MouseEvent.MOUSE_UP,mouseUpFunc);
            //circle.addEventListener(MouseEvent.MOUSE_OUT,mouseUpFunc);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,mouseClickFunc,true);
            //
            _canvas = new Canvas()
            addChild(_canvas)
            _canvas.x = 19;
            _canvas.y = 278;
            _canvas.col = 0xFFFFFF
            _canvas.addEventListener(MouseEvent.CLICK, canvasClear)
        }

        //DOWN
        private function sliderDownFunc(e:MouseEvent):void {
           stage.addEventListener(MouseEvent.MOUSE_MOVE,sliderMoveFunc);
           stage.addEventListener(MouseEvent.MOUSE_UP,sliderUpFunc);           
           setColorA()            
        }
        private function circleDownFunc(e:MouseEvent):void {
           stage.addEventListener(MouseEvent.MOUSE_MOVE,circleMoveFunc);
           stage.addEventListener(MouseEvent.MOUSE_UP,circleUpFunc);           
           setColorA()
        }
 
        private function setColorA():void {
            var color:ColorTransform = new ColorTransform();
            if (! _svbmpd.getPixel(circle.x - 20,circle.y - 20)) {
                color.color = 0xFFFFFF;
            } else {
                color.color = _svbmpd.getPixel(circle.x - 20,circle.y - 20);
            }
            prevColorObj.transform.colorTransform = color;
            _canvas.noLoop()
        }

        //UP,OUT
        private function sliderUpFunc(e:MouseEvent):void {
          stage.removeEventListener(MouseEvent.MOUSE_MOVE,sliderMoveFunc);
          stage.removeEventListener(MouseEvent.MOUSE_UP,sliderUpFunc);              
          _canvas.loop()          
        }
        private function circleUpFunc(e:MouseEvent):void {        
          stage.removeEventListener(MouseEvent.MOUSE_MOVE,circleMoveFunc);
          stage.removeEventListener(MouseEvent.MOUSE_UP,circleUpFunc);               
          _canvas.loop()
        }

        //MOVE
        private function sliderMoveFunc(e:MouseEvent):void {
            slider.y=mouseY;
            if (slider.y<_hBmp.y) {
              slider.y=_hBmp.y
            } else if (slider.y>_hBmp.y+_hBmp.height) {
              slider.y=_hBmp.y+_hBmp.height             
            }
            svColorChange();
            colorSetB();
        }

        private function circleMoveFunc(e:MouseEvent):void {
            circle.x=mouseX;                     
            circle.y=mouseY;
            if (circle.y < _svBmp.y) {
              circle.y=_svBmp.y
            } else if (circle.y > _svBmp.y+_svBmp.height) {
              circle.y=_svBmp.y + _svBmp.height            
            }
            if (circle.x<_svBmp.x) {
              circle.x=_svBmp.x
            } else if (circle.x>_svBmp.x+_svBmp.width) {
              circle.x=_svBmp.x+_svBmp.width            
            }            
            colorSetB();
        }
        
        private function colorSetB():void{
            rgb.text = toStringRGB(_svbmpd.getPixel(circle.x - 20,circle.y - 20))
            var colObj:Object = ConvertHSV.colorToHsv(_svbmpd.getPixel(circle.x - 20,circle.y - 20));
            h.text = Math.round(colObj.h).toString();
            s.text = Math.round(colObj.s).toString();
            b.text = Math.round(colObj.v).toString();
            //
            var color:ColorTransform = new ColorTransform();
            color.color = _svbmpd.getPixel(circle.x - 20,circle.y - 20);
            setColorObj.transform.colorTransform = color;
            //
            _canvas.col = _svbmpd.getPixel(circle.x - 20,circle.y - 20)            
        }



        //CLICK
        private function mouseClickFunc(e:MouseEvent):void {
            switch (e.target) {
                case bt0 :
                    var str:String = ""
                    if(_colorArray.length > 1){
                        for(var i:int=0; i<_colorArray.length; i++){
                            str += toStringRGB(_colorArray[i]) + "\n"
                        }
                        Clipboard.generalClipboard.clear();
                        System.setClipboard(str)
                    }
                    break;
                case bt1 :
                    if (_colorArray.length < 6) {
                        _colorArray.push(_svbmpd.getPixel(circle.x - 20,circle.y - 20));
                        for (i=0; i<_colorArray.length; i++) {
                            //
                            var color:ColorTransform = new ColorTransform();
                            color.color = _colorArray[i]
                            this["color" + i].transform.colorTransform = color;
                        }
                    }
                    break;
                case bt2 :
                    _colorArray=new Array()
                    Clipboard.generalClipboard.clear();
                    for (i=0; i<6; i++) {
                            //
                            var initColor:ColorTransform = new ColorTransform();
                            initColor.color = 0xFFFFFF
                            this["color" + i].transform.colorTransform = initColor;
                        }
                    break;
            }
        }

        //Change SV KeyColor
        private function svColorChange():void {
            if (_svbmpd) {
                _svbmpd.dispose();
                this.removeChild(_svBmp);
                _svBmp = null;
            }
            //
            _rot = 359-(slider.y-20)*(359/(_hBmp.height));
            trace(_rot);
            _svbmpd = CreatePickColor.svBmpd(_rot);
            _svBmp = new Bitmap(_svbmpd);
            this.addChild(_svBmp);
            _svBmp.x = 20;
            _svBmp.y = 20;
            //
            setChildIndex(UISet,numChildren - 1);
        }
        
        //toStringRGB
        private function toStringRGB(val:uint):String {
          var str:String = "#" + ((val >> 16) & 0xFF).toString(16).toUpperCase() + ((val >> 8) & 0xFF).toString(16).toUpperCase() + (val & 0xFF).toString(16).toUpperCase();
          return str;
        }
        
        //Canvas Clear
        private function canvasClear(e:MouseEvent):void{
            _canvas.canvasClear()
        }
    }
}



//
import flash.display.Bitmap;
import flash.display.BitmapData;

class CreatePickColor {
        
    public static function svBmpd(rot:Number, size:uint = 250):BitmapData {
        var size:uint = size
        var bmpd:BitmapData = new BitmapData(size,size,false,0x000000);
        bmpd.lock()
        for (var y:uint = 0; y < size; y++) {
            for (var x:uint = 0; x < size; x++) {
                bmpd.setPixel(x, y, ConvertHSV.hsvToColor(rot, x/size, 1-y/size));
            }
        }
        bmpd.unlock()
        return bmpd;
    }
        
    public static function hBmpd(size:uint = 250):BitmapData {
        var size:uint = size
        var bmpd:BitmapData = new BitmapData(20,size,false,0x000000);
        bmpd.lock()
        for (var y:uint = 0; y < size; y++) {
            for (var x:uint = 0; x < size; x++) {
                bmpd.setPixel(x, y, ConvertHSV.hsvToColor(359-y*(359/size), 1, 1));
            }
        }
        bmpd.unlock()
        return bmpd;
    }
}


//
class ConvertHSV {
    // HSV >>> color
    public static function hsvToColor(h:Number, s:Number, v:Number):Number {
        var cv:Number = Math.round(v * 255);
        var r:Number = cv;
        var g:Number = cv;
        var b:Number = cv;
        if (s > 0) {
            var i:Number = Math.floor(h / 60);
            var f:Number = h / 60 - i;
            var m:Number = Math.round(v * (1 - s) * 255);
            var n:Number = Math.round(v * (1 - s * f) * 255);
            var k:Number = Math.round(v * (1 - s * (1 - f)) * 255);
            switch (i) {
                case 0 :
                    g = k;
                    b = m;
                    break;
                case 1 :
                    r = n;
                    b = m;
                    break;
                case 2 :
                    r = m;
                    b = k;
                    break;
                case 3 :
                    r = m;
                    g = n;
                    break;
                case 4 :
                    r = k;
                    g = m;
                    break;
                case 5 :
                    g = m;
                    b = n;
                    break;
            }
        }
        return r << 16 | g << 8 | b;
    }

    // color >>> HSV
    public static function colorToHsv(color:Number):Object {
        var r:Number = color >> 16;
        var g:Number = (color >> 8) & 0xFF;
        var b:Number = color & 0xFF;
        var max:Number = Math.max(r,Math.max(g,b));
        var min:Number = Math.min(r,Math.min(g,b));
        var range:Number = max - min;
        var h:Number = 0;
        var s:Number = 0;
        var v:Number = max / 255;
        if (v > 0) {
        s = range / max;
        if (s > 0) {
            var cr:Number = (max - r) / range;
            var cg:Number = (max - g) / range;
            var cb:Number = (max - b) / range;
            if (r == max) {
                h = cb - cg;
            } else if (g == max) {
                h = 2 + cr - cb;
            } else {
                h = 4 + cg - cr;
            }
                h *= 60;
                if (h<0) {
                    h+=360;
                }
            }
        }
        return {h:Math.round(h * 100) * 0.01, s:Math.round(s * 100), v:Math.round(v * 100)};
    }
}


import frocessing.display.*;
import flash.geom.Point;

class Canvas extends F5MovieClip2DBmp{
      
    private static const WIDTH:Number  = 430;
    private static const HEIGHT:Number = 180;
    private var _pastMousePos:Point
    private var _px:Number = 0
    private var _py:Number = 0
    private var _col:int = 0
    
    public function Canvas() {
        super();
    }
    
    public function setup():void {
        size(WIDTH, HEIGHT);
        background(0);
        noFill();
        colorMode(RGB, 1);
    }

    public function draw():void{
        if(_pastMousePos != null){
            var p:Point = new Point(mouseX, mouseY)
            var distance:int = Point.distance(p, _pastMousePos);
            _pastMousePos = p
            var r:int = Math.random() * 5
            for(var i:int; i<distance ;i++){
                stroke(_col, 0.1);
                _px += (p.x+(Math.random()*distance-distance/2) - _px) * Math.random() * 0.5;    
                _py += (p.y+(Math.random()*distance-distance/2) - _py) * Math.random() * 0.5;
                ellipse(_px, _py, r*distance/2+2, r*distance/2+2)
            }
            _pastMousePos = p
        }else{
            _pastMousePos = new Point(mouseX, mouseY)
        }
    }
    
    public function set col(col:int):void{
        _col = col
    }
    
    public function canvasClear():void{
        background(0, 1);
    }
}