/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zoLc
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;

	public class FlashTest extends Sprite {
		private var _data:/*Datum*/Array;
		
        public function FlashTest() {
			_data = new Array();
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			create();
			update();
			draw();
		}
		
		private function create():void {
			for (var index:uint = 0; index < 5; ++index) {
				var pos:Point = new Point(232.5, 232.5);
				var rad:Number = Math.random() * Math.PI * 2;
				var speedLength:Number = 2;
				var speed:Point = new Point(Math.cos(rad) * speedLength, Math.sin(rad) * speedLength);
				var datum:Datum = new Datum(pos, speed, 0);
				_data.push(datum);
			}
		}
		
		private function update():void {
			for (var index:uint = 0; index < _data.length; ++index) {
				var datum:Datum = _data[index];
				
				datum.pos.x += datum.speed.x;
				datum.pos.y += datum.speed.y;
				datum.rotate += Math.PI * 2 * 0.04;
				
				if (datum.pos.x < 0
					|| datum.pos.x > 465
					|| datum.pos.y < 0
					|| datum.pos.y > 465
					) {
					_data.splice(index, 1);
					--index;
					continue;
				}
			}
		}
		
		private function draw():void {
			var g:Graphics = this.graphics;
			g.clear();
			g.beginFill(0x000000);
			g.drawRect(0, 0, 465, 465);
			g.endFill();
			
			g.lineStyle(1, 0xffffff);
			var size:Number = 4.0;
			
			for (var index:uint = 0; index < _data.length; ++index) {
				var datum:Datum = _data[index];
				g.moveTo(
					datum.pos.x + (Math.cos(datum.rotate) * size),
					datum.pos.y + (Math.sin(datum.rotate) * size));
				g.lineTo(
					datum.pos.x + (Math.cos(datum.rotate + Math.PI) * size),
					datum.pos.y + (Math.sin(datum.rotate + Math.PI) * size));
				g.moveTo(
					datum.pos.x + (Math.cos(datum.rotate + (Math.PI * 0.5)) * size),
					datum.pos.y + (Math.sin(datum.rotate + (Math.PI * 0.5)) * size));
				g.lineTo(
					datum.pos.x + (Math.cos(datum.rotate - (Math.PI * 0.5)) * size),
					datum.pos.y + (Math.sin(datum.rotate - (Math.PI * 0.5)) * size));
			}
		}
    }
}
import flash.geom.Point;

class Datum {
	public var pos:Point;
	public var speed:Point;
	public var rotate:Number;
	
	public function Datum(pos:Point, speed:Point, rotate:Number) {
		this.pos = pos;
		this.speed = speed;
		this.rotate = rotate;
	}
}