/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zoAk
 */

// forked from yawakisin's Papervision3d入門 2.5.4
/*
	Flash3D コンテンツ制作のためのPapervision3Dのサンプルテスト	
	
	code 2.5.5
*/

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.system.*;
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.primitives.*;
	
	public class Sample3 extends BasicView {
		private var rot:Number = 0;
		// 一時的なマウスの値を格納する変数
		private var oldX:Number = 0;
		// 目標角度
		private var targetRot:Number = 0;
		// マウスを押した状態かどうかを判別するフラグ
		private var isMouseDown:Boolean = false;
		
		// コンストラクタ
		public function Sample3() 
		{
			var urlReq:URLRequest = new URLRequest(new String("http://assets.wonderfl.net/images/related_images/2/29/2957/295773efe549b4206f0ab5e4e776915fb02f95ff"));
			var loader:Loader = new Loader();
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, init);
			loader.load(urlReq, new LoaderContext(true));		
		}
		
		private function init(e:Event):void 
		{
			var loader:Loader = Loader(e.target.loader);
			// ロードしたデータからbitmaDataを作成する。
			var bmdata:BitmapData = new BitmapData(loader.width, loader.height);
			bmdata.draw(loader);

			// マテリアルを作成
			var material:BitmapMaterial = new BitmapMaterial(bmdata);
			
			// 球体(Sphere)を作成
			// 引数はマテリアル、球面の半径、横のポリゴン分割数、縦のポリゴン分割数
			var sphere:Sphere = new Sphere(material, 400, 16, 16);
			
			// 3D空間に球体を追加
			scene.addChild(sphere);
			
			// レンダリング
			startRendering();

			// エンターフレームのイベントを登録
			addEventListener(Event.ENTER_FRAME, loop);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
		}
		
		// アニメーション
		private function loop(e:Event):void 
		{
			// イージングの公式を用いて滑らかにする
			// 値 += (目標値 - 現在の値) * 減速値
			rot += (targetRot - rot) * 0.05;
			
			// 角度に応じてカメラの位置を設定
			var deg:Number = rot * Math.PI / 180;
			camera.x = 1000 * Math.sin(deg);
			camera.z = 1000 * Math.cos(deg);
		}

		private function downHandler(e:MouseEvent):void 
		{
			isMouseDown = true;
			oldX = e.stageX;	// mouseX でもー
		}
		
		private function upHandler(e:MouseEvent):void 
		{
			isMouseDown = false;		
		}

		private function moveHandler(e:MouseEvent):void 
		{
			if (isMouseDown)
			{
				// マウスが以前いた位置のx座標からの移動距離を算出
				var dx:Number = e.stageX - oldX;
				// 目標角度に移動距離の値を加算
				targetRot += dx / 4;
				// oldX にマウスのX座標を代入
				oldX = e.stageX;
			}
		}
		
	}
}
