/**
 * Copyright motikawa_rgm ( http://wonderfl.net/user/motikawa_rgm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/znpq
 */

// forked from bkzen's MoviePuzzleTest
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * [企画]皆で動くパズル作ろうぜ
     * http://wonderfl.net/c/yb0z
     * 前から気になってた事があって、Wonderfl は色んな作品があるけど作品同士のつながりがないのが気になっていた。
     * 例えば、パーツだけ作って読み込んでロードするだけで使える[素材]を作るとか。
     * あと Fork することで何かに参加できるようにすればもっと面白い事になって行きそうなきがする。
     * チェックメイトやJAMのような方法ではなく、Forkされたもの全てが一つの作品を作るというか。
     * これからもチェックメイトやJAM以外にも[企画]タグや[素材]タグが増えていくといいなぁ。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000000", frameRate = "60", width = "465", height = "465")]
    public class MoviePuzzle extends Sprite 
    {
        private static const BG_COLOR: uint = 0x000000;
        private static const FRAME_RATE: uint = 30;
        
        public function MoviePuzzle() 
        {
            // ローダーで読み込まれなかった時の為のデモ用
            addEventListener(Event.ADDED_TO_STAGE, demo);
        }
        
        /**
         * 
         * MoviePuzzle -> MovieJigsawPuzzle
         *         obj["disp"]      : DisplayObject : 描画対象このオブジェクトの440x440の範囲で切り取られて描画されます。
         *         obj["color"]     : uint : 背景色(省略時は0x000000)
         *         obj["frameRate"] : uint : フレームレート(省略時は60)
         *         obj["level"]     : uint : 上限レベル(省略時は1)
         * @param    obj : <Object>
         */
        public function initialize(obj: Object): void
        {
            disp = new Ribbon();
            obj["disp"]  = disp;
            obj["color"] = 0xdddddd;
            obj["frameRate"]  = 60;
        }
        
        /**
         * スタートする時に呼ばれます。
         * @param    level : uint : 指定レベル : 変える必要があれば。
         */
        public function start(level: uint): void
        {
            Object(disp).start(level);
        }
        
        /**
         * 終了した時に呼ばれます。
         */
        public function end(): void
        {
            Object(disp).end();
        }
        
        private var disp: DisplayObject;
        
        /**
         * デモ用
         * @param    e
         */
        private function demo(e: Event): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, demo);
            //
            var obj: Object = {};
            initialize(obj);
            disp = obj["disp"];
            var col: uint = obj["color"];
            var bmd: BitmapData = new BitmapData(440, 440, false, col);
            var bmp: Bitmap = new Bitmap(bmd, "auto", true);
            start(1);
            addChild(bmp);
            addEventListener(Event.ENTER_FRAME, function(e: Event): void {
                bmd.lock();
                bmd.fillRect(bmd.rect, col);
                bmd.draw(disp);
                bmd.unlock();
            } );
        }
    }
}
/**
 * ...
 * @author motikawa/t.okazaki
 */
import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
class Ribbon extends Sprite
{
    private static const RIBBON_LENGTH:int = 400;
    private var _ribbons:Vector.<RibbonParts>;
    private var _center:Point = new Point();
    private var _rotation:Number = 0;
    private var _rotatinRadius:Number = 150;
    private var _dir:Number = .2;
    public function Ribbon() 
    {
        _init();
    }
    private function _init():void 
    {
        _ribbons = new Vector.<RibbonParts>(RIBBON_LENGTH, true);
        _center = new Point(440* .5 , 440 * .5);
        var i:uint = 0,
            w:Number = 25,
            bp:RibbonParts,
            p:RibbonParts;
        
        for (i = 0; i < RIBBON_LENGTH; i++)
        {
            if ( i == 0) p = new RibbonHeadParts(w, 30);
            else if ( i == RIBBON_LENGTH -1) p = new RibbonTailParts(w, 30);
            else p = new RibbonParts(w, 3);
            
            p.rotateX = i;
            addChildAt(p, 0);
            _ribbons[i] = p;
        }
        filters = [new DropShadowFilter(10, 45, 0x553333, .2, 8, 8, 3)];
        //startMove();
    }
    public function start(level:int):void
    {
        _rotation = 0;
        addEventListener(Event.ENTER_FRAME, _update);
    }
    private function _update(e:Event):void
    {
        var rp:RibbonParts,
            i:int,len:int = _ribbons.length,
            dx:Number, dy:Number, rad:Number;
        _rotation += 1.5;
        rad = (_rotation ) * NativePixel3D.RADIAN;
        dx = Math.cos(rad) * _rotatinRadius + _center.x;
        dy = Math.sin(rad) * _rotatinRadius + _center.y;
        rp = _ribbons[0];
        rp.drag(dx, dy);
        for (i = 1; i < len; i++)
        {
            rp = _ribbons[i - 1];
            (_ribbons[i] as RibbonParts).drag(rp.x, rp.y,rp.length);
        }
        
        _dir = (_rotatinRadius > 200) ? -.2 : (_rotatinRadius < 100) ? .2 : _dir;
        _rotatinRadius += _dir;
    }
    public function end():void
    {
        removeEventListener(Event.ENTER_FRAME, _update);
    }
}

class NativePixel3D
{
    public static const RADIAN:Number = Math.PI / 180;
    private static var _fl:Number = 300;
    private var _z:Number;
    private var _x:Number;
    private var _y:Number;
    private var _rotationX:Number;
    private var _rotationY:Number;
    private var _rotationZ:Number;
    private var _vec:Vector3D;
    public function NativePixel3D($x:Number, $y:Number, $z:Number,$color:uint)
    {
        _vec = new Vector3D();
        _vec.x = _x = $x;
        _vec.y = _y = $y;
        _vec.z = _z = $z;
        _rotationX = _rotationY = _rotationZ = 0;
    }
    public function set rotationY(value:Number):void
    {
        var rad:Number = RADIAN * (_rotationY - value),
            sin:Number = Math.sin(rad),
            cos:Number = Math.cos(rad),
            dx:Number = _vec.x,
            dz:Number = _vec.z;
            
        _vec.x = dx * cos - sin * dz;
        _vec.z = dx * sin + cos * dz;
        _rotationY =  (value >= 360) ? value - 360 : (value < 0) ? value + 360 : value;
    }
    public function set rotationX(value:Number):void
    {
        var rad:Number = RADIAN * (_rotationX - value),
            sin:Number = Math.sin(rad),
            cos:Number = Math.cos(rad),
            dy:Number = _vec.y,
            dz:Number = _vec.z;
        _vec.y = dy * cos - sin * dz,
        _vec.z = dy * sin + cos * dz,
        _rotationX = (value >= 360) ? value - 360 : (value < 0) ? value + 360 : value;
    }
    public function set rotationZ(value:Number):void
    {
        var rad:Number = RADIAN * (_rotationZ - value),
            sin:Number = Math.sin(rad),
            cos:Number = Math.cos(rad),
            dx:Number = _vec.x,
            dy:Number = _vec.y;
        _vec.x = dx * cos - sin * dy,
        _vec.y = dx * sin + cos * dy,
        _rotationZ =  (value >= 360) ? value - 360 : (value < 0) ? value + 360 : value;
    }
    public function update():void
    {
        _x = _vec.x;
        _y = _vec.y;
        _z = _vec.z;
    }
    
    public function get position():Vector3D { return _vec; }
    public function get x():Number { return _x * _fl *1 / ( _fl - _z); }
    public function get y():Number { return - _y * _fl * 1 / ( _fl - _z); }
    public function get z():Number { return _z; }
    public function set z(value:Number):void { _z = value; }
    public function get rotationX():Number { return _rotationX; }
    public function get rotationY():Number { return _rotationY; }
    public function get rotationZ():Number { return _rotationZ; }
}
class RibbonParts extends Shape
{
    {
        init();
    }
    private static function init():void
    {
        var texsture:BitmapData = new BitmapData(100, 1, false, 0x0),
            mt:Matrix = new Matrix(),
            sh:Shape = new Shape();
        
        mt.createGradientBox(100, 1, 0);
        sh.graphics.beginGradientFill(GradientType.LINEAR, [ 0XF4D5E7, 0xC64F82], [1,  1], [0,  255], mt);
        sh.graphics.drawRect(0, 0, 100, 1);
        sh.graphics.endFill();
        
        texsture.draw(sh);
        _colors = new Vector.<uint>(100,true);
        var i:uint = 0,
            len:uint = texsture.width;
            
        for (i = 0 ; i < len; i++)    _colors[i] = texsture.getPixel(i, 0);
    }
    
    private static var _colors:Vector.<uint>;
    private static function getColor(num:Number):uint
    {
        num = (num > 1) ? 1 : ( num < 0)? 0 : num;
        return _colors[int((_colors.length -1) * num)];
    }
    
    private static const LIGHT_POS:Vector3D = new Vector3D( -1, .5, 1);
    protected var _normalResult:Vector.<Vector3D>;
    protected var _results:Vector.<Vector.<Number>>;
    protected var _length:Number = 0;
    private var _rotationX:int;
    private var _position:Vector3D;
    public function get length():Number { return _length; }
    public function RibbonParts(w:Number, h:Number)
    {
        init(w, h);
    }
    protected function init(w:Number,h:Number):void
    {
        _length = h;
        w *= .5;
        var normal:NativePixel3D = new NativePixel3D(0, 0, -1, 0x0),
            v:Array = [4],
            q1:NativePixel3D = new NativePixel3D( -5, -w, 0, 0x0),
            q2:NativePixel3D = new NativePixel3D(  h, -w, 0, 0x0),
            q3:NativePixel3D = new NativePixel3D(  h,  w, 0, 0x0),
            q4:NativePixel3D = new NativePixel3D( -5,  w, 0, 0x0);
        v[0] = q1;
        v[1] = q2;
        v[2] = q3;
        v[3] = q4;
        _normalResult = new Vector.<Vector3D>(360,true);
        _results = new Vector.<Vector.<Number>>(360, true);
        calculate(v, normal);
        draw(_results[0], _normalResult[0]);
    }
    protected final function calculate(pixels:Array,norm:NativePixel3D):void
    {
        var i:uint = 0,
            j:uint = 0,
            k:uint = 0,
            rot:int = 0,
            len:uint = 360,
            len2:uint = pixels.length * 2,
            len3:uint = pixels.length,
            p:NativePixel3D,
            v:Vector.<Number>;
        for (i = 0 ; i < len ; i++)
        {
            if ( i >= 85 && i <= 95) rot = 85;
            else if ( i >= 265 && i <= 275) rot = 265;
            else rot = i;
            v = new Vector.<Number>(len2, true);
            norm.rotationX = i;
            norm.position.normalize();
            for ( k = 0; k < len3; k++)
            {
                p = pixels[k];
                p.rotationX = i;
                p.update();
                v[k * 2] = p.x;
                v[k * 2 + 1] = p.y;
            }
            _normalResult[i] = norm.position.clone();
            _results[i] = v;
        }
    }
    public function set rotateX(value:int):void
    {
        value = (value > 359) ? value - 360 : (value < 0) ? value + 360 : value;
        _rotationX = (value > 87 && value < 93) ? 93 :( value > 267 && value < 273) ? 273 : value;
        draw(_results[value],_normalResult[value]);
    }
    public function get rotateX():int { return _rotationX; };
    
    public final function drag(xPos:Number,yPos:Number,len:Number = NaN):void
    {
        var dx:Number = xPos - x,
            dy:Number = yPos - y,
            radian:Number = Math.atan2(dy, dx),
            l:Number = isNaN(len) ? _length : len,
            degree:Number = radian / NativePixel3D.RADIAN;
        rotation = degree;
        x = xPos - Math.cos(radian) * l;
        y = yPos - Math.sin(radian) * l;
        rotateX ++;
    }
    protected final function draw(v:Vector.<Number>,normal:Vector3D):void
    {
        graphics.clear();
        graphics.beginFill(updateColor(normal), 1);
        for (var i:uint = 0, len:uint = v.length; i < len; i += 2)
        {
            if (i == 0) graphics.moveTo(v[i], v[i + 1]);
            else graphics.lineTo(v[i], v[i + 1]);
        }
        graphics.endFill();
    }
    public function set rotateZ(value:Number):void
    {
        rotation = value;
    }
    private function updateColor(v:Vector3D):uint
    {
        v.normalize();
        var dp:Number = v.dotProduct(LIGHT_POS),
            ac:Number = Math.acos(dp / (v.length * LIGHT_POS.length)),
            col:Number = ac / Math.PI * 1.6;
        return getColor(col);
    }
    public function get position():Vector3D { return _position; }
}
class RibbonHeadParts extends RibbonParts
{
    public function RibbonHeadParts(w:Number, h:Number)
    {
        super(w, h);
    }
    override protected function init(w:Number, h:Number):void 
    {
        _length = 3;
        w *= .5;
        var normal:NativePixel3D = new NativePixel3D(0, 0, -1, 0x0),
            v:Array = [5],
            q1:NativePixel3D = new NativePixel3D( -5, -w, 0, 0x0),
            q2:NativePixel3D = new NativePixel3D(  h, -w, 0, 0x0),
            q3:NativePixel3D = new NativePixel3D(  0,  0, 0, 0x0),
            q4:NativePixel3D = new NativePixel3D(  h,  w, 0, 0x0),
            q5:NativePixel3D = new NativePixel3D( -5,  w, 0, 0x0);
        v[0] = q1;
        v[1] = q2;
        v[2] = q3;
        v[3] = q4;
        v[4] = q5;
        _normalResult = new Vector.<Vector3D>(360, true);
        _results = new Vector.<Vector.<Number>>(360, true);
        calculate(v, normal);
        draw(_results[0], _normalResult[0]);
    }
}
class RibbonTailParts extends RibbonParts
{
    public function RibbonTailParts(w:Number, h:Number)
    {
        super(w, h);
    }
    override protected function init(w:Number, h:Number):void 
    {
        _length = h;
        w *= .5;
        var normal:NativePixel3D = new NativePixel3D(0, 0, -1, 0x0),
            v:Array = [5],
            q1:NativePixel3D = new NativePixel3D( -h, -w, 0, 0x0),
            q2:NativePixel3D = new NativePixel3D(  5, -w, 0, 0x0),
            q3:NativePixel3D = new NativePixel3D(  5,  w, 0, 0x0),
            q4:NativePixel3D = new NativePixel3D( -h,  w, 0, 0x0),
            q5:NativePixel3D = new NativePixel3D(  0,  0, 0, 0x0);
        v[0] = q1;
        v[1] = q2;
        v[2] = q3;
        v[3] = q4;
        v[4] = q5;
        _normalResult = new Vector.<Vector3D>(360, true);
        _results = new Vector.<Vector.<Number>>(360, true);
        calculate(v, normal);
        draw(_results[0], _normalResult[0]);
    }
}