/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/znjE
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
         
         myTri = new xTri();
         myTri.x0 = 110;
         myTri.y0 = 60;
         myTri.x1 = 280;
         myTri.y1 = 280;
         myTri.x2 = 90;
         myTri.y2 = 290;
         
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var myTri:xTri;
        
        public function onEnter(e:Event):void
        {
           graphics.clear();
           graphics.lineStyle(2, 0);
           
           var a:xTri;
           a = myTri;
           
           graphics.moveTo(a.x0, a.y0);
           graphics.lineTo(a.x1, a.y1);
           graphics.lineTo(a.x2, a.y2);
           graphics.lineTo(a.x0, a.y0);
           
           var mx:Number;
           var my:Number;
           mx = stage.mouseX;
           my = stage.mouseY;
            
           graphics.drawCircle(mx,my, 4); 
            
           if (a.isInside(mx,my))
           {
             graphics.beginFill(0, 0.5);
              graphics.moveTo(a.x0, a.y0);
              graphics.lineTo(a.x1, a.y1);
              graphics.lineTo(a.x2, a.y2);
              graphics.lineTo(a.x0, a.y0);
             graphics.endFill();   
           }//endif 
            
           graphics.lineStyle(1, 0, 0.5);
           graphics.moveTo(a.x0, a.y0);
           graphics.lineTo(mx,my);            
            
           graphics.moveTo(a.x1, a.y1);
           graphics.lineTo(mx,my);            
            
           graphics.moveTo(a.x2, a.y2);
           graphics.lineTo(mx,my);            
            
            
        }//onenter
        
    }//classend
}
import flash.display.Graphics;

internal class xTri
{
    public var x0:Number = 0;
    public var y0:Number = 0;
    public var x1:Number = 0;
    public var y1:Number = 0;
    public var x2:Number = 0;
    public var y2:Number = 0;
    
    
    
    public function isInside(wx:Number, wy:Number):Boolean
    {
      var ax:Number;    var ay:Number;
      var bx:Number;    var by:Number;
      var wz:Number;
         
      //so what happens here
      //is we check each edge of the triangle
      //and see on which side the point is   
      //if we are on the same side of all edges
      //we are inside the triangle
      
      // to find which side the point is
      // we use a cross product with the edge
      // and a vector from one of the vertices on the edge
      // to the point we are testing
      // because we are in 2D we only need the Z axis (wz)
      // and see its sign, aka is it towards or away from us   

      // (special case is when the Z is 0
      // that means the point is exactly on an edge (or vertex)
      // here it's handled by saying that
      // a point on the edge of the triangle 
      // is considered as a point inside it)
       
         
      ax = x1 - x0;
      ay = y1 - y0;
      bx = wx - x0;
      by = wy - y0;
      wz = (ax * by) - (ay * bx);
      if (wz < 0) { return false; }

      ax = x2 - x1;
      ay = y2 - y1;
      bx = wx - x1;
      by = wy - y1;
      wz = (ax * by) - (ay * bx);
      if (wz < 0) { return false; }
      
      ax = x0 - x2;
      ay = y0 - y2;
      bx = wx - x2;
      by = wy - y2;
      wz = (ax * by) - (ay * bx);
      if (wz < 0) { return false; }
        
      return true;  
    }//isinside
    
    
}//xtri