/**
 * Copyright tokufxug ( http://wonderfl.net/user/tokufxug )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/znZG
 */

// forked from undo's Japanino LED test2 画面クリックでLEDオンオフ
// forked from undo's Japanino LED test
//Japanino test

//画面をクリックすると13番PINを1-0で切り替える。

// ※このコードはStandardFirmata用です。
// JapaninoまたはArduinoにStandardFirmataを書き込んでからお試しください。

package {
    import flash.display.Sprite;
    import flash.events.*;

    import caurina.transitions.Tweener;

    import funnel.*;

    [SWF(frameRate="24")]

    import flash.accessibility.Accessibility;
    public class JapaninoTest extends Sprite {
        // 光残像キットを取付けたJapaninoボード
        private var _japanino:Arduino;
        // 13番PIN
        private var _led13:Pin;
        
        //スイッチ
        private var _switch:Sprite;

        public function JapaninoTest() {
            // Japaninoのインス	タンスを生成する
            _japanino = new Arduino(Arduino.FIRMATA);

            // Japaninoの準備が完了した時に発生するイベントに対してリスナをセット
            _japanino.addEventListener(FunnelEvent.READY, onJapaninoReady);
            
            this._switch = new Sprite();
            addChild(this._switch);
            this._switch.graphics.beginFill(0xff0000);
            this._switch.graphics.drawRect(-50,-25,100,50);
            this._switch.graphics.endFill();
            this._switch.buttonMode = true;
            this._switch.x = this.stage.stageWidth/2;
            this._switch.y = this.stage.stageHeight/2;
            
            this._switch.addEventListener(MouseEvent.CLICK, onStageClick);
        }
	
        private function onJapaninoReady(e:Event):void {
        		//13番PINを取得。返り値はfunnel.Pinオブジェクト
        		this._led13 = _japanino.digitalPin(13);
        }

		private function onStageClick(evt:MouseEvent):void
		{
			if(this._led13)
			{
				//13番PINに1なら0を　0なら1を書き込む
				this._led13.value = (this._led13.value == 1)?0:1;
				
				//スイッチをオンオフしてる風に見せる
				this._switch.graphics.clear();
				switch(this._led13.value)
				{
					case 0:
						this._switch.graphics.beginFill(0xff0000);
					break;
					case 1:
						this._switch.graphics.beginFill(0x0000ff);
					break;
				}
				this._switch.graphics.drawRect(-50,-25,100,50);
				this._switch.graphics.endFill();
			}	
		}
    }
}
