/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zmxq
 */

package {
    import flash.text.engine.TextLine;
    import flash.display.*;
    import flash.text.*;
    //[SWF(backgroundColor=0x333333, width=465, height=465)]
    public class FlashTest extends Sprite {
        private var map1:ozmap = new ozmap();
        public var text1:TextField;
        private var btn1:Btn;
        public function FlashTest() {
            

            
            addChild(map1);    
            map1.map.graphics.beginFill(0x00ff00);
            map1.map.graphics.drawRect(0,0,50,50);
            map1.map.graphics.endFill();     
 
        }

    }
}
    import flash.net.FileReference;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
 //   import flash.ui.*;
    import flash.utils.*;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;

class ozmap extends Sprite{
        
        private var scale:Number = 1;
        
        private var wheel:int;//ホイール回転量
        private var zoom:Number = 1.0;//拡大率
        public var map:Sprite;//フィールド
        
        private var mapFocusX:Number=0;
        private var mapFocusY:Number=0;
        private var scrFocusX:int=0; 
        private var scrFocusY:int=0; 
        private var mX:int=0; 
        private var mY:int=0; 
        
        private var scalingPanel:Sprite;
        private var base:Sprite; 
              
        private var mapscale:int=0;
        private var dragPanel:Shape = new Shape();
        private var onMouseBtn:Boolean;
        private var msk:Sprite = new Sprite();
        
        private var file:FileReference;
        
       
        
        
        //コンストラクタ 
        public function ozmap():void{
 
            //カーソル位置描画
            scalingPanel = new Sprite();//ズーム中心 
            addChild(scalingPanel);
            
            
            //マップ基準座標
            base = new Sprite();     
            scalingPanel.addChild(base);
            
            //マップ上への配置
            map = new Sprite();
            map.addEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.addEventListener(MouseEvent.MOUSE_UP,up1);

            addEventListener(MouseEvent.MOUSE_WHEEL,on_wheel);//ホイール操作 
            addEventListener(Event.ENTER_FRAME, onFrame);//メインループ
 
            base.addChildAt(map,0); 
            map.addChild(dragPanel);
            
            aaaa();   
        }
        
            


        
        public function setAreaRect(x:Number,y:Number,width:Number,height:Number):void{
           this.addChild(msk);
           this.x = x;
           this.y = y;
           msk.graphics.beginFill(0xff0000);
           msk.graphics.drawRect(0,0,width,height);
           msk.graphics.endFill();
           this.mask = msk;
        }


  
        //マップドラッグ
        private var scrOn:Boolean;
        private function down1(event:MouseEvent):void{
            wheel=0;
            scrOn=false;
            onMouseBtn=true;

      　    event.currentTarget.startDrag();
      　    addEventListener(MouseEvent.MOUSE_MOVE,onMove);
      　    event.stopPropagation();//イベントの伝播を止める
        }
        private function up1(event:MouseEvent):void{
            
            onMouseBtn=false;
            event.currentTarget.stopDrag();
            removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            
           // event.stopPropagation();//イベントの伝播を止める
        }
        
        private function onMove(e:MouseEvent):void{
            aaaa();
        }
    
        //ホイール操作
        private function on_wheel(event:MouseEvent):void{
            wheel += event.delta;        
        }
  
        //メインループ
        private function onFrame(e:Event):void {
            on_zoom();
            //フルスクリーンでのスクロールモード
            
            if(stage.displayState == StageDisplayState.FULL_SCREEN){
                var size:Number = 50;
                if(scrOn==true && onMouseBtn==false){
                    if(stage.mouseY < size)map.y -= (stage.mouseY-size)/zoom/5;
                    else if(this.root.loaderInfo.height-size < stage.mouseY){
                        map.y -= (size+stage.mouseY-this.root.loaderInfo.height)/zoom/5;                    
                    }
                    if(stage.mouseX < 10)map.x -= (stage.mouseX-10)/zoom/10;
                    else if(this.root.loaderInfo.width-10 < stage.mouseX){
                        map.x -= (10+stage.mouseX-this.root.loaderInfo.width)/zoom/10;                    
                    }
                }
                else{
                    if(stage.mouseY < size)scrOn=false;
                    else if(this.root.loaderInfo.height-size < stage.mouseY)scrOn=false;
                    else if(stage.mouseX < 10)scrOn=false;
                    else if(this.root.loaderInfo.width-10 < stage.mouseX)scrOn=false;
                    else scrOn=true;
                }

            }
        }
        
        
        //マップスクロール基準点の更新
        private function aaaa():void{

            if(0<=wheel){
                mX = mouseX; mY = mouseY;//カーソル位置
                //ズーム中心
                scalingPanel.x = mouseX; scalingPanel.y = mouseY; 
                //マップ位置
                base.x -= (mX-scrFocusX)/zoom; base.y -= (mY-scrFocusY)/zoom;
                //フォーカス位置
                scrFocusX = mX; scrFocusY = mY;
            }
            else{
                mX = this.root.loaderInfo.width/2; mY = this.root.loaderInfo.height/2;//カーソル位置
                //ズーム中心
                scalingPanel.x =this.root.loaderInfo.width/2; scalingPanel.y = this.root.loaderInfo.height/2; 
                //マップ位置
                base.x -= (mX-scrFocusX)/zoom; base.y -= (mY-scrFocusY)/zoom;
                //フォーカス位置
                scrFocusX = mX; scrFocusY = mY;
            }

            //フィールドドラッグ用
            dragPanel.graphics.clear();
            dragPanel.graphics.beginFill(0xff0000,0);
            dragPanel.graphics.drawCircle(-(map.x+map.parent.x)/map.scaleX,-(map.y+map.parent.y)/map.scaleY,600/map.scaleX);
            dragPanel.graphics.endFill();
        }

        
        
        private function on_zoom():void{
            if(wheel != 0){
                aaaa();//基準点更新
                
                if(wheel < 0){
                    zoom *= 1+(0.005*wheel);
                }
                else if(0 < wheel){
                    zoom *= 1+(0.005*wheel);
                }
                
                
                if(2 < zoom){

                    map.scaleX *= 2;
                    map.scaleY *= 2;
                    zoom /= 2;
                    map.x += map.x+base.x;
                    map.y += map.y+base.y;
                    
                    mapscale--;
                
                }
                else if(zoom < 1.0){
             
                    map.x -= (map.x+base.x)/2;
                    map.y -= (map.y+base.y)/2;
                    zoom *= 2;
                    map.scaleX /= 2;
                    map.scaleY /= 2;
                    
                    mapscale++;
                    
                }
                scalingPanel.scaleX = zoom;
                scalingPanel.scaleY = zoom;        
            }
          
        }
        
    }
    
    
    
////////////////////////////////////////////////////////////////////////
//  TextEditer class
////////////////////////////////////////////////////////////////////////


    import flash.text.*;
    import flash.ui.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.System;
    class TextEditer extends TextField {
        private var file:FileReference;
        private var prevText:Object;
        private var nextText:Object;
        
        public function TextEditer():void {
            System.useCodePage = true;//UNICODE以外のテキストファイルをロードする場合 true
            this.type = "input";//入力可能
            //this.tabEnabled = true;
            this.selectable = false;
            this.addEventListener(KeyboardEvent.KEY_DOWN, onKey); 
            addEventListener(MouseEvent.CLICK, onFocus);    
            addEventListener(MouseEvent.MOUSE_WHEEL,onWheel);
            
            //コンテキストメニュー@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@            
            var menu1:ContextMenuItem = new ContextMenuItem("ファイルを開く");
            menu1.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function():void {
                //txt.appendText("menu");
                load();
            });
            var menu2:ContextMenuItem = new ContextMenuItem("ファイルを保存");
            menu2.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function():void {
                save();
            });

            contextMenu = new ContextMenu();
            contextMenu.hideBuiltInItems();
            contextMenu.customItems = [menu1,menu2];
            //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  
        }
        
        private function onWheel(e:MouseEvent):void{
            e.stopPropagation();
        }

        
        //改行コードの統一 (CR+LF or CR) → LF
        private function unifyLineFeedCode(str:String):String {
            var CR:String = String.fromCharCode(13);
            var LF:String = String.fromCharCode(10);
            str = str.split(CR+LF).join(LF);
            str = str.split(CR).join(LF);
            return str;
        }
        
        //セーブ
        public function save():void {
            var fileRef:FileReference = new FileReference();
            fileRef.save(this.text, this.name);
        }
        
        //ファイルロード
        public function load():void {//ファイル選択　①
            file = new FileReference();
            file.addEventListener(Event.COMPLETE, onLoaded);
            file.addEventListener(Event.SELECT, onSelect);
            file.browse();
        }
        private function onSelect(e:Event):void{//ロード開始　②
            file.load();
        }   
        private function onLoaded(e:Event):void {//ロード完了　③
            this.name = file.name;   
            var byte:int = file.data.length;
            var byte2:uint;
            
            //txt.text = String(file.data);
            this.text = unifyLineFeedCode(file.data.toString());//改行コード統一
            file.removeEventListener(Event.COMPLETE, onLoaded);
            file.removeEventListener(Event.SELECT, onSelect);      
        }

        
        //編集モード終了
        private function outFocus(e:FocusEvent):void {
            this.selectable = false;
            removeEventListener(FocusEvent.FOCUS_OUT, outFocus);
            removeEventListener(MouseEvent.MOUSE_DOWN, dragCansel);
            addEventListener(MouseEvent.MOUSE_DOWN, onFocus);
            //this.appendText(" Out ");
        }
        
        //編集モード開始
        private function onFocus(e:MouseEvent):void {
            this.selectable = true;
            addEventListener(FocusEvent.FOCUS_OUT, outFocus);
            removeEventListener(MouseEvent.MOUSE_DOWN, onFocus);
            addEventListener(MouseEvent.MOUSE_DOWN, dragCansel);
            //this.appendText(" In ");
            //e.stopPropagation();
        }
        
        private function dragCansel(e:MouseEvent):void {
            e.stopPropagation();
        }
        
        //キー入力
        private function onKey(e:KeyboardEvent):void {
            var sw:Boolean;
            var str1:String;
            var str2:String;
            
            
            //　エンターキーの状態
            if (e.keyCode == 13) sw = true;
            else if (e.keyCode == 108) sw = true;
            else sw = false;
            
            //キャレット位置に改行文字を挿入
            if(sw == true){
                str1 = this.text.substring(0, this.caretIndex);
                str2 = this.text.substring(this.caretIndex, this.length);
                this.text = str1;
                this.appendText("\n");//キャレット位置で改行
                
                //インデント構造（タブ＆スペースの構成）を調べる
                var indent:int=0;
                var prevReturn:int = this.text.lastIndexOf('\r', this.caretIndex-1);//前回の改行位置
                //一つ前の改行直後に続くタブコードの数=インデント深度
                for (var j:int = prevReturn+1; j < this.caretIndex; j++) {
                    if (this.text.charAt(j) == '\t' || this.text.charAt(j) == ' ' ) indent++;
                    else break;
                }
                //上の行のインデントに従う
                var indentStr:String = this.text.slice(prevReturn + 1, prevReturn + 1 + indent);
                this.appendText(indentStr);//インデント
                this.text += str2;//結合
                
                //キャレット位置をインクリメント
                this.setSelection(this.caretIndex +indent + 1, this.caretIndex +indent + 1);
                return;
            }
            //tab
            if (e.keyCode == 9) {
                str1 = this.text.substring(0, this.caretIndex);
                str2 = this.text.substring(this.caretIndex, this.length);
                this.text = str1 + '\t' + str2;
                //キャレット位置をインクリメント
                this.setSelection(this.caretIndex + 1, this.caretIndex + 1);                
                return;
            }
            

        }

    }
    
    
//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
