/**
 * Copyright iong ( http://wonderfl.net/user/iong )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zmoN
 */

// forked from Albert's Drag snap

// + check pile blocks
// + add collision detection
// but I don't understand why can't snap...
package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    import flash.display.*;
    import flash.geom.*;

    public class DragSnap extends Sprite
    {
        public const NUM_POINTS:int = 50;
        public var pts:Vector.<Point> = new Vector.<Point>();
        protected var mc:Sprite;

        protected var iSizeBlock:uint = 34;
        protected var iC:uint = Math.floor(stage.stageWidth/iSizeBlock);
        protected var pHit:Point;

        public var hXMin:int;
        public var hXMax:int;
        public var hYMin:int;
        public var hYMax:int;
        
        public var pX:Number;
        public var pY:Number;

        public function DragSnap()
        {
            var i:int;

            var aryBoardP:Array = new Array();
            for(i=0; i<iC; i++){
                aryBoardP[i] = new Array();
                for(var k:int=0; k<iC; k++){
                    aryBoardP[i][k]= false;
                }
            }

            var c:DragBlock;
            var iw:uint;
            var ih:uint;
            for(i=0; i<NUM_POINTS; i++)
            {
                iw = int(13*Math.random());
                ih = int(13*Math.random());
                while(aryBoardP[iw][ih]){
                    iw = int(13*Math.random());
                    ih = int(13*Math.random());
                }
                aryBoardP[iw][ih] = true;

                pts[i] = new Point(34*(iw+1), 34*(ih+1));
                c = new DragBlock(pts[i], Math.random()*0xAAAAAA);
                addChild(c);
                c.buttonMode = true;
                c.addEventListener(MouseEvent.MOUSE_DOWN, drag);
            }

            //draw();
        }

 
        protected function draw():void
        {
            /*graphics.clear();*/
        }
        
        protected function drag(event:MouseEvent):void
        {
            mc = event.currentTarget as Sprite;

            initBoardArea(mc);

            stage.addEventListener(MouseEvent.MOUSE_UP, endDrag);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, move);
            move();
        }
        
        protected function endDrag(event:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_UP, endDrag);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, move);
            move();
        }
        
        protected function move(event:MouseEvent=null):void
        {
            pX = mouseX;
            pY = mouseY;

            if(pX<hXMin)pX= hXMin;
            if(pX>hXMax)pX= hXMax;
            if(pY<hYMin)pY= hYMin;
            if(pY>hYMax)pY= hYMax;

            mc.x = pX;
            mc.y = pY;
            draw();
        }

        private function initBoardArea(mc:Sprite):void
        {
            var mX:uint = Math.floor(mc.x/iSizeBlock)-1;
            var mY:uint = Math.floor(mc.y/iSizeBlock)-1;

            hXMin = iSizeBlock;
            hXMax = stage.stageWidth-iSizeBlock+12;
            hYMin = iSizeBlock;
            hYMax = stage.stageHeight-iSizeBlock+12;

            var i:int;
            var aryHit:Array;

            for(i=mY; i>=0; i--){
                pHit   = new Point(mc.x, iSizeBlock*(i+1));
                aryHit = stage.getObjectsUnderPoint(pHit);
                if(aryHit.length>0 && i!=mY){
                    hYMin = iSizeBlock*(i+1)+iSizeBlock;
                    break;
                }
            }
            for(i=(mY+1); i<iC; i++){
                pHit   = new Point(mc.x, iSizeBlock*(i+1));
                aryHit = stage.getObjectsUnderPoint(pHit);
                if(aryHit.length>0 && i!=mY){
                    hYMax = iSizeBlock*(i+1)-iSizeBlock;
                    break;
                }
            }

            for(i=mX; i>=0; i--){
                pHit   = new Point(iSizeBlock*(i+1), mc.y);
                aryHit = stage.getObjectsUnderPoint(pHit);
                if(aryHit.length>0 && i!=mX){
                    hXMin = iSizeBlock*(i+1)+iSizeBlock;
                    break;
                }
            }
            for(i=(mX+1); i<iC; i++){
                pHit   = new Point(iSizeBlock*(i+1), mc.y);
                aryHit = stage.getObjectsUnderPoint(pHit);
                if(aryHit.length>0 && i!=mX){
                    hXMax = iSizeBlock*(i+1)-iSizeBlock;
                    break;
                }
            }
        }
    }
}

    import flash.display.Sprite;
    import flash.geom.Point;
    import flash.geom.Matrix;

class DragBlock extends Sprite
{
    protected var pnt:Point;
    public function DragBlock(p:Point, color:int)
    {
        myGradient(-12,-12,34,34,color);
        
        pnt = p;
        super.x = pnt.x;
        super.y = pnt.y;
    }
    
    override public function set x(value:Number):void
    {
        super.x = pnt.x = value;
    }
    
    override public function set y(value:Number):void
    {
        super.y = pnt.y = value;
    }
    
    protected function myGradient(x:int, y:int, w:int, h:int, color:int):void
    {
        var matrix:Matrix = new Matrix();
        var color3:int = 0xffffff - color; //
        var color2:int = color+((((((color3&0xff0000) >> 16)/4*3)<<16) + ((((color3&0x00ff00) >> 8)/4*3)<<8) + (color3&0x0000ff)/4*3));

        matrix.createGradientBox(w, h, 45 * Math.PI / 180, x, y);
        graphics.beginGradientFill("linear", [color2, color], [1.0, 1.0], [0, 255], matrix);            
        graphics.drawRoundRect(x,y,w,h,5,5);
        graphics.endFill();

        matrix.createGradientBox(w, h, 45 * Math.PI / 180, x, y);
        graphics.beginGradientFill("linear", [color, color2], [1.0, 1.0], [0, 255], matrix);
        graphics.drawRoundRect(x+7, y+7, w-14, h-14,3,3);
        graphics.endFill();
    }
}