/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zmlI
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    [SWF(width = "512", height = "512", frameRate = "30", backgroundColor = "#000000")]
    /**
     * Binary Squares
     * @see "Alt.Fractals: A Visual Guide to Fractal Geometry and Design" P.186
     *       http://amzn.to/nb2zaC
     * @see  http://www.alt-fractals.com/
     * @author Aquioux(Yoshida, Akio)
     */
    public class Main extends Sprite {
        public function Main():void {
            var sw:int = stage.stageWidth;
            var sh:int = stage.stageHeight;
            var bmd:BitmapData = new BitmapData(sw, sh, false);
            addChild(new Bitmap(bmd));
            
            var color1:uint = 0xFFFFFF;
            var color2:uint = 0x000000;
            var yIdx:int = 0;
            var vIdx:int = 0;
            while (yIdx < sh) {
                var currentColor:int = color1;
                var blockEdge:int = Math.pow(2, vIdx);
                for (var xIdx:int = 0; xIdx < sw; xIdx++) {
                    if (xIdx % blockEdge == 0) currentColor = (currentColor - color2) * -1;
                    var add:int  = blockEdge;
                    var loop:int = add;
                    while (loop--) bmd.setPixel(xIdx, yIdx + loop, currentColor);
                }
                yIdx += add;
                vIdx++;
            }
        }
    }
}