/**
 * Copyright wrm ( http://wonderfl.net/user/wrm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zmh3
 */

package {
    import flash.events.MouseEvent;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.display.Sprite;
    import com.bit101.components.*;
    [SWF(frameRate = "60")]
    public class FlashTest extends Sprite {
        private var w:int = 465;
        private var h:int = 465;
        private var g:Graphics;
        private var ml:Boolean;
        private var nml:Boolean;
        private var pml:Boolean;
        
        private var ps:Vector.<P>;
        private var np:int;
        private var ns:Vector.<N>;
        private var nn:int;
        
        private var ta:TextArea;
        
        public function FlashTest() {
            init();
        }
        
        private function init():void {
            Style.embedFonts = false;/*
            ta = new TextArea(this, 0, 0, "");
            ta.alpha = 0.8;
            ta.editable = false;
            ta.width = 128;
            ta.height = 300;*/
            ps = new Vector.<P>(65536, true);
            np = 0;
            ns = new Vector.<N>(65536, true);
            nn = 0;
            
            for (var i:int = w - 100; i < w - 10; i += 6) {
                for (var j:int = 10; j < h - 10; j += 6) {
                    ps[np] = new P(i, j);
                    np++;
                }
            }
            
            g = graphics;
            addEventListener(Event.ENTER_FRAME, frame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:Event):void { nml = true; });
            stage.addEventListener(MouseEvent.MOUSE_UP, function(e:Event):void { nml = false; });
        }
        
        private var r:Number = 9;
        private var d:Number = 0.8;
        
        private function frame(e:Event):void {
            pml = ml;
            ml = nml;
            
            if (ml) {
                ps[np++] = new P(mouseX - 8, mouseY + 8);
                ps[np++] = new P(mouseX, mouseY + 8);
                ps[np++] = new P(mouseX + 8, mouseY + 8);
            }
            
            g.clear();
            g.beginFill(0x101010);
            g.drawRect(0, 0, w, h);
            g.endFill();
            
            for (var i:int = 0; i < np; i++) {
                var p:P = ps[i];
                p.nn = 0;
                p.p *= 0.995;
                p.d = 0;
            }
            
            nn = 0;
            
            for (i = 0; i < np; i++) {
                var p1:P = ps[i];
                for (var j:int = 0; j < i; j++) {
                    var p2:P = ps[j];
                    var dx:Number = p2.x - p1.x;
                    var dy:Number = p2.y - p1.y;
                    var l2:Number = dx * dx + dy * dy;
                    if (l2 > 0.001 && l2 < r * r) {
                        if (ns[nn] == null) ns[nn] = new N();
                        ns[nn].st(p1, p2, dx, dy, l2, r);
                        nn++;
                    }
                }
            }
            
            for (i = 0; i < nn; i++) {
                var n:N = ns[i];
                var p12:Number = (n.p1.p + n.p2.p) * n.w;
                n.p1.vx -= n.nx * p12;
                n.p1.vy -= n.ny * p12;
                n.p2.vx += n.nx * p12;
                n.p2.vy += n.ny * p12;
            }
            
            for (i = 0; i < np; i++) {
                p = ps[i];
                p.denom = 0;
                p.tmpx = 0;
                p.tmpy = 0;
                var npn:int = p.nn;
                for (j = 0; j < npn; j++) {
                    n = p.ns[j];
                    if (n.p1 == p) {
                        n.p2.tmpx = 0;
                        n.p2.tmpy = 0;
                    } else {
                        n.p1.tmpx = 0;
                        n.p1.tmpy = 0;
                    }
                    n.p1.tmpx -= n.nx * n.w;
                    n.p1.tmpy -= n.ny * n.w;
                    n.p2.tmpx += n.nx * n.w;
                    n.p2.tmpy += n.ny * n.w;
                }
                for (j = 0; j < npn; j++) {
                    n = p.ns[j];
                    p.denom += ((n.p2.tmpx - n.p1.tmpx) * n.nx + (n.p2.tmpy - n.p1.tmpy) * n.ny) * n.dw;
                }
            }
            
            for (var t:int = 0; t < 8; t++) {
                for (i = 0; i < np; i++) {
                    p = ps[i];
                    if (p.d < d) {
                        p.p = 0;
                        continue;
                    }
                    npn = p.nn;
                    var sum:Number = 0;
                    for (j = 0; j < npn; j++) {
                        n = p.ns[j];
                        sum += ((n.p2.vx - n.p1.vx) * n.nx + (n.p2.vy - n.p1.vy) * n.ny) * n.dw;
                    }
                    
                    var oldp:Number = p.p;
                    var newp:Number = oldp + (Math.max(p.d - d, 0) * 10 - sum) / p.denom;
                    if (newp < 0) newp = 0;
                    var difp:Number = newp - oldp;
                    for (j = 0; j < npn; j++) {
                        n = p.ns[j];
                        n.p1.vx -= n.nx * difp * n.w;
                        n.p1.vy -= n.ny * difp * n.w;
                        n.p2.vx += n.nx * difp * n.w;
                        n.p2.vy += n.ny * difp * n.w;
                    }/*
                    sum = 0;
                    for (j = 0; j < npn; j++) {
                        n = p.ns[j];
                        sum += ((n.p2.vx - n.p1.vx) * n.nx + (n.p2.vy - n.p1.vy) * n.ny) * n.dw;
                    }
                    ta.text += sum + "\n";*/
                    p.p = newp;
                }
                for (i = 0; i < nn; i++) {
                    n = ns[i];
                    if (n.w > 0.3334) {
                        var rvn:Number = (n.p2.vx - n.p1.vx) * n.nx + (n.p2.vy - n.p1.vy) * n.ny;
                        var f:Number = -rvn * 0.5;
                        if (f < 0) f = 0;
                        n.p1.vx -= f * n.nx;
                        n.p1.vy -= f * n.ny;
                        n.p2.vx += f * n.nx;
                        n.p2.vy += f * n.ny;
                    }
                }
                for (i = 0; i < np; i++) {
                    p = ps[i];
                    if (p.x < 10) {
                        if (p.vx < 0) p.vx *= 0.1;
                        p.vx += (10 - p.x) * 0.1;
                    }
                    if (p.x > w - 10) {
                        if (p.vx > 0) p.vx *= 0.1;
                        p.vx += (w - 10 - p.x) * 0.1;
                    }
                    if (p.y < 10) {
                        // p.vy *= 0.5;
                        p.vy += (10 - p.y) * 0.1;
                    }
                    if (p.x > 20 && p.x < w - 20 && p.y > h - 10) {
                        if (p.vy > 0) p.vy *= 0.1;
                        p.vy += (h - 10 - p.y) * 0.1;
                    }
                    
                    var r:Number;
                    var il:Number;
                    
                    if (p.x < 20 && p.y > h - 20) {
                        dx = 20 - p.x;
                        dy = h - 20 - p.y;
                        r = dx * dx + dy * dy;
                        if (r > 100) {
                            r = Math.sqrt(r);
                            il = 1 / r;
                            dx *= il;
                            dy *= il;
                            p.vx -= 0.9 * dx * (p.vx * dx + p.vy * dy);
                            p.vy -= 0.9 * dy * (p.vx * dx + p.vy * dy);
                            p.vx += dx * (r - 10) * 0.1;
                            p.vy += dy * (r - 10) * 0.1;
                        }
                    }
                    
                    if (p.x > w - 20 && p.y > h - 20) {
                        dx = w - 20 - p.x;
                        dy = h - 20 - p.y;
                        r = dx * dx + dy * dy;
                        if (r > 100) {
                            r = Math.sqrt(r);
                            il = 1 / r;
                            dx *= il;
                            dy *= il;
                            p.vx -= 0.9 * dx * (p.vx * dx + p.vy * dy);
                            p.vy -= 0.9 * dy * (p.vx * dx + p.vy * dy);
                            p.vx += dx * (r - 10) * 0.1;
                            p.vy += dy * (r - 10) * 0.1;
                        }
                    }
                }
            }
            
            /*
            for (i = 0; i < nn; i++) {
                n = ns[i];
                var vt:Number = n.vx * n.ny + n.vy * -n.nx;
                vt *= n.w * 0.00;
                n.p1.vx += n.ny * vt;
                n.p1.vy += -n.nx * vt;
                n.p2.vx -= n.ny * vt;
                n.p2.vy -= -n.nx * vt;
            }*/
            
            for (i = 0; i < np; i++) {
                p = ps[i];
                p.x += p.vx;
                p.y += p.vy;
                p.vy += 0.2;
                dx = p.x - mouseX;
                dy = p.y - mouseY;
                r = dx * dx + dy * dy;
                if (r > 0.1 && r < 2500) {
                    r = Math.sqrt(r);
                    il = 1 / r;
                    p.vx += dx * (50 - r) * 0.02;
                    p.vy += dy * (50 - r) * 0.02;
                }

                //g.beginFill(0x2020ff + (Math.min(Math.max(0, p.d - d) / d * 64, 0x80) << 16));
                g.beginFill(0x4040ff + (Math.min(p.p * 8, 0x80) << 16));
                //g.beginFill(0x2020ff);
                g.drawCircle(p.x | 0, p.y | 0, 2);
                g.endFill();
            }
            /*
            for (i = 0; i < nn; i++) {
                n = ns[i];
                g.lineStyle(2, 0xff2020, 1 - (1 - n.w) * (1 - n.w));
                g.moveTo(n.p1.x, n.p1.y);
                g.lineTo(n.p2.x, n.p2.y);
            }*/
            
        }
        
    }
    
}

class P {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var tmpx:Number;
    public var tmpy:Number;
    public var ns:Vector.<N>;
    public var nn:int;
    public var p:Number;
    public var denom:Number;
    public var d:Number;
    
    public function P(x:Number = 0, y:Number = 0) {
        ns = new Vector.<N>(1024, true);
        nn = 0;
        p = 0;
        d = 0;
        this.x = x;
        this.y = y;
        this.vx = 0;
        this.vy = 0;
    }
}

class N {
    public var p1:P;
    public var p2:P;
    public var dx:Number;
    public var dy:Number;
    public var nx:Number;
    public var ny:Number;
    public var vx:Number;
    public var vy:Number;
    public var w:Number;
    public var dw:Number;
    public var nv:Number;
    public function N() {
    }
    
    public function st(p1:P, p2:P, dx:Number, dy:Number, l2:Number, r:Number):void {
        this.p1 = p1;
        this.p2 = p2;
        this.dx = dx;
        this.dy = dy;
        vx = p2.vx - p1.vx;
        vy = p2.vy - p1.vy;
        l2 = Math.sqrt(l2);
        var il:Number = l2 == 0 ? 0 : 1 / l2;
        nx = dx * il;
        ny = dy * il;
        nv = nx * vx + ny * vy;
        w = 1 - l2 / r;
        dw = 2 * w;
        p1.d += w * w;
        p2.d += w * w;
        p1.ns[p1.nn++] = this;
        p2.ns[p2.nn++] = this;
    }


}



