/**
 * Copyright ruiko ( http://wonderfl.net/user/ruiko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zlo3
 */

// forked from ruiko's flash on 2010-7-31
//イベントハンドラが滅茶苦茶
package {
    import flash.trace.Trace;
    import flash.ui.Mouse;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.ui.Keyboard;
    [SWF(width="640", height="400", backgroundColor="0xffffff", frameRate="24")]

    public class Main extends Sprite {
        // 最下層にしいてある長方形
        private var screen:Sprite = new Sprite();
        //3画面の制御
        private var flag:int = 1;
        //右ボタン
        private var right:Sprite = new Sprite();
        //左ボタン
        private var left:Sprite = new Sprite();
        //入力フォーム付き上カバー
        private var cover:Cover= new Cover();
        
        public function Main():void {
            //画面（最下層）設定
            screen= new Sprite();
            screen.graphics.beginFill(0xE6E6FA,1);
            screen.graphics.drawRect(0,0,stage.stageWidth*3,stage.stageHeight);
            screen.graphics.endFill();
            screen.x = -stage.stageWidth;
            
            addChild(screen);
            //移動ボタン描画
            drawMoveButton();
            
            // クリックイベントを監視する
            stage.addEventListener("click", stageClick);
            right.addEventListener("click", moveRight);
            left.addEventListener("click", moveLeft);
        }
        
        //左に移動（スクリーンを右にずらす）
        private function moveLeft(event:MouseEvent):void {
            trace("migi");
            if(flag>0){
                screen.x+=stage.stageWidth;
                flag-=1;
            }
            //移動ボタン描画
            drawMoveButton();
        }
        
        //右に移動（スクリーンを左にずらす）
        private function moveRight(event:MouseEvent):void {
            trace("hidari");
            if(flag<2){
                screen.x -= stage.stageWidth; 
                flag+=1;
            }
            //移動ボタン描画
            drawMoveButton();
        }

        
        //イベントハンドラ
        private function stageClick(event:MouseEvent):void {
            //スクリーン上で起こった
            if (event.target == screen) {
             
            // 四角を作成
            var s:Memo = new Memo();
            
            screen.addChild(s.createMemo(Math.random() * 0x1000000));
            // 四角をクリックされた位置に移動
            s.x = event.stageX+(stage.stageWidth*flag);
            s.y = event.stageY;
            //ダブルクリック許可
            s.doubleClickEnabled = true;
           
            //マウスボタンダウン
            s.addEventListener(MouseEvent.MOUSE_DOWN, rectClickDown);
            //マウスボタンアップ
            s.addEventListener(MouseEvent.MOUSE_UP, rectClickUp);
            //ダブルクリック
            s.addEventListener(MouseEvent.DOUBLE_CLICK, rectDoubleClick(s));
            }
            else if (event.target == cover) {
                //カバー上で起こった
                //テキストフィールドの入力を取得
                var input:String = cover.tf.text;
                screen.removeChild(cover);
                //文字を書き換えてメモ描画
                screen.addChild(cover.clickedMemo.editText(input));
                //移動ボタン描画
                this.drawMoveButton();
            }
           
        }
        
        //ドラッグ開始
        private function rectClickDown(event:MouseEvent):void {
            event.target.startDrag( );
        }
        //ドラッグ終了
        private function rectClickUp(event:MouseEvent):void {
            event.target.stopDrag( );
        }
        //ダブルクリック
        private function rectDoubleClick(memo:Memo):Function {
            return function ( event:MouseEvent ):void{  
            
                trace(memo.inputText);
                right.graphics.clear();
                left.graphics.clear();
                cover = new Cover();
             
                //クリックしたメモと画面サイズと画面位置
                screen.addChild(cover.createCover(stage.stageWidth, stage.stageHeight, memo, flag));
            }
        }

        /**
         * 画面移動ボタン描画
         */
        public function drawMoveButton():void {

           
           if(flag==0 || flag==1){
                right.graphics.beginFill(0x000000);
                right.graphics.drawCircle(stage.stageWidth-25,stage.stageHeight-40,20);
                right.graphics.endFill();
                addChild(right);;
            }else{
                right.graphics.clear();
            }

            if(flag==1 || flag==2){
                left.graphics.beginFill(0x000000);
                left.graphics.drawCircle(25,stage.stageHeight-40,20);
                left.graphics.endFill();
                addChild(left); 
            }else{
                left.graphics.clear();
            }
        }
   }
}
    import flash.display.Sprite;
    import flash.text.*;
    class Memo extends Sprite {
        public var colorNum:uint;
        public var inputText:String = "テスト";
        public var tf:TextField = new TextField();

        public function createMemo(color:uint):Memo{
            var s:Sprite = new Sprite();
            colorNum = color;
            inputText = colorNum.toString();
            
            this.graphics.beginFill(colorNum);
            this.graphics.drawRect(this.x,this.y,120,50);
            this.graphics.endFill();
            
            tf.defaultTextFormat = new TextFormat("", 10, 0x0, true);
            tf.width = 120;
            tf.wordWrap = true;
            tf.text = inputText;
            tf.selectable = false;
            tf.mouseEnabled = false;
            tf.multiline = true;
            tf.autoSize = TextFieldAutoSize.LEFT;
            this.addChild(tf);
            
            return(this);
        }
        
        //テキストのみ書き換え
        public function editText(newText:String):Memo {
            tf.text = newText;
            tf.autoSize = TextFieldAutoSize.LEFT;
            this.addChild(tf);
            
            return(this);
        }

    }
    
    import flash.display.Sprite;
    import flash.text.*;
    class Cover extends Sprite {
        public var colorNum:uint;
        public var inputText:String = "テスト";
        public var tf:TextField = new TextField();
        public var clickedMemo:Memo = new Memo();

        public function createCover(width:int, height:int, memo:Memo, flag:int):Cover {
            
            clickedMemo = memo;
            this.graphics.beginFill(0x555555,0.3);
            this.graphics.drawRect(0,0,width*3,height);
            this.graphics.endFill();   
              //テキストボックス
            tf = new TextField();
            tf.border = true;
            tf.background = true;
            tf.wordWrap = true;
            tf.type = "input";
            tf.text = memo.tf.text;
            tf.x = width * flag + 100;
            tf.y = 100;
            this.addChild(tf);
            trace(width);
     
            return(this);
            
        }

    }
