/**
 * Copyright ikuko ( http://wonderfl.net/user/ikuko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zlTt
 */

package  
{
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.ui.ContextMenu;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    /**
     * ...
     * @author ikko
     * .sample
     */
    [SWF(width = "465", height = "465", frameRate = "60")]
    public class sample extends Sprite 
    {
        private var _viewport:Viewport3D;
        private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _renderer:BasicRenderEngine;
        private var _container:DisplayObject3D;
        private var _texture:BitmapData;
        
        private const cameraR:Number    = 1000;
        private var _degree:Number    = 0;
        
        public function sample() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addEventListener(Event.REMOVED_FROM_STAGE, LiberatingListener);
            // entry point
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align    = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            
            var RightClickMenu:ContextMenu = new ContextMenu ();
            RightClickMenu.hideBuiltInItems();
            stage.showDefaultContextMenu = false;
            
            graphics.clear();
            
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
            
            prepPV3D();
        }
        
        private function onResize(e:Event = null):void 
        {
            //removeEventListener(Event.RESIZE, onResize);
            graphics.clear();
            graphics.beginFill(0x0, 1);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
        }
        
        private function prepPV3D():void 
        {
            _viewport    = new Viewport3D(640, 480, true, false, true, true);
            _scene        = new Scene3D();
            _camera        = new Camera3D(60, 10, 3000, true);
            _renderer    = new BasicRenderEngine();
            
            _container = new DisplayObject3D();
            _scene.addChild(_container);
            
            _camera.target = DisplayObject3D.ZERO;
            
            addChild(_viewport);
            addEventListener(Event.ENTER_FRAME, renderingHD);
            
            var _wire:WireframeMaterial = new WireframeMaterial(0x222222, 1);
            var _sphere:Sphere = new Sphere(_wire, 600, 12, 12);
            _container.addChild(_sphere);
            
            loadIMG();
        }
        
        private function loadIMG():void 
        {
            var _myPath = "http://a3.twimg.com/profile_images/1450207873/_____bigger.jpg";
            var _url : URLRequest    = new URLRequest(_myPath);
            var _loader : Loader    = new Loader();
            var _context:LoaderContext = new LoaderContext(true);
            
            _loader.contentLoaderInfo.addEventListener (IOErrorEvent.IO_ERROR, reLoad);
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompHD);
            _loader.load(_url, _context);

            function reLoad(e:IOErrorEvent)    {
                trace ("ERROR_IMAGE_NOTFOUND");
                _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, loadCompHD);
                _loader.contentLoaderInfo.removeEventListener (IOErrorEvent.IO_ERROR, reLoad);
            }

            function loadCompHD(e:Event)    {
                _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, loadCompHD);
                _loader.contentLoaderInfo.removeEventListener (IOErrorEvent.IO_ERROR, reLoad);
                _texture = new BitmapData(_loader.content.width, _loader.content.height);
                _texture.draw(_loader.content);
                
                addPlanes();
            }
        }
        
        private function addPlanes():void 
        {
            var i:uint;
            var _max:uint = 150;
            for (i = 0; i < _max; i++ )    {
                _container.addChild(new kned(_texture));
            }
        }
        
        private function renderingHD(e:Event):void 
        {
            _renderer.renderScene(_scene, _camera, _viewport);
            
            _degree ++;
            
            _container.rotationX ++;
            _container.rotationY ++;
            
            //_camera.x = cameraR * Math.cos(_degree * Math.PI / 180);
            //_camera.z = cameraR * Math.sin(_degree * Math.PI / 180);
        }
        
        protected function LiberatingListener(evt:Event)    {
            removeEventListener(Event.REMOVED_FROM_STAGE, LiberatingListener);
            removeEventListener(Event.ENTER_FRAME, renderingHD);
        }
    }
}

import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import org.papervision3d.materials.BitmapMaterial;
import org.papervision3d.objects.DisplayObject3D;
import org.papervision3d.objects.primitives.Plane;

class kned extends Plane    {
    private var _spr:Sprite = new Sprite();
    private var _theta:Number = 0;
    private var _phi:Number;
    private var _r:Number = 600 + Math.random()*100;
    private var _rad:Number = Math.PI / 180;
    private var _rand:Number = Math.round(Math.random());
    private var _radTheta:Number;
    private var _sw:Boolean = false;
    
    public function kned($texture:BitmapData)    {
        var _material:BitmapMaterial = new BitmapMaterial($texture, true);
        _material.smooth = true;
        _material.doubleSided = true;
        super(_material, 50, 50, 1, 1);
        
        _theta    = Math.random();
        _phi    = -180 + Math.random() * 360;
        _radTheta    = 2 * Math.acos(Math.sqrt(1 - _theta));
        
        var _rand:Number = Math.round(Math.random());
        if (_rand == 0)    _sw = true;
        else            _sw = false;
        
        
        var _radPI        = _phi * _rad;
        
        setPosition();
        lookAt(DisplayObject3D.ZERO);
        
        _spr.addEventListener(Event.ENTER_FRAME, setPosition);
    }
    
    private function setPosition(e:Event = null):void 
    {
        //if (_sw)    _phi += .1;
        //else        _phi -= .1;
        
        var _radPI        = _phi * _rad;
        
        x = _r * Math.sin(_radTheta) * Math.cos(_radPI);
        y = _r * Math.sin(_radTheta) * Math.sin(_radPI);
        z = _r * Math.cos(_radTheta);
    }
}