/**
 * Copyright l.dijkman ( http://wonderfl.net/user/l.dijkman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zlKC
 */

// forked from Test_Dept's Legacy Display
package {

    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * LegacyDisplay
     * @author Test Dept
     */
    [SWF(backgroundColor="#cccccc", width="465", height="465", frameRate="3")]
    public class LegacyDisplay extends Sprite {

        public function LegacyDisplay() {

            var color : uint = 0x0000ff;
            var hiColor : uint = color;
            var loColor : uint = getDarkColor(hiColor, .2);

            var patterns1 : Array = [
                "a", "b", "c", "d", "e", "f", "a", "b", "c",
                ".",
                "abcdefg.", ""
            ];
            var index1 : int = 0;
            
            var patterns2 : Array = [
                "abcdef", "bc",     "abdeg", "abcdg",   "bcfg",
                "acdfg",  "acdefg", "abc",   "abcdefg", "abcdfg"
            ];
            var index2 : int = 0;

            addEventListener(Event.ENTER_FRAME, function(event : Event) : void {

                var g : Graphics = graphics;
                g.clear();

                var pattern1 : String = patterns1[index1];
                index1 = (index1 + 1) % patterns1.length;
                var pattern2 : String = patterns2[index2];
                index2 = (index2 + 1) % patterns2.length;

                LEDUtil.draw7Segments(g, pattern1, 10, 10, 
                    200, 0, hiColor, loColor, 0x000000); 
                LEDUtil.draw7Segments(g, pattern2, 215, 10,
                    200, 0, hiColor, loColor, 0x000000); 
            } );
        }

        private static function getDarkColor(color : uint, scale : Number) : uint {
            var r : uint = (color >>> 16) & 0xff;
            var g : uint = (color >>> 8) & 0xff;
            var b : uint = color & 0xff;
            r = (r * scale) & 0xff;
            g = (g * scale) & 0xff;
            b = (b * scale) & 0xff;
            return (r << 16) | (g << 8) | b;
        }
      }
}

import flash.display.Graphics;

/*

[Segments]

     a
    f b
     g
    e c
     d
       .

[Digit Patterns]

0: abcdef
1: bc
2: abdeg
3: abcdg
4: bcfg
5: acdfg
6: acdefg
7: abc
8: abcdefg
9: abcdfg
-: g

*/
class LEDUtil {

    public static function draw7Segments(
        g : Graphics,
        pattern : String,
        x : Number,
        y : Number,
        width : Number,
        height : Number,
        hiColor : uint,
        loColor : uint,
        bgColor : uint
    ) : void {

        // auto size
        if (width <= 0) {
            width = height * 7 / 10;
        } else if (height <= 0) {
            height = width * 10 / 7;
        }

        g.beginFill(bgColor);
        g.drawRect(x, y, width, height);
        g.endFill();

        var scale : Number = (width / height > _SEG_WIDTH / _SEG_HEIGHT)?
            height / _SEG_HEIGHT : width / _SEG_WIDTH;

        var cx : Number = x + (width - _SEG_WIDTH * scale) / 2;
        var cy : Number = y + (height - _SEG_HEIGHT * scale) / 2;
        
        var on : Boolean;
        
        for (var i : int = 0; i < _ALL_SEGMENTS.length; i++) {
            var c : String = _ALL_SEGMENTS.charAt(i);
            on = (pattern != null && pattern.indexOf(c) != -1);
            drawSegment(g, c, cx, cy, scale, on? hiColor : loColor);
        }

        on = (pattern != null && pattern.indexOf(".") != -1);
        drawPoint(g, cx, cy, scale, on? hiColor : loColor);
    }

    private static function drawSegment(
            g : Graphics,
            segment : String,
            x : Number,
            y : Number,
            scale : Number,
            color : uint
    ) : void {

        var data : Array = _segmentData[segment];

        g.beginFill(color);

        var length : int = data.length / 2;

        for (var i : int = 0; i < length; i++) {

            var dx : Number = data[i * 2] * scale + x;
            var dy : Number = data[i * 2 + 1] * scale + y;

            if (i == 0) {
                g.moveTo(dx, dy);
            } else {
                g.lineTo(dx, dy);
            }
        }

        g.endFill();
    }
    
    private static function drawPoint(
            g : Graphics, 
            x : Number,
            y : Number,
            scale : Number,
            color : uint
    ) : void {
        g.beginFill(color);
        g.drawCircle(542 * scale + x, 840 * scale + y, 46 * scale);
        g.endFill();
    }

    private static const _SEG_WIDTH : Number = 636;

    private static const _SEG_HEIGHT : Number = 1000;

    private static const _ALL_SEGMENTS : String = "abcdefg";
    
    private static const _segmentData : Object = {
        'a' : [575, 138, 494, 211, 249, 211, 194, 137, 213, 120, 559, 120],
        'b' : [595, 160, 544, 452, 493, 500, 459, 456, 500, 220, 582, 146],
        'c' : [525, 560, 476, 842, 465, 852, 401, 792, 441, 562, 491, 516],
        'd' : [457, 860, 421, 892, 94, 892, 69, 864, 144, 801, 394, 801],
        'e' : [181, 560, 141, 789, 61, 856, 48, 841, 96, 566, 148, 516],
        'f' : [241, 218, 200, 453, 150, 500, 115, 454, 166, 162, 185, 145],
        'g' : [485, 507, 433, 555, 190, 555, 156, 509, 204, 464, 451, 464]
    };      
}    
