/**
 * Copyright ohyachi ( http://wonderfl.net/user/ohyachi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zjxQ
 */

// forked from ohyachi's forked from: forked from: Papervision3d入門 2.5.4
// forked from ohyachi's forked from: Papervision3d入門 2.5.4
// forked from yawakisin's Papervision3d入門 2.5.4
// forked from yawakisin's Papervision3d入門 2.5.3
/*
    Flash3D コンテンツ制作のためのPapervision3Dのサンプルテスト    
    
    code 2.5.4
*/

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import org.papervision3d.view.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    
    public class Sample3 extends BasicView {
        private var rot:Number = 0;
        
        // コンストラクタ
        public function Sample3() 
        {
            var urlReq:URLRequest = new URLRequest(new String("http://www.yujiohyachi.com/images/tsuki4"));
            var loader:Loader = new Loader();
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, init);
            loader.load(urlReq, new LoaderContext(true));        
        }
        
        private function init(e:Event):void 
        {
            var loader:Loader = Loader(e.target.loader);
            // ロードしたデータからbitmaDataを作成する。
            var bmdata:BitmapData = new BitmapData(loader.width, loader.height);
            bmdata.draw(loader);

            // マテリアルを作成
            var material:BitmapMaterial = new BitmapMaterial(bmdata);
            
            // 球体(Sphere)を作成
            // 引数はマテリアル、球面の半径、横のポリゴン分割数、縦のポリゴン分割数
            var sphere:Sphere = new Sphere(material, 600, 50, 50);
            
            // 3D空間に球体を追加
            scene.addChild(sphere);
            
            // レンダリング
            startRendering();

            // エンターフレームのイベントを登録
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        // アニメーション
        private function loop(e:Event):void 
        {
            // マウスのX座標がステージの幅の何％の位置にあるか調べてそれを360度で乗算する
            var targetRot:Number = (mouseX / stage.stageWidth) * 360;
            
            // イージングの公式を用いて滑らかにする
            // 値 += (目標値 - 現在の値) * 減速値
            rot += (targetRot - rot) * 0.02;
            
            // 角度に応じてカメラの位置を設定
            var deg:Number = rot * Math.PI / 180;
            camera.x = 1000 * Math.sin(deg);
            camera.z = 1000 * Math.cos(deg);
        }
    }
}
