/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zjSt
 */

// forked from fancyblock's Bounding Circle Computation
package 
{
    import flash.utils.Proxy;
    import flash.geom.Rectangle;
    import flash.display.AVM1Movie;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite 
    {
        public const DOT_CNT:int = 15;
        public const DOT_SIZE:int = 6;
        
        protected var m_dotList:Array = new Array();
        
        public function FlashTest() 
        {
            // write as3 code here..
            for( var i:int = 0; i < DOT_CNT; i++ )
            {
                var dt:dot = new dot( this, DOT_SIZE, 0x0005e0 );
                dt.x = Math.random() * 265.0 + 100;
                dt.y = Math.random() * 265.0 + 100;
                
                dt.addEventListener( MouseEvent.MOUSE_DOWN, onStartDrag );
                dt.addEventListener( MouseEvent.MOUSE_UP, onStopDrag );
                
                m_dotList.push( dt );
            }

            calculateBoundCircle();
        }
        
        protected function onStartDrag( evt:MouseEvent ):void
        {
            evt.currentTarget.startDrag();
        }
        
        protected function onStopDrag( evt:MouseEvent ):void
        {
            evt.currentTarget.stopDrag();
            
            calculateBoundCircle();
        }

        // this algorithm is not correct, need to redo
        protected function calculateBoundCircle():void
        {
            var center:Point = new Point();
            var radius:Number = 0;
            
            var rect:Rectangle = new Rectangle( m_dotList[0].x, m_dotList[0].y, 0, 0 );
            
            var i:int;
            var dt:dot;
            for( i = 0; i < m_dotList.length; i++ )
            {
                dt = m_dotList[i] as dot;
                
                if( dt.x < rect.left )
                {
                    rect.left = dt.x;
                }
                if( dt.x + DOT_SIZE > rect.right )
                {
                    rect.right = dt.x + DOT_SIZE;
                }
                if( dt.y < rect.top )
                {
                    rect.top = dt.y;
                }
                if( dt.y + DOT_SIZE > rect.bottom )
                {
                    rect.bottom = dt.y + DOT_SIZE;
                }
            }

            center.x = rect.x + rect.width / 2;
            center.y = rect.y + rect.height / 2;
            var pt:Point = new Point();
            for( i = 0; i < m_dotList.length; i++ )
            {
                dt = m_dotList[i] as dot;
                
                pt.x = dt.x;
                pt.y = dt.y;
                
                var distance:Number = pt.subtract( center ).length;
                
                if( distance > radius )
                {
                    radius = distance;
                }

            }
            
            this.graphics.clear();
            this.graphics.lineStyle( 2, 0x00af37 );
            this.graphics.drawCircle( center.x, center.y, radius );
            
            this.graphics.lineStyle( 1, 0x00af37 );
            this.graphics.beginFill(0x00af37);
            this.graphics.drawCircle( center.x, center.y, 3);            
            this.graphics.endFill();
            
            //this.graphics.drawRect( rect.x, rect.y, rect.width, rect.height );
        }

    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;

class dot extends Sprite
{
    public function dot( host:Sprite, size:int, color:uint )
    {
        host.addChild( this );
        
        var data:BitmapData = new BitmapData( size, size, true, 0xfff000 );
        var bmp:Bitmap = new Bitmap( data );
        
        this.addChild( bmp );
        
        var spr:Sprite = new Sprite();
        spr.graphics.beginFill( color );
        spr.graphics.drawEllipse( 0, 0, size, size );
        spr.graphics.endFill();
        data.draw( spr );
    }

}
