/**
 * Copyright George.Profenza ( http://wonderfl.net/user/George.Profenza )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zils
 */

// forked from George.Profenza's ChromaLapse
package {
    import flash.geom.*;
    import flash.display.*;
    import flash.media.*;
    import flash.utils.*;
    import flash.events.*;
    //flash port of Chris Shen's Chroma Lapse 
    //ht
    public class FlashChromaLapse extends Sprite {
        
        private var hs:int = 24;//history size
        private var current:BitmapData;//current frame
        private var history:Vector.<BitmapData> = new Vector.<BitmapData>(hs,true);
        private var video:Video;//video object to access camera data
        private var rgb:Bitmap;//display composited pixels on screen
        private var rect:Rectangle;//region of interest
        private var zero:Point = new Point();//start copy/pasting from this position
        
         public function FlashChromaLapse() {
            init();
        }
        private function init():void{
            var camera:Camera = Camera.getCamera();
            if (camera != null) {
                video = new Video(stage.stageWidth,stage.stageWidth*3/4);
                video.attachCamera(camera);
                
                rect = new Rectangle(0,0,video.width,video.height);
                for(var i:int = 0 ; i < hs; i++) history[i] = new BitmapData(rect.width,rect.height,false,0);//allocate history pixels
                current = new BitmapData(rect.width,rect.height,false,0);
                rgb = addChild(new Bitmap(current)) as Bitmap;
                addEventListener(Event.ENTER_FRAME,update);
            }else {
               trace("no camera");
          }        
        }
        protected function update(e:Event):void {
            //history update
            for(var i:int = hs-1; i > 0; i--) history[i].copyPixels(history[i-1],rect,zero);
            history[0].draw(video);
            current.lock();
            current.copyChannel(history[0],rect,zero,BitmapDataChannel.RED, BitmapDataChannel.RED);
            current.copyChannel(history[11],rect,zero, BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
            current.copyChannel(history[23],rect,zero, BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
            current.unlock();
        }
    }
}