/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zidn
 */

package {
  import flash.display.*;
  import flash.events.Event;
  import flash.geom.*;
  import flash.net.URLRequest;
  import flash.system.LoaderContext;

  [SWF(frameRate="10")]
  public class ch36ex1 extends Sprite {
    protected const SIZE:Rectangle = new Rectangle(0, 0, 48, 48);
    protected var TOTALFRAMES:int;
    protected var bmp:BitmapData;
    protected var filmstrip:Loader;
    protected var frame:int = 0;
    public function ch36ex1() {
      filmstrip = new Loader();
      //Animation by Derek Yu - www.derekyu.com - used with permission
      filmstrip.load(
        new URLRequest("http://actionscriptbible.com/files/monkey.png"),
        new LoaderContext(true));
      filmstrip.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoad);
      addChild(filmstrip);
      
      bmp = new BitmapData(SIZE.width, SIZE.height);
      var bitmap:Bitmap = new Bitmap(bmp);
      addChild(bitmap);
      bitmap.y = SIZE.height + 10;
    }
    protected function onLoad(event:Event):void {
      TOTALFRAMES = filmstrip.width / SIZE.width;
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function onEnterFrame(event:Event):void {
      frame = ++frame % TOTALFRAMES;
      
      //highlight the area we're drawing
      graphics.clear();
      graphics.lineStyle(0, 0xff0000);
      graphics.drawRect(frame*SIZE.width, 0, SIZE.width, SIZE.height);
      
      //clear the bitmap
      bmp.fillRect(bmp.rect, 0);
      //shift the filmstrip to the left to put the right frame in place
      var shiftTransform:Matrix = new Matrix();
      shiftTransform.translate(-frame * SIZE.width, 0);
      //use SIZE to clip the shifted graphic to the correct position and size
      bmp.draw(filmstrip, shiftTransform, null, null, SIZE);
    }
  }
}