/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ziTC
 */

// forked from 0xABCDEF's drawBridge
package
{
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    import flash.display.GraphicsPath;
    import flash.display.GraphicsPathWinding;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    [ SWF( frameRate = "60" ) ]
    public class DrawBridge extends Sprite
    {
        private const MAX_RADIUS:Number = 100;
        private var startRadius:Number;
        private var endRadius:Number;
        private var startSlider:HSlider;
        private var endSlider:HSlider;
        private var startControl:PointControl;
        private var controlControl:PointControl;
        private var endControl:PointControl;
        public function DrawBridge()
        {
            startRadius = 10;
            endRadius = 20;
            new Label( this, 20, 10, "start" );
            new Label( this, 20, 30, "end" );
            startSlider = new HSlider( this, 50, 15, function():void {
                startRadius = startSlider.value * MAX_RADIUS / 100;
                startControl.radius = startRadius;
                startControl.draw();
            } );
            startSlider.value = startRadius / MAX_RADIUS * 100;
            endSlider = new HSlider( this, 50, 35, function():void {
                endRadius = endSlider.value * MAX_RADIUS / 100;
                endControl.radius = endRadius;
                endControl.draw();
            } );
            endSlider.value = endRadius / MAX_RADIUS * 100;
            addEventListener( Event.ENTER_FRAME, ENTER_FRAME );
            startControl = addChild( new PointControl( 0xFF0000, startRadius ) ) as PointControl;
            startControl.x = 100;
            startControl.y = 200;
            controlControl = addChild( new PointControl( 0x00FF00, 10 ) ) as PointControl;
            controlControl.x = 200;
            controlControl.y = 300;
            endControl = addChild( new PointControl( 0x0000FF, endRadius ) ) as PointControl;
            endControl.x = 300;
            endControl.y = 200;
        }
        private function ENTER_FRAME( e:Event ):void
        {
            startControl.updatePoint();
            endControl.updatePoint();
            controlControl.updatePoint();
            graphics.clear();
            graphics.beginFill( 0 );
            drawQuadraticBridge( startControl.point, controlControl.point, endControl.point, startRadius, endRadius );
            graphics.endFill();
        }
        private function drawQuadraticBridge(
            start:Point,
            control:Point,
            end:Point,
            startRadius:Number,
            endRadius:Number ):void
        {
            var quarter:Number = Math.PI * 0.5;
            var half:Number = quarter + quarter;
            var startAngle:Number = Math.atan2( control.y - start.y, control.x - start.x );
            var endAngle:Number = Math.atan2( end.y - control.y, end.x - control.x );
            var controlAngle:Number = ( endAngle+startAngle ) * 0.5;
            if( startAngle < 0 )
                if( endAngle > 0 )
                    if( ( half + startAngle ) < endAngle )
                        controlAngle += half;
            if( endAngle < 0 )
                if( startAngle > 0 )
                    if( ( half + endAngle ) < startAngle )
                        controlAngle += half;
            var controlRadius:Number = ( startRadius + endRadius ) * 0.5;
            var p0:Point = Point.polar( startRadius, startAngle + quarter ).add( start );
            var p1:Point = Point.polar( startRadius, startAngle - quarter ).add( start );
            var p2:Point = Point.polar( controlRadius, controlAngle - quarter ).add( control );
            var p3:Point = Point.polar( endRadius, endAngle - quarter ).add( end );
            var p4:Point = Point.polar( endRadius, endAngle + quarter ).add( end );
            var p5:Point = Point.polar( controlRadius, controlAngle + quarter ).add( control );
            graphics.moveTo( p0.x, p0.y );
            graphics.lineTo( p1.x, p1.y );
            graphics.curveTo( p2.x, p2.y, p3.x, p3.y );
            graphics.lineTo( p4.x, p4.y );
            graphics.curveTo( p5.x, p5.y, p0.x, p0.y );
        }
    }
}
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.geom.Point;
internal class PointControl extends Sprite
{
    public var point:Point;
    public var color:uint;
    public var radius:Number;
    public function PointControl( color:uint, radius:Number )
    {
        this.point = new Point;
        this.color = color;
        this.radius = radius;
        draw();
        addEventListener( MouseEvent.MOUSE_DOWN, MOUSE_DOWN );
    }
    public function draw():void
    {
        graphics.clear();
        graphics.beginFill( color );
        graphics.drawCircle( 0, 0, radius );
        graphics.endFill();
    }
    private function MOUSE_DOWN( e:MouseEvent ):void
    {
        startDrag();
        stage.addEventListener( MouseEvent.MOUSE_UP, MOUSE_UP );
    }
    private function MOUSE_UP( e:MouseEvent ):void
    {
        stopDrag();
        stage.removeEventListener( MouseEvent.MOUSE_UP, MOUSE_UP );
    }
    public function updatePoint():void
    {
        point.x = x;
        point.y = y;
    }
    public function updateControl():void
    {
        x = point.x;
        y = point.y;
    }
}