/**
 * Copyright yasyasyas ( http://wonderfl.net/user/yasyasyas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ziFa
 */

package {
	import flash.display.SpreadMethod;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Point;
	import flash.text.engine.EastAsianJustifier;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	public class Main2 extends Sprite {
		
		private var sp1:Sprite;
		private var sp2:Sprite;
		private var sp3:Sprite;
		private var cx:Number = 200; //時計の中心点のx座標
		private var cy:Number = 200; //時計の中心点のy座標
		private var numList:Array = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"];
		
		public function Main2() {
			//trace("hoge");
			
			for (var i:int = 0; i < numList.length; i++) {
				var nanji:TextField = new TextField();
				var tFormat:TextFormat = nanji.getTextFormat();
				tFormat.size = 30;
				tFormat.bold = true;
				nanji.defaultTextFormat = tFormat;
				nanji.autoSize = "center";
				nanji.text = numList[i];
				//円周上の時間の数字の座標をPointオブジェクトで表す
				var pt:Point = Point.polar(110, -(2 * Math.PI / 12) * 2 + (2 * Math.PI / 12) * i); //"1"時の角度をスタート位置にするように調整
				pt.offset(cx, cy);  //Pointオブジェクトの基準点を時計の中心点に移動する
				nanji.x = pt.x - nanji.width / 2; //TextFieldオブジェクトの中心をPoint座標に合わせるための調整
				nanji.y = pt.y - nanji.height / 2;  //TextFieldオブジェクトの中心をPoint座標に合わせるための調整
				addChild(nanji);
			}
			
			
			
			var tf:TextField = new TextField();
			tf.text = "SOIKO";
			tf.autoSize = "center";
			tf.x = 200 - tf.width * 0.5;
			//tf.border = true;
			tf.y = 220;
			addChild(tf);
			
			//秒針
			sp1 = new Sprite();
			sp1.graphics.beginFill(0xff0000);
			//sp1.graphics.drawCircle(50, 0, 20);
			sp1.graphics.drawRect(-30, -1, 130, 2);
			sp1.graphics.endFill();
			sp1.x = 200;
			sp1.y = 200;
			//addChild(sp1);
			
			
			//分針
			sp2 = new Sprite();
			sp2.graphics.beginFill(0x00FF00);
			//sp2.graphics.drawCircle(50, 0, 20);
			sp2.graphics.drawRect(0, -5, 100, 10);
			sp2.graphics.endFill();
			sp2.x = 200;
			sp2.y = 200;
			//addChild(sp2);
			
			//時針
			sp3 = new Sprite();
			sp3.graphics.beginFill(0x0000FF);
			//sp3.graphics.drawCircle(50, 0, 20);
			sp3.graphics.drawRect(0, -8, 80, 16);
			sp3.graphics.endFill();
			sp3.x = 200;
			sp3.y = 200;

			addChild(sp3);
			addChild(sp2);
			addChild(sp1);
			
			//中心点
			var cyu:Sprite = new Sprite();
			cyu.graphics.beginFill(0x000000);
			cyu.graphics.drawCircle(0, 0, 10);
			cyu.graphics.endFill();
			cyu.x = cx;
			cyu.y = cy;
			addChild(cyu);
			
			this.addEventListener(Event.ENTER_FRAME, onEnter);
			
		}
		
		private function onEnter(event:Event):void {
			//trace("Boo");
			var date:Date = new Date();
			//trace(date.hours, date.minutes, date.seconds);
			
			sp1.rotation = -90 + date.seconds * 6;
			sp2.rotation = -90 + date.minutes * 6;
			sp3.rotation = -90 + date.hours * 30 + date.minutes*0.5;
			
		}

		
	}
}