/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zhdp
 */

//三葉結び目
//http://mathworld.wolfram.com/TrefoilKnot.html


package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Vector3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.shadematerials.PhongMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.view.BasicView;
	
	[SWF(width="465", height="465", backgroundColor="0x222222", frameRate="20")]
	public class ThreeFoilKnot extends BasicView
	{
		private const BLUR:BlurFilter = new BlurFilter(4, 4, 2);	
		private var counter:Number = 0;
		
		private var a:Number = 1;
		private var b:Number = 0.3;
		private var c:Number = 0.5;
		private var d:Number = 0.2;
		
		private const Ustep:Number = 0.15;
		private const Vstep:Number = 0.4;
		private var light:PointLight3D;
		private var shade:FlatShadeMaterial;// PhongMaterial;
		private var holder:DisplayObject3D;
		private var plArray:Array = new Array();

		public function ThreeFoilKnot()
		{
Wonderfl.capture_delay(8);
			super(465 / 4, 465 / 4, true, true, "Target");
			light = new PointLight3D();
			shade = new FlatShadeMaterial(light, 0xffeeff, 0x554455, 1);////PhongMaterial(light, 0xffeeff, 0x554455, 1);
			//shade.doubleSided = true;
			
			holder = new DisplayObject3D();
			//viewport.filters = [BLUR];
			scene.addChild(holder);
			holder.z = -330;
			holder.y = -210;
			camera.target = holder
			startRendering();
			addEventListener(Event.ENTER_FRAME, onFrame);
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		
		private function onClick(e:MouseEvent):void 
		{
			counter = 0;
			for (var i:int = 0; i < plArray.length; i++) 
			{
				holder.removeChild(plArray[i]);
			}
			plArray.length = 0;
			a = 0.5 + Math.random() * 1;
			b = 0.2 + Math.random() * 0.4;
			c = 0.3 + Math.random() * 0.6;;
			d = 0.05 + Math.random() * 0.4;
			holder.rotationX = Math.random() * 180;
		}
		
		private function onFrame(e:Event):void
		{
			if(counter < Math.PI*4){
                counter += Ustep;
				for (var j:Number = 0; j < Math.PI * 2; j += Vstep) 
				{
					plot(counter, j);
				}
			}
			holder.rotationY += 1.5;
		}
		private function plot(uu:Number, vv:Number):void
		{
			var v1:Number3D = calc(uu, vv);
			var v2:Number3D = calc(uu + Ustep, vv);
			var v3:Number3D = calc(uu , vv+Vstep);
			var v4:Number3D = calc(uu + Ustep, vv+Vstep);
			
			var pl:MyPlane = new MyPlane(shade, v1, v2, v3);
			var pl2:MyPlane = new MyPlane(shade, v2, v4, v3);
			
			plArray.push(pl);
			plArray.push(pl2);
			holder.addChild(pl);
			holder.addChild(pl2);
			pl.x = (v1.x + v2.x + v3.x) / 3;
			pl2.x = (v3.x + v4.x + v2.x) / 3;
			pl.y = (v1.y + v2.y + v3.y) / 3;
			pl2.y = (v3.y + v4.y + v2.y) / 3;
			pl.z = (v1.z + v2.z + v3.z) / 3;
			pl2.z = (v3.z + v4.z + v2.z) / 3;
		}
		private function calc(uu:Number, vv:Number):Number3D
		{
			var r:Number = a + b * Math.cos(1.5 * uu);
			var xx:Number = r * Math.cos(uu);
			var yy:Number = r * Math.sin(uu);
			var zz:Number = c * Math.sin(1.5 * uu);
			var dx:Number = 1.5 * b * Math.sin(1.5 * uu) * Math.cos(uu) - (a + b * Math.cos(1.5 * uu)) * Math.sin(uu);
			var dy:Number = 1.5 * b * Math.sin(1.5 * uu) * Math.sin(uu) + (a + b * Math.cos(1.5 * uu)) * Math.cos(uu);
			var dz:Number = 1.5 * c * Math.cos(1.5 * uu);
			var qn:Vector3D = new Vector3D(dx, dy, dz);
			qn.normalize();
			var qvn:Vector3D = new Vector3D(qn.y, -qn.x, 0);
			qvn.normalize();
			var ww:Vector3D = qn.crossProduct(qvn);
			var sc:Number = 200;
			var x1:Number = xx + d * (qvn.x * Math.cos(vv) + ww.x * Math.sin(vv));
			var y1:Number = yy + d * (qvn.y * Math.cos(vv) + ww.y * Math.sin(vv));
			var z1:Number = zz + d * (qvn.z * Math.cos(vv) + ww.z * Math.sin(vv));
			x1 *= sc; y1 *= sc; z1 *= sc;
			var nx1:Number = qvn.x * Math.cos(vv) + ww.x * Math.sin(vv);
			var ny1:Number = qvn.y * Math.cos(vv) + ww.y * Math.sin(vv);
			var nz1:Number = ww.z * Math.sin(vv);
			return new Number3D(x1, y1, z1);
		}
	}
}
import org.papervision3d.core.geom.TriangleMesh3D;
import org.papervision3d.core.math.NumberUV;
import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.core.math.Number3D;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.geom.renderables.Triangle3D;
class MyPlane extends TriangleMesh3D
{
	public function MyPlane(m:MaterialObject3D, v1:Number3D, v2:Number3D, v3:Number3D)
	{
		super( m, new Array(), new Array(), null );
		
		var vertices:Array = this.geometry.vertices;
		var faces:Array = this.geometry.faces;
		var centerX:Number =  (v1.x + v2.x + v3.x) / 3 ;
		var centerY:Number =  (v1.y + v2.y + v3.y) / 3 ;
		var centerZ:Number =  (v1.z + v2.z + v3.z) / 3 ;
		vertices.push(new Vertex3D(v1.x-centerX, v1.y-centerY, v1.z-centerZ));
		vertices.push(new Vertex3D(v2.x-centerX, v2.y-centerY, v2.z-centerZ));
		vertices.push(new Vertex3D(v3.x-centerX, v3.y-centerY, v3.z-centerZ));
		
		faces.push(new Triangle3D(this, [ vertices[0], vertices[1], vertices[2] ], m, [  new NumberUV(0,0), new NumberUV(0,1),new NumberUV(1,0) ] ) );

		this.geometry.ready = true;
	}
}