/**
 * Copyright a_24 ( http://wonderfl.net/user/a_24 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zfoB
 */

package {
    import a24.tween.*;
    import flash.events.*;
    import flash.display.*;
    import flash.net.*;
    import flash.text.*;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor="#FFFFFF")]
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            var url1:URLRequest = new URLRequest("http://package.a24.cat/assets/common/tween24_logo_01.jpg");
            var url2:URLRequest = new URLRequest("http://package.a24.cat/assets/common/tween24_logo_02.jpg");

            var logo01:Loader = new Loader();
            logo01.x = 110;
            logo01.y = 160;

            var logo02:Loader = new Loader();
            logo02.x = 158;
            logo02.y = 180;
            
            var text:TextField = new TextField();
            text.y = 250;
            text.width = 465;
            text.autoSize = "center";
            text.defaultTextFormat = new TextFormat("Arial", 11, 0x666666);
            text.text = "Released Tween24 v2.0, September 24, 2012";
            

            EventTween24.onClickAndGetURL(this, "http://code.google.com/p/tween24/", "_blank");
            

            Tween24.serial(
            
                // Wait image load
                Tween24.parallel(
                    Tween24.funcAndWaitEvent(logo01.contentLoaderInfo, Event.COMPLETE, logo01.load, url1),
                    Tween24.funcAndWaitEvent(logo02.contentLoaderInfo, Event.COMPLETE, logo02.load, url2)
                ),

                // Init
                Tween24.prop(logo01).$y(-80).blurY(64).fadeOut(),
                Tween24.prop(logo02).$x(40).blurX(64).fadeOut(),
                Tween24.prop(text).fadeOut(),
                Tween24.addChild(this, logo01, logo02, text),

                // Tween
                Tween24.wait(0.5),
                Tween24.tween(logo01, 0.4, Ease24._BounceOut).$y(0).blurY(0).fadeIn(),
                Tween24.wait(0.2),
                Tween24.tween(logo02, 0.4, Ease24._6_ExpoOut).$x(0).blurX(0).fadeIn(),
                Tween24.wait(0.5),
                Tween24.tween(text, 0.6).fadeIn()
                
            ).play();
            
        }
    }
}