/**
 * Copyright xxxYukihiroxxx ( http://wonderfl.net/user/xxxYukihiroxxx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zfTW
 */

// forked from checkmate's Saqoosha challenge for amateurs
// [comments]
// 滑らかに動かしたいが、上手く表現できない。 - It is not expressible well though I want to move smoothly. 
// 霧がかった感じを出したかったので、こんな風にアレンジしてみた。
// Respect for nbhd, alumican_net.

package {
    
    import flash.display.Sprite;
    import org.libspark.betweenas3.easing.Circ;
    
    import flash.events.Event;
    import flash.display.Graphics;
    
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilter;
    import flash.filters.BitmapFilterQuality;

    
    [SWF(width=465, height=465, backgroundColor=0xFFFFFF, frameRate=120)]

    public class Gradation_challenge extends Sprite {
        
        private var _container:Sprite = new Sprite();
        private var _spList:Array = new Array();
        private var _blurFilter:BlurFilter;
        
        private var bgColor:uint = 0xFFFFFF;
        private var size:uint    = 465;
        private var offset:uint  = 0;
        
        public function Gradation_challenge() {
            addEventListener(Event.ADDED_TO_STAGE, _onAdded);
            
            // add filter.
            draw();
            var filter:BitmapFilter = getBitmapFilter();
            var myFilters:Array = new Array();
            myFilters.push(filter);
            filters = myFilters;
        }
        
        private function getBitmapFilter():BitmapFilter {
            var blurX:Number = 20;
            var blurY:Number = 20;
            return new BlurFilter(blurX, blurY, BitmapFilterQuality.HIGH);
        }
        
        private function draw():void {
            graphics.beginFill(bgColor);
            graphics.drawRect(offset, offset, size, size);
            graphics.endFill();
        }

        private function _onAdded(e:Event):void {
            removeEventListener(e.type, arguments.callee);
            addChild(_container);
            var total:int = 465;
            var grad:Gradation = new Gradation(0xFF0000, 0xFF8000, 0xFFFF00, 0x00FF00, 0x00FFFF, 0x0000FF, 0x8000FF);
            // 複数の色をつなぐ場合、Circ.easeInOutなど使うと滑らかになる。
            grad.setEasing(Circ.easeInOut);

            for (var y:int = 0; y < total; y++) {
                _spList[y] = new Sprite();
                var g:Graphics = _spList[y].graphics as Graphics;
                // getColorでグラデーションを構成する中間色を取り出す。渡す値は0～1。滑らかにこの値を変化させることでグラデーションを作り出す。
                g.beginFill(grad.getColor(y / (total-1) ));
                g.drawRect(0, 0, stage.stageWidth, 1);
                g.endFill();

                y != 0 ? _spList[y].y = _spList[y - 1].y + _spList[y].height : false;

                _container.addChild(_spList[y]);
                
                _spList[y].addEventListener(Event.ENTER_FRAME, _loop);
            }
        }
        
        private function _loop(e:Event):void {
            var sp:Sprite = e.target as Sprite;
            if (sp.y > stage.stageHeight) sp.y = 0;
            sp.y += Math.random()*0.8;
        }
    }
}


import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}