/**
 * Copyright Albert ( http://wonderfl.net/user/Albert )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zfN0
 */

package {
    import flash.display.Sprite;
    import flash.geom.Point;  
    import flash.geom.Vector3D;
    import flash.display.BitmapData;  
    import flash.display.Bitmap;
    
    public class FlashTest extends Sprite {
        // isometric conversion
        private var centerX:Number=stage.stageWidth/2;
        private var centerY:Number=stage.stageHeight/2;
        private var theta:Number=Math.PI/4;// 45 degrees;
        private var cosX:Number=Math.cos(theta);
        private var sinX:Number=Math.sin(theta);

        public function iso3D(x:Number, y:Number, z:Number):Point {
            var pnt:Point = new Point();            
            pnt.x = centerX + (x-z) *  cosX
            pnt.y = centerY -  (x+z) * 0.5 * sinX - y;
            return pnt;
        }
      
        public function FlashTest() {
            // example:
            var canvas:BitmapData=new BitmapData(stage.stageWidth,stage.stageHeight,true,0xFF000000);
            addChild(new Bitmap(canvas,"auto",true));
            var size:int=100;
            var hs:int=size / 2;
            var pen:Point = new Point();
            var vect:Vector3D = new Vector3D();
            // draw a few shapes with offset:
            for (var dist:int = 10; dist <= 80; dist *= 2) {
                // voxel space:
                for (var i:int = 0; i<size; i++) {
                    for (var j:int = 0; j<size; j++) {
                        for (var k:int = 0; k<size; k++) {
                            vect.x=j-hs;
                            vect.y=i-hs;
                            vect.z=k-hs;
                            pen = iso3D(vect.x,vect.y,vect.z);
                            if (Math.sqrt((vect.x * vect.x) + (vect.y * vect.y) + (vect.z * vect.z)) <dist) {
                                // using Vector3D.distance() is very slow compared to above
                                // a few types of coloring:
                                var xp:Number = pen.x + (dist <<2) - 200;
                                canvas.setPixel(xp, pen.y-100, (i <<16 | j <<8 | k) <<1);
                                canvas.setPixel(xp, pen.y+100, (k <<16 | k <<8 | k+j)  );
                            }
                        }
                    }
                }
            }        
        }
    }
}