/**
 * Copyright plus-tic ( http://wonderfl.net/user/plus-tic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zfJ1
 */

//
package{
	import flash.text.*;
	import flash.utils.Timer;
	import flash.events.*
	import flash.display.Sprite;
	
	import flash.accessibility.Accessibility;
	public class Textpatapata extends Sprite {
		public const _replaceWord:String = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789=+-*/!?s";
		private var _content:TextField;
		private var word:String;
		private var timer:Timer;
		private var randomCnt:uint;
		private var randomArr:Array = new Array;
		private var shuffleArr:Array = new Array;
		private var speed:Number = 1;
		private var _time:uint = 30;
		private var cnt1:uint = 0;
		private var cnt2:uint = 0;
		
		public var Text1:TextField;
		
	
		public function Textpatapata(content:TextField){
			this._content = content;
			this.word = content.text;
			
			timer = new Timer(speed, 0);	
			timer.addEventListener(TimerEvent.TIMER,	onTick, false, 0, true);	
		}
		
		public function setText(newText:String):void{
			this.word = newText;
		}
		
		public function start():void{
			_content.text = "";
			randomCnt = 0;
			randomArr = [];
			shuffleArr = [];
			cnt1 = 0;
			cnt2 = 0;
			
			_content.wordWrap = false;
			_content.autoSize = TextFieldAutoSize.LEFT;
			
			for(var i:uint=0; i<word.length;i++){
				randomArr.push(i);
				_content.appendText("_");
			}
			
			shuffleArr = shuffle(randomArr);
			
			timer.start();			
		}
		
    		private function shuffle(arr:Array):Array  
        {  
             var l:Number = arr.length;  
             var newArr:Array = arr;  
   
             while(l)  
             {  
                 var m:Number = Math.floor(Math.random()*l);  
                 var n:Number = newArr[--l];  
                 newArr[l] = newArr[m];  
                 newArr[m] = n;  
             }  
             return newArr;  
         }  
				
		
		private function onTick(e:TimerEvent):void{
			if(randomCnt < _time){
				var randomNo:uint = Math.round(Math.random() * _replaceWord.length);
				
				var s1:uint = shuffleArr[cnt1];
				var s2:uint = shuffleArr[cnt2];
				var s3:String = _replaceWord.charAt(randomNo);
				
				_content.replaceText(s1,s2,s3);
				
				if(cnt1 >= word.length -1) cnt1 = 0 ;
				else cnt1++;				
			}else{
				var s4:uint = shuffleArr[cnt2];
				var s5:uint = shuffleArr[cnt2];
				var s6:String = word.charAt(shuffleArr[cnt2]);
				
				_content.replaceText(s4,s5,s6);
				cnt2++;
				
				if(cnt2 >= word.length){
					timer.stop();
				}
			}
			randomCnt++;
		}
		
		public function get time():uint{
			return _time;
		}
		
		public function set time(t:uint):void{
			_time = t;
		}
		
	}
	
}

