/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zeoV
 */

// forked from glasses_factory's Rect Brambles
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.GradientBevelFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Quart;
    
    [SWF(frameRate=60, backgroundColor=0x000000,width=465, height=465)]
    public class Study1 extends Sprite
    {
        
        //Constractor
        public function Study1()
        {
            init();
        }
        
        
        public function init():void
        {
            _pallet = new Sprite();
            _canvas = new BitmapData( 465,465, true, 0 );
            _sqVec = new Vector.<WireSq>(SQ_NUM, true);
            for( var i:int = 0; i < SQ_NUM; ++i )
            {
                var sq:WireSq = new WireSq( this.stage, 10);
                sq.x = Math.random() * 465;
                sq.y = Math.random() * 465;
                sq.rotation = Math.random() * 360 / Math.PI;
                _pallet.addChild( sq );
                _sqVec[i] = sq;
                sq.extract();
            }
            
            _canvas.draw( _pallet );
            _easel = new Bitmap( _canvas );
            
            
            addChild( _easel );
                    
            addEventListener( Event.ENTER_FRAME, _enterFrameHandler );
        }
        
        /*/////////////////////////////////
        * private methods
        /*/////////////////////////////////
        
        private function _enterFrameHandler( e:Event ):void
        {
            for( var i:int = 0; i < SQ_NUM; ++i )
            {
                _sqVec[i].update();
            }
            _canvas.colorTransform( _rect, _colTrf );
            _canvas.draw( _pallet );
            _easel.bitmapData = _canvas;
        }
        
        
        /*/////////////////////////////////
        * private variables
        /*/////////////////////////////////
        
        private var _easel:Bitmap;
        
        private var _canvas:BitmapData;
        
        private var _pallet:Sprite;
        
        private const _colTrf:ColorTransform = new ColorTransform( 1, 1, 1, 0.988 );
        
        private const _rect:Rectangle = new Rectangle( 0, 0, 465, 465 );
        
        private var _sq:WireSq;
        
        private var _sqVec:Vector.<WireSq>;
        
        private const SQ_NUM:uint = 250;
        
    }
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.display.Stage;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Quart;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.tweens.ITween;


class WireSq extends Sprite
{
    public function WireSq( stage:Stage, size:Number = 10 )
    {
        _stage = stage;
        _p = new Vector.<Particle>();
        for( var i: int = 0; i < 4; i++ )
        {
            var p:Particle = new Particle( size * 0.5, size * 0.5 );
            _p.push( p );
        }
        
        _p[0].tx = _p[0].ty = 0;
        _p[1].tx = size;    _p[1].ty = 0;
        _p[2].tx = _p[2].ty = size;
        _p[3].tx = 0;        _p[3].ty = size;
        
        
        _t = BetweenAS3.serial(
                BetweenAS3.parallel(
                    BetweenAS3.tween( _p[0], { x:_p[0].tx, y:_p[0].ty }, { x:_p[0].orgX, y:_p[0].orgY }, 0.5, Quart.easeOut ),
                    BetweenAS3.tween( _p[2], { x:_p[2].tx, y:_p[2].ty }, { x:_p[2].x, y:_p[2].orgY }, 0.5, Quart.easeOut )),
                BetweenAS3.parallel(
                    BetweenAS3.tween( _p[1], { x:_p[1].tx, y:_p[1].ty }, { x:_p[1].x, y:_p[1].orgY }, 0.5, Quart.easeOut ),
                    BetweenAS3.tween( _p[3], { x:_p[3].tx, y:_p[3].ty }, { x:_p[3].x, y:_p[3].orgY }, 0.5, Quart.easeOut )));
        _u = BetweenAS3.serial(
                BetweenAS3.delay(_t, 0.8),
                BetweenAS3.delay(BetweenAS3.reverse(_t), 1.2)
                );
        _u.stopOnComplete = false;
    }
    
    private var _u : ITween;
    
    public function extract():void
    {
        _u.play();
    }
    
    public function update():void
    {
        wonder();
        move();
        draw();
    }
    
    private function wonder():void
    {
        var center:Vector2D = _velocity.clone().normalize().muliply( 10 );
        var offcet:Vector2D = new Vector2D(0);
        offcet.length = 5;
        offcet.angle = _angle;
        _angle += Math.random() * 1 - 1 * .5;
        var force:Vector2D = center.add( offcet );
        _steeredFV2 = _steeredFV2.add( force ); 
    }
    
    private function move():void
    {
        _steeredFV2.truncate( _maxF );
        _steeredFV2 = _steeredFV2.divide( 1.0 );
        _velocity = _velocity.add( _steeredFV2 );
        _steeredFV2 = new Vector2D();
        
        _velocity.truncate( _maxV );
        _position = _position.add( _velocity );
        
        if( position.x > _stage.stageWidth ){ position.x = 0 };
        if( position.x < 0 ){ position.x = _stage.stageWidth };
        if( position.y > _stage.stageHeight ){ position.y = 0 };
        if( position.y < 0 ){ position.y = _stage.stageHeight };
        
        xx = position.x;
        yy = position.y;
        this.rotation += _velocity.angle * 180 / Math.PI;
    }
    
    private function draw():void
    {
        var g:Graphics = this.graphics;
        g.clear();
        g.lineStyle( 1, 0xffffff );
        g.moveTo( _p[0].x, _p[0].y );
        for( var i:int = 1; i < 4; i++ )
        {
            g.lineTo( _p[i].x, _p[i].y );
        }
        g.lineTo( _p[0].x, _p[0].y );
        g.lineTo( _p[2].x, _p[2].y );
    }
    
    
    private function get position():Vector2D
    {
        return _position;
    }
    private function set position( value:Vector2D ):void
    {
        _position = value;
        xx = _position.x;
        yy = _position.y;
    }
    
    private function get xx():Number
    {
        return this.x;
    }
    
    private function set xx( value:Number ):void
    {
        this.x = value;
        _position.x = xx;
    }
    
    private function get yy():Number
    {
        return this.y;
    }
    
    private function set yy( value:Number ):void
    {
        this.y = value;
        _position.y = yy;
    }
    
    private var _stage:Stage;
    
    private var _t:ITween;
    
    private var _p:Vector.<Particle>;
    
    private var _direct:Boolean;
    
    private var _velocity:Vector2D = new Vector2D();
    
    private var _position:Vector2D = new Vector2D();
    
    private var _steeredFV2:Vector2D = new Vector2D();
    
    private var _maxF:Number = 1.0;
    
    private var _maxV:Number = 2;
    
    private var _angle:Number = 0;
}

class Particle
{
    public var x:Number = 0, y:Number = 0;
    public var orgX:Number = 0, orgY:Number = 0;
    public var tx:Number = 0, ty:Number = 0;
    
    public function Particle(xx:Number, yy:Number)
    {
        x = orgX = xx;    y = orgY = yy;
    }
}

class Vector2D
{
    public function get x():Number{ return _x; }
    public function set x( value:Number ):void    { _x = value; }
    private var _x:Number = 0;
    
    public function get y():Number{ return _y; }
    public function set y( value:Number ):void{ _y = value; }
    private var _y:Number = 0;
    
    public function get length():Number
    {
        return Math.sqrt( _x * _x + _y * _y );
    }
    
    public function set length( value:Number ):void
    {
        var a:Number = this.angle;
        _x = Math.cos( a ) * value;
        _y = Math.sin( a ) * value;
    }
    
    public function get angle():Number
    {
        return Math.atan2( _y, _x );
    }
    
    public function set angle( value:Number ):void
    {
        var len:Number = this.length;
        _x = Math.cos( value ) * len;
        _y = Math.sin( value ) * len;
    }
    
    //Constractor
    public function Vector2D( x:Number = 0, y:Number = 0 )
    {
        _x = x;
        _y = y;
    }
    
    
    public function add( vec:Vector2D ):Vector2D
    {
        return new Vector2D( _x + vec.x, _y + vec.y );
    }
    
    public function muliply( value:Number ):Vector2D
    {
        return new Vector2D( _x * value, _y * value );
    }
    
    
    public function divide( value:Number ):Vector2D
    {
        return new Vector2D( _x / value, _y / value );
    }
    
    
    public function normalize():Vector2D
    {
        if( length == 0 )
        {
            _x = 1;
            return this;
        }
        var len:Number = length;
        _x /= len;
        _y /= len;
        return this;
    }
    
    public function truncate( max:Number ):Vector2D
    {
        length = Math.min( max, length );
        return this;
    }
    
    public function clone():Vector2D
    {
        return new Vector2D( _x, _y );
    }
}