/**
 * Copyright murderdeathkitty ( http://wonderfl.net/user/murderdeathkitty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zeCt
 */

// forked from failrate's forked from: SoundFork
// forked from murderdeathkitty's SoundFork
// forked from murderdeathkitty's flash on 2009-7-17
package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.utils.*;
    import flash.net.*;
    public class SoundFork extends Sprite {
        
        private var sound: Sound;
        private var channel: SoundChannel
        private var freq1:Number = 100;
        private var freq2:Number = 100;
        public function SoundFork(): void
        {
            addEventListener(Event.ADDED_TO_STAGE, start);
            addEventListener(Event.REMOVED_FROM_STAGE, stop);
        }
        public function start(e: Event = null): void
        {
            sound = new Sound();
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, generate);
            channel = sound.play();
        }
        public function stop(e: Event = null): void
        {
            if(channel != null){
                channel.stop();
                channel = null;
            }
        }
        
        //replace this with your own sound!!!
        //output is 44100 hz, stereo. values between -1 and 1
        private function generate(e: SampleDataEvent): void
        {
            var data: ByteArray = e.data;
            var i: Number;
            var output1: Number;
            var output2: Number;
            var envelope:Number =0;
            freq1 += Math.random() * 2.0 - 1.0;
            if ( freq1 <= 60 ) { freq1 = 60; }
            if ( freq1 >= 1000 ) { freq1 = 1000; }
            freq2 += Math.random() * 2.0 - 1.0;
            if ( freq2 <= 60 ) { freq2 = 60; }
            if ( freq2 >= 1000 ) { freq2 = 1000; }

            for(i = 0; i < 8000; ++i){
                if ( i < 4000 ) { envelope += 1.0/500; }
                else { envelope -= 1.0/500; }
                output1 = (Math.sin(i/freq1) * envelope/2)*(Math.sin(i/(freq2+100)) * envelope/2);
                output2 = (Math.sin(i/freq2) * envelope/2)*(Math.sin(i/(freq1+100)) * envelope/2);
                
                data.writeFloat(output1*0.8 + output2*0.2);//left
                data.writeFloat(output2*0.8 + output1*0.2);//right
            }
        }
    }
}