/**
 * Copyright y_tti ( http://wonderfl.net/user/y_tti )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zdkg
 */

//
// nitoyon先生のコードの座標変換部分をMatrix3Dにまかせてみた。
// http://d.hatena.ne.jp/nitoyon/20080616/as_3d_lessen1
//

package
{
	import __AS3__.vec.Vector;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix3D;
	import flash.geom.Point;
	import flash.geom.Vector3D;
	
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0x000000")]
	public class Matrix3DTest extends Sprite
	{
		private var _canvas:Sprite;
		private var _p1:Vector3D;
		private var _p2:Vector3D;
		private var _p3:Vector3D;
		private var _p4:Vector3D;
		
		public function Matrix3DTest()
		{
			_canvas = new Sprite();
			_canvas.x = stage.stageWidth>>1;
			_canvas.y = stage.stageHeight>>1;
			addChild(_canvas);
			
			_p1 = new Vector3D(0,0,100);
			_p2 = new Vector3D(100,0,0);
			_p3 = new Vector3D(0,100,0);
			_p4 = new Vector3D(-50,-50,-50);
			
			addEventListener(Event.ENTER_FRAME , _update );
		}
		
		private function _update(e:Event=null):void {
			//Matrix3Dで変換位置決定
			var matrix:Matrix3D = new Matrix3D();
			var pivot:Vector3D = new Vector3D(0,0,0);
			matrix.appendRotation(stage.mouseX, Vector3D.Y_AXIS , pivot);
			matrix.appendRotation(stage.mouseY, Vector3D.Z_AXIS , pivot);
			
			//Matrix3Dで座標変換
			var pp1:Vector3D = matrix.transformVector(_p1);
			var pp2:Vector3D = matrix.transformVector(_p2);
			var pp3:Vector3D = matrix.transformVector(_p3);
			var pp4:Vector3D = matrix.transformVector(_p4);
			
			//描く
			_canvas.graphics.clear();
			_drawPoint(pp1);
			_drawPoint(pp2);
			_drawPoint(pp3);
			_drawPoint(pp4);
			_drawLine(pp1,pp2);
			_drawLine(pp1,pp3);
			_drawLine(pp1,pp4);
			_drawLine(pp2,pp3);
			_drawLine(pp2,pp4);
			_drawLine(pp3,pp4);
		}
		
		private function _drawPoint($p:Vector3D):void {
			_canvas.graphics.beginFill(0xFFFFFF,1);
			_canvas.graphics.drawCircle($p.x,$p.y,10);
			_canvas.graphics.endFill();
		}
		
		private function _drawLine($p1:Vector3D,$p2:Vector3D):void {
			_canvas.graphics.lineStyle(3,0xFFFFFF,1);
			_canvas.graphics.moveTo($p1.x,$p1.y);
			_canvas.graphics.lineTo($p2.x , $p2.y );
		}
		
	}
}

class Point3D {
	public var x:Number;
	public var y:Number;
	public var z:Number;
	
	public function Point3D($x:Number,$y:Number,$z:Number) {
		this.x = $x;
		this.y = $y;
		this.z = $z;
	}
}